/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class BasicReport
extends Basic {
    public static final int USR = 0;
    public static final int GRP = 1;
    public static final int PRJ = 2;
    public static final int UNKNOWN = -1;
    public static final String EDIT = "edit";
    public static final String CHANGE = "change";
    public static final String NEW = "new";
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String PROJECT = "project";
    public static final String ACTIVITY = "activity";
    public static final String DATE = "date";
    public static final String PID = "pid";
    public static final String WILDCARD = "-1";
    public static final String[] KCC = new String[]{"sessionKey", "sessionCode", "sessionContext"};
    public static final File SDIR = new File(System.getProperty("java.io.tmpdir"));
    protected String groupId;
    protected String userId;
    protected String projectName;
    protected String activityName;
    protected String[] kcc;
    protected int type = -1;
    protected String pageId;
    protected DateManager dm;

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.dm = new DateManager(this);
        this.userId = this.getParamNotNull(USER);
        if (this.userId.length() > 0 && this.userId.charAt(0) == '\u00a0') {
            this.userId = this.userId.replace('\u00a0', ' ');
        }
        this.groupId = this.getParamNotNull(GROUP);
        this.projectName = this.getParamNotNull(PROJECT);
        this.activityName = this.getParamNotNull(ACTIVITY);
        this.kcc = new String[3];
        for (int i = 0; i < KCC.length; ++i) {
            this.kcc[i] = this.getParam(KCC[i]);
        }
        this.pageId = this.getParam(PID);
        if (this.pageId == null || this.pageId.length() == 0) {
            this.pageId = Long.toString(100000000L + (long)(Math.random() * 1.0E8));
        }
        return this.dm.init();
    }

    protected Vector getSessionList() throws Exception {
        Vector vector = null;
        File file = new File(SDIR, "report_" + this.pageId + ".ser");
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            vector = (Vector)objectInputStream.readObject();
        } else {
            switch (this.type) {
                case 0: {
                    vector = bridge.getInfoSessionUser(this.userId, this.projectName, this.dm.dFrom, this.dm.dTo, this.kcc, false);
                    break;
                }
                case 1: {
                    vector = bridge.getInfoSessionGroup(this.groupId, this.projectName, this.dm.dFrom, this.dm.dTo, this.kcc, true);
                    break;
                }
                case 2: {
                    vector = bridge.getInfoSessionAct(this.projectName, this.activityName, this.dm.dFrom, this.dm.dTo, this.kcc, true);
                    break;
                }
                default: {
                    vector = new Vector();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(vector);
            file.deleteOnExit();
        }
        return vector;
    }

    public String[][] vToArray(Vector vector, String string, String string2) {
        String[][] stringArray = null;
        if (string != null || vector != null && vector.size() > 0) {
            int n = vector != null ? vector.size() : 0;
            stringArray = new String[n + (string != null ? 1 : 0)][];
            int n2 = 0;
            if (string != null) {
                String string3 = string;
                if (string2 != null) {
                    string3 = this.getMsg(string2);
                }
                stringArray[n2++] = new String[]{string, string3};
            }
            if (vector != null) {
                for (int i = 0; i < n; ++i) {
                    String string4 = ((String)vector.get(i)).trim();
                    stringArray[n2++] = new String[]{string4, string4};
                }
            }
        }
        return stringArray;
    }

    public String[][] vToArray(Vector vector, int n, int n2) {
        String[][] stringArray = null;
        if (vector != null && vector.size() > 0) {
            int n3 = vector.size();
            stringArray = new String[n3][];
            for (int i = 0; i < n3; ++i) {
                Object[] objectArray = (Object[])vector.get(i);
                stringArray[i] = new String[2];
                stringArray[i][0] = ((String)objectArray[n]).trim();
                stringArray[i][1] = ((String)objectArray[n2]).trim();
            }
        }
        return stringArray;
    }
}

