/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.BasicJDBCBridge;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class ReportServerJDBCBridge
extends BasicJDBCBridge {
    public static final String[] KCC = new String[]{"SESSION_KEY", "SESSION_CODE", "SESSION_CONTEXT"};
    public String GROUP_SESSION_DATE_STRING = null;
    public String ORDER_QUALIFICATION_1_STRING = null;
    public String ORDER_QUALIFICATION_2_STRING = null;
    private static Date FIRST_DATE = null;

    public ReportServerJDBCBridge(ConnectionBeanProvider connectionBeanProvider, boolean bl, String string) throws Exception {
        super(connectionBeanProvider, bl, string);
        ConnectionBean connectionBean = connectionBeanProvider.getConnectionBean();
        switch (this.DBMSType) {
            case 1: {
                this.GROUP_SESSION_DATE_STRING = "s.SESSION_DATETIME";
                this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*) AS qf";
                this.ORDER_QUALIFICATION_2_STRING = "qf";
                break;
            }
            case 2: {
                this.GROUP_SESSION_DATE_STRING = "trunc(s.SESSION_DATETIME)";
                this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*) AS qf";
                this.ORDER_QUALIFICATION_2_STRING = "qf";
                break;
            }
            default: {
                this.GROUP_SESSION_DATE_STRING = "Format(s.SESSION_DATETIME,'yyyy/mm/dd')";
                this.ORDER_QUALIFICATION_2_STRING = this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*)";
            }
        }
    }

    public static Date getFirstDate() {
        if (FIRST_DATE == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1992, 0, 1);
            FIRST_DATE = calendar.getTime();
        }
        return FIRST_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getMinSessionDate() throws Exception {
        Date date;
        block7: {
            Exception exception = null;
            date = ReportServerJDBCBridge.getFirstDate();
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT min(SESSION_DATETIME) FROM " + this.getTableName("SESSIONS"));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    date = resultSet.getDate(1);
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block7;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return date;
    }

    private String getFilteringStringQuery(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (stringArray != null) {
            for (int i = 0; i < KCC.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                stringBuffer.append(bl ? " AND s." : " s.").append(KCC[i]).append("=?");
                bl = true;
            }
        }
        return stringBuffer.substring(0);
    }

    private int updateFiltering(PreparedStatement preparedStatement, String[] stringArray, int n) throws SQLException {
        if (stringArray != null) {
            for (int i = 0; i < KCC.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                preparedStatement.setString(n++, stringArray[i]);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getInfoSessionUser(String string, String string2, Date date, Date date2, String[] stringArray, boolean bl) throws Exception {
        Exception exception = null;
        Vector<SessionData> vector = new Vector<SessionData>();
        String string3 = null;
        if (string2 != null && string2.length() > 0 && !string2.equals("-1")) {
            string3 = string2;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*)").append(", sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(",").append(this.getTableName("USERS", "u")).append(" WHERE u.USER_ID=? AND s.USER_ID=u.USER_ID").append(this.getFilteringStringQuery(stringArray, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (string3 != null) {
            stringBuffer.append(" AND s.PROJECT_NAME=?");
        }
        stringBuffer.append(" GROUP BY s.SESSION_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setString(n++, string);
            n = this.updateFiltering(preparedStatement, stringArray, n);
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string3 != null) {
                preparedStatement.setString(n++, string3);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            SessionData sessionData = null;
            while (resultSet.next()) {
                SessionData sessionData2 = new SessionData(resultSet.getString(2), string, resultSet.getString(3), ReportUtils.strToDate(resultSet.getString(1)), resultSet.getInt(4), resultSet.getInt(6), resultSet.getInt(5), Math.max(0, resultSet.getInt(7)));
                if (bl) {
                    if (sessionData2.sameDate(sessionData)) {
                        sessionData.acumula(sessionData2);
                        continue;
                    }
                    if (sessionData != null) {
                        vector.add(sessionData);
                    }
                    sessionData = sessionData2;
                    continue;
                }
                vector.add(sessionData2);
            }
            if (sessionData != null) {
                vector.add(sessionData);
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getInfoSessionGroup(String string, String string2, Date date, Date date2, String[] stringArray, boolean bl) throws Exception {
        Exception exception = null;
        Vector<SessionData> vector = new Vector<SessionData>();
        String string3 = null;
        if (string2 != null && string2.length() > 0 && !string2.equals("-1")) {
            string3 = string2;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*), sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME), s.USER_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE u.GROUP_ID=? AND s.USER_ID=u.USER_ID").append(this.getFilteringStringQuery(stringArray, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (string3 != null) {
            stringBuffer.append(" AND s.PROJECT_NAME=?");
        }
        stringBuffer.append(" GROUP BY s.SESSION_ID, s.USER_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setString(n++, string);
            n = this.updateFiltering(preparedStatement, stringArray, n);
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string3 != null) {
                preparedStatement.setString(n++, string3);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            SessionData sessionData = null;
            while (resultSet.next()) {
                SessionData sessionData2 = new SessionData(resultSet.getString(2), resultSet.getString(8), resultSet.getString(3), ReportUtils.strToDate(resultSet.getString(1)), resultSet.getInt(4), resultSet.getInt(6), resultSet.getInt(5), Math.max(0, resultSet.getInt(7)));
                if (bl) {
                    if (sessionData2.sameDate(sessionData)) {
                        sessionData.acumula(sessionData2);
                        continue;
                    }
                    if (sessionData != null) {
                        vector.add(sessionData);
                    }
                    sessionData = sessionData2;
                    continue;
                }
                vector.add(sessionData2);
            }
            if (sessionData != null) {
                vector.add(sessionData);
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getInfoSessionAct(String string, String string2, Date date, Date date2, String[] stringArray, boolean bl) throws Exception {
        Exception exception = null;
        Vector<SessionData> vector = new Vector<SessionData>();
        String string3 = null;
        if (string2 != null && string2.length() > 0 && !string2.equals("-1")) {
            string3 = string2;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*), sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME), s.USER_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(" WHERE s.PROJECT_NAME=?").append(this.getFilteringStringQuery(stringArray, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (string3 != null) {
            stringBuffer.append(" AND a.ACTIVITY_NAME=?");
        }
        stringBuffer.append(" GROUP BY s.SESSION_ID, s.USER_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setString(n++, string);
            n = this.updateFiltering(preparedStatement, stringArray, n);
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string3 != null) {
                preparedStatement.setString(n++, string3);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            SessionData sessionData = null;
            while (resultSet.next()) {
                SessionData sessionData2 = new SessionData(resultSet.getString(2), resultSet.getString(8), resultSet.getString(3), ReportUtils.strToDate(resultSet.getString(1)), resultSet.getInt(4), resultSet.getInt(6), resultSet.getInt(5), Math.max(0, resultSet.getInt(7)));
                if (bl) {
                    if (sessionData2.sameDate(sessionData)) {
                        sessionData.acumula(sessionData2);
                        continue;
                    }
                    if (sessionData != null) {
                        vector.add(sessionData);
                    }
                    sessionData = sessionData2;
                    continue;
                }
                vector.add(sessionData2);
            }
            if (sessionData != null) {
                vector.add(sessionData);
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    public boolean hasUserTables() throws Exception {
        boolean bl = true;
        String string = this.getProperty("USER_TABLES", null);
        bl = string == null || !string.trim().toLowerCase().equals("false");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProjList(String string, Date date, Date date2, String[] stringArray) throws Exception {
        Exception exception = null;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT distinct(PROJECT_NAME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(" WHERE s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?");
        if (string != null) {
            stringBuffer.append(" AND s.USER_ID=?");
        }
        stringBuffer.append(this.getFilteringStringQuery(stringArray, true)).append(" ORDER BY PROJECT_NAME");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string != null) {
                preparedStatement.setString(n++, string);
            }
            n = this.updateFiltering(preparedStatement, stringArray, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString("PROJECT_NAME"));
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProjListGrup(String string, Date date, Date date2, String[] stringArray) throws Exception {
        Exception exception = null;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT distinct(PROJECT_NAME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("GROUPS", "g")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE SESSION_DATETIME>=? AND SESSION_DATETIME<=?").append(" AND u.GROUP_ID=g.GROUP_ID AND s.USER_ID=u.USER_ID");
        if (string != null) {
            stringBuffer.append(" AND g.GROUP_ID=?");
        }
        stringBuffer.append(this.getFilteringStringQuery(stringArray, true)).append(" ORDER BY PROJECT_NAME");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string != null) {
                preparedStatement.setString(n++, string);
            }
            n = this.updateFiltering(preparedStatement, stringArray, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString("PROJECT_NAME"));
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getActList(String string, Date date, Date date2, String[] stringArray) throws Exception {
        Exception exception = null;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT distinct(ACTIVITY_NAME)").append(" FROM ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("SESSIONS", "s")).append(" WHERE s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND a.SESSION_ID=s.SESSION_ID");
        if (string != null) {
            stringBuffer.append(" AND s.PROJECT_NAME=?");
        }
        stringBuffer.append(this.getFilteringStringQuery(stringArray, true)).append(" ORDER BY ACTIVITY_NAME");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
            preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            if (string != null) {
                preparedStatement.setString(n++, string);
            }
            n = this.updateFiltering(preparedStatement, stringArray, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString("ACTIVITY_NAME"));
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPacSessionList(String string, String string2, String string3, Date date, Date date2, String[] stringArray) throws Exception {
        Exception exception = null;
        Vector<ActivityData> vector = new Vector<ActivityData>();
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT s.PROJECT_NAME, a.ACTIVITY_ID, a.ACTIVITY_NAME, a.NUM_ACTIONS").append(" ,a.SCORE, a.ACTIVITY_SOLVED, a.QUALIFICATION, a.TOTAL_TIME").append(" FROM ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("SESSIONS", "s")).append(" WHERE a.SESSION_ID=s.SESSION_ID");
        if (date != null && date2 != null) {
            stringBuffer.append(" AND SESSION_DATETIME>=? AND SESSION_DATETIME<=?");
        }
        if (string != null) {
            stringBuffer.append(" AND s.USER_ID=?");
        }
        stringBuffer.append(this.getFilteringStringQuery(stringArray, true));
        if (string3 != null) {
            stringBuffer.append(" AND a.SESSION_ID=?");
        }
        if (string2 != null && !string2.equals("-1")) {
            stringBuffer.append(" AND s.PROJECT_NAME=?");
        }
        stringBuffer.append(" ORDER BY s.SESSION_DATETIME, a.ACTIVITY_ID");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            int n = 1;
            if (date != null && date2 != null) {
                preparedStatement.setTimestamp(n++, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(n++, new Timestamp(date2.getTime()));
            }
            if (string != null) {
                preparedStatement.setString(n++, string);
            }
            n = this.updateFiltering(preparedStatement, stringArray, n);
            if (string3 != null) {
                preparedStatement.setString(n++, string3);
            }
            if (string2 != null && !string2.equals("-1")) {
                preparedStatement.setString(n++, string2);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ActivityData activityData = new ActivityData(resultSet.getString("PROJECT_NAME"), resultSet.getString("ACTIVITY_NAME"), resultSet.getString("ACTIVITY_ID"), Math.max(0, resultSet.getInt("TOTAL_TIME")), resultSet.getInt("NUM_ACTIONS"), resultSet.getInt("SCORE"), resultSet.getInt("ACTIVITY_SOLVED") != 0, resultSet.getInt("QUALIFICATION"));
                vector.add(activityData);
            }
            resultSet.close();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(UserData userData, boolean bl) throws Exception {
        boolean bl2;
        block9: {
            Exception exception = null;
            bl2 = false;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                String string = this.getTableName("USERS");
                preparedStatement = connectionBean.getPreparedStatement(bl ? "INSERT INTO " + string + " (USER_NAME,USER_ICON,USER_PWD,USER_ID,GROUP_ID) VALUES (?,?,?,?,?)" : "UPDATE " + string + " SET USER_NAME=?, USER_ICON=?, USER_PWD=? WHERE USER_ID=?");
                preparedStatement.setString(1, userData.getText());
                if (userData.getIconUrl() != null && userData.getIconUrl().length() == 0) {
                    userData.setIconUrl(null);
                }
                preparedStatement.setString(2, userData.getIconUrl());
                preparedStatement.setString(3, userData.pwd);
                preparedStatement.setString(4, userData.getId());
                if (bl) {
                    preparedStatement.setString(5, userData.groupId);
                }
                bl2 = preparedStatement.executeUpdate() > 0;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block9;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (!bl2) {
            throw new Exception("SQL \"UPDATE\" statement returns 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroup(GroupData groupData, boolean bl) throws Exception {
        boolean bl2;
        block8: {
            Exception exception = null;
            bl2 = false;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                String string = this.getTableName("GROUPS");
                preparedStatement = connectionBean.getPreparedStatement(bl ? "INSERT INTO " + string + " (GROUP_NAME,GROUP_ICON,GROUP_ID) VALUES (?,?,?)" : "UPDATE " + string + " SET GROUP_NAME=?, GROUP_ICON=? WHERE GROUP_ID=?");
                preparedStatement.setString(1, groupData.getText());
                if (groupData.getIconUrl() != null && groupData.getIconUrl().length() == 0) {
                    groupData.setIconUrl(null);
                }
                preparedStatement.setString(2, groupData.getIconUrl());
                preparedStatement.setString(3, groupData.getId());
                bl2 = preparedStatement.executeUpdate() > 0;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block8;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (!bl2) {
            throw new Exception("SQL \"UPDATE\" statement returns 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserReportData(String string, Date date, Date date2) throws Exception {
        Exception exception = null;
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT SESSION_ID").append(" FROM ").append(this.getTableName("SESSIONS")).append(" WHERE USER_ID=?");
        if (date != null && date2 != null) {
            stringBuffer.append(" AND SESSION_DATETIME>=? AND SESSION_DATETIME<=?");
        }
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            preparedStatement.setString(1, string);
            if (date != null && date2 != null) {
                preparedStatement.setTimestamp(2, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(date2.getTime()));
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.deleteSession(resultSet.getString(1));
            }
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroupReportData(String string, Date date, Date date2) throws Exception {
        Exception exception = null;
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("SELECT SESSION_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE u.GROUP_ID=?").append(" AND u.USER_ID=s.USER_ID");
        if (date != null && date2 != null) {
            stringBuffer.append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?");
        }
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            preparedStatement.setString(1, string);
            if (date != null && date2 != null) {
                preparedStatement.setTimestamp(2, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(date2.getTime()));
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.deleteSession(resultSet.getString(1));
            }
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSession(String string) throws Exception {
        block6: {
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("ACTIONS") + " WHERE SESSION_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("ACTIVITIES") + " WHERE SESSION_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("SESSIONS") + " WHERE SESSION_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block6;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String string) throws Exception {
        block6: {
            Exception exception = null;
            this.clearUserReportData(string, null, null);
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                connectionBean.getConnection().commit();
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("USERS") + " WHERE USER_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block6;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String string) throws Exception {
        block6: {
            Exception exception = null;
            this.clearGroupReportData(string, null, null);
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                connectionBean.getConnection().commit();
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("USERS") + " WHERE GROUP_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                connectionBean.getConnection().commit();
                preparedStatement = connectionBean.getPreparedStatement("DELETE FROM " + this.getTableName("GROUPS") + " WHERE GROUP_ID=?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block6;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

