/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.HTTPRequest;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.rp.ActReport;
import edu.xtec.jclic.report.rp.DbAdmin;
import edu.xtec.jclic.report.rp.GroupAdmin;
import edu.xtec.jclic.report.rp.GroupReport;
import edu.xtec.jclic.report.rp.Img;
import edu.xtec.jclic.report.rp.JClicReportService;
import edu.xtec.jclic.report.rp.Login;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.jclic.report.rp.UserAdmin;
import edu.xtec.jclic.report.rp.UserReport;
import edu.xtec.servlet.RequestProcessor;
import edu.xtec.servlet.ResourceRP;
import edu.xtec.util.Messages;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;

public class HTTPReportServer
extends ReportServerEventMaker {
    public static final int DEFAULT_PORT = 9000;
    public static final int DEFAULT_TIMEOUT = 1200;
    protected static final String[] URI = new String[]{"/login", "/main", "/dbAdmin", "/userReport", "/actReport", "/img", "/groupReport", "/groupAdmin", "/userAdmin", "/resource", "/JClicReportService"};
    protected static final Class[] CLS = new Class[]{Login.class, Main.class, DbAdmin.class, UserReport.class, ActReport.class, Img.class, GroupReport.class, GroupAdmin.class, UserAdmin.class, ResourceRP.class, JClicReportService.class};
    HttpThread httpThread;
    Messages messages;

    public HTTPReportServer(Messages messages) {
        this.messages = messages;
        this.httpThread = null;
        RequestProcessor.setDirectResources(true);
    }

    public boolean startServer(int n, int n2) {
        if (this.serverRunning()) {
            this.fireReportServerSystemEvent(this.messages.get("manage_server_already_started"), 5);
            return false;
        }
        try {
            this.httpThread = new HttpThread(n, n2);
            this.httpThread.start();
        }
        catch (Exception exception) {
            this.fireReportServerSystemEvent(exception.toString(), 5);
            return false;
        }
        return true;
    }

    public boolean stopServer() {
        if (!this.serverRunning()) {
            this.fireReportServerSystemEvent("Server is not started!", 5);
            return false;
        }
        this.httpThread.stopServer();
        while (this.serverRunning()) {
            Thread.yield();
        }
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.serverRunning()) {
            this.stopServer();
        }
        super.finalize();
    }

    public boolean serverRunning() {
        return this.httpThread != null;
    }

    protected class HttpThread
    extends Thread {
        boolean running = false;
        ServerSocket ss = null;
        int socketTimeOut = 0;

        HttpThread(int n, int n2) throws Exception {
            this.ss = new ServerSocket(n);
            HTTPReportServer.this.fireReportServerSystemEvent(Integer.toString(n), 2);
            this.socketTimeOut = n2;
            this.running = false;
        }

        public void run() {
            try {
                this.running = true;
                this.ss.setSoTimeout(1000);
                while (this.running) {
                    try {
                        Socket socket = this.ss.accept();
                        ClientConnection clientConnection = new ClientConnection(socket);
                        clientConnection.start();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (Exception exception) {
                        HTTPReportServer.this.fireReportServerSystemEvent(exception.toString(), 5);
                        this.running = false;
                    }
                }
                this.ss.close();
                HTTPReportServer.this.fireReportServerSystemEvent(null, 3);
            }
            catch (IOException iOException) {
                HTTPReportServer.this.fireReportServerSystemEvent(iOException.toString(), 5);
            }
            this.running = false;
            HTTPReportServer.this.httpThread = null;
        }

        public void stopServer() {
            this.running = false;
        }

        protected class ClientConnection
        extends Thread {
            Socket socket = null;
            int id = 0;

            ClientConnection(Socket socket) {
                this.socket = socket;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RequestProcessor requestProcessor = null;
                HTTPRequest hTTPRequest = null;
                try {
                    Iterator iterator;
                    int n;
                    hTTPRequest = new HTTPRequest(this.socket);
                    HTTPReportServer.this.fireReportServerSocketEvent(this.socket, hTTPRequest.firstLine, 6);
                    String string = hTTPRequest.urlBase;
                    if (string == null || string.length() == 0 || string.equals("/")) {
                        string = URI[0];
                    }
                    Class clazz = null;
                    for (n = 0; n < URI.length; ++n) {
                        if (!URI[n].equals(string)) continue;
                        clazz = CLS[n];
                        break;
                    }
                    n = 0;
                    if (clazz == null && hTTPRequest.urlBase != null && (n = hTTPRequest.urlBase.lastIndexOf(47)) >= 0 && n < hTTPRequest.urlBase.length() - 1) {
                        iterator = hTTPRequest.urlBase.substring(n + 1);
                        hTTPRequest.params.put("id", new String[]{iterator});
                        Class clazz2 = clazz = class$edu$xtec$servlet$ResourceRP == null ? (class$edu$xtec$servlet$ResourceRP = HTTPReportServer.class$("edu.xtec.servlet.ResourceRP")) : class$edu$xtec$servlet$ResourceRP;
                    }
                    if (clazz == null) {
                        hTTPRequest.error(404, null);
                    } else {
                        Object object;
                        requestProcessor = (RequestProcessor)clazz.newInstance();
                        requestProcessor.setParams(hTTPRequest.params);
                        if (requestProcessor.wantsInputStream()) {
                            requestProcessor.setInputStream(hTTPRequest.inputStream);
                        }
                        iterator = hTTPRequest.cookies.keySet().iterator();
                        while (iterator.hasNext()) {
                            object = (String)iterator.next();
                            requestProcessor.setCookie((String)object, (String)hTTPRequest.cookies.get(object));
                        }
                        requestProcessor.init();
                        hTTPRequest.head.cache = !requestProcessor.noCache();
                        object = new Vector();
                        requestProcessor.header((Vector)object);
                        if (!((Vector)object).isEmpty()) {
                            iterator = ((Vector)object).iterator();
                            while (iterator.hasNext() && !hTTPRequest.head.commited) {
                                String[] stringArray = (String[])iterator.next();
                                if (stringArray[0].equals("ERROR")) {
                                    hTTPRequest.error(Integer.parseInt(stringArray[1]), stringArray[2]);
                                    continue;
                                }
                                if (stringArray[0].equals("REDIRECT")) {
                                    hTTPRequest.redirect(stringArray[1]);
                                    break;
                                }
                                if (stringArray[0].equals("CONTENT_TYPE")) {
                                    hTTPRequest.head.contentType = stringArray[1];
                                    continue;
                                }
                                if (stringArray[0].equals("CONTENT_LENGTH")) {
                                    hTTPRequest.head.contentLength = Integer.parseInt(stringArray[1]);
                                    continue;
                                }
                                if (stringArray[0].equals("EXTRA")) {
                                    StringBuffer stringBuffer = new StringBuffer(100);
                                    if (hTTPRequest.head.extra != null) {
                                        stringBuffer.append(hTTPRequest.head.extra).append("\n\r");
                                    }
                                    stringBuffer.append(stringArray[1]).append(": ").append(stringArray[2]);
                                    hTTPRequest.head.extra = stringBuffer.substring(0);
                                    continue;
                                }
                                if (!stringArray[0].equals("COOKIE")) continue;
                                hTTPRequest.cookies.put(stringArray[1], stringArray[2]);
                            }
                        }
                        if (!hTTPRequest.head.commited) {
                            hTTPRequest.head.write();
                            if (requestProcessor.usesWriter()) {
                                requestProcessor.process(hTTPRequest.pw);
                                hTTPRequest.pw.flush();
                                hTTPRequest.pw.close();
                            } else {
                                requestProcessor.process(hTTPRequest.os);
                                hTTPRequest.os.flush();
                                hTTPRequest.os.close();
                            }
                            hTTPRequest.commited = true;
                        }
                        requestProcessor.end();
                        requestProcessor = null;
                    }
                }
                catch (Exception exception) {
                    String string;
                    int n = requestProcessor != null && requestProcessor.errCode >= 0 ? requestProcessor.errCode : 500;
                    String string2 = string = requestProcessor != null && requestProcessor.errMsg != null ? requestProcessor.errMsg : exception.getMessage();
                    if (hTTPRequest != null && !hTTPRequest.head.commited) {
                        try {
                            hTTPRequest.error(n, string);
                        }
                        catch (Exception exception2) {
                            System.err.println("Unable to report error due to\n" + exception2);
                        }
                    }
                    HTTPReportServer.this.fireReportServerSocketEvent(this.socket, exception.toString(), 5);
                    System.err.println("ERROR " + n + ": " + string);
                    exception.printStackTrace(System.err);
                }
                finally {
                    if (requestProcessor != null) {
                        requestProcessor.end();
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to close socket due to:\n" + exception);
                    }
                }
            }
        }
    }
}

