/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.jclic.report.HTTPReportServer;
import edu.xtec.jclic.report.ReportServerEvent;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.rp.JClicReportService;
import edu.xtec.jclic.report.rp.ReportsRequestProcessor;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Encryption;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;

public class ReportServer
extends JFrame
implements ReportServerConstants,
ResourceBridge {
    HTTPReportServer httpServer;
    int httpPort;
    int httpTimeOut;
    Options options = new Options(this);
    Messages msg;
    boolean webVerbose;
    boolean webAutostart;
    Image frameIcon = ResourceManager.getImageIcon("icons/reportServerIcon.png").getImage();
    File cfgFile;
    rsListener webServerListener;
    PrintWriter logWeb;
    DateFormat dateFormat;
    DateFormat timeFormat;
    public static final String MSG_BUNDLE = "messages.ReportServerMessages";
    private JButton aboutBtn;
    private JPanel btnPanel;
    private JPanel btnWebPanel;
    private JButton exitBtn;
    private JButton launchBrowserBtn;
    private JButton settingsButton;
    private JButton startWebServerBtn;
    private JButton stopWebServerBtn;
    private JButton webClearTextBtn;
    private JButton webCopyTextBtn;
    private JPanel webMsgPanel;
    private JScrollPane webMsgScrollPane;
    private JTextArea webMsgTextArea;
    private JPanel webServerPane;
    private JCheckBox webVerboseCheckBox;

    public ReportServer(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0] != null) {
            this.cfgFile = new File(stringArray[0]);
            if (!this.cfgFile.isAbsolute()) {
                this.cfgFile = new File(System.getProperty("user.dir"), stringArray[0]);
            }
        }
        if (this.cfgFile == null || !this.cfgFile.exists()) {
            this.cfgFile = new File(PersistentSettings.getFilePath("JClic", "jclicReports.properties", this.options));
        }
        Properties properties = new Properties();
        try {
            properties.load(ReportServerConstants.class.getResourceAsStream("jclicReports.properties"));
            if (this.cfgFile.exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.cfgFile);
                properties.load(fileInputStream);
                fileInputStream.close();
                String string = properties.getProperty("dbPassword");
                if (string != null && string.length() > 0) {
                    properties.setProperty("dbPassword", Encryption.Decrypt(string));
                }
            }
            this.options.syncProperties(properties, false);
            this.loadSettings();
        }
        catch (Exception exception) {
            System.err.println("Error reading settings!\n" + exception);
        }
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2);
        this.timeFormat = DateFormat.getTimeInstance(2);
        this.httpServer = new HTTPReportServer(this.msg);
        this.initComponents();
        this.webServerListener = new rsListener(this.webMsgTextArea);
        this.webServerListener.writer = this.logWeb;
        this.httpServer.addListener(this.webServerListener);
        JClicReportService.eventMaker.addListener(this.webServerListener);
        this.pack();
        this.setVisible(true);
        if (this.webAutostart) {
            this.startWebServer();
        }
    }

    protected void loadSettings() throws Exception {
        ReportsRequestProcessor.setProperties(this.options.toProperties());
        this.msg = PersistentSettings.getMessages(this.options, MSG_BUNDLE);
        this.msg.addBundle("messages.JClicMessages");
        this.msg.addBundle("commonSettings");
        this.options.setLookAndFeel();
        this.httpPort = this.options.getInt("http_port", 9000);
        this.httpTimeOut = this.options.getInt("http_timeout", 1200);
        ToolTipManager.sharedInstance().setEnabled(this.options.getBoolean("tooltips", true));
        this.webVerbose = this.options.getBoolean("http_verbose", true);
        this.webAutostart = this.options.getBoolean("http_autostart", true);
        String string = this.options.getString("browser");
        if (string != null && string.length() > 0) {
            BrowserLauncher.setPreferredBrowser(string);
        }
        try {
            String string2 = this.options.getString("http_logFile", null);
            if (string2 != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                this.logWeb = new PrintWriter(fileOutputStream, true);
                if (this.webServerListener != null) {
                    this.webServerListener.writer = this.logWeb;
                }
            }
        }
        catch (Exception exception) {
            this.msg.showErrorWarning(this, "error_opening_logs", exception);
        }
    }

    protected void startWebServer() {
        if (this.httpServer.startServer(this.httpPort, this.httpTimeOut)) {
            this.startWebServerBtn.setEnabled(false);
            this.stopWebServerBtn.setEnabled(true);
            this.launchBrowserBtn.setEnabled(true);
        } else {
            this.msg.showErrorWarning(this, "error_serverCannotStart", null);
        }
    }

    void stopWebServer() {
        if (this.httpServer.serverRunning()) {
            this.httpServer.stopServer();
        }
        this.startWebServerBtn.setEnabled(true);
        this.launchBrowserBtn.setEnabled(false);
        this.stopWebServerBtn.setEnabled(false);
    }

    private void initComponents() {
        this.webServerPane = new JPanel();
        this.btnWebPanel = new JPanel();
        this.startWebServerBtn = new JButton();
        this.stopWebServerBtn = new JButton();
        this.launchBrowserBtn = new JButton();
        this.webMsgPanel = new JPanel();
        this.webMsgScrollPane = new JScrollPane();
        this.webMsgTextArea = new JTextArea();
        this.webVerboseCheckBox = new JCheckBox();
        this.webClearTextBtn = new JButton();
        this.webCopyTextBtn = new JButton();
        this.btnPanel = new JPanel();
        this.settingsButton = new JButton();
        this.aboutBtn = new JButton();
        this.exitBtn = new JButton();
        this.setTitle(this.msg.get("form_title"));
        this.setIconImage(this.frameIcon);
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ReportServer.this.exitForm(windowEvent);
            }
        });
        this.webServerPane.setLayout(new GridBagLayout());
        this.btnWebPanel.setLayout(new GridBagLayout());
        this.startWebServerBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/run.gif")));
        this.startWebServerBtn.setToolTipText(this.msg.get("form_btn_start_tooltip"));
        this.startWebServerBtn.setText(this.msg.get("form_btn_start"));
        this.startWebServerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.startWebServerBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 2, 2);
        this.btnWebPanel.add((Component)this.startWebServerBtn, gridBagConstraints);
        this.stopWebServerBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/cancel.gif")));
        this.stopWebServerBtn.setToolTipText(this.msg.get("form_btn_stop_tooltip"));
        this.stopWebServerBtn.setText(this.msg.get("form_btn_stop"));
        this.stopWebServerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.stopWebServerBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 2, 2);
        this.btnWebPanel.add((Component)this.stopWebServerBtn, gridBagConstraints);
        this.launchBrowserBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/browser_small.gif")));
        this.launchBrowserBtn.setText(this.msg.get("form_btn_show"));
        this.launchBrowserBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.launchBrowserBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 2, 2);
        this.btnWebPanel.add((Component)this.launchBrowserBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webServerPane.add((Component)this.btnWebPanel, gridBagConstraints);
        this.webMsgPanel.setLayout(new GridBagLayout());
        this.webMsgPanel.setBorder(new TitledBorder(this.msg.get("form_messages_title")));
        this.webMsgPanel.setMinimumSize(new Dimension(300, 200));
        this.webMsgPanel.setPreferredSize(new Dimension(400, 200));
        this.webMsgTextArea.setEditable(false);
        this.webMsgScrollPane.setViewportView(this.webMsgTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.webMsgPanel.add((Component)this.webMsgScrollPane, gridBagConstraints);
        this.webVerboseCheckBox.setToolTipText(this.msg.get("form_messages_verbose_tooltip"));
        this.webVerboseCheckBox.setSelected(this.webVerbose);
        this.webVerboseCheckBox.setText(this.msg.get("form_messages_verbose"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.webMsgPanel.add((Component)this.webVerboseCheckBox, gridBagConstraints);
        this.webClearTextBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/delete.gif")));
        this.webClearTextBtn.setToolTipText(this.msg.get("form_messages_clear_tooltip"));
        this.webClearTextBtn.setText(this.msg.get("form_messages_clear"));
        this.webClearTextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.webClearTextBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.webMsgPanel.add((Component)this.webClearTextBtn, gridBagConstraints);
        this.webCopyTextBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/copy.gif")));
        this.webCopyTextBtn.setToolTipText(this.msg.get("form_messages_copy_tooltip"));
        this.webCopyTextBtn.setText(this.msg.get("form_messages_copy"));
        this.webCopyTextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.webCopyTextBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.webMsgPanel.add((Component)this.webCopyTextBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.webServerPane.add((Component)this.webMsgPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.webServerPane, "Center");
        this.btnPanel.setLayout(new GridBagLayout());
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/settings.gif")));
        this.settingsButton.setText(this.msg.get("settings_button"));
        this.settingsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.settingsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.btnPanel.add((Component)this.settingsButton, gridBagConstraints);
        this.aboutBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/about_small.gif")));
        this.aboutBtn.setText(this.msg.get("ABOUT"));
        this.aboutBtn.setToolTipText(this.msg.get("form_btn_exit_tooltip"));
        this.aboutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.aboutBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.btnPanel.add((Component)this.aboutBtn, gridBagConstraints);
        this.exitBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/exit_small.gif")));
        this.exitBtn.setText(this.msg.get("form_btn_exit"));
        this.exitBtn.setToolTipText(this.msg.get("form_btn_exit_tooltip"));
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportServer.this.exitBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.btnPanel.add((Component)this.exitBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.btnPanel, "South");
    }

    private void aboutBtnActionPerformed(ActionEvent actionEvent) {
        this.showAbout();
    }

    private void webClearTextBtnActionPerformed(ActionEvent actionEvent) {
        this.webMsgTextArea.setText("");
    }

    private void webCopyTextBtnActionPerformed(ActionEvent actionEvent) {
        this.webMsgTextArea.selectAll();
        this.webMsgTextArea.copy();
        this.webMsgTextArea.select(0, 0);
    }

    private void launchBrowserBtnActionPerformed(ActionEvent actionEvent) {
        try {
            URL uRL = new URL("http", InetAddress.getLocalHost().getHostName(), this.httpPort, "/");
            BrowserLauncher.openURL(uRL.toExternalForm());
        }
        catch (Exception exception) {
            this.msg.showErrorWarning(this, "error", exception);
        }
    }

    private void stopWebServerBtnActionPerformed(ActionEvent actionEvent) {
        this.stopWebServer();
    }

    private void startWebServerBtnActionPerformed(ActionEvent actionEvent) {
        this.startWebServer();
    }

    private void settingsButtonActionPerformed(ActionEvent actionEvent) {
        ReportServerSettingsDlg reportServerSettingsDlg = new ReportServerSettingsDlg((Frame)this, true, this.options);
        reportServerSettingsDlg.setVisible(true);
        if (reportServerSettingsDlg.result && this.cfgFile != null) {
            try {
                String string = null;
                Properties properties = this.options.toProperties();
                string = properties.getProperty("dbPassword", "");
                if (string != null && string.length() > 0) {
                    properties.put("dbPassword", Encryption.Encrypt(string));
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.cfgFile);
                properties.store(fileOutputStream, "Jclic report server settings");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                this.msg.showErrorWarning(this, "error_writting_settings", exception);
            }
            this.stopWebServer();
            if (this.logWeb != null) {
                this.logWeb.flush();
                this.logWeb.close();
                this.logWeb = null;
                this.webServerListener.writer = null;
            }
            try {
                this.loadSettings();
            }
            catch (Exception exception) {
                System.err.println("Error loading settings.\n" + exception);
            }
            if (this.webAutostart) {
                this.startWebServer();
            }
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.stopWebServer();
        if (this.logWeb != null) {
            this.logWeb.flush();
            this.logWeb.close();
            this.logWeb = null;
            this.webServerListener.writer = null;
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new ReportServer(stringArray).setVisible(true);
    }

    public InputStream getProgressInputStream(InputStream inputStream, int n, String string) {
        return inputStream;
    }

    public void displayUrl(String string, boolean bl) {
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            System.err.println("Error opening URL: " + string);
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public String getMsg(String string) {
        return this.msg.get(string);
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    protected void showAbout() {
        AboutWindow aboutWindow = new AboutWindow((Component)this.getComponent(), this, new Dimension(500, 400));
        try {
            aboutWindow.buildAboutTab("JClic Reports", this.getMsg("REPORTS_VERSION"), "logo_reports_small.png", null, null, null, null);
            aboutWindow.buildStandardTab(aboutWindow.getHtmlSystemInfo(), "about_window_systemInfo", "about_window_lb_system", "icons/system_small.gif");
            aboutWindow.setVisible(true);
        }
        catch (Exception exception) {
            System.err.println("Error building about window!\n" + exception);
        }
    }

    class rsListener
    implements ReportServerEventMaker.Listener {
        JTextArea textArea;
        PrintWriter writer;

        rsListener(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        public void reportEventPerformed(ReportServerEvent reportServerEvent) {
            if (ReportServer.this.webVerbose || reportServerEvent.type == 0) {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(ReportServer.this.dateFormat.format(new Date()));
                stringBuffer.append(" ").append(reportServerEvent.toString());
                if (this.writer != null) {
                    this.writer.println(stringBuffer.substring(0));
                }
                this.textArea.append(stringBuffer.append("\n").substring(0));
            }
        }
    }
}

