/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.convert.jorbis.JorbisFormatConversionProvider;
import org.tritonus.sampled.file.jorbis.JorbisAudioFileReader;

public class AppletVorbisSPIWorkaround {
    public static boolean DEBUG = false;
    public static String useragent = null;

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        try {
            return AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.convert.jorbis.JorbisFormatConversionProvider");
                return new JorbisFormatConversionProvider().getAudioInputStream(audioFormat, audioInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Vorbis codec not properly installed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioFileFormat:file)");
            }
            AudioFileFormat audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(bufferedInputStream);
            return audioFileFormat;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioInputStream:file)");
            }
            return AppletVorbisSPIWorkaround.getAudioInputStream(bufferedInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)bufferedInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)bufferedInputStream).close();
            throw iOException;
        }
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioInputStream:url)");
            }
            return AppletVorbisSPIWorkaround.getAudioInputStream(bufferedInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)bufferedInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)bufferedInputStream).close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        Object object;
        BufferedInputStream bufferedInputStream = null;
        if (useragent != null) {
            object = uRL.openConnection();
            ((URLConnection)object).setUseCaches(false);
            ((URLConnection)object).setDoInput(true);
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).setAllowUserInteraction(false);
            ((URLConnection)object).setRequestProperty("User-Agent", useragent);
            ((URLConnection)object).setRequestProperty("Accept", "*/*");
            ((URLConnection)object).setRequestProperty("Icy-Metadata", "1");
            ((URLConnection)object).setRequestProperty("Connection", "close");
            bufferedInputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
        } else {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec AudioFileFormat(url)");
            }
            object = AppletVorbisSPIWorkaround.getAudioFileFormat(bufferedInputStream);
            return object;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.err.println("Using AppletVorbisSPIWorkaround to get codec");
                }
                try {
                    inputStream.mark(4096);
                    Class.forName("org.tritonus.sampled.file.jorbis.JorbisAudioFileReader");
                    AudioFileFormat audioFileFormat = new JorbisAudioFileReader().getAudioFileFormat(inputStream);
                    return audioFileFormat;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Vorbis codec not properly installed");
                }
            }
        }
        finally {
            inputStream.reset();
        }
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println("Using AppleVorbisSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.file.jorbis.JorbisAudioFileReader");
                return new JorbisAudioFileReader().getAudioInputStream(inputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Vorbis codec not properly installed:" + classNotFoundException.getMessage());
            }
        }
    }
}

