/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ConnectionBean {
    private Connection con;
    private HashMap statements;
    private Date born;
    private Date lastUsed;
    private String lastStatement;
    private Date closed;
    public int usageCount;

    public ConnectionBean(Connection connection, boolean bl) {
        this.con = connection;
        if (bl) {
            this.statements = new HashMap();
        }
        this.born = new Date();
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConnectionBean ").append(this.hashCode());
        if (this.statements != null) {
            stringBuffer.append(" (").append(this.statements.size()).append(" statements)");
        }
        stringBuffer.append("<br>\n");
        stringBuffer.append("Created: ").append(this.born).append("<br>\n");
        stringBuffer.append("Usage count: ").append(this.usageCount).append("<br>\n");
        if (this.lastUsed == null) {
            stringBuffer.append("Not yet used!<br>\n");
        } else {
            stringBuffer.append("Last used: ").append(this.lastUsed).append("<br>\n");
            stringBuffer.append("Last statement: ").append(this.lastStatement).append("<br>\n");
        }
        if (this.closed != null) {
            stringBuffer.append("Closed: ").append(this.closed).append("<br>\n");
        }
        return stringBuffer.toString();
    }

    public Connection getConnection() {
        this.lastUsed = new Date();
        return this.con;
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.closed != null) {
            throw new SQLException("Connection closed!");
        }
        this.lastUsed = new Date();
        this.lastStatement = string;
        PreparedStatement preparedStatement2 = preparedStatement = this.statements == null ? null : (PreparedStatement)this.statements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.con.prepareStatement(string);
            if (this.statements != null) {
                this.statements.put(string, preparedStatement);
            }
        } else {
            try {
                preparedStatement.clearParameters();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return preparedStatement;
    }

    public PreparedStatement getPreparedStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.closed != null) {
            throw new SQLException("Connection closed!");
        }
        this.lastUsed = new Date();
        this.lastStatement = string;
        PreparedStatement preparedStatement2 = preparedStatement = this.statements == null ? null : (PreparedStatement)this.statements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.con.prepareStatement(string, n, n2);
            if (this.statements != null) {
                this.statements.put(string, preparedStatement);
            }
        } else {
            try {
                preparedStatement.clearParameters();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return preparedStatement;
    }

    public void closeStatement(PreparedStatement preparedStatement) {
        this.closeStatement(preparedStatement, false);
    }

    public void closeStatement(PreparedStatement preparedStatement, boolean bl) {
        if (preparedStatement != null) {
            if (bl || this.statements == null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    System.err.println("Error closing statement: " + preparedStatement);
                }
            }
            if (this.statements != null && bl) {
                Iterator iterator = this.statements.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (this.statements.get(k) != preparedStatement) continue;
                    this.statements.remove(k);
                    break;
                }
            }
        }
    }

    public void closeConnection() throws SQLException {
        if (this.closed == null) {
            this.closed = new Date();
            if (this.statements != null) {
                Iterator iterator = this.statements.keySet().iterator();
                while (iterator.hasNext()) {
                    PreparedStatement preparedStatement = (PreparedStatement)this.statements.get(iterator.next());
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                this.statements.clear();
            }
            this.con.close();
        }
    }

    public String getLastStatement() {
        return this.lastStatement;
    }

    public int getNumStatements() {
        return this.statements == null ? 0 : this.statements.size();
    }
}

