/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Options
extends HashMap {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final Boolean BTRUE = new Boolean(true);
    public static final Boolean BFALSE = new Boolean(false);
    public static final String MAC = "Mac";
    public static final String WIN = "Windows";
    public static final String JAVA131 = "java131";
    public static final String JAVA14 = "java14";
    public static final String JAVA141 = "java141";
    public static final String ARCH64BIT = "arch64bit";
    public static final String MAIN_PARENT_COMPONENT = "mainParentComponent";
    public static final String APPLET = "applet";
    public static final String LANGUAGE_BY_PARAM = "languageByParam";
    protected static final String[] TRANSIENT_KEYS = new String[]{"mainParentComponent", "applet", "languageByParam", "Mac", "Windows", "java14", "java131", "java141", "arch64bit", "messages"};

    public Options() {
        this.init();
    }

    public Options(Map map) {
        super(map);
        this.init();
    }

    public Options(Component component) {
        this.init();
        if (component != null) {
            this.setMainComponent(component);
        }
    }

    protected void init() {
        String string;
        String string2 = System.getProperty("java.version");
        if (string2 != null && string2.compareTo("1.3.1") >= 0) {
            this.put(JAVA131, new Boolean(true));
        }
        if (string2 != null && string2.compareTo("1.4.0") >= 0) {
            this.put(JAVA14, new Boolean(true));
        }
        if (string2 != null && string2.compareTo("1.4.1") >= 0) {
            this.put(JAVA141, new Boolean(true));
        }
        if ((string = System.getProperty("os.name").toLowerCase()) != null) {
            if (string.indexOf("mac") >= 0) {
                this.put(MAC, new Boolean(true));
                this.put("lookAndFeel", "system");
            } else if (string.toLowerCase().indexOf("win") >= 0) {
                this.put(WIN, new Boolean(true));
            }
        }
        if ("64".equals(string = System.getProperty("sun.arch.data.model"))) {
            this.put(ARCH64BIT, new Boolean(true));
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Object k = iterator.next();
            if (k == null || !(k instanceof String)) continue;
            int n = 0;
            for (n = 0; n < TRANSIENT_KEYS.length && !k.equals(TRANSIENT_KEYS[n]); ++n) {
            }
            if (n != TRANSIENT_KEYS.length || (v = this.get(k)) == null) continue;
            properties.setProperty((String)k, v.toString());
        }
        return properties;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof Boolean) {
                bl2 = (Boolean)v;
            } else if (v instanceof String) {
                bl2 = ((String)v).equalsIgnoreCase(TRUE);
            } else if (v instanceof Integer) {
                bl2 = (Integer)v != 0;
            }
        }
        return bl2;
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, bl ? BTRUE : BFALSE);
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public String getString(String string, String string2) {
        return StrUtils.secureString(this.get(string), string2);
    }

    public int getInt(String string, int n) {
        int n2 = n;
        Object v = this.get(string);
        if (v != null) {
            if (v instanceof Integer) {
                n2 = (Integer)v;
            } else if (v instanceof String) {
                try {
                    n2 = Integer.parseInt((String)v);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
            }
        }
        return n2;
    }

    public Messages getMessages() {
        return this.getMessages(null);
    }

    public Messages getMessages(String string) {
        return Messages.getMessages(this, string);
    }

    public String getMsg(String string) {
        return this.getMessages(null).get(string);
    }

    public Component getMainComponent() {
        return (Component)this.get(MAIN_PARENT_COMPONENT);
    }

    public Applet getApplet() {
        return (Applet)this.get(APPLET);
    }

    public void setMainComponent(Component component) {
        this.put(MAIN_PARENT_COMPONENT, component);
        if (component instanceof Applet) {
            this.put(APPLET, component);
        }
    }

    public void setLookAndFeel() {
        String string = this.getString("lookAndFeel");
        if (string != null) {
            LFUtil.setLookAndFeel(string, this.getMainComponent());
        }
    }

    public void syncProperties(Map map, boolean bl) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (bl && this.containsKey(entry.getKey())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public static Map strToMap(String string, Map map, String string2, char c, boolean bl) {
        if (string != null && string.length() >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(c);
                if (n <= 0) continue;
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                if (string4 == null || string4.length() <= 0 || !bl && string.length() <= 0) continue;
                map.put(string4, string5);
            }
        }
        return map;
    }

    public static String getString(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        return string3 == null ? string2 : string3;
    }

    public static Window getWindowForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return Options.getWindowForComponent(component.getParent());
    }
}

