/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;

public abstract class Skin
extends JPanel
implements ProgressInputStream.ProgressInputStreamListener {
    public static final int DEFAULT_PROGRESS_WAKE_ON = 1000;
    public static final String RESOURCE_FOLDER = "skins";
    public static final String RESOURCE_LIST_FILE = "listskins.properties";
    public static final int MAIN = 0;
    public static final int AUX = 1;
    public static final int MEM = 2;
    public static final int NUM_MSG_AREAS = 3;
    public static final String[] msgAreaNames = new String[]{"main", "aux", "mem"};
    public String name = null;
    public String fileName = null;
    protected AbstractButton[] buttons = new AbstractButton[8];
    protected Counter[] counters = new Counter[3];
    protected ActiveBox[] msgArea = new ActiveBox[3];
    protected Component player;
    protected PlayStation ps;
    protected ActiveBox msgBox;
    long mem;
    private static int waitCursorCount;
    protected boolean readyToPaint;
    public JDialog currentHelpWindow;
    public JDialog currentAboutWindow;
    protected int progressMax;
    protected int progress;
    protected boolean hasProgress;
    protected boolean progressActive;
    protected long progressStartTime = 0L;
    protected static HashSet skinStack;
    public static final String ELEMENT_NAME = "skin";
    public static final String INTERNAL_SKIN_PREFIX = "@";
    public static final String NAME = "name";

    protected Skin() {
        this.setEnabled(false);
        this.readyToPaint = false;
        this.setLayout(null);
        this.player = null;
        this.ps = null;
        this.currentHelpWindow = null;
        this.currentAboutWindow = null;
        this.progress = 0;
        this.progressMax = 100;
        this.progressActive = false;
        this.hasProgress = false;
        skinStack.add(this);
    }

    public void emptySkinStack() {
        skinStack = new HashSet();
    }

    public void attach(Component component) {
        if (this.player != null) {
            this.detach();
        }
        this.player = component;
        this.add(this.player);
        this.setWaitCursor();
        this.setEnabled(true);
        this.revalidate();
    }

    public void detach() {
        if (this.player != null) {
            this.remove(this.player);
            this.player = null;
        }
        if (this.currentHelpWindow != null) {
            this.currentHelpWindow.setVisible(false);
        }
        if (this.currentAboutWindow != null) {
            this.currentAboutWindow.setVisible(false);
        }
        this.setEnabled(false);
    }

    public static Skin getSkin(String string, FileSystem fileSystem, PlayStation playStation) throws Exception {
        Serializable serializable;
        Skin skin = null;
        Iterator iterator = skinStack.iterator();
        while (iterator.hasNext()) {
            serializable = (Skin)iterator.next();
            if (serializable == null || !string.equals(((Skin)serializable).fileName) || !playStation.equals(((Skin)serializable).ps)) continue;
            return serializable;
        }
        if (string.startsWith(INTERNAL_SKIN_PREFIX)) {
            serializable = FileSystem.getXMLDocument(ResourceManager.getResourceAsStream("skins/" + string.substring(INTERNAL_SKIN_PREFIX.length()))).getRootElement();
            fileSystem = null;
        } else {
            serializable = fileSystem.getXMLDocument(string).getRootElement();
        }
        JDomUtility.checkName((Element)serializable, ELEMENT_NAME);
        Class<?> clazz = Class.forName(JDomUtility.getClassName((Element)serializable));
        skin = (Skin)clazz.newInstance();
        skin.name = ((Element)serializable).getAttributeValue(NAME);
        skin.fileName = string;
        skin.ps = playStation;
        skin.setProperties((Element)serializable, fileSystem);
        return skin;
    }

    protected abstract void setProperties(Element var1, FileSystem var2) throws Exception;

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (this.player != null) {
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        }
        this.render(graphics2D, graphics2D.getClipBounds());
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public abstract void render(Graphics2D var1, Rectangle var2);

    public void setProgressMax(int n) {
        this.progressMax = n;
    }

    public void setProgressValue(int n) {
        this.progress = n;
    }

    public void setProgressName(String string) {
        this.setSystemMessage(null, string == null ? null : this.ps.getMsg("LOADING_FILE") + " " + FileSystem.getFileNameOf(string));
    }

    public void startProgress(String string) {
        this.progressStartTime = System.currentTimeMillis();
        this.setProgressValue(0);
        this.progressActive = true;
    }

    public void endProgress() {
        this.progressActive = false;
    }

    public InputStream getProgressInputStream(InputStream inputStream, int n, String string) {
        InputStream inputStream2 = null;
        if (this.hasProgress && !this.progressActive) {
            ProgressInputStream progressInputStream = new ProgressInputStream(inputStream, n, string);
            progressInputStream.addProgressInputStreamListener(this);
            inputStream2 = progressInputStream;
        } else {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }

    public ActiveBox getMsgBox() {
        return this.msgBox;
    }

    public Counter getCounter(int n) {
        return n < 0 || n >= 3 ? null : this.counters[n];
    }

    public void enableCounter(int n, boolean bl) {
        Counter counter = this.getCounter(n);
        if (counter != null) {
            counter.setEnabled(bl);
        }
    }

    public void resetAllCounters(boolean bl) {
        for (int i = 0; i < 3; ++i) {
            if (this.counters[i] == null) continue;
            this.counters[i].setValue(0);
            this.counters[i].setCountDown(0);
            this.counters[i].setEnabled(bl);
        }
    }

    public AbstractButton getButton(int n) {
        return n < 0 || n >= 8 ? null : this.buttons[n];
    }

    public Object[] getCurrentSettings() {
        Object[] objectArray = new Object[]{this.buttons, this.msgBox, this.counters, new Integer(waitCursorCount)};
        return objectArray;
    }

    public void setCurrentSettings(Object[] objectArray) {
        int n;
        Object object;
        if (objectArray.length > 0 && objectArray[0] != null) {
            object = (AbstractButton[])objectArray[0];
            for (n = 0; n < 8; ++n) {
                if (n >= ((AbstractButton[])object).length || object[n] == null || this.buttons[n] == null) continue;
                this.buttons[n].setVisible(((Component)object[n]).isVisible());
            }
        }
        if (objectArray.length > 1 && objectArray[1] != null && this.msgBox != null) {
            object = (ActiveBox)objectArray[1];
            this.msgBox.copyContent((ActiveBox)object);
            this.msgBox.setBoxBase(((AbstractBox)object).getBoxBaseResolve());
        }
        if (objectArray.length > 2 && objectArray[2] != null && this.counters != null) {
            object = (Counter[])objectArray[2];
            for (n = 0; n < 3; ++n) {
                if (n >= ((Object)object).length || object[n] == null || this.counters[n] == null) continue;
                this.counters[n].setEnabled(((Counter)object[n]).isEnabled());
                this.counters[n].setValue(((Counter)object[n]).getValue());
            }
        }
        if (objectArray.length > 3 && objectArray[3] != null) {
            waitCursorCount = (Integer)objectArray[3];
            this.setWaitCursor();
        }
    }

    protected void drawSlicedFrame(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, Image image, int n, int n2, int n3, int n4) {
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        rectangle3.setBounds(rectangle2.x, rectangle2.y, n, n3);
        rectangle4.setBounds(rectangle.x, rectangle.y, rectangle3.width, rectangle3.height);
        Utils.drawImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x += n;
        rectangle3.width = n2 - n;
        rectangle4.x += n;
        rectangle4.width = rectangle.width - n - (rectangle2.width - n2);
        Utils.tileImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x = rectangle2.x + n2;
        rectangle3.width = rectangle2.width - n2;
        rectangle4.x = rectangle.x + rectangle.width - (rectangle2.width - n2);
        rectangle4.width = rectangle3.width;
        Utils.drawImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.setBounds(rectangle2.x, rectangle2.y + n3, n, n4 - n3);
        rectangle4.setBounds(rectangle.x, rectangle.y + n3, n, rectangle.height - n3 - (rectangle2.height - n4));
        Utils.tileImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x += n;
        rectangle3.width = n2 - n;
        rectangle4.x += n;
        rectangle4.width = rectangle.width - n - (rectangle2.width - n2);
        Utils.tileImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x = rectangle2.x + n2;
        rectangle3.width = rectangle2.width - n2;
        rectangle4.x = rectangle.x + rectangle.width - (rectangle2.width - n2);
        rectangle4.width = rectangle3.width;
        Utils.tileImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.setBounds(rectangle2.x, rectangle2.y + n4, n, rectangle2.height - n4);
        rectangle4.setBounds(rectangle.x, rectangle.y + rectangle.height - (rectangle2.height - n4), rectangle3.width, rectangle3.height);
        Utils.drawImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x += n;
        rectangle3.width = n2 - n;
        rectangle4.x += n;
        rectangle4.width = rectangle.width - n - (rectangle2.width - n2);
        Utils.tileImage(graphics, image, rectangle4, rectangle3, this);
        rectangle3.x = rectangle2.x + n2;
        rectangle3.width = rectangle2.width - n2;
        rectangle4.x = rectangle.x + rectangle.width - (rectangle2.width - n2);
        rectangle4.width = rectangle3.width;
        Utils.drawImage(graphics, image, rectangle4, rectangle3, this);
    }

    public boolean hasMemMonitor() {
        return this.msgArea[2] != null;
    }

    public void setMem(long l) {
        this.mem = l;
        if (this.msgArea[2] != null) {
            String string = new StringBuffer(Long.toString(this.mem / 1000L)).append(" Kb").substring(0);
            this.msgArea[2].setTextContent(string);
        }
    }

    public void setSystemMessage(String string, String string2) {
        if (!this.isVisible()) {
            return;
        }
        if (this.msgArea[0] != null && string != null) {
            this.msgArea[0].setTextContent(string);
        }
        if (this.msgArea[1] != null) {
            this.msgArea[1].setTextContent(string2 == null ? "" : string2);
        }
    }

    public void startAnimation() {
    }

    public void stopAnimation() {
    }

    public void setWaitCursor(boolean bl) {
        if (bl) {
            ++waitCursorCount;
        } else if (--waitCursorCount < 0) {
            waitCursorCount = 0;
        }
        this.setWaitCursor();
    }

    public void setWaitCursor() {
        this.setCursor(waitCursorCount > 0 ? Cursor.getPredefinedCursor(3) : null);
    }

    public void showHelp(JComponent jComponent, String string) {
        this.currentHelpWindow = new HelpWindow(this, jComponent, string);
        this.currentHelpWindow.setVisible(true);
        this.currentHelpWindow = null;
        this.requestFocus();
    }

    public AboutWindow buildAboutWindow() {
        return new AboutWindow((Component)this, this.ps, new Dimension(500, 400));
    }

    public void showAboutWindow(AboutWindow aboutWindow) {
        this.currentAboutWindow = aboutWindow;
        this.currentAboutWindow.setVisible(true);
        this.currentAboutWindow = null;
        this.requestFocus();
    }

    public void requestFocus() {
        if (this.player != null) {
            this.player.requestFocus();
        }
    }

    public static String[] getSystemSkinList(boolean bl) {
        Vector<String> vector = new Vector<String>();
        Properties properties = new Properties();
        try {
            properties.load(ResourceManager.getResourceAsStream("skins/listskins.properties"));
        }
        catch (Exception exception) {
            System.err.println("Unable to open /edu/xtec/resources/skins/listskins.properties:\n" + exception);
        }
        if (bl) {
            vector.add("");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = INTERNAL_SKIN_PREFIX + properties.getProperty(string).trim();
            vector.add(string2);
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[vector.size()]);
        }
        return new String[0];
    }

    static {
        skinStack = new HashSet();
    }

    class HelpWindow
    extends ExtendedJDialog {
        HelpWindow(Component component, JComponent jComponent, String string) {
            JComponent jComponent2;
            super(component, Skin.this.ps.getMsg("help_window_caption"), true);
            this.getContentPane().setLayout(new BorderLayout());
            if (jComponent != null) {
                this.getContentPane().add((Component)jComponent, "Center");
            } else {
                jComponent2 = new JLabel(string == null || string.trim().length() == 0 ? "?" : string.trim());
                this.getContentPane().add((Component)jComponent2, "North");
            }
            jComponent2 = new JButton(Skin.this.ps.getMsg("help_window_close_button"), ResourceManager.getImageIcon("icons/exit_small.gif"));
            ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpWindow.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)jComponent2, "South");
            this.pack();
            Point point = null;
            if (jComponent != null && (point = (Point)jComponent.getClientProperty("prefLoc")) != null) {
                point = new Point(point);
                int n = (this.getWidth() - this.getContentPane().getWidth()) / 2;
                int n2 = this.getHeight() - this.getContentPane().getHeight() - n;
                point.translate(-n, -n2);
            }
            if (point == null) {
                point = component.getLocationOnScreen();
            }
            this.setLocation(point);
        }
    }
}

