/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.jclic.report.SessionReg;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.CompoundListCellRenderer;
import edu.xtec.util.CompoundObject;
import edu.xtec.util.Encryption;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class Reporter {
    String userId;
    String sessionKey;
    String sessionContext;
    String groupCodeFilter;
    String userCodeFilter;
    String description;
    Date started;
    Vector sessions = new Vector();
    SessionReg currentSession;
    public boolean initiated = false;
    protected Boolean bUserBased;
    public static final String ALLOW_CREATE_GROUPS = "ALLOW_CREATE_GROUPS";
    public static final String ALLOW_CREATE_USERS = "ALLOW_CREATE_USERS";
    public static final String SHOW_GROUP_LIST = "SHOW_GROUP_LIST";
    public static final String SHOW_USER_LIST = "SHOW_USER_LIST";
    public static final String USER_TABLES = "USER_TABLES";
    public static final String TIME_LAP = "TIME_LAP";
    public static final String ELEMENT_NAME = "reporter";
    public static final String USER_ID = "user";
    public static final String KEY = "key";
    public static final String CONTEXT = "context";
    public static final String GROUP_CODE_FILTER = "groupCodeFilter";
    public static final String USER_CODE_FILTER = "userCodeFilter";

    public Reporter() {
        this.started = new Date();
    }

    public String getProperty(String string, String string2) throws Exception {
        return string2;
    }

    public boolean getBooleanProperty(String string, boolean bl) throws Exception {
        String string2 = this.getProperty(string, new Boolean(bl).toString());
        return string == null ? bl : Boolean.valueOf(string2);
    }

    public Vector getGroups() throws Exception {
        return null;
    }

    public Vector getUsers(String string) throws Exception {
        return null;
    }

    public UserData getUserData(String string) throws Exception {
        return null;
    }

    public GroupData getGroupData(String string) throws Exception {
        return null;
    }

    public boolean userBased() throws Exception {
        if (this.bUserBased == null) {
            this.bUserBased = new Boolean(this.getBooleanProperty(USER_TABLES, true));
        }
        return this.bUserBased;
    }

    protected GroupData promptForNewGroup(Component component, Messages messages) throws Exception {
        JTextField jTextField = new JTextField(20);
        JTextField jTextField2 = new JTextField(20);
        JComponent[] jComponentArray = new JComponent[]{jTextField, jTextField2};
        String[] stringArray = new String[]{"report_name_prompt", "report_id_prompt"};
        String string = null;
        String string2 = null;
        GroupData groupData = null;
        while (groupData == null) {
            boolean bl = messages.showInputDlg(component, new String[]{"report_new_group_data"}, stringArray, jComponentArray, "report_new_group");
            if (!bl) {
                return null;
            }
            string = StrUtils.nullableString(jTextField.getText());
            string2 = StrUtils.nullableString(jTextField2.getText());
            if (string2 == null) {
                messages.showAlert(component, "report_err_bad_id");
                continue;
            }
            if (this.getGroupData(string2) != null) {
                messages.showAlert(component, "report_err_duplicate_id");
                continue;
            }
            if (string == null) {
                messages.showAlert(component, "report_err_bad_name");
                continue;
            }
            groupData = new GroupData(string2, string, null, null);
            groupData.setId(this.newGroup(groupData));
        }
        return groupData;
    }

    protected UserData promptForNewUser(Component component, Messages messages, String string) throws Exception {
        if (string == null && (string = this.promptGroupId(component, messages)) == null) {
            return null;
        }
        JTextField jTextField = new JTextField(20);
        JTextField jTextField2 = new JTextField(20);
        JPasswordField jPasswordField = new JPasswordField(24);
        JPasswordField jPasswordField2 = new JPasswordField(24);
        JComponent[] jComponentArray = new JComponent[]{jTextField, jTextField2, jPasswordField, jPasswordField2};
        String[] stringArray = new String[]{"report_name_prompt", "report_id_prompt", "report_pw_prompt", "report_pw_prompt_confirm"};
        String string2 = null;
        String string3 = null;
        String string4 = null;
        UserData userData = null;
        while (userData == null) {
            if (!messages.showInputDlg(component, new String[]{"report_new_user_data"}, stringArray, jComponentArray, "report_new_user")) {
                return null;
            }
            string2 = StrUtils.nullableString(jTextField.getText());
            string3 = StrUtils.nullableString(jTextField2.getText());
            string4 = StrUtils.nullableString(String.copyValueOf(jPasswordField.getPassword()));
            boolean bl = true;
            if (string4 != null) {
                bl = string4.equals(StrUtils.nullableString(String.copyValueOf(jPasswordField2.getPassword())));
                string4 = Encryption.Encrypt(string4);
            }
            if (!bl) {
                messages.showAlert(component, "report_err_bad_pwd");
                continue;
            }
            if (string3 == null) {
                messages.showAlert(component, "report_err_bad_id");
                continue;
            }
            if (this.getUserData(string3) != null) {
                messages.showAlert(component, "report_err_duplicate_id");
                continue;
            }
            if (string2 == null) {
                messages.showAlert(component, "report_err_bad_name");
                continue;
            }
            userData = new UserData(string3, string2, null, string4, string);
            userData.setId(this.newUser(userData));
        }
        return userData;
    }

    protected String promptGroupId(Component component, final Messages messages) throws Exception {
        Serializable serializable;
        Object object;
        String string = null;
        Vector vector = this.getGroups();
        if (vector.isEmpty()) {
            object = messages.get("report_generic_group_name");
            this.newGroup(new GroupData((String)object, (String)object, null, null));
            vector = this.getGroups();
            if (vector.isEmpty()) {
                return string;
            }
        }
        object = vector;
        JList jList = new JList();
        jList.setCellRenderer(new CompoundListCellRenderer());
        jList.setListData(object);
        jList.setSelectedValue(((Vector)object).get(0), false);
        JScrollPane jScrollPane = new JScrollPane(jList);
        JComponent[] jComponentArray = null;
        if (this.getBooleanProperty(ALLOW_CREATE_GROUPS, false)) {
            serializable = new JButton(messages.get("report_new_group"));
            ((AbstractButton)serializable).addActionListener(new ActionListener((Vector)object, jList){
                private final /* synthetic */ Vector val$v;
                private final /* synthetic */ JList val$list;
                {
                    this.val$v = vector;
                    this.val$list = jList;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = null;
                    if (actionEvent.getSource() != null && actionEvent.getSource() instanceof Component) {
                        component = (Component)actionEvent.getSource();
                    }
                    try {
                        GroupData groupData = Reporter.this.promptForNewGroup(component, messages);
                        if (groupData != null) {
                            this.val$v.add(groupData);
                            this.val$list.setListData(this.val$v);
                            this.val$list.setSelectedValue(groupData, true);
                        }
                    }
                    catch (Exception exception) {
                        messages.showErrorWarning(component, "report_err_creating_group", exception);
                    }
                }
            });
            jComponentArray = new JComponent[]{jScrollPane, serializable};
        } else {
            jComponentArray = new JComponent[]{jScrollPane};
        }
        if (messages.showInputDlg(component, new String[]{"report_grouplist_title"}, null, jComponentArray, "report_ident_user") && (serializable = (GroupData)jList.getSelectedValue()) != null) {
            string = ((CompoundObject)serializable).getId();
        }
        return string;
    }

    public String promptUserId(Component component, final Messages messages) throws Exception {
        if (!this.userBased()) {
            throw new Exception("No users defined in the database!");
        }
        boolean bl = false;
        int n = 0;
        while (this.userId == null && !bl && n++ < 3) {
            Object object;
            Object object2;
            JTextField jTextField;
            Object object3;
            if (this.getBooleanProperty(SHOW_USER_LIST, true)) {
                Serializable serializable;
                object3 = null;
                if (this.getBooleanProperty(SHOW_GROUP_LIST, true) && (object3 = this.promptGroupId(component, messages)) == null) {
                    return null;
                }
                jTextField = object3;
                object2 = this.getUsers((String)((Object)jTextField));
                boolean bl2 = this.getBooleanProperty(ALLOW_CREATE_USERS, false);
                if (((Vector)object2).isEmpty() && !bl2) {
                    messages.showErrorWarning(component, jTextField == null ? "report_err_no_users" : "report_err_no_users_in_group", null);
                    break;
                }
                JList jList = new JList();
                jList.setCellRenderer(new CompoundListCellRenderer());
                jList.setListData(object2);
                if (!((Vector)object2).isEmpty()) {
                    jList.setSelectedValue(((Vector)object2).get(0), false);
                }
                object = new JScrollPane(jList);
                JComponent[] jComponentArray = null;
                if (bl2) {
                    serializable = new JButton(messages.get("report_new_user"));
                    ((JComponent)serializable).setToolTipText(messages.get("report_new_user_tooltip"));
                    ((AbstractButton)serializable).addActionListener(new ActionListener((String)((Object)jTextField), (Vector)object2, jList){
                        private final /* synthetic */ String val$groupId;
                        private final /* synthetic */ Vector val$v;
                        private final /* synthetic */ JList val$list;
                        {
                            this.val$groupId = string;
                            this.val$v = vector;
                            this.val$list = jList;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            Component component = null;
                            if (actionEvent.getSource() != null && actionEvent.getSource() instanceof Component) {
                                component = (Component)actionEvent.getSource();
                            }
                            try {
                                UserData userData = Reporter.this.promptForNewUser(component, messages, this.val$groupId);
                                if (userData != null) {
                                    this.val$v.add(userData);
                                    this.val$list.setListData(this.val$v);
                                    this.val$list.setSelectedValue(userData, true);
                                }
                            }
                            catch (Exception exception) {
                                messages.showErrorWarning(component, "report_err_creating_user", exception);
                            }
                        }
                    });
                    jComponentArray = new JComponent[]{object, serializable};
                } else {
                    jComponentArray = new JComponent[]{object};
                }
                if (!messages.showInputDlg(component, new String[]{"report_userlist_title"}, null, jComponentArray, "report_ident_user") || (serializable = (UserData)jList.getSelectedValue()) == null) break;
                if (((UserData)serializable).pwd != null && ((UserData)serializable).pwd.length() > 0) {
                    String string;
                    String string2 = Encryption.Decrypt(((UserData)serializable).pwd);
                    if (string2.equals(string = messages.showInputDlg(component, "report_user_has_pwd", "report_pw_prompt", null, "report_ident_user", true))) {
                        this.userId = ((CompoundObject)serializable).getId();
                        continue;
                    }
                    messages.showErrorWarning(component, "report_err_invalid_user", null);
                    continue;
                }
                this.userId = ((CompoundObject)serializable).getId();
                continue;
            }
            object3 = new JTextField();
            jTextField = new JPasswordField(24);
            if (!messages.showInputDlg(component, new String[]{"report_select_user"}, new String[]{"report_id_prompt", "report_pw_prompt"}, new JComponent[]{object3, jTextField}, "report_ident_user") || (object2 = StrUtils.nullableString(((JTextComponent)object3).getText())) == null) break;
            UserData userData = this.getUserData((String)object2);
            boolean bl3 = false;
            if (userData != null && ((object = StrUtils.nullableString(userData.pwd)) == null || Encryption.Decrypt((String)object).equals(String.copyValueOf(((JPasswordField)jTextField).getPassword())))) {
                bl3 = true;
            }
            if (!bl3) {
                messages.showErrorWarning(component, "report_err_invalid_user", null);
                continue;
            }
            this.userId = userData.getId();
        }
        return this.userId;
    }

    public String toHtmlString(Messages messages) {
        String string = "report_";
        Html html = new Html(3000);
        Html html2 = new Html(3000);
        html2.doubleCell(messages.get(string + "started"), true, messages.getShortDateTimeStr(this.started), false);
        html2.doubleCell(messages.get(string + "system"), true, this.description == null ? messages.get(string + "system_standard") : this.description, false);
        if (this.userId != null) {
            html2.doubleCell(messages.get(string + USER_ID), true, this.userId, false);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.sessions.size(); ++i) {
            SessionReg.Info info = this.getSessionReg(i).getInfo(true);
            if (info.numSequences <= 0) continue;
            ++n;
            n2 += info.numSequences;
            if (info.nActivities <= 0) continue;
            n3 += info.nActivities;
            n4 += info.nActSolved;
            n6 += info.nActions;
            if (info.nActScore > 0) {
                l += info.tScore * (long)info.nActScore;
                n5 += info.nActScore;
            }
            l2 += info.tTime;
        }
        if (n2 > 0) {
            if (n > 1) {
                html2.doubleCell(messages.get(string + "num_projects"), true, messages.getNumber(n), false);
            }
            html2.doubleCell(messages.get(string + "num_sequences"), true, messages.getNumber(n2), false);
            html2.doubleCell(messages.get(string + "num_activities"), true, messages.getNumber(n3), false);
            if (n3 > 0) {
                html2.doubleCell(messages.get(string + "num_activities_solved"), true, messages.getNumber(n4) + " (" + messages.getPercent(n4 * 100 / n3) + ")", false);
                if (n5 > 0) {
                    html2.doubleCell(messages.get(string + "global_score"), true, messages.getPercent(l / (long)n5), false);
                }
                html2.doubleCell(messages.get(string + "total_time"), true, messages.getHmsTime(l2), false);
                html2.doubleCell(messages.get(string + "num_actions"), true, messages.getNumber(n6), false);
            }
            html.append(Html.table(html2.toString(), null, 0, 2, -1, null, false)).append("&nbsp;");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.sessions.size(); ++i) {
                SessionReg sessionReg = this.getSessionReg(i);
                if (sessionReg.getInfo((boolean)false).numSequences <= 0) continue;
                stringBuffer.append(sessionReg.toHtmlString(messages, false, n > 1));
            }
            html.append(Html.table(stringBuffer.substring(0), null, 1, 2, -1, null, false));
        } else {
            html.append(Html.table(html2.toString(), null, 0, 2, -1, null, false));
            html.br().bold(messages.get(string + "no_activities"));
        }
        return html.toString();
    }

    public void init(HashMap hashMap, Component component, Messages messages) throws Exception {
        this.userId = (String)hashMap.get(USER_ID);
        this.sessionKey = (String)hashMap.get(KEY);
        this.sessionContext = (String)hashMap.get(CONTEXT);
        this.groupCodeFilter = (String)hashMap.get(GROUP_CODE_FILTER);
        this.userCodeFilter = (String)hashMap.get(USER_CODE_FILTER);
        this.initiated = true;
    }

    public static Reporter getReporter(HashMap hashMap, Component component, Messages messages) throws Exception {
        String string = null;
        if (hashMap == null) {
            throw new IllegalArgumentException("Null properties passed to \"getReporter\"");
        }
        string = (String)hashMap.get("class");
        if (string == null) {
            throw new IllegalArgumentException("Properties passed to \"getReporter\" with null class name");
        }
        Class<?> clazz = Class.forName(string);
        Reporter reporter = (Reporter)clazz.newInstance();
        reporter.init(hashMap, component, messages);
        return reporter;
    }

    public static Reporter getReporter(String string, String string2, Component component, Messages messages) throws Exception {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Properties passed to \"getReporter\" with null class name");
        }
        if (string.indexOf(46) < 0) {
            string = "edu.xtec.jclic.report." + string;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("class", string);
        Options.strToMap(string2, hashMap, ";", '=', false);
        return Reporter.getReporter(hashMap, component, messages);
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void end() {
        this.endSession();
    }

    public void endSequence() {
        if (this.currentSession != null) {
            this.currentSession.endSequence();
        }
    }

    public void endSession() {
        this.endSequence();
        this.currentSession = null;
    }

    public String newGroup(GroupData groupData) throws Exception {
        throw new Exception("No database!");
    }

    public String newUser(UserData userData) throws Exception {
        throw new Exception("No database!");
    }

    public void newSession(JClicProject jClicProject, Component component, Messages messages) {
        this.endSession();
        this.currentSession = new SessionReg(jClicProject);
        this.sessions.add(this.currentSession);
    }

    public void newSequence(ActivitySequenceElement activitySequenceElement) {
        if (this.currentSession != null) {
            this.currentSession.newSequence(activitySequenceElement);
        }
    }

    public void newActivity(Activity activity) {
        if (this.currentSession != null) {
            this.currentSession.newActivity(activity);
        }
    }

    public void endActivity(int n, int n2, boolean bl) {
        if (this.currentSession != null) {
            this.currentSession.endActivity(n, n2, bl);
        }
    }

    public void newAction(String string, String string2, String string3, boolean bl) {
        if (this.currentSession != null) {
            this.currentSession.newAction(string, string2, string3, bl);
        }
    }

    public SessionReg getSessionReg(int n) {
        return n >= this.sessions.size() ? null : (SessionReg)this.sessions.get(n);
    }

    public SequenceReg.Info getCurrentSequenceInfo() {
        return this.currentSession == null ? null : this.currentSession.getCurrentSequenceInfo();
    }

    public String getCurrentSequenceTag() {
        return this.currentSession == null ? null : this.currentSession.getCurrentSequenceTag();
    }
}

