/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.ActionReg;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;

public class BasicJDBCBridge {
    public static final String DEFAULT_ODBC_BRIDGE = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String DEFAULT_DB = "jdbc:odbc:JClicUserReports";
    public static final String TABLE_PREFIX_KEY = "tablePrefix";
    public static final String CREATE_TABLES_KEY = "createTables";
    public static final String TRUST_CLIENT_DATETIME = "trustClientDateTime";
    public static final int OTHER = 0;
    public static final int MYSQL = 1;
    public static final int ORACLE = 2;
    public static final int ACCESS = 3;
    protected String driver;
    protected String url;
    public String DBMSName;
    public int DBMSType;
    protected ConnectionBeanProvider cbp;
    protected boolean createTables;
    protected String tablePrefix;
    public static final Object[][] TABLE_DEFS = new Object[][]{{"SETTINGS", new String[]{"SETTING_KEY VARCHAR(255) NOT NULL", "SETTING_VALUE VARCHAR(255)", "PRIMARY KEY (SETTING_KEY)"}}, {"GROUPS", new String[]{"GROUP_ID VARCHAR(50) NOT NULL", "GROUP_NAME VARCHAR(80) NOT NULL", "GROUP_DESCRIPTION VARCHAR(255)", "GROUP_ICON VARCHAR(255)", "GROUP_CODE VARCHAR(50)", "GROUP_KEYWORDS VARCHAR(255)", "PRIMARY KEY (GROUP_ID)"}}, {"USERS", new String[]{"USER_ID VARCHAR(50) NOT NULL", "GROUP_ID VARCHAR(50) NOT NULL", "USER_NAME VARCHAR(80) NOT NULL", "USER_PWD VARCHAR(255)", "USER_ICON VARCHAR(255)", "USER_CODE VARCHAR(50)", "USER_KEYWORDS VARCHAR(255)", "PRIMARY KEY (USER_ID)"}}, {"SESSIONS", new String[]{"SESSION_ID VARCHAR(50) NOT NULL", "USER_ID VARCHAR(50) NOT NULL", "SESSION_DATETIME TIMESTAMP NOT NULL", "PROJECT_NAME VARCHAR(100) NOT NULL", "SESSION_KEY VARCHAR(50)", "SESSION_CODE VARCHAR(50)", "SESSION_CONTEXT VARCHAR(50)", "PRIMARY KEY (SESSION_ID)"}}, {"ACTIVITIES", new String[]{"SESSION_ID VARCHAR(50) NOT NULL", "ACTIVITY_ID INTEGER(5) NOT NULL", "ACTIVITY_NAME VARCHAR(50) NOT NULL", "NUM_ACTIONS INTEGER(4)", "SCORE INTEGER(4)", "ACTIVITY_SOLVED INTEGER(1)", "QUALIFICATION INTEGER(3)", "TOTAL_TIME INTEGER(5)", "ACTIVITY_CODE VARCHAR(50)", "PRIMARY KEY (SESSION_ID,ACTIVITY_ID)"}}, {"ACTIONS", new String[]{"SESSION_ID VARCHAR(50) NOT NULL", "ACTIVITY_ID INTEGER(5) NOT NULL", "ACTION_ID INTEGER(4) NOT NULL", "ACTION_TYPE VARCHAR(20) NOT NULL", "ACTION_SOURCE VARCHAR(255)", "ACTION_DEST VARCHAR(255)", "ACTION_OK INTEGER(1)", "PRIMARY KEY (SESSION_ID,ACTIVITY_ID,ACTION_ID)"}}};
    public static final String[][] DEFAULT_SETTINGS = new String[][]{{"ALLOW_CREATE_GROUPS", "false"}, {"ALLOW_CREATE_USERS", "false"}, {"SHOW_GROUP_LIST", "true"}, {"SHOW_USER_LIST", "true"}, {"USER_TABLES", "true"}, {"TIME_LAP", "10"}};

    public BasicJDBCBridge(ConnectionBeanProvider connectionBeanProvider, boolean bl, String string) throws Exception {
        this.cbp = connectionBeanProvider;
        this.createTables = bl;
        String string2 = this.tablePrefix = string == null ? "" : string;
        if (bl) {
            this.checkTables();
        }
    }

    public String getTableName(String string) {
        return this.getTableName(string, null);
    }

    public String getTableName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
            stringBuffer.append(this.tablePrefix);
        }
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(" ").append(string2);
        }
        return stringBuffer.substring(0);
    }

    public ConnectionBeanProvider getConnectionBeanProvider() {
        return this.cbp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTables() throws Exception {
        block16: {
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            try {
                Connection connection = connectionBean.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.DBMSName = databaseMetaData.getDatabaseProductName();
                if (this.DBMSName != null) {
                    this.DBMSName = this.DBMSName.toLowerCase();
                    this.DBMSType = this.DBMSName.indexOf("oracle") >= 0 ? 2 : (this.DBMSName.indexOf("mysql") >= 0 ? 1 : (this.DBMSName.indexOf("access") >= 0 ? 3 : 0));
                }
                for (int i = 0; i < TABLE_DEFS.length; ++i) {
                    int n;
                    String string = this.getTableName((String)TABLE_DEFS[i][0]);
                    ResultSet resultSet = databaseMetaData.getTables(null, null, string, null);
                    boolean bl = resultSet.next();
                    resultSet.close();
                    if (bl) continue;
                    Statement statement = connection.createStatement();
                    StringBuffer stringBuffer = new StringBuffer("CREATE TABLE ");
                    stringBuffer.append(string).append("(");
                    String[] stringArray = (String[])TABLE_DEFS[i][1];
                    for (n = 0; n < stringArray.length; ++n) {
                        int n2;
                        String string2 = stringArray[n];
                        if (this.DBMSType == 3) {
                            n2 = string2.indexOf("INTEGER(");
                            if (n2 > 0) {
                                int n3 = string2.indexOf(41, n2);
                                string2 = string2.substring(0, n2 + 7) + (n3 > 0 && string2.length() > n3 + 1 ? string2.substring(n3 + 1) : "");
                            }
                        } else if (this.DBMSType == 2) {
                            n2 = string2.indexOf("TIMESTAMP");
                            if (n2 > 0) {
                                string2 = string2.substring(0, n2) + "DATE" + (string2.length() > n2 + 9 ? string2.substring(n2 + 9) : "");
                            }
                            if ((n2 = string2.indexOf("INTEGER")) > 0) {
                                string2 = string2.substring(0, n2) + "NUMBER" + string2.substring(n2 + 7);
                            }
                        }
                        stringBuffer.append(string2).append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(")");
                    statement.executeUpdate(stringBuffer.substring(0));
                    if (i == 0) {
                        for (n = 0; n < DEFAULT_SETTINGS.length; ++n) {
                            stringBuffer.setLength(0);
                            stringBuffer.append("INSERT INTO ").append(string).append(" VALUES(").append("'").append(DEFAULT_SETTINGS[n][0]).append("','").append(DEFAULT_SETTINGS[n][1]).append("')");
                            statement.executeUpdate(stringBuffer.substring(0));
                        }
                    }
                    statement.close();
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block16;
                throw exception;
            }
        }
    }

    public void end() {
        if (this.cbp != null) {
            ConnectionBeanProvider.freeConnectionBeanProvider(this.cbp);
        }
        this.cbp = null;
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String string, String string2) throws Exception {
        String string3;
        block7: {
            string3 = string2;
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT SETTING_VALUE FROM " + this.getTableName("SETTINGS") + " WHERE SETTING_KEY=?");
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string3 = BasicJDBCBridge.trimStr(resultSet.getString(1));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block7;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getProperties() throws Exception {
        HashMap<String, String> hashMap;
        block7: {
            hashMap = new HashMap<String, String>();
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT * FROM " + this.getTableName("SETTINGS"));
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("SETTING_KEY"), resultSet.getString("SETTING_VALUE"));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block7;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGroups() throws Exception {
        Vector<GroupData> vector;
        block8: {
            vector = new Vector<GroupData>();
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT GROUP_ID,GROUP_NAME,GROUP_ICON,GROUP_DESCRIPTION FROM " + this.getTableName("GROUPS"));
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String[] stringArray = new String[4];
                    for (int i = 0; i < 3; ++i) {
                        stringArray[i] = BasicJDBCBridge.trimStr(resultSet.getString(i + 1));
                    }
                    vector.add(new GroupData(stringArray[0], stringArray[1], stringArray[2], stringArray[3]));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block8;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUsers(String string) throws Exception {
        Vector<UserData> vector;
        block10: {
            vector = new Vector<UserData>();
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                StringBuffer stringBuffer = new StringBuffer("SELECT USER_NAME,USER_ICON,USER_ID,USER_PWD,GROUP_ID");
                stringBuffer.append(" FROM ").append(this.getTableName("USERS"));
                if (string != null) {
                    stringBuffer.append(" WHERE GROUP_ID=?");
                }
                preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
                if (string != null) {
                    preparedStatement.setString(1, string);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String[] stringArray = new String[5];
                    for (int i = 0; i < 5; ++i) {
                        stringArray[i] = BasicJDBCBridge.trimStr(resultSet.getString(i + 1));
                    }
                    vector.add(new UserData(stringArray[2], stringArray[0], stringArray[1], stringArray[3], stringArray[4]));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block10;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserData getUserData(String string) throws Exception {
        UserData userData;
        block7: {
            userData = null;
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT * FROM " + this.getTableName("USERS") + " WHERE USER_ID=?");
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    userData = new UserData(BasicJDBCBridge.trimStr(resultSet.getString("USER_ID")), BasicJDBCBridge.trimStr(resultSet.getString("USER_NAME")), BasicJDBCBridge.trimStr(resultSet.getString("USER_ICON")), BasicJDBCBridge.trimStr(resultSet.getString("USER_PWD")), BasicJDBCBridge.trimStr(resultSet.getString("GROUP_ID")));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block7;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupData getGroupData(String string) throws Exception {
        GroupData groupData;
        block7: {
            groupData = null;
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT * FROM " + this.getTableName("GROUPS") + " WHERE GROUP_ID=?");
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    groupData = new GroupData(BasicJDBCBridge.trimStr(resultSet.getString("GROUP_ID")), BasicJDBCBridge.trimStr(resultSet.getString("GROUP_NAME")), BasicJDBCBridge.trimStr(resultSet.getString("GROUP_ICON")), BasicJDBCBridge.trimStr(resultSet.getString("GROUP_DESCRIPTION")));
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block7;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return groupData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addSession(String string, long l, String string2, String string3, String string4, String string5) throws Exception {
        String string6;
        block8: {
            string6 = null;
            Exception exception = null;
            if (string == null) {
                throw new Exception("Invalid UserId");
            }
            if (string2 == null) {
                throw new Exception("Invalid ProjectName");
            }
            string6 = string.concat("_").concat(Long.toString(l));
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("INSERT INTO " + this.getTableName("SESSIONS") + " (SESSION_ID,USER_ID,SESSION_DATETIME,PROJECT_NAME,SESSION_KEY,SESSION_CODE,SESSION_CONTEXT)" + " VALUES(?,?,?,?,?,?,?)");
                preparedStatement.setString(1, string6);
                preparedStatement.setString(2, string);
                preparedStatement.setTimestamp(3, new Timestamp(l));
                preparedStatement.setString(4, string2);
                preparedStatement.setString(5, string4);
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, string5);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block8;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return string6;
    }

    public int addActivity(int n, String string, ActivityReg activityReg) throws Exception {
        return this.addActivity(n, string, activityReg.name, activityReg.numActions, activityReg.score, activityReg.solved, activityReg.getPrecision(), (int)(activityReg.totalTime / 1000L), activityReg.code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addActivity(int n, String string, String string2, int n2, int n3, boolean bl, int n4, int n5, String string3) throws Exception {
        int n6;
        block8: {
            if (string == null) {
                throw new Exception("Invalid sessionId");
            }
            if (string2 == null) {
                throw new Exception("Invalid activity name");
            }
            n6 = n;
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("INSERT INTO " + this.getTableName("ACTIVITIES") + " (SESSION_ID,ACTIVITY_ID,ACTIVITY_NAME,NUM_ACTIONS,SCORE,ACTIVITY_SOLVED,QUALIFICATION,TOTAL_TIME,ACTIVITY_CODE)" + " VALUES(?,?,?,?,?,?,?,?,?)");
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setString(3, string2);
                preparedStatement.setInt(4, n2);
                preparedStatement.setInt(5, n3);
                preparedStatement.setInt(6, bl ? 1 : 0);
                preparedStatement.setInt(7, n4);
                preparedStatement.setInt(8, n5);
                preparedStatement.setString(9, string3);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return (int)exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block8;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return n6;
    }

    public int addAction(int n, String string, int n2, ActionReg actionReg) throws Exception {
        return this.addAction(n, string, n2, actionReg.type, actionReg.source, actionReg.dest, actionReg.isOk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAction(int n, String string, int n2, String string2, String string3, String string4, boolean bl) throws Exception {
        int n3;
        block8: {
            if (string == null) {
                throw new Exception("Invalid sessionId");
            }
            if (string2 == null) {
                throw new Exception("Invalid action type");
            }
            n3 = n2;
            Exception exception = null;
            ConnectionBean connectionBean = this.cbp.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("INSERT INTO " + this.getTableName("ACTIONS") + " (SESSION_ID,ACTIVITY_ID,ACTION_ID,ACTION_TYPE,ACTION_SOURCE,ACTION_DEST,ACTION_OK)" + " VALUES(?,?,?,?,?,?,?)");
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setInt(3, n2);
                preparedStatement.setString(4, string2);
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, string4);
                preparedStatement.setInt(7, bl ? 1 : 0);
                preparedStatement.executeUpdate();
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
                return (int)exception;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception == null) break block8;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newGroup(GroupData groupData) throws Exception {
        Exception exception = null;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + this.getTableName("GROUPS") + " (GROUP_ID,GROUP_NAME");
        int n = 0;
        if (groupData.hasIcon()) {
            stringBuffer.append(",GROUP_ICON");
            ++n;
        }
        if (groupData.description != null && groupData.description.length() > 0) {
            stringBuffer.append(",GROUP_DESCRIPTION");
            ++n;
        }
        stringBuffer.append(") VALUES(?,?");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(",?");
        }
        stringBuffer.append(")");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            n = 1;
            preparedStatement.setString(n++, groupData.getId());
            preparedStatement.setString(n++, groupData.getText());
            if (groupData.hasIcon()) {
                preparedStatement.setString(n++, groupData.getIconUrl());
            }
            if (groupData.description != null && groupData.description.length() > 0) {
                preparedStatement.setString(n++, groupData.description);
            }
            preparedStatement.executeUpdate();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return groupData.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newUser(UserData userData) throws Exception {
        Exception exception = null;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + this.getTableName("USERS") + " (GROUP_ID,USER_ID,USER_NAME");
        int n = 0;
        if (userData.hasIcon()) {
            stringBuffer.append(",USER_ICON");
            ++n;
        }
        if (userData.pwd != null && userData.pwd.length() > 0) {
            stringBuffer.append(",USER_PWD");
            ++n;
        }
        stringBuffer.append(") VALUES(?,?,?");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(",?");
        }
        stringBuffer.append(")");
        ConnectionBean connectionBean = this.cbp.getConnectionBean();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionBean.getPreparedStatement(stringBuffer.substring(0));
            n = 1;
            preparedStatement.setString(n++, userData.groupId);
            preparedStatement.setString(n++, userData.getId());
            preparedStatement.setString(n++, userData.getText());
            if (userData.hasIcon()) {
                preparedStatement.setString(n++, userData.getIconUrl());
            }
            if (userData.pwd != null && userData.pwd.length() > 0) {
                preparedStatement.setString(n++, userData.pwd);
            }
            preparedStatement.executeUpdate();
            connectionBean.closeStatement(preparedStatement);
            this.cbp.freeConnectionBean(connectionBean);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
            }
            catch (Throwable throwable) {
                connectionBean.closeStatement(preparedStatement);
                this.cbp.freeConnectionBean(connectionBean);
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return userData.getId();
    }

    public static String trimStr(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }
}

