/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.report.ActionReg;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Element;

public class ActivityReg
implements Serializable,
Domable {
    String name;
    String code;
    long startTime;
    long totalTime;
    Vector actions;
    boolean solved;
    ActionReg lastAction;
    int score;
    int minActions;
    boolean closed;
    boolean reportActions;
    int numActions;
    public static final String ELEMENT_NAME = "activity";
    public static final String NAME = "name";
    public static final String CODE = "code";
    public static final String START = "start";
    public static final String TIME = "time";
    public static final String SOLVED = "solved";
    public static final String SCORE = "score";
    public static final String MIN_ACTIONS = "minActions";
    public static final String CLOSED = "closed";
    public static final String REPORT_ACTIONS = "reportActions";
    public static final String ACTIONS = "actions";
    private static final String okTd = "BGCOLOR=\"#90FF90\"";
    private static final String badTd = "BGCOLOR=\"#FF9090\"";

    public ActivityReg(Activity activity) {
        this.name = activity.name;
        this.code = activity.code;
        this.actions = new Vector();
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.solved = false;
        this.score = 0;
        this.lastAction = null;
        this.closed = false;
        this.minActions = activity.getMinNumActions();
        this.reportActions = activity.reportActions;
        this.numActions = 0;
    }

    public ActivityReg(Element element) throws Exception {
        this.actions = new Vector();
        this.setProperties(element, null);
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        JDomUtility.setStringAttr(element, NAME, this.name, false);
        JDomUtility.setStringAttr(element, CODE, this.code, false);
        JDomUtility.setStringAttr(element, START, Long.toString(this.startTime), false);
        JDomUtility.setStringAttr(element, TIME, Long.toString(this.totalTime), false);
        element.setAttribute(SOLVED, JDomUtility.boolString(this.solved));
        JDomUtility.setStringAttr(element, SCORE, Integer.toString(this.score), false);
        JDomUtility.setStringAttr(element, MIN_ACTIONS, Integer.toString(this.minActions), false);
        if (!this.closed) {
            element.setAttribute(CLOSED, JDomUtility.BOOL_STR[0]);
        }
        if (this.reportActions) {
            element.setAttribute(REPORT_ACTIONS, JDomUtility.BOOL_STR[1]);
        }
        JDomUtility.setStringAttr(element, ACTIONS, Integer.toString(this.numActions), false);
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            element.addContent(((ActionReg)iterator.next()).getJDomElement());
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(element, NAME, this.name, false);
        this.code = JDomUtility.getStringAttr(element, CODE, this.code, false);
        this.startTime = JDomUtility.getLongAttr(element, START, this.startTime);
        this.totalTime = JDomUtility.getLongAttr(element, TIME, this.totalTime);
        this.solved = JDomUtility.getBoolAttr(element, SOLVED, this.solved);
        this.score = JDomUtility.getIntAttr(element, SCORE, this.score);
        this.minActions = JDomUtility.getIntAttr(element, MIN_ACTIONS, this.minActions);
        this.closed = JDomUtility.getBoolAttr(element, CLOSED, true);
        this.reportActions = JDomUtility.getBoolAttr(element, REPORT_ACTIONS, false);
        this.numActions = JDomUtility.getIntAttr(element, ACTIONS, this.numActions);
        Iterator iterator = element.getChildren("action").iterator();
        while (iterator.hasNext()) {
            this.lastAction = new ActionReg((Element)iterator.next());
            this.actions.add(this.lastAction);
        }
    }

    public String toHtmlString(Messages messages, String string) {
        Html html = new Html(300);
        html.tr(true);
        if (string != null) {
            html.append(string);
        }
        html.td(this.name, false);
        if (this.closed) {
            html.td(messages.get(this.solved ? "YES" : "NO"), 1, true, this.solved ? okTd : badTd);
            html.td(messages.getNumber(this.numActions), 2, false, null);
            html.td(messages.getPercent(this.getPrecision()), 2, false, null);
            html.td(messages.getHmsTime(this.totalTime), 2, false, null);
        } else {
            html.append("<TD COLSPAN=\"4\" ALIGN=\"center\">").append(messages.get("report_not_finished")).td(false);
        }
        html.tr(false);
        return html.toString();
    }

    public void newAction(String string, String string2, String string3, boolean bl) {
        if (!this.closed) {
            this.lastAction = new ActionReg(string, string2, string3, bl);
            this.actions.add(this.lastAction);
        }
    }

    public ActionReg getActionReg(int n) {
        return n >= this.actions.size() ? null : (ActionReg)this.actions.get(n);
    }

    public void closeActivity() {
        if (!this.closed) {
            this.totalTime = this.lastAction != null ? this.lastAction.time - this.startTime : System.currentTimeMillis() - this.startTime;
            this.closed = true;
        }
    }

    public int getPrecision() {
        int n = 0;
        if (this.closed && this.minActions > 0 && this.numActions > 0) {
            n = this.solved ? (this.numActions < this.minActions ? 100 : this.minActions * 100 / this.numActions) : 100 * (this.score * this.score) / (this.minActions * this.numActions);
        }
        return n;
    }

    public void endActivity(int n, int n2, boolean bl) {
        if (!this.closed) {
            this.solved = bl;
            this.numActions = n2;
            this.score = n;
            this.closeActivity();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ACTIVITY: ");
        stringBuffer.append(this.name);
        return stringBuffer.substring(0);
    }
}

