/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom.Element;

public class ProjectSettings
implements Editable,
Domable {
    public String title = UNTITLED;
    public String iconFileName = null;
    public String description = null;
    public String descriptors = null;
    public String area = null;
    public String level = null;
    public Locale locale = null;
    public String[] languages = null;
    public Author[] authors = null;
    public Organization[] organizations = null;
    public Revision[] revisions = new Revision[]{new Revision(new Date(), "created")};
    public String skinFileName = null;
    public EventSounds eventSounds = new EventSounds(null);
    public static String UNTITLED = "untitled";
    public static String ELEMENT_NAME = "settings";
    public static String TITLE = "title";
    public static String LOCALE = "locale";
    public static String LANGUAGE = "language";
    public static String DESCRIPTION = "description";
    public static String DESCRIPTORS = "descriptors";
    public static String SKIN = "skin";
    public static String FILE = "file";
    public static String AREA = "area";
    public static String LEVEL = "level";
    public static String ICON = "icon";

    public Element getJDomElement() {
        int n;
        Element element = new Element(ELEMENT_NAME);
        element.addContent(new Element(TITLE).setText(this.title));
        if (this.revisions != null) {
            for (n = 0; n < this.revisions.length; ++n) {
                element.addContent(this.revisions[n].getJDomElement());
            }
        }
        if (this.authors != null) {
            for (n = 0; n < this.authors.length; ++n) {
                element.addContent(this.authors[n].getJDomElement());
            }
        }
        if (this.organizations != null) {
            for (n = 0; n < this.organizations.length; ++n) {
                element.addContent(this.organizations[n].getJDomElement());
            }
        }
        if (this.languages != null) {
            for (n = 0; n < this.languages.length; ++n) {
                element.addContent(new Element(LANGUAGE).setText(this.languages[n]));
            }
        }
        if (this.locale != null) {
            StringBuffer stringBuffer = new StringBuffer(this.locale.getLanguage());
            if (this.locale.getCountry() != null && this.locale.getCountry().length() > 0) {
                stringBuffer.append('-').append(this.locale.getCountry());
                if (this.locale.getVariant() != null && this.locale.getVariant().length() > 0) {
                    stringBuffer.append('-').append(this.locale.getVariant());
                }
            }
            element.setAttribute(LOCALE, stringBuffer.substring(0));
        }
        if (this.description != null) {
            JDomUtility.addParagraphs(element, DESCRIPTION, this.description);
        }
        Element element2 = new Element(DESCRIPTORS);
        if (this.area != null) {
            element2.setAttribute(AREA, this.area);
        }
        if (this.level != null) {
            element2.setAttribute(LEVEL, this.level);
        }
        if (this.descriptors != null) {
            element2.setText(this.descriptors);
        }
        element.addContent(element2);
        element2 = this.eventSounds.getJDomElement();
        if (element2 != null) {
            element.addContent(element2);
        }
        if (this.skinFileName != null) {
            element2 = new Element(SKIN);
            element2.setAttribute(FILE, this.skinFileName);
            element.addContent(element2);
        }
        if (this.iconFileName != null) {
            element2 = new Element(ICON);
            element2.setAttribute(FILE, this.iconFileName);
            element.addContent(element2);
        }
        return element;
    }

    public static ProjectSettings getProjectSettings(Element element) throws Exception {
        ProjectSettings projectSettings = new ProjectSettings();
        projectSettings.setProperties(element, null);
        return projectSettings;
    }

    public void setProperties(Element element, Object object) throws Exception {
        String string;
        JDomUtility.checkName(element, ELEMENT_NAME);
        Element element2 = element.getChild(TITLE);
        if (element2 != null) {
            this.title = element2.getText();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = element.getChildren("revision").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Revision.getRevision((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.revisions = arrayList.toArray(new Revision[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren("author").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Author.getAuthor((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.authors = arrayList.toArray(new Author[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren("organization").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Organization.getOrganization((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.organizations = arrayList.toArray(new Organization[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren(LANGUAGE).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Element)iterator.next()).getText());
        }
        if (!arrayList.isEmpty()) {
            this.languages = arrayList.toArray(new String[arrayList.size()]);
        }
        if ((string = JDomUtility.getStringAttr(element, LOCALE, null, false)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string2 != null && string3 != null) {
                this.locale = string4 != null ? new Locale(string2, string3, string4) : new Locale(string2, string3);
            }
        }
        this.description = JDomUtility.getParagraphs(element.getChild(DESCRIPTION));
        element2 = element.getChild(DESCRIPTORS);
        if (element2 != null) {
            if (!element2.getChildren("p").isEmpty()) {
                this.descriptors = JDomUtility.getParagraphs(element.getChild(DESCRIPTORS));
                this.descriptors = StrUtils.replace(this.descriptors, "\n", ", ");
            } else {
                this.descriptors = StrUtils.nullableString(element2.getTextNormalize());
            }
            this.area = JDomUtility.getStringAttr(element2, AREA, this.area, false);
            this.level = JDomUtility.getStringAttr(element2, LEVEL, this.level, false);
        }
        if ((element2 = element.getChild("eventSounds")) != null) {
            this.eventSounds = EventSounds.getEventSounds(element2);
        }
        if ((element2 = element.getChild(SKIN)) != null) {
            this.skinFileName = JDomUtility.getStringAttr(element2, FILE, this.skinFileName, false);
        }
        if ((element2 = element.getChild(ICON)) != null) {
            this.iconFileName = JDomUtility.getStringAttr(element2, FILE, this.iconFileName, false);
        }
    }

    public String toHtmlString(Messages messages) {
        int n;
        int n2;
        String string = "about_window_lb_";
        Html html = new Html(1000);
        html.doubleCell(messages.get(string + "project"), true, this.title, true);
        if (this.area != null) {
            html.doubleCell(messages.get(string + "area"), true, this.area, false);
        }
        if (this.level != null) {
            html.doubleCell(messages.get(string + "level"), true, this.level, false);
        }
        if (this.authors != null) {
            n2 = this.authors.length;
            html.tr(true).td(messages.get(string + "author" + (n2 > 1 ? "s" : "")), true).td(true);
            for (n = 0; n < n2; ++n) {
                if (this.authors[n] == null) continue;
                html.append(this.authors[n].toHtmlString(messages)).br();
            }
            html.td(false).tr(false);
        }
        if (this.organizations != null) {
            n2 = this.organizations.length;
            html.tr(true).td(messages.get(string + "organization" + (n2 > 1 ? "s" : "")), true).td(true);
            for (n = 0; n < this.organizations.length; ++n) {
                if (n > 0) {
                    html.nbsp().br();
                }
                if (this.organizations[n] == null) continue;
                html.append(this.organizations[n].toHtmlString(messages)).br();
            }
            html.td(false).tr(false);
        }
        if (this.revisions != null) {
            html.tr(true).td(messages.get(string + "history"), true).td(true);
            for (n2 = 0; n2 < this.revisions.length; ++n2) {
                if (n2 > 0) {
                    html.nbsp().br();
                }
                if (this.revisions[n2] == null) continue;
                html.append(this.revisions[n2].toHtmlString(messages)).br();
            }
            html.td(false).tr(false);
        }
        if (this.languages != null) {
            n2 = this.languages.length;
            html.tr(true).td(messages.get(string + "language" + (n2 > 1 ? "s" : "")), true).td(true);
            for (n = 0; n < n2; ++n) {
                if (this.languages[n] == null) continue;
                html.append(this.languages[n]).sp();
            }
            html.td(false).tr(false);
        }
        if (this.description != null) {
            html.doubleCell(messages.get(string + "description"), true, this.description, false);
        }
        if (this.descriptors != null) {
            html.doubleCell(messages.get(string + "descriptors"), true, this.descriptors, false);
        }
        return Html.table(html.toString(), null, 1, 5, -1, null, false);
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }
}

