/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.media.QT61AudioBuffer;
import edu.xtec.jclic.media.QT61Tools;
import java.awt.Component;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.std.movies.Movie;
import quicktime.std.movies.TimeInfo;

public class QT61ActiveMediaPlayer
extends ActiveMediaPlayer {
    MoviePlayer player = null;
    QTComponent canvas;
    boolean realized = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QT61ActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        super(mediaContent, mediaBag, playStation);
        if (this.useAudioBuffer) return;
        try {
            this.player = QT61Tools.getPlayer(mediaBag.getMediaDataSource(mediaContent.mediaFileName));
            if (this.player == null) return;
        }
        catch (Exception exception) {
            System.err.println("Error reading media \"" + mediaContent.mediaFileName + "\":\n" + exception);
        }
    }

    public AudioBuffer createAudioBuffer(int n) throws Exception {
        return new QT61AudioBuffer(this.mc.length);
    }

    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.attachVisualComponent();
                    this.player.getMovie().setTimeScale(1000);
                    this.setTimeRanges();
                    this.realized = true;
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime exception:\n" + exception);
            }
        }
    }

    protected void playNow(ActiveBox activeBox) {
        if (this.useAudioBuffer) {
            super.playNow(activeBox);
        } else if (this.player != null) {
            try {
                this.stop();
                if (!this.realized) {
                    this.realize();
                }
                if (this.mc.mediaType == 2) {
                    this.linkTo(activeBox);
                }
                this.attachVisualComponent();
                this.player.setTime(Math.max(this.mc.from, 0));
                TaskAllMovies.addMovieAndStart();
                this.player.getMovie().setActive(true);
                this.player.setRate(1.0f);
            }
            catch (Exception exception) {
                System.err.println("QuickTime Exception:\n" + exception);
            }
        }
    }

    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.player.setRate(0.0f);
                    this.player.getMovie().setActive(false);
                    TaskAllMovies.removeMovie();
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime Error:\n" + exception);
            }
        }
    }

    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.destroyVisualComponent();
                    this.realized = false;
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime Error:\n" + exception);
            }
        }
    }

    protected void setTimeRanges() {
        if (this.useAudioBuffer || this.player == null) {
            return;
        }
        try {
            if (this.mc.from >= 0 || this.mc.to >= 0) {
                int n = Math.max(0, this.mc.from);
                int n2 = this.mc.to;
                if (n2 < 0) {
                    n2 = this.player.getDuration();
                }
                this.player.setTime(Math.max(this.mc.from, 0));
                this.player.getMovie().setActiveSegment(new TimeInfo(n, n2 - n));
            }
        }
        catch (Exception exception) {
            System.err.println("QuickTime Error:\n" + exception);
        }
    }

    protected Component getVisualComponent() {
        if (this.player == null || this.mc.mediaType != 2) {
            return null;
        }
        if (this.canvas == null) {
            try {
                this.canvas = QTFactory.makeQTComponent((Movie)this.player.getMovie());
            }
            catch (Exception exception) {
                System.err.println("Error building QTCanvas!\n" + exception);
            }
        }
        return (Component)this.canvas;
    }
}

