/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.ByteDataSource;
import edu.xtec.util.ExtendedByteArrayInputStream;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.media.protocol.DataSource;

public class JMFAudioPlayer
implements AudioPlayer {
    protected Player player = null;
    public static final Time zeroTime = new Time(0L);

    public boolean setDataSource(Object object) throws Exception {
        this.close();
        if (object instanceof ExtendedByteArrayInputStream) {
            this.player = Manager.createPlayer((DataSource)new ByteDataSource((ExtendedByteArrayInputStream)object));
        } else if (object instanceof String) {
            MediaLocator mediaLocator = new MediaLocator((String)object);
            DataSource dataSource = Manager.createDataSource((MediaLocator)mediaLocator);
            this.player = Manager.createPlayer((DataSource)dataSource);
        }
        return this.player != null;
    }

    public void realize(String string, MediaBag mediaBag) throws Exception {
        if (string != null) {
            this.setDataSource(mediaBag.getMediaDataSource(string));
        }
        if (this.player != null) {
            this.player.realize();
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public void play() {
        try {
            this.stop();
            this.player.setMediaTime(zeroTime);
            this.player.start();
        }
        catch (Exception exception) {
            System.err.println("Error playing system sound:\n" + exception);
        }
    }

    public void stop() {
        if (this.player != null && this.player.getState() >= 600) {
            this.player.stop();
        }
    }
}

