/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.util.LFUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThumbsExplorerPanel
extends JPanel {
    public static final int DEFAULT_THUMB_WIDTH = 90;
    public static final int DEFAULT_THUMB_HEIGHT = 90;
    public static final int DEFAULT_THUMB_MARGIN = 14;
    public static final int DEFAULT_TEXT_HEIGHT = 14;
    public static final int DEFAULT_THUMB_INTERNAL_MARGIN = 2;
    protected static BasicStroke BORDER_STROKE = new BasicStroke(0.2f);
    protected int th_width;
    protected int th_height;
    protected int th_margin;
    protected int th_textHeight;
    protected int th_int_margin;
    protected Font font;
    private Vector elements;
    private ThumbElement current;
    private int elementsPerRow;
    private EventListenerList listenerList;
    public Dimension maxThumbSize;
    public Dimension boxSize;

    public ThumbsExplorerPanel() {
        this.setLayout(null);
        this.elements = new Vector();
        this.listenerList = new EventListenerList();
        this.setSizes(90, 90, 14, 14, 2);
        this.setPreferredSize(new Dimension(3 * this.boxSize.width, this.boxSize.height));
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(LFUtil.getColor("Table.background", Color.lightGray));
        this.elementsPerRow = 1;
        this.enableEvents(24L);
    }

    public void setSizes(int n, int n2, int n3, int n4, int n5) {
        this.th_width = Math.max(10, n);
        this.th_height = Math.max(10, n2);
        this.th_margin = Math.max(5, n3);
        this.th_textHeight = Math.max(10, n4);
        this.th_int_margin = Math.max(0, n5);
        this.boxSize = new Dimension(n + 2 * n3, n2 + n4 + 2 * n3);
        this.maxThumbSize = new Dimension(n - 2 * n5, n2 - 2 * n5);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.getThumbElement(i).sizeImage();
        }
        this.invalidate();
    }

    public void resizeTo(int n) {
        int n2 = this.elements.size();
        int n3 = Math.max(this.boxSize.width, n);
        int n4 = n3 / this.boxSize.width;
        int n5 = n2 / n4 + 1;
        int n6 = n5 * this.boxSize.height;
        this.setPreferredSize(new Dimension(n3, n6));
        this.revalidate();
        this.repaint();
    }

    public ThumbElement getThumbElement(int n) {
        return (ThumbElement)this.elements.get(n);
    }

    public ThumbElement[] getThumbElements() {
        return this.elements.toArray(new ThumbElement[this.elements.size()]);
    }

    public ThumbElement getElementFor(Object object) {
        ThumbElement thumbElement = null;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.getThumbElement(i).getUserObject() != object) continue;
            thumbElement = this.getThumbElement(i);
            break;
        }
        return thumbElement;
    }

    public int getThumbElementCount() {
        return this.elements.size();
    }

    public void removeThumbElementAt(int n) {
        Object e;
        if (this.elements != null && (e = this.elements.get(n)) != null) {
            if (e == this.current) {
                this.current = null;
            }
            this.elements.removeElementAt(n);
            this.invalidate();
        }
    }

    public void removeAllThumbElements() {
        this.elements.removeAllElements();
        this.current = null;
        this.invalidate();
        this.repaint();
    }

    public ThumbElement addThumbElement(int n, Object object, ImageIcon imageIcon, String string) {
        ThumbElement thumbElement = new ThumbElement(object, imageIcon, string);
        if (n >= 0) {
            this.elements.add(n, thumbElement);
        } else {
            this.elements.add(thumbElement);
        }
        this.invalidate();
        return thumbElement;
    }

    public ThumbElement addThumbElement(Object object, ImageIcon imageIcon, String string) {
        return this.addThumbElement(-1, object, imageIcon, string);
    }

    public ThumbElement getCurrent() {
        return this.current;
    }

    public Object getCurrentObject() {
        return this.current == null ? null : this.current.getUserObject();
    }

    public void setCurrent(ThumbElement thumbElement) {
        Rectangle rectangle;
        if (this.current != null && (rectangle = this.getRectFor(this.getIndexOf(this.current))) != null) {
            this.repaint(rectangle);
        }
        if (thumbElement != null && this.elements.contains(thumbElement)) {
            this.current = thumbElement;
            rectangle = this.getRectFor(this.getIndexOf(this.current));
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            this.scrollRectToVisible(rectangle);
        } else {
            this.current = null;
        }
    }

    public void checkCurrentVisibility() {
        Rectangle rectangle;
        if (this.current != null && (rectangle = this.getRectFor(this.getIndexOf(this.current))) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setCurrentObject(Object object) {
        ThumbElement thumbElement = null;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.getThumbElement(i).getUserObject() != object) continue;
            thumbElement = this.getThumbElement(i);
            break;
        }
        this.setCurrent(thumbElement);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public int getIndexOf(ThumbElement thumbElement) {
        return thumbElement == null ? -1 : this.elements.indexOf(thumbElement);
    }

    public Rectangle getRectFor(int n) {
        Rectangle rectangle = null;
        if (n >= 0 && n < this.elements.size()) {
            rectangle = new Rectangle(this.boxSize);
            rectangle.x = n % this.elementsPerRow * rectangle.width;
            rectangle.y = n / this.elementsPerRow * rectangle.height;
        }
        return rectangle;
    }

    public void doLayout() {
        Dimension dimension = this.getPreferredSize();
        int n = Math.max(dimension.width, this.boxSize.width);
        this.elementsPerRow = n / this.boxSize.width;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle rectangle2 = new Rectangle(this.boxSize);
        for (int i = 0; i < this.elements.size(); ++i) {
            rectangle2.x = i % this.elementsPerRow * rectangle2.width;
            rectangle2.y = i / this.elementsPerRow * rectangle2.height;
            if (!rectangle2.intersects(rectangle)) continue;
            this.getThumbElement(i).paint(graphics2D, rectangle2);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this.current, 1001, "");
        EventListener[] eventListenerArray = this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ActionListener)eventListenerArray[i]).actionPerformed(actionEvent);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    protected void fireSelectionChanged(int n) {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this.current, n, n, false);
        EventListener[] eventListenerArray = this.listenerList.getListeners(ListSelectionListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ListSelectionListener)eventListenerArray[i]).valueChanged(listSelectionEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        if (this.isEnabled() && mouseEvent.getID() == 502 && (n = mouseEvent.getX() / this.boxSize.width + this.elementsPerRow * (mouseEvent.getY() / this.boxSize.height)) < this.elements.size()) {
            if (mouseEvent.getClickCount() == 1) {
                this.setCurrent(this.getThumbElement(n));
                this.fireSelectionChanged(n);
            } else if (mouseEvent.getClickCount() == 2) {
                this.fireActionPerformed();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
    }

    public class ThumbElement {
        ImageIcon image;
        String text;
        Object userObject;

        ThumbElement(Object object, ImageIcon imageIcon, String string) {
            this.setUserObject(object);
            this.setImage(imageIcon);
            this.setText(string);
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public ImageIcon getImage() {
            return this.image;
        }

        public void setImage(ImageIcon imageIcon) {
            this.image = imageIcon;
            if (imageIcon != null) {
                this.sizeImage();
            }
        }

        protected void sizeImage() {
            if (this.image != null) {
                int n = this.image.getIconWidth();
                int n2 = this.image.getIconHeight();
                if (n > ThumbsExplorerPanel.this.maxThumbSize.width || n2 > ThumbsExplorerPanel.this.maxThumbSize.height) {
                    double d = Math.min((double)ThumbsExplorerPanel.this.maxThumbSize.width / (double)n, (double)ThumbsExplorerPanel.this.maxThumbSize.height / (double)n2);
                    this.image = new ImageIcon(this.image.getImage().getScaledInstance((int)(d * (double)n), (int)(d * (double)n2), 4));
                }
            }
        }

        protected void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Object object;
            graphics2D.setBackground(LFUtil.getColor("Table.background", Color.white));
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (ThumbsExplorerPanel.this.current == this) {
                object = new Rectangle(rectangle.x + ThumbsExplorerPanel.this.th_margin / 2, rectangle.y + ThumbsExplorerPanel.this.th_margin / 2, rectangle.width - ThumbsExplorerPanel.this.th_margin, rectangle.height - ThumbsExplorerPanel.this.th_margin);
                graphics2D.setColor(LFUtil.getSysColor("activeCaption", Color.orange));
                graphics2D.fill((Shape)object);
                graphics2D.setColor(LFUtil.getSysColor("activeCaptionBorder", Color.red));
                graphics2D.draw((Shape)object);
            }
            if (this.image != null) {
                this.image.paintIcon(ThumbsExplorerPanel.this, graphics2D, rectangle.x + (ThumbsExplorerPanel.this.th_width + 2 * ThumbsExplorerPanel.this.th_margin - this.image.getIconWidth()) / 2, rectangle.y + (ThumbsExplorerPanel.this.th_height + 2 * ThumbsExplorerPanel.this.th_margin - this.image.getIconHeight()) / 2);
            }
            graphics2D.setColor(LFUtil.getColor("Table.gridColor", Color.gray));
            graphics2D.setStroke(BORDER_STROKE);
            graphics2D.drawRect(rectangle.x + ThumbsExplorerPanel.this.th_margin, rectangle.y + ThumbsExplorerPanel.this.th_margin, ThumbsExplorerPanel.this.th_width, ThumbsExplorerPanel.this.th_height);
            if (this.text != null && this.text.length() > 0) {
                TextHitInfo textHitInfo;
                int n;
                if (ThumbsExplorerPanel.this.current == this) {
                    graphics2D.setColor(LFUtil.getSysColor("activeCaptionText", Color.black));
                } else {
                    graphics2D.setColor(LFUtil.getColor("Table.foreground", Color.black));
                }
                object = graphics2D.getFontRenderContext();
                Font font = LFUtil.getFont("Table.font", ThumbsExplorerPanel.this.font);
                TextLayout textLayout = new TextLayout(this.text, font, (FontRenderContext)object);
                Rectangle2D rectangle2D = textLayout.getBounds();
                if (textLayout.getBounds().getWidth() > (double)ThumbsExplorerPanel.this.th_width && (n = (textHitInfo = textLayout.hitTestChar(ThumbsExplorerPanel.this.th_width - 20, 0.0f)).getInsertionIndex()) > 0) {
                    textLayout = new TextLayout(this.text.substring(0, n) + "...", font, (FontRenderContext)object);
                    rectangle2D = textLayout.getBounds();
                }
                textLayout.draw(graphics2D, (float)rectangle.x + (float)ThumbsExplorerPanel.this.th_margin + ((float)ThumbsExplorerPanel.this.th_width - (float)rectangle2D.getWidth()) / 2.0f, (float)rectangle.y + (float)(2 * ThumbsExplorerPanel.this.th_margin) + (float)ThumbsExplorerPanel.this.th_height);
            }
        }
    }
}

