/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Resizable;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class TextGrid
extends AbstractBox
implements Cloneable,
Resizable,
ActionListener {
    int nRows;
    int nCols;
    char[][] chars;
    char[][] answers;
    int[][] attributes;
    double cellWidth;
    double cellHeight;
    Rectangle2D preferredBounds = new Rectangle2D.Double();
    public char wild = (char)42;
    String randomChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    boolean cursorEnabled;
    boolean useCursor;
    Point cursor = new Point();
    boolean cursorBlink;
    Timer cursorTimer;
    boolean wildTransparent;
    public static final int MIN_CELL_SIZE = 12;
    public static final int DEFAULT_CELL_SIZE = 20;
    public static final int MIN_INTERNAL_MARGIN = 2;
    public static final int NORMAL = 0;
    public static final int INVERTED = 1;
    public static final int HIDDEN = 2;
    public static final int LOCKED = 4;
    public static final int MARKED = 8;
    public static final int TRANSPARENT = 16;

    public TextGrid(AbstractBox abstractBox, JComponent jComponent, double d, double d2, int n, int n2, double d3, double d4, BoxBase boxBase, boolean bl) {
        super(abstractBox, jComponent, boxBase);
        this.x = d;
        this.y = d2;
        this.nCols = Math.max(1, n);
        this.nRows = Math.max(1, n2);
        this.cellWidth = Math.max(d3, 12.0);
        this.cellHeight = Math.max(d4, 12.0);
        this.width = this.cellWidth * (double)this.nCols;
        this.height = this.cellHeight * (double)this.nRows;
        this.chars = new char[this.nRows][this.nCols];
        this.attributes = new int[this.nRows][this.nCols];
        this.preferredBounds.setRect(this.getBounds());
        this.setBorder(bl);
        this.cursorTimer = new Timer(500, this);
        this.cursorTimer.setRepeats(true);
        this.cursorEnabled = false;
        this.useCursor = false;
        this.wildTransparent = false;
        this.answers = null;
    }

    public static TextGrid createEmptyGrid(AbstractBox abstractBox, JComponent jComponent, double d, double d2, TextGridContent textGridContent, boolean bl) {
        TextGrid textGrid = new TextGrid(abstractBox, jComponent, d, d2, textGridContent.ncw, textGridContent.nch, textGridContent.w, textGridContent.h, textGridContent.bb, textGridContent.border);
        textGrid.wild = textGridContent.wild;
        textGrid.randomChars = textGridContent.randomChars;
        textGrid.wildTransparent = bl;
        return textGrid;
    }

    public void setChars(String[] stringArray) {
        this.answers = new char[this.nRows][this.nCols];
        for (int i = 0; i < this.nRows; ++i) {
            String string = i < stringArray.length ? stringArray[i] : null;
            for (int j = 0; j < this.nCols; ++j) {
                this.chars[i][j] = string == null || j >= string.length() ? 32 : (int)string.charAt(j);
                this.answers[i][j] = this.chars[i][j];
            }
        }
        this.repaint();
    }

    public void randomize() {
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                if (this.chars[i][j] != this.wild) continue;
                this.chars[i][j] = this.randomChars.charAt((int)(Math.random() * (double)this.randomChars.length()));
            }
        }
        this.repaint();
    }

    public void setCellAttributes(boolean bl, boolean bl2) {
        int n = 4;
        n = this.wildTransparent ? (n |= 0x10) : (n |= 3);
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                if (bl && this.chars[i][j] == this.wild) {
                    this.attributes[i][j] = n;
                    continue;
                }
                this.attributes[i][j] = 0;
                if (!bl2) continue;
                this.chars[i][j] = 32;
            }
        }
        this.repaint();
    }

    public void setCellLocked(int n, int n2, boolean bl) {
        if (n >= 0 && n < this.nCols && n2 >= 0 && n2 < this.nRows) {
            this.attributes[n2][n] = bl ? 4 | (this.wildTransparent ? 16 : 3) : 0;
        }
    }

    public Point getItemFor(int n, int n2) {
        int n3;
        if (!this.isValidCell(n, n2)) {
            return null;
        }
        Point point = new Point();
        boolean bl = false;
        boolean bl2 = false;
        for (n3 = 0; n3 < n; ++n3) {
            if ((this.attributes[n2][n3] & 4) != 0) {
                if (bl) continue;
                if (bl2) {
                    ++point.x;
                }
                bl = true;
                continue;
            }
            bl2 = true;
            bl = false;
        }
        bl = false;
        bl2 = false;
        for (n3 = 0; n3 < n2; ++n3) {
            if ((this.attributes[n3][n] & 4) != 0) {
                if (bl) continue;
                if (bl2) {
                    ++point.y;
                }
                bl = true;
                continue;
            }
            bl2 = true;
            bl = false;
        }
        return point;
    }

    public void setCursorEnabled(boolean bl) {
        this.cursorEnabled = bl;
        if (bl) {
            this.startCursorBlink();
        } else {
            this.stopCursorBlink();
        }
    }

    public void startCursorBlink() {
        if (this.useCursor && this.cursorEnabled && this.cursorTimer != null && !this.cursorTimer.isRunning()) {
            this.blink(1);
            this.cursorTimer.start();
        }
    }

    public void stopCursorBlink() {
        if (this.cursorTimer != null && this.cursorTimer.isRunning()) {
            this.cursorTimer.stop();
            this.blink(-1);
        }
    }

    public void moveCursor(int n, int n2, boolean bl) {
        Point point;
        if (this.useCursor && !this.cursor.equals(point = this.findNextCellWithAttr(this.cursor.x, this.cursor.y, bl ? 4 : 0, n, n2, false))) {
            this.setCursorAt(point.x, point.y, bl);
        }
    }

    public Point findFreeCell(Point point, int n, int n2) {
        Point point2 = null;
        if (point != null && (n != 0 || n2 != 0)) {
            Point point3 = new Point(point);
            while (point2 == null) {
                point3.x += n;
                point3.y += n2;
                if (point3.x < 0 || point3.x >= this.nCols || point3.y < 0 || point3.y >= this.nRows) break;
                if (this.getCellAttribute(point3.x, point3.y, 4)) continue;
                point2 = point3;
            }
        }
        return point2;
    }

    public boolean isIntoBlacks(Point point, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? !(point.x > 0 && !this.getCellAttribute(point.x - 1, point.y, 4) || point.x < this.nCols - 1 && !this.getCellAttribute(point.x + 1, point.y, 4)) : !(point.y > 0 && !this.getCellAttribute(point.x, point.y - 1, 4) || point.y < this.nRows - 1 && !this.getCellAttribute(point.x, point.y + 1, 4));
        return bl2;
    }

    public boolean isIntoWhites(Point point, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? point.x > 0 && !this.getCellAttribute(point.x - 1, point.y, 4) && point.x < this.nCols - 1 && !this.getCellAttribute(point.x + 1, point.y, 4) : point.y > 0 && !this.getCellAttribute(point.x, point.y - 1, 4) && point.y < this.nRows - 1 && !this.getCellAttribute(point.x, point.y + 1, 4);
        return bl2;
    }

    public Point findNextCellWithAttr(int n, int n2, int n3, int n4, int n5, boolean bl) {
        Point point = new Point(n + n4, n2 + n5);
        while (true) {
            if (point.x < 0) {
                point.x = this.nCols - 1;
                point.y = point.y > 0 ? --point.y : this.nRows - 1;
            } else if (point.x >= this.nCols) {
                point.x = 0;
                point.y = point.y < this.nRows - 1 ? ++point.y : 0;
            }
            if (point.y < 0) {
                point.y = this.nRows - 1;
                point.x = point.x > 0 ? --point.x : this.nCols - 1;
            } else if (point.y >= this.nRows) {
                point.y = 0;
                point.x = point.x < this.nCols - 1 ? ++point.x : 0;
            }
            if (point.x == n && point.y == n2 || this.getCellAttribute(point.x, point.y, n3) == bl) break;
            point.x += n4;
            point.y += n5;
        }
        return point;
    }

    public void setCursorAt(int n, int n2, boolean bl) {
        this.stopCursorBlink();
        if (this.isValidCell(n, n2)) {
            this.cursor.x = n;
            this.cursor.y = n2;
            this.useCursor = true;
            if (bl && this.getCellAttribute(n, n2, 4)) {
                this.moveCursor(1, 0, bl);
                return;
            }
            if (this.cursorEnabled) {
                this.startCursorBlink();
            }
        }
    }

    public void setUseCursor(boolean bl) {
        this.useCursor = bl;
    }

    public Point getCursor() {
        return this.cursor;
    }

    public int countCharsLike(char c) {
        int n = 0;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                if (this.chars[i][j] != c) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNumCells() {
        return this.nRows * this.nCols;
    }

    public int countCoincidences(boolean bl) {
        int n = 0;
        if (this.answers != null) {
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < this.nCols; ++j) {
                    if (!this.isCellOk(j, i, bl)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public boolean isCellOk(int n, int n2, boolean bl) {
        char c;
        char c2;
        boolean bl2 = false;
        if (this.isValidCell(n, n2) && (c2 = this.chars[n2][n]) != this.wild && (c2 == (c = this.answers[n2][n]) || !bl && Character.toUpperCase(c2) == Character.toUpperCase(c))) {
            bl2 = true;
        }
        return bl2;
    }

    public Point getLogicalCoords(Point2D point2D) {
        int n;
        if (!this.contains(point2D)) {
            return null;
        }
        int n2 = (int)((point2D.getX() - this.getX()) / this.cellWidth);
        if (this.isValidCell(n2, n = (int)((point2D.getY() - this.getY()) / this.cellHeight))) {
            return new Point(n2, n);
        }
        return null;
    }

    public boolean isValidCell(int n, int n2) {
        return n < this.nCols && n2 < this.nRows && n >= 0 && n2 >= 0;
    }

    public void setCharAt(int n, int n2, char c) {
        if (this.isValidCell(n, n2)) {
            this.chars[n2][n] = c;
            this.repaintCell(n, n2);
        }
    }

    public char getCharAt(int n, int n2) {
        if (this.isValidCell(n, n2)) {
            return this.chars[n2][n];
        }
        return ' ';
    }

    public String getStringBetween(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isValidCell(n, n2) && this.isValidCell(n3, n4)) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            if (n5 == 0 || n6 == 0 || Math.abs(n5) == Math.abs(n6)) {
                int n7 = Math.max(Math.abs(n5), Math.abs(n6));
                if (n7 > 0) {
                    n5 /= n7;
                    n6 /= n7;
                }
                for (int i = 0; i <= n7; ++i) {
                    stringBuffer.append(this.getCharAt(n + n5 * i, n2 + n6 * i));
                }
            }
        }
        return stringBuffer.substring(0);
    }

    public void setAttributeBetween(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (this.isValidCell(n, n2) && this.isValidCell(n3, n4)) {
            int n6 = n3 - n;
            int n7 = n4 - n2;
            if (n6 == 0 || n7 == 0 || Math.abs(n6) == Math.abs(n7)) {
                int n8 = Math.max(Math.abs(n6), Math.abs(n7));
                if (n8 > 0) {
                    n6 /= n8;
                    n7 /= n8;
                }
                for (int i = 0; i <= n8; ++i) {
                    this.setAttribute(n + n6 * i, n2 + n7 * i, n5, bl);
                }
            }
        }
    }

    public void setAttribute(int n, int n2, int n3, boolean bl) {
        if (this.isValidCell(n, n2)) {
            if (n3 == 8 && !bl) {
                this.repaintCell(n, n2);
            }
            int[] nArray = this.attributes[n2];
            int n4 = n;
            nArray[n4] = nArray[n4] & ~n3;
            int[] nArray2 = this.attributes[n2];
            int n5 = n;
            nArray2[n5] = nArray2[n5] | (bl ? n3 : 0);
            if (n3 != 8 || bl) {
                this.repaintCell(n, n2);
            }
        }
    }

    public void setAllCellsAttribute(int n, boolean bl) {
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                this.setAttribute(j, i, n, bl);
            }
        }
    }

    public boolean getCellAttribute(int n, int n2, int n3) {
        if (this.isValidCell(n, n2)) {
            return (this.attributes[n2][n] & n3) != 0;
        }
        return false;
    }

    public Rectangle2D getCellRect(int n, int n2) {
        return new Rectangle2D.Double(this.getX() + (double)n * this.cellWidth, this.getY() + (double)n2 * this.cellHeight, this.cellWidth, this.cellHeight);
    }

    public Rectangle getCellBorderBounds(int n, int n2) {
        boolean bl = this.getCellAttribute(n, n2, 8);
        if (!this.border && !bl) {
            return this.getCellRect(n, n2).getBounds();
        }
        BoxBase boxBase = this.getBoxBaseResolve();
        Stroke stroke = bl ? boxBase.getMarker() : boxBase.getBorder();
        return stroke.createStrokedShape(this.getCellRect(n, n2)).getBounds();
    }

    public void repaintCell(int n, int n2) {
        JComponent jComponent = this.getContainerResolve();
        if (jComponent != null) {
            jComponent.repaint(this.getCellBorderBounds(n, n2));
        }
    }

    public Object clone() {
        TextGrid textGrid = (TextGrid)super.clone();
        textGrid.nRows = this.nRows;
        textGrid.nCols = this.nCols;
        textGrid.chars = new char[this.nRows][this.nCols];
        textGrid.attributes = new int[this.nRows][this.nCols];
        for (int i = 0; i < this.nRows; ++i) {
            System.arraycopy(this.chars[i], 0, textGrid.chars[i], 0, this.nCols);
            System.arraycopy(this.attributes[i], 0, textGrid.attributes[i], 0, this.nCols);
        }
        textGrid.cellWidth = this.cellWidth;
        textGrid.cellHeight = this.cellHeight;
        textGrid.preferredBounds = (Rectangle2D)this.preferredBounds.clone();
        return textGrid;
    }

    public Dimension getPreferredSize() {
        return this.preferredBounds.getBounds().getSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(12 * this.nCols, 12 * this.nRows);
    }

    public Dimension getScaledSize(double d) {
        return new Dimension(StrUtils.roundTo(d * this.preferredBounds.getWidth(), this.nCols), StrUtils.roundTo(d * this.preferredBounds.getHeight(), this.nRows));
    }

    public void setBounds(Rectangle2D rectangle2D) {
        super.setBounds(rectangle2D);
        this.cellWidth = this.width / (double)this.nCols;
        this.cellHeight = this.height / (double)this.nRows;
    }

    public boolean update(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (rectangle != null && !this.shape.intersects(rectangle)) {
            return false;
        }
        this.updateContent(graphics2D, rectangle, imageObserver);
        return true;
    }

    public boolean updateContent(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        BoxBase boxBase = this.getBoxBaseResolve();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(boxBase.getFont());
        boolean bl = false;
        while (!((double)fontMetrics.charWidth('W') <= this.cellWidth - 4.0 && (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) <= this.cellHeight - 4.0 || !boxBase.reduceFont())) {
            bl = true;
            fontMetrics = graphics2D.getFontMetrics(boxBase.getFont());
        }
        if (bl) {
            JComponent jComponent = this.getContainerResolve();
            if (jComponent != null) {
                RepaintManager.currentManager(jComponent).markCompletelyDirty(jComponent);
            }
            return true;
        }
        char[] cArray = new char[1];
        double d = (this.cellHeight - (double)fontMetrics.getDescent() + (double)fontMetrics.getAscent()) / 2.0;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                int n;
                Rectangle rectangle2 = this.getCellBorderBounds(j, i);
                if (!rectangle2.intersects(rectangle) || ((n = this.attributes[i][j]) & 0x10) != 0) continue;
                boolean bl2 = (n & 1) != 0;
                boolean bl3 = (n & 8) != 0;
                boolean bl4 = this.useCursor && this.cursor.x == j && this.cursor.y == i;
                Rectangle2D rectangle2D = this.getCellRect(j, i);
                graphics2D.setColor(bl4 && this.cursorBlink ? boxBase.inactiveColor : (bl2 ? boxBase.textColor : boxBase.backColor));
                graphics2D.fill(rectangle2D);
                graphics2D.setColor(Color.black);
                if ((n & 2) == 0) {
                    cArray[0] = this.chars[i][j];
                    if (cArray[0] != '\u0000') {
                        double d2 = rectangle2D.getX() + (this.cellWidth - (double)fontMetrics.charWidth(cArray[0])) / 2.0;
                        double d3 = rectangle2D.getY() + d;
                        GlyphVector glyphVector = boxBase.getFont().createGlyphVector(fontRenderContext, cArray);
                        if (boxBase.shadow) {
                            graphics2D.setColor(boxBase.shadowColor);
                            graphics2D.drawGlyphVector(glyphVector, (float)(d2 + (double)(boxBase.getDynFontSize() / 10.0f)), (float)(d3 + (double)(boxBase.getDynFontSize() / 10.0f)));
                        }
                        graphics2D.setColor(bl2 ? boxBase.backColor : (this.isAlternative() ? boxBase.alternativeColor : boxBase.textColor));
                        graphics2D.drawGlyphVector(glyphVector, (float)d2, (float)d3);
                    }
                }
                if (this.border || bl3) {
                    graphics2D.setColor(boxBase.borderColor);
                    graphics2D.setStroke(bl3 ? boxBase.getMarker() : boxBase.getBorder());
                    if (bl3) {
                        graphics2D.setXORMode(Color.white);
                    }
                    graphics2D.draw(rectangle2D);
                    if (bl3) {
                        graphics2D.setPaintMode();
                    }
                    graphics2D.setStroke(BoxBase.DEFAULT_STROKE);
                }
                graphics2D.setColor(Color.black);
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.blink(0);
    }

    protected synchronized void blink(int n) {
        if (this.useCursor) {
            this.cursorBlink = n == 1 ? true : (n == -1 ? false : !this.cursorBlink);
            this.repaintCell(this.cursor.x, this.cursor.y);
        }
    }

    public void end() {
        if (this.cursorTimer != null) {
            this.cursorTimer.stop();
            this.cursorTimer = null;
        }
    }

    public void finalize() throws Throwable {
        this.end();
        super.finalize();
    }
}

