/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.textGrid;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import org.jdom.Element;

public class WordSearch
extends Activity
implements ActiveBagContentKit.Compatible {
    String[] clues;
    int[] clueItems;

    public WordSearch(JClicProject jClicProject) {
        super(jClicProject);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[1];
        this.clues = null;
        this.clueItems = null;
    }

    public void initNew() {
        super.initNew();
        this.clues = new String[0];
        this.clueItems = new int[0];
        this.tgc = TextGridContent.initNew(3, 3, 'A');
    }

    public Element getJDomElement() {
        Element element = null;
        Element element2 = null;
        if (this.clues == null || this.tgc == null) {
            return null;
        }
        Element element3 = super.getJDomElement();
        element3.addContent(this.tgc.getJDomElement());
        element = new Element("clues");
        for (int i = 0; i < this.clues.length; ++i) {
            element2 = new Element("clue");
            element2.setAttribute("id", Integer.toString(this.clueItems[i]));
            element2.setText(this.clues[i]);
            element.addContent(element2);
        }
        element3.addContent(element);
        if (this.abc[0] != null) {
            element3.addContent(this.abc[0].getJDomElement().setAttribute("id", "secondary"));
            element = new Element("layout");
            element.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
            element3.addContent(element);
            if (this.scramble[0]) {
                element = new Element("scramble");
                element.setAttribute("times", Integer.toString(this.shuffles));
                element.setAttribute("secondary", JDomUtility.boolString(this.scramble[0]));
                element3.addContent(element);
            }
        }
        return element3;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild("textGrid");
        if (element2 == null) {
            throw new IllegalArgumentException("WordSearch without TextGridContent!");
        }
        this.tgc = TextGridContent.getTextGridContent(element2);
        element2 = element.getChild("clues");
        if (element2 == null) {
            throw new IllegalArgumentException("WordSearch without clues!");
        }
        List list = element2.getChildren("clue");
        int n = list.size();
        this.clues = new String[n];
        this.clueItems = new int[n];
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)list.get(i);
            this.clueItems[i] = JDomUtility.getIntAttr(element3, "id", i);
            this.clues[i] = element3.getText();
        }
        element2 = element.getChild("cells");
        if (element2 != null) {
            if (!"secondary".equals(element2.getAttributeValue("id"))) {
                throw new IllegalArgumentException("WordSearch expects only \"secondary\" BagContent!");
            }
            this.abc[0] = ActiveBagContent.getActiveBagContent(element2, this.project.mediaBag);
            element2 = element.getChild("scramble");
            if (element2 != null) {
                this.shuffles = JDomUtility.getIntAttr(element2, "times", this.shuffles);
                this.scramble[0] = JDomUtility.getBoolAttr(element2, "secondary", this.scramble[0]);
            } else {
                this.scramble[0] = false;
            }
        } else {
            this.abc[0] = null;
        }
        element2 = element.getChild("layout");
        if (element2 != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(element2, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.boxGridPos = clic3Activity.graPos;
        this.tgc = new TextGridContent();
        this.tgc.nch = clic3Activity.nctxh;
        this.tgc.ncw = clic3Activity.nctxw;
        this.tgc.w = clic3Activity.txtCW;
        this.tgc.h = clic3Activity.txtCH;
        this.tgc.border = clic3Activity.delim[1];
        this.tgc.text = clic3Activity.graTxt;
        this.clues = clic3Activity.tags[0];
        this.clueItems = new int[this.clues.length];
        for (int i = 0; i < this.clues.length; ++i) {
            this.clueItems[i] = i;
        }
        this.tgc.bb = clic3Activity.getBoxBase(0);
        if (clic3Activity.bar[0]) {
            clic3Activity.txtCW = clic3Activity.txtCW2;
            clic3Activity.txtCH = clic3Activity.txtCH2;
            this.abc[0] = clic3Activity.createActiveBagContent(0);
            this.abc[0].setBoxBase(clic3Activity.getBoxBase(1));
        } else {
            this.abc[0] = null;
        }
    }

    public int getMinNumActions() {
        return this.clues.length;
    }

    public boolean helpSolutionAllowed() {
        return true;
    }

    public boolean hasRandom() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    public String[] getClues() {
        return this.clues;
    }

    public void setClues(String[] stringArray, int[] nArray) {
        this.clues = stringArray;
        if (this.clues == null) {
            this.clues = new String[0];
        }
        this.clueItems = nArray;
        if (this.clueItems == null || this.clueItems.length != this.clues.length) {
            this.clueItems = new int[this.clues.length];
            for (int i = 0; i < this.clueItems.length; ++i) {
                this.clueItems[i] = i;
            }
        }
    }

    class Panel
    extends Activity.Panel {
        TextGrid grid;
        ActiveBoxBag bgAlt;
        boolean[] resolvedClues;

        protected Panel(PlayStation playStation) {
            super(playStation);
            this.bc = new BoxConnector(this);
            this.resolvedClues = new boolean[WordSearch.this.clues.length];
            this.grid = null;
            this.bgAlt = null;
        }

        public void clear() {
            if (this.grid != null) {
                this.grid.end();
                this.grid = null;
            }
            if (this.bgAlt != null) {
                this.bgAlt.end();
                this.bgAlt = null;
            }
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (WordSearch.this.acp != null && WordSearch.this.abc != null) {
                WordSearch.this.acp.generateContent(new ActiveBagContentKit(0, 0, WordSearch.this.abc, false), this.ps);
            }
            if (WordSearch.this.tgc != null) {
                this.grid = TextGrid.createEmptyGrid(null, this, WordSearch.this.margin, WordSearch.this.margin, WordSearch.this.tgc, false);
                if (WordSearch.this.abc[0] != null) {
                    this.bgAlt = ActiveBoxGrid.createEmptyGrid(null, this, WordSearch.this.margin, WordSearch.this.margin, WordSearch.this.abc[0]);
                }
                this.grid.setVisible(true);
                this.invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.grid != null) {
                this.grid.setChars(WordSearch.this.tgc.text);
                this.grid.randomize();
                this.grid.setAllCellsAttribute(1, false);
                for (int i = 0; i < WordSearch.this.clueItems.length; ++i) {
                    this.resolvedClues[i] = false;
                }
                if (this.bgAlt != null) {
                    this.bgAlt.setContent(WordSearch.this.abc[0]);
                    if (WordSearch.this.scramble[0]) {
                        this.shuffle(new ActiveBoxBag[]{this.bgAlt}, true, true);
                    }
                    this.bgAlt.setVisible(false);
                }
                this.playing = true;
            }
        }

        public int getCurrentScore() {
            int n = 0;
            if (WordSearch.this.clues != null) {
                for (int i = 0; i < WordSearch.this.clues.length; ++i) {
                    if (!this.resolvedClues[i]) continue;
                    ++n;
                }
            }
            return n;
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.grid != null) {
                this.grid.update(graphics2D, rectangle, this);
            }
            if (this.bgAlt != null) {
                this.bgAlt.update(graphics2D, rectangle, this);
            }
            if (this.bc.active) {
                this.bc.update(graphics2D, rectangle, this);
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.grid == null || this.getSize().equals(dimension)) {
                return dimension;
            }
            if (this.bgAlt != null) {
                return BoxBag.layoutDouble(dimension, this.grid, this.bgAlt, WordSearch.this.boxGridPos, WordSearch.this.margin);
            }
            return BoxBag.layoutSingle(dimension, this.grid, WordSearch.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            this.bc.end();
                            Point point2 = this.grid.getLogicalCoords(this.bc.origin);
                            Point point3 = this.grid.getLogicalCoords(this.bc.dest);
                            if (point2 == null || point3 == null) break;
                            String string = this.grid.getStringBetween(point2.x, point2.y, point3.x, point3.y);
                            if (string != null && string.length() > 0) {
                                int n;
                                int n2;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                for (n2 = 0; n2 < WordSearch.this.clues.length; ++n2) {
                                    if (!string.equals(WordSearch.this.clues[n2])) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (bl2 && !(bl3 = this.resolvedClues[n2])) {
                                    ActiveBox activeBox;
                                    this.resolvedClues[n2] = true;
                                    this.grid.setAttributeBetween(point2.x, point2.y, point3.x, point3.y, 1, true);
                                    if (this.bgAlt != null && (n = WordSearch.this.clueItems[n2]) >= 0 && n < this.bgAlt.getNumCells() && (activeBox = this.bgAlt.getActiveBox(WordSearch.this.clueItems[n2])) != null) {
                                        activeBox.setVisible(true);
                                        bl = activeBox.playMedia(this.ps);
                                    }
                                }
                                if (!bl3) {
                                    n = this.getCurrentScore();
                                    this.ps.reportNewAction(this.getActivity(), "SELECT", string, null, bl2, n);
                                    if (n == WordSearch.this.clues.length) {
                                        this.finishActivity(true);
                                        break;
                                    }
                                    if (bl) break;
                                    this.playEvent(bl2 ? 3 : 2);
                                    break;
                                }
                                if (bl2 || bl) break;
                                this.playEvent(2);
                                break;
                            }
                            this.playEvent(2);
                            break;
                        }
                        if (!this.grid.contains(point)) break;
                        this.playEvent(1);
                        this.bc.begin(point);
                        break;
                    }
                    case 503: 
                    case 506: {
                        if (!this.bc.active) break;
                        this.bc.moveTo(point);
                    }
                }
            }
        }

        public void showHelp() {
            if (!WordSearch.this.helpWindowAllowed() || this.grid == null) {
                return;
            }
            HelpActivityComponent helpActivityComponent = null;
            if (WordSearch.this.showSolution) {
                helpActivityComponent = new HelpActivityComponent(this){
                    JScrollPane scrollPane;
                    JList cluesList;
                    {
                        this.scrollPane = null;
                        this.cluesList = null;
                    }

                    public void render(Graphics2D graphics2D, Rectangle rectangle) {
                    }

                    public void init() {
                        this.cluesList = new JList<String>(((Panel)Panel.this).WordSearch.this.clues);
                        this.cluesList.setSelectionMode(0);
                        this.cluesList.addListSelectionListener(this);
                        this.scrollPane = new JScrollPane(this.cluesList);
                        this.add(this.scrollPane);
                        Dimension dimension = Panel.this.grid.getBounds().getSize();
                        this.scrollPane.setBounds(8, 8, dimension.width, dimension.height);
                        dimension.width += 16;
                        dimension.height += 16;
                        this.setPreferredSize(dimension);
                        this.setMaximumSize(dimension);
                        this.setMinimumSize(dimension);
                        Point point = (Point)this.getClientProperty("prefLoc");
                        if (point != null) {
                            point.translate((int)Panel.this.grid.x - 8, (int)Panel.this.grid.y - 8);
                        }
                    }

                    public void doLayout() {
                        Rectangle rectangle = this.getBounds();
                        if (this.scrollPane != null) {
                            this.scrollPane.setBounds(8, 8, rectangle.width - 16, rectangle.height - 16);
                        }
                    }

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (Panel.this.bgAlt != null && !listSelectionEvent.getValueIsAdjusting()) {
                            int n = this.cluesList.getSelectedIndex();
                            if (n < 0) {
                                this.unmarkBox();
                            } else {
                                Panel.this.playEvent(1);
                                this.markBox(Panel.this.bgAlt.getActiveBox(((Panel)Panel.this).WordSearch.this.clueItems[n]), true);
                            }
                        }
                    }
                };
                helpActivityComponent.init();
            }
            if (this.ps.showHelp(helpActivityComponent, WordSearch.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.getCurrentScore());
            }
            if (helpActivityComponent != null) {
                helpActivityComponent.end();
            }
        }
    }
}

