/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.jdom.Element;

public class TextTarget {
    public static final int NO_INFO = 0;
    public static final int INFO_ALWAYS = 1;
    public static final int INFO_ON_ERROR = 2;
    public static final int INFO_ON_DEMAND = 3;
    public static final String[] infoTypes = new String[]{"no_info", "always", "onError", "onDemand"};
    public static final int NOT_EDITED = 0;
    public static final int EDITED = 1;
    public static final int SOLVED = 2;
    public static final int WITH_ERROR = 3;
    public static final int INFO_LEFTALIGN = 1;
    public static final int INFO_ONLYPLAY = 2;
    public boolean isList = false;
    public int numIniChars = 1;
    public char iniChar = (char)95;
    public int maxLenResp = 0;
    public String[] answer = null;
    public String[] options = null;
    public String iniText = null;
    public int infoMode = 0;
    public ActiveBoxContent popupContent = null;
    public int popupDelay = 0;
    public int popupMaxTime = 0;
    public boolean onlyPlay = false;
    protected TargetCombo comboList = null;
    public int targetStatus = 0;
    private boolean flagModified = false;
    TextActivityPane parentPane;
    public static final String ELEMENT_NAME = "target";
    public static final String ANSWER = "answer";
    public static final String OPTION_LIST = "optionList";
    public static final String OPTION = "option";
    public static final String RESPONSE = "response";
    public static final String FILL = "fill";
    public static final String INI_LEN = "length";
    public static final String MAX_LEN = "maxLength";
    public static final String INI_TEXT = "show";
    public static final String INFO = "info";
    public static final String MODE = "mode";
    public static final String DELAY = "delay";
    public static final String MAX_TIME = "maxTime";

    public TextTarget() {
    }

    public TextTarget(Document document, int n, int n2) {
        this();
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        String string = null;
        try {
            string = document.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        this.numIniChars = string.length();
        this.answer = new String[]{string};
        this.maxLenResp = this.numIniChars;
    }

    public void reset() {
        this.targetStatus = 0;
        this.flagModified = false;
        if (this.comboList != null) {
            this.comboList.checkColors();
        }
    }

    public Element getJDomElement() {
        Element element;
        int n;
        Element element2 = new Element(ELEMENT_NAME);
        if (this.answer != null) {
            for (n = 0; n < this.answer.length; ++n) {
                element2.addContent(new Element(ANSWER).addContent(this.answer[n]));
            }
        }
        if (this.isList) {
            element = new Element(OPTION_LIST);
            if (this.options != null) {
                for (n = 0; n < this.options.length; ++n) {
                    element.addContent(new Element(OPTION).addContent(this.options[n]));
                }
            }
            element2.addContent(element);
        } else {
            element = new Element(RESPONSE);
            element.setAttribute(FILL, new String(new char[]{this.iniChar}));
            element.setAttribute(INI_LEN, Integer.toString(this.numIniChars));
            element.setAttribute(MAX_LEN, Integer.toString(this.maxLenResp));
            if (this.iniText != null && this.iniText.length() > 0) {
                element.setAttribute(INI_TEXT, this.iniText);
            }
            element2.addContent(element);
        }
        if (this.popupContent != null && this.infoMode != 0) {
            element = new Element(INFO);
            if (this.infoMode != 1) {
                element.setAttribute(MODE, infoTypes[this.infoMode]);
            }
            if (this.popupDelay > 0) {
                element.setAttribute(DELAY, Integer.toString(this.popupDelay));
            }
            if (this.popupMaxTime > 0) {
                element.setAttribute(MAX_TIME, Integer.toString(this.popupMaxTime));
            }
            if (this.onlyPlay && this.popupContent.mediaContent != null) {
                element.addContent(this.popupContent.mediaContent.getJDomElement());
            } else {
                element.addContent(this.popupContent.getJDomElement());
            }
            element2.addContent(element);
        }
        return element2;
    }

    public static TextTarget getTextTarget(Element element, MediaBag mediaBag) throws Exception {
        TextTarget textTarget = new TextTarget();
        textTarget.setProperties(element, mediaBag);
        return textTarget;
    }

    public void setProperties(Element element, Object object) throws Exception {
        List list;
        Element element2;
        JDomUtility.checkName(element, ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)object;
        List list2 = element.getChildren(ANSWER);
        if (!list2.isEmpty()) {
            this.answer = new String[list2.size()];
            for (int i = 0; i < this.answer.length; ++i) {
                this.answer[i] = ((Element)list2.get(i)).getText();
            }
        }
        if ((element2 = element.getChild(OPTION_LIST)) != null && !(list = element2.getChildren(OPTION)).isEmpty()) {
            this.isList = true;
            this.options = new String[list.size()];
            for (int i = 0; i < this.options.length; ++i) {
                this.options[i] = ((Element)list.get(i)).getText();
            }
        }
        if ((element2 = element.getChild(RESPONSE)) != null) {
            String string = new String(new char[]{this.iniChar});
            if ((string = JDomUtility.getStringAttr(element2, FILL, string, true)).length() > 0) {
                this.iniChar = string.charAt(0);
            }
            this.numIniChars = JDomUtility.getIntAttr(element2, INI_LEN, this.numIniChars);
            this.maxLenResp = JDomUtility.getIntAttr(element2, MAX_LEN, this.maxLenResp);
            this.iniText = element2.getAttributeValue(INI_TEXT);
        }
        if ((element2 = element.getChild(INFO)) != null) {
            this.infoMode = JDomUtility.getStrIndexAttr(element2, MODE, infoTypes, 1);
            this.popupDelay = JDomUtility.getIntAttr(element2, DELAY, this.popupDelay);
            this.popupMaxTime = JDomUtility.getIntAttr(element2, MAX_TIME, this.popupMaxTime);
            Element element3 = element2.getChild("media");
            if (element3 != null) {
                this.onlyPlay = true;
                this.popupContent = new ActiveBoxContent();
                this.popupContent.mediaContent = MediaContent.getMediaContent(element3);
            } else {
                element3 = element2.getChild("cell");
                if (element3 != null) {
                    this.popupContent = ActiveBoxContent.getActiveBoxContent(element3, mediaBag);
                }
            }
        }
    }

    protected void setParentPane(TextActivityPane textActivityPane) {
        this.parentPane = textActivityPane;
    }

    public void setAnswer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            this.answer = null;
        } else {
            this.answer = new String[n];
            for (int i = 0; i < n; ++i) {
                this.answer[i] = stringTokenizer.nextToken();
            }
        }
    }

    public String getAnswers() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.answer != null) {
            for (int i = 0; i < this.answer.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(this.answer[i]);
            }
        }
        return stringBuffer.substring(0);
    }

    public boolean checkText(String string, Evaluator evaluator) {
        if (this.answer == null || string == null) {
            return false;
        }
        boolean bl = evaluator.checkText(string, this.answer);
        this.targetStatus = bl ? 2 : 3;
        return bl;
    }

    public JComboBox buildCombo(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!this.isList || this.options == null) {
            return null;
        }
        this.comboList = new TargetCombo(this.options, attributeSet, attributeSet2);
        if (this.iniText != null) {
            this.comboList.setSelectedItem(this.iniText);
        }
        return this.comboList;
    }

    public String getFillString() {
        return this.getFillString(this.numIniChars);
    }

    public String getFillString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.iniChar);
        }
        return stringBuffer.substring(0);
    }

    public void requestFocus(TextActivityBase.Panel panel, TargetMarker targetMarker) {
        if (this.comboList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextTarget.this.comboList.requestFocus();
                }
            });
        } else {
            panel.requestFocus();
        }
        if (this.popupContent != null && (this.infoMode == 1 || this.infoMode == 2 && this.targetStatus == 3)) {
            panel.popupTimer.setUp(this, targetMarker);
        }
    }

    public void checkPopup(TextActivityBase.Panel panel, TargetMarker targetMarker, boolean bl) {
        if (this.popupContent != null) {
            boolean bl2 = false;
            if (this.infoMode == 2) {
                bl2 = this.targetStatus == 3;
            } else if (this.infoMode == 3) {
                bl2 = bl;
            }
            if (bl2) {
                panel.popupTimer.setUp(this, targetMarker);
            } else {
                panel.popupTimer.stopPopup();
            }
        }
    }

    protected Point getPopupLocation(TextActivityBase.Panel panel, TargetMarker targetMarker) {
        if (this.popupContent == null || this.onlyPlay) {
            return null;
        }
        Rectangle rectangle = targetMarker.getBegRect(panel.pane);
        if (rectangle == null) {
            return null;
        }
        Point point = rectangle.getLocation();
        point.y -= this.popupContent.dimension.height;
        if (point.y < 0) {
            point.y = rectangle.y + rectangle.height;
        }
        if (point.x + this.popupContent.dimension.width > panel.pane.getWidth()) {
            point.x -= panel.pane.getWidth() - point.x + this.popupContent.dimension.width;
            if (point.x < 0) {
                point.x = 0;
            }
        }
        return point;
    }

    public void adjustPopupLocation(TextActivityBase.Panel panel, TargetMarker targetMarker) {
        Point point = this.getPopupLocation(panel, targetMarker);
        if (point != null) {
            panel.pane.bx.setLocation(point);
        }
    }

    public void lostFocus(TextActivityBase.Panel panel, TargetMarker targetMarker) {
        if (this.comboList != null && this.parentPane != null) {
            this.parentPane.repaint();
        }
        if (this.popupContent != null) {
            panel.popupTimer.stopPopup();
        }
    }

    public void setModified(boolean bl) {
        this.flagModified = bl;
        if (bl && this.targetStatus == 0) {
            this.targetStatus = 1;
        }
    }

    public boolean isModified() {
        return this.flagModified;
    }

    public static class PopupTimer
    extends Timer {
        TextTarget target;
        boolean action;
        TextActivityBase.Panel tabp;
        TargetMarker tm;

        public PopupTimer(TextActivityBase.Panel panel) {
            super(1000, null);
            this.tabp = panel;
            this.setRepeats(false);
            this.target = null;
        }

        public void setUp(TextTarget textTarget, TargetMarker targetMarker) {
            this.stop();
            this.target = textTarget;
            this.tm = targetMarker;
            this.action = true;
            if (this.target != null && this.target.popupContent != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (PopupTimer.this.target.popupDelay > 0) {
                            PopupTimer.this.setInitialDelay(PopupTimer.this.target.popupDelay * 1000);
                            PopupTimer.this.setRepeats(false);
                            PopupTimer.this.start();
                        } else {
                            PopupTimer.this.startPopup();
                        }
                    }
                });
            }
        }

        public void startPopup() {
            this.stop();
            if (this.target != null && this.target.popupContent != null) {
                Point point;
                if (!this.target.onlyPlay && (point = this.target.getPopupLocation(this.tabp, this.tm)) != null) {
                    this.tabp.pane.enableActiveBox(this.target.popupContent, point);
                }
                if (this.target.popupContent.mediaContent != null) {
                    this.tabp.ps.playMedia(this.target.popupContent.mediaContent, this.tabp.pane.bx);
                }
                if (this.target.popupMaxTime > 0) {
                    this.action = false;
                    this.setInitialDelay(this.target.popupMaxTime * 1000);
                    this.setRepeats(false);
                    this.start();
                }
            }
        }

        public void stopPopup() {
            this.stop();
            if (this.target != null && this.target.popupContent != null) {
                this.tabp.ps.stopMedia(1);
                this.tabp.pane.disableActiveBox();
            }
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (this.action) {
                this.startPopup();
            } else {
                this.stopPopup();
            }
        }
    }

    class TargetCombo
    extends JComboBox {
        Color bgColor;
        Color foreColor;
        Color errBgColor;
        Color errForeColor;
        Font rFont;
        TargetComboCellRenderer cellRenderer;
        JTextField editor;
        AbstractAction showListAction;
        AbstractAction fwdAction;
        AbstractAction bkAction;

        public TargetCombo(Object[] objectArray, AttributeSet attributeSet, AttributeSet attributeSet2) {
            super(objectArray);
            this.setSelectedIndex(-1);
            this.showListAction = new AbstractAction("showList"){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetCombo.this.setPopupVisible(true);
                }
            };
            this.fwdAction = new AbstractAction("forward"){

                public void actionPerformed(ActionEvent actionEvent) {
                    Action action;
                    if (((TargetCombo)TargetCombo.this).TextTarget.this.parentPane != null && (action = ((TargetCombo)TargetCombo.this).TextTarget.this.parentPane.getActionMap().get("next-target")) != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.bkAction = new AbstractAction("backwards"){

                public void actionPerformed(ActionEvent actionEvent) {
                    Action action;
                    if (((TargetCombo)TargetCombo.this).TextTarget.this.parentPane != null && (action = ((TargetCombo)TargetCombo.this).TextTarget.this.parentPane.getActionMap().get("prev-target")) != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            };
            this.rFont = TextActivityDocument.attributesToFont(attributeSet);
            this.setFont(this.rFont);
            this.bgColor = StyleConstants.getBackground(attributeSet);
            this.foreColor = StyleConstants.getForeground(attributeSet);
            this.errBgColor = StyleConstants.getBackground(attributeSet2);
            this.errForeColor = StyleConstants.getForeground(attributeSet2);
            this.setCursor(Cursor.getDefaultCursor());
            this.cellRenderer = new TargetComboCellRenderer();
            this.setRenderer(this.cellRenderer);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension((int)dimension.getWidth() + this.rFont.getSize() / 2, (int)dimension.getHeight()));
            this.setMaximumSize(this.getPreferredSize());
            this.setEditable(true);
            Component component = this.getEditor().getEditorComponent();
            this.editor = component instanceof JTextField ? (JTextField)component : new JTextField();
            this.editor.setEnabled(false);
            this.checkColors();
            this.setAlignmentY(0.8f);
            this.setKActions();
        }

        protected void setKActions() {
            this.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(10, 0), 0);
            this.editor.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.editor.registerKeyboardAction(this.showListAction, KeyStroke.getKeyStroke(10, 0), 0);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(39, 0), 1);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(9, 0), 1);
            this.registerKeyboardAction(this.fwdAction, KeyStroke.getKeyStroke(10, 0), 1);
            this.registerKeyboardAction(this.bkAction, KeyStroke.getKeyStroke(37, 0), 1);
            this.registerKeyboardAction(this.bkAction, KeyStroke.getKeyStroke(9, 1), 1);
        }

        public void checkColors() {
            if (TextTarget.this.targetStatus == 3) {
                this.editor.setBackground(this.errBgColor);
                this.editor.setForeground(this.errForeColor);
                this.editor.setDisabledTextColor(this.errForeColor);
            } else {
                this.editor.setBackground(this.bgColor);
                this.editor.setForeground(this.foreColor);
                this.editor.setDisabledTextColor(this.foreColor);
            }
        }

        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
            if (object != null && TextTarget.this.parentPane != null) {
                TextTarget.this.setModified(true);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!TargetCombo.this.isPopupVisible()) {
                            ((TargetCombo)TargetCombo.this).TextTarget.this.parentPane.targetChanged(TextTarget.this);
                        }
                    }
                });
            }
        }

        class TargetComboCellRenderer
        extends JLabel
        implements ListCellRenderer {
            public TargetComboCellRenderer() {
                this.setOpaque(true);
                this.setFont(TargetCombo.this.rFont);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? TargetCombo.this.foreColor : TargetCombo.this.bgColor);
                this.setForeground(bl ? TargetCombo.this.bgColor : TargetCombo.this.foreColor);
                this.setText(object.toString());
                return this;
            }
        }
    }
}

