/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.BasicEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.jdom.Element;

public class Order
extends TextActivityBase {
    public static final int ORDER_WORDS = 0;
    public static final int ORDER_PARAGRAPHS = 1;
    protected boolean amongParagraphs = false;
    protected int type;
    protected Evaluator ev;
    public static final String[] TYPES = new String[]{"orderWords", "orderParagraphs"};
    public static final String AMONG_PARAGRAPHS = "amongParagraphs";

    public Order(JClicProject jClicProject) {
        super(jClicProject);
        this.setType(0);
        this.hasCheckButton = true;
        this.checkButtonText = "";
        this.ev = new BasicEvaluator(jClicProject);
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        element.setAttribute("type", TYPES[this.type]);
        if (this.amongParagraphs) {
            element.setAttribute(AMONG_PARAGRAPHS, JDomUtility.boolString(this.amongParagraphs));
        }
        element.addContent(this.ev.getJDomElement());
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.setType(JDomUtility.getStrIndexAttr(element, "type", TYPES, this.type));
        if (this.type == 0) {
            this.amongParagraphs = JDomUtility.getBoolAttr(element, AMONG_PARAGRAPHS, this.amongParagraphs);
        }
        this.ev = Evaluator.getEvaluator(element.getChild("evaluator"), this.project);
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        ((BasicEvaluator)this.ev).setProperties(clic3Activity);
        this.setType(clic3Activity.puzMode == 5 ? 1 : 0);
        this.amongParagraphs = clic3Activity.brPar;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    public int getType() {
        return this.type;
    }

    public boolean hasRandom() {
        return true;
    }

    public boolean shuffleAlways() {
        return true;
    }

    public void setType(int n) {
        this.type = n == 0 ? 0 : 1;
        this.tad.setTargetType(n == 0 ? 2 : 3);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        int nActions;
        TargetMarker anchor;
        TargetMarker cursor;

        protected Panel(PlayStation playStation) {
            super(Order.this, playStation);
            this.playDoc = null;
            this.nActions = 0;
        }

        protected void initDocument() throws Exception {
            if (Order.this.tad != null) {
                int n;
                this.playing = false;
                this.playDoc = new TextActivityDocument(Order.this.styleContext);
                Order.this.tad.cloneDoc(this.playDoc, false, false, false);
                for (n = 0; n < this.playDoc.tmb.size(); ++n) {
                    this.playDoc.tmb.getElement((int)n).target = new TextTarget();
                    this.playDoc.tmb.getElement((int)n).target.answer = new String[]{this.playDoc.tmb.getElement(n).getCurrentText()};
                }
                if (this.playDoc.tmb.size() > 1) {
                    for (n = 0; n < 5 && this.shuffle() == this.playDoc.tmb.size(); ++n) {
                    }
                }
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEditable(false);
                this.pane.requestFocus();
                this.bc = new BoxConnector(this.pane);
                this.nActions = 0;
            }
        }

        private int shuffle() {
            int n;
            if (this.playDoc == null || this.playDoc.tmb.size() < 2) {
                return 0;
            }
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            int n2 = targetMarkerBag.size();
            int[] nArray = targetMarkerBag.getParagragraphOffsets();
            int[] nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = n;
            }
            int n3 = 0;
            int n4 = 0;
            Random random = new Random();
            for (int i = 0; i < Order.this.shuffles; ++i) {
                int n5;
                n3 = random.nextInt(n2);
                if (Order.this.type == 0 && !Order.this.amongParagraphs) {
                    n = 0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        if (n5 == n3 || nArray[n5] != nArray[n3]) continue;
                        nArray2[n++] = n5;
                    }
                }
                if (n <= 0) continue;
                for (n5 = 0; n5 < 300 && (n4 = nArray2[random.nextInt(n)]) == n3; ++n5) {
                }
                if (n3 == n4) continue;
                targetMarkerBag.swapTargets(targetMarkerBag.getElement(n3), targetMarkerBag.getElement(n4));
            }
            return targetMarkerBag.checkTargets(Order.this.ev);
        }

        protected TextActivityPane buildPane() {
            OrderPane orderPane = new OrderPane();
            orderPane.setActions();
            return orderPane;
        }

        protected void setTargetAnchor(TargetMarker targetMarker) {
            if (this.anchor != null) {
                this.playDoc.applyStyleToTarget(this.anchor, "target", false, true);
            }
            this.anchor = targetMarker;
            if (this.anchor != null) {
                this.playDoc.applyStyleToTarget(this.anchor, "target", true, true);
            }
        }

        protected void setTargetCursor(TargetMarker targetMarker) {
            if (targetMarker != null && targetMarker == this.anchor) {
                this.cursor = targetMarker;
                return;
            }
            if (this.cursor != null && this.cursor != this.anchor) {
                this.playDoc.applyStyleToTarget(this.cursor, "target", false, true);
            }
            this.cursor = targetMarker;
            if (this.cursor != null) {
                this.playDoc.applyStyleToTarget(this.cursor, null, true, true);
            }
        }

        protected void swapTargets(TargetMarker targetMarker, TargetMarker targetMarker2) {
            if (targetMarker == targetMarker2 || !this.playing || this.playDoc == null) {
                return;
            }
            this.setTargetAnchor(null);
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            targetMarkerBag.swapTargets(targetMarker, targetMarker2);
            targetMarker.checkText(Order.this.ev);
            boolean bl = targetMarker2.checkText(Order.this.ev);
            ++this.nActions;
            if (!Order.this.hasCheckButton) {
                int n = targetMarkerBag.countSolvedTargets();
                this.ps.reportNewAction(this.getActivity(), "PLACE", targetMarker.getCurrentText(), Integer.toString(targetMarkerBag.indexOf(targetMarker2)), bl, n);
                if (bl && n == targetMarkerBag.size()) {
                    this.finishActivity(true);
                } else {
                    this.playEvent(bl ? 3 : 2);
                }
            }
            this.setTargetCursor(targetMarker2);
        }

        protected void doCheck(boolean bl) {
            int n;
            if (this.playDoc == null || this.playDoc.tmb.size() == 0) {
                return;
            }
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            if (this.bc.active) {
                this.bc.end();
            }
            for (n = 0; n < targetMarkerBag.size(); ++n) {
                TargetMarker targetMarker = targetMarkerBag.getElement(n);
                this.playDoc.applyStyleToTarget(targetMarker, targetMarker.target.targetStatus == 2 ? "target" : "targetError", false, true);
            }
            n = targetMarkerBag.countSolvedTargets();
            this.ps.setCounterValue(0, n);
            this.ps.setCounterValue(1, this.nActions);
            if (n != targetMarkerBag.size()) {
                if (bl) {
                    this.playEvent(4);
                    this.pane.requestFocus();
                }
            } else {
                this.finishActivity(true);
            }
        }

        public void finishActivity(boolean bl) {
            if (this.bc.active) {
                this.bc.end();
            }
            this.pane.setEnabled(false);
            super.finishActivity(bl);
        }

        class OrderPane
        extends TextActivityPane {
            AbstractAction forwardAction;
            AbstractAction backwardAction;
            AbstractAction nextTargetAction;
            AbstractAction prevTargetAction;
            AbstractAction insertBreakAction;
            AbstractAction insertTabAction;
            AbstractAction beginAction;
            AbstractAction endAction;
            AbstractAction upAction;
            AbstractAction downAction;

            protected OrderPane() {
                super(Panel.this);
                this.forwardAction = new AbstractAction("caret-forward"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OrderPane.this.nextTargetAction.actionPerformed(actionEvent);
                    }
                };
                this.backwardAction = new AbstractAction("caret-backward"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OrderPane.this.prevTargetAction.actionPerformed(actionEvent);
                    }
                };
                this.nextTargetAction = new AbstractAction("next-target"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(((OrderPane)OrderPane.this).Panel.this.playDoc.tmb.getNextTarget(((OrderPane)OrderPane.this).Panel.this.cursor));
                        }
                    }
                };
                this.prevTargetAction = new AbstractAction("prev-target"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(((OrderPane)OrderPane.this).Panel.this.playDoc.tmb.getPrevTarget(((OrderPane)OrderPane.this).Panel.this.cursor));
                        }
                    }
                };
                this.insertBreakAction = new AbstractAction("insert-break"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OrderPane.this.initKeyAction()) {
                            if (((OrderPane)OrderPane.this).Panel.this.anchor == null) {
                                Panel.this.setTargetAnchor(((OrderPane)OrderPane.this).Panel.this.cursor);
                            } else {
                                Panel.this.swapTargets(((OrderPane)OrderPane.this).Panel.this.anchor, ((OrderPane)OrderPane.this).Panel.this.cursor);
                            }
                        }
                    }
                };
                this.insertTabAction = new AbstractAction("insert-tab"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if ((actionEvent.getModifiers() & 1) != 0) {
                            OrderPane.this.prevTargetAction.actionPerformed(actionEvent);
                        } else {
                            OrderPane.this.nextTargetAction.actionPerformed(actionEvent);
                        }
                    }
                };
                this.beginAction = new AbstractAction("caret-begin"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(((OrderPane)OrderPane.this).Panel.this.playDoc.tmb.getElement(0));
                        }
                    }
                };
                this.endAction = new AbstractAction("caret-end"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OrderPane.this.initKeyAction()) {
                            Panel.this.setTargetCursor(((OrderPane)OrderPane.this).Panel.this.playDoc.tmb.getElement(((OrderPane)OrderPane.this).Panel.this.playDoc.tmb.size() - 1));
                        }
                    }
                };
                this.upAction = new AbstractAction("caret-up"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OrderPane.this.prevTargetAction.actionPerformed(actionEvent);
                    }
                };
                this.downAction = new AbstractAction("caret-down"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OrderPane.this.nextTargetAction.actionPerformed(actionEvent);
                    }
                };
                this.enableEvents(48L);
            }

            public boolean processMouse(MouseEvent mouseEvent) {
                if (!super.processMouse(mouseEvent) || Panel.this.bc == null || !Panel.this.playing) {
                    return false;
                }
                switch (mouseEvent.getID()) {
                    case 501: {
                        int n = this.viewToModel(mouseEvent.getPoint());
                        if (n < 0) break;
                        Panel.this.playEvent(1);
                        TargetMarker targetMarker = Panel.this.playDoc.tmb.getElementByOffset(n, false);
                        if (targetMarker != null) {
                            Panel.this.setTargetCursor(targetMarker);
                            if (((Panel)Panel.this).bc.active) {
                                Panel.this.bc.end();
                                if (Panel.this.cursor == Panel.this.anchor) {
                                    Panel.this.setTargetAnchor(null);
                                    Panel.this.setTargetCursor(targetMarker);
                                    break;
                                }
                                Panel.this.swapTargets(Panel.this.anchor, Panel.this.cursor);
                                break;
                            }
                            Panel.this.setTargetAnchor(targetMarker);
                            Panel.this.bc.begin(mouseEvent.getPoint());
                            break;
                        }
                        Panel.this.bc.end();
                        Panel.this.setTargetAnchor(null);
                        break;
                    }
                    case 503: 
                    case 506: {
                        if (!((Panel)Panel.this).bc.active) break;
                        Panel.this.bc.moveTo(mouseEvent.getPoint());
                    }
                }
                return false;
            }

            public boolean initKeyAction() {
                if (!Panel.this.playing) {
                    return false;
                }
                if (((Panel)Panel.this).bc.active) {
                    Panel.this.bc.end();
                }
                if (Panel.this.cursor == null) {
                    Panel.this.setTargetCursor(Panel.this.playDoc.tmb.getElement(0));
                    return false;
                }
                return true;
            }

            protected void setActions() {
                HashMap hashMap = Actions.getActionKeys(this);
                ActionMap actionMap = new ActionMap();
                actionMap.setParent(this.getActionMap());
                this.setActionMap(actionMap);
                Actions.mapTraceAction(this, hashMap, "beep");
                Actions.mapTraceAction(this, hashMap, "requestFocus");
                Actions.mapTraceAction(this, hashMap, "toggle-componentOrientation");
                Actions.mapAction(this, hashMap, this.insertBreakAction);
                Actions.mapAction(this, hashMap, this.insertTabAction);
                Actions.mapAction(this, hashMap, this.forwardAction);
                Actions.mapAction(this, hashMap, this.backwardAction);
                Actions.mapAction(this, hashMap, this.beginAction);
                Actions.mapAction(this, hashMap, this.endAction);
                Actions.mapAction(this, hashMap, this.upAction);
                Actions.mapAction(this, hashMap, this.downAction);
                Actions.mapAction(this, hashMap, this.nextTargetAction);
                Actions.mapAction(this, hashMap, this.prevTargetAction);
                actionMap.setParent(null);
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.insertTabAction.getValue("Name"));
            }
        }
    }
}

