/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MenuElementEditor
extends Editor {
    protected static ImageIcon icon;
    protected ImageIcon meIcon;
    protected ProjectLibrary projectLibrary;
    public static EditorAction findProjectAction;
    public static EditorAction findIconAction;
    protected static boolean actionsCreated;

    public MenuElementEditor(MenuElement menuElement) {
        super(menuElement);
    }

    protected void createChildren() {
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            this.meIcon = this.getMenuElement().getIcon(projectLibrary.mediaBag);
        }
    }

    public MenuElement getMenuElement() {
        return (MenuElement)this.getUserObject();
    }

    public MenuEditor getMenuEditorParent() {
        MenuEditor menuEditor = null;
        if (this.getParent() != null && this.getParent() instanceof MenuEditor) {
            menuEditor = (MenuEditor)this.getParent();
        }
        return menuEditor;
    }

    public Class getEditorPanelClass() {
        return MenuElementEditorPanel.class;
    }

    public ProjectLibrary getProjectLibrary() {
        if (this.projectLibrary != null) {
            return this.projectLibrary;
        }
        MenuEditor menuEditor = this.getMenuEditorParent();
        if (menuEditor != null) {
            this.projectLibrary = menuEditor.getProjectLibrary();
        }
        return this.projectLibrary;
    }

    public String toString() {
        return this.getMenuElement().caption;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new MenuElementEditorPanel(options);
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/miniclic.png");
        }
        return icon;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return bl ? MenuElementEditor.getIcon() : null;
    }

    protected boolean canClone() {
        return true;
    }

    protected Editor getClone() throws Exception {
        MenuElement menuElement = MenuElement.getMenuElement(this.getMenuElement().getJDomElement());
        MenuElementEditor menuElementEditor = (MenuElementEditor)menuElement.getEditor(null);
        menuElementEditor.projectLibrary = this.getProjectLibrary();
        menuElementEditor.meIcon = this.meIcon;
        return menuElementEditor;
    }

    public void setActionsOwner() {
        this.allowPaste = true;
        this.allowCopy = true;
        this.allowDelete = true;
        this.allowCut = true;
        super.setActionsOwner();
        if (actionsCreated) {
            findProjectAction.setActionOwner(this);
            findIconAction.setActionOwner(this);
            boolean bl = this.getMenuEditorParent() != null;
            MenuEditor.newMenuAction.setActionOwner(bl ? this : null);
            MenuEditor.newMenuElementAction.setActionOwner(bl ? this : null);
        }
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            findProjectAction.setActionOwner(null);
            findIconAction.setActionOwner(null);
            MenuEditor.newMenuAction.setActionOwner(null);
            MenuEditor.newMenuElementAction.setActionOwner(null);
        }
    }

    protected void syncParentIndex() {
        MenuEditor menuEditor = this.getMenuEditorParent();
        if (menuEditor != null) {
            menuEditor.getMenu().menuElements.remove(this.getMenuElement());
            menuEditor.getMenu().menuElements.add(menuEditor.getIndex(this), this.getMenuElement());
        }
    }

    public boolean moveUp(boolean bl) {
        boolean bl2 = super.moveUp(bl);
        if (bl2) {
            this.syncParentIndex();
        }
        return bl2;
    }

    public boolean moveDown(boolean bl) {
        boolean bl2 = super.moveDown(bl);
        if (bl2) {
            this.syncParentIndex();
        }
        return bl2;
    }

    public boolean delete(boolean bl) {
        boolean bl2 = false;
        this.getProjectLibrary();
        MenuEditor menuEditor = this.getMenuEditorParent();
        if (menuEditor != null && (bl2 = super.delete(bl))) {
            menuEditor.getMenu().menuElements.remove(this.getMenuElement());
        }
        return bl2;
    }

    public boolean canBeParentOf(Editor editor) {
        return false;
    }

    public boolean canBeSiblingOf(Editor editor) {
        return editor instanceof MenuElementEditor || editor instanceof MenuEditor;
    }

    public void findProject(Options options, Component component) {
        MenuElement menuElement = this.getMenuElement();
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            int[] nArray = new int[]{5, 4};
            String string = projectLibrary.getFileSystem().chooseFile(menuElement.projectPath, false, nArray, options, "edit_find_file", component, false);
            if (string != null) {
                menuElement.projectPath = string;
                this.fireEditorDataChanged(null);
            }
        }
    }

    public void findIcon(Options options, Component component) {
        MenuElement menuElement = this.getMenuElement();
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            String string;
            int[] nArray = new int[]{11, 8};
            String string2 = menuElement.icon;
            if (string2 != null && string2.startsWith("@")) {
                string2 = null;
            }
            if ((string = projectLibrary.getFileSystem().chooseFile(string2 == null ? menuElement.projectPath : string2, false, nArray, options, "edit_find_image", component, false)) != null) {
                ImageIcon imageIcon = null;
                try {
                    imageIcon = new ImageIcon(projectLibrary.getFileSystem().getImageFile(string));
                    if (imageIcon.getIconWidth() > 32 || imageIcon.getIconHeight() > 32) {
                        options.getMessages().showAlert(component, "menuElement_err_iconTooLarge");
                        imageIcon = null;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error reading image " + string + "\n" + exception);
                }
                if (imageIcon != null) {
                    menuElement.icon = string;
                    this.meIcon = menuElement.getIcon(projectLibrary.mediaBag);
                    this.fireEditorDataChanged(null);
                }
            }
        }
    }

    public static void createActions(Options options) {
        MenuElementEditor.createBasicActions(options);
        if (!actionsCreated) {
            findProjectAction = new EditorAction("edit_find_file", "icons/file_open.gif", "edit_find_file", options){

                protected void doAction(Editor editor) {
                    if (editor instanceof MenuElementEditor) {
                        ((MenuElementEditor)editor).findProject(this.options, this.getComponentSrc());
                    }
                }
            };
            findIconAction = new EditorAction("edit_find_image", "icons/file_open.gif", "edit_find_image", options){

                protected void doAction(Editor editor) {
                    if (editor instanceof MenuElementEditor) {
                        ((MenuElementEditor)editor).findIcon(this.options, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    static {
        actionsCreated = false;
    }
}

