/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MenuEditorPanel
extends EditorPanel {
    private JTextField captionText;
    private JPanel mainPanel;

    public MenuEditorPanel(Options options) {
        super(options);
        MenuEditor.createActions(options);
        this.initComponents();
        this.postInit(250, true, true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.captionText = new JTextField();
        this.captionText.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        jLabel.setLabelFor(this.captionText);
        jLabel.setText(this.options.getMsg("edit_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.captionText.setToolTipText(this.options.getMsg("menu_dlg_name_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.captionText, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof MenuEditor;
    }

    protected MenuEditor getMenuEditor() {
        return (MenuEditor)this.editor;
    }

    protected Menu getMenu() {
        if (this.editor == null) {
            return null;
        }
        return this.getMenuEditor().getMenu();
    }

    public void fillData() {
        Menu menu = this.getMenu();
        this.captionText.setText(menu == null ? "" : menu.description);
    }

    public void saveData() {
        Menu menu = this.getMenu();
        if (menu != null) {
            this.getMenuEditor().setDescription(this.captionText.getText());
        }
    }

    protected Icon getIcon() {
        return MenuEditor.getIcon();
    }

    protected String getTitle() {
        return this.options.getMsg("menu_dlg_title");
    }

    protected void addActionsTo(Container container) {
        container.add(new SmallButton(MenuEditor.newMenuElementAction));
        container.add(new SmallButton(MenuEditor.newMenuAction));
        container.add(new SmallButton(Editor.moveUpAction));
        container.add(new SmallButton(Editor.moveDownAction));
        container.add(new SmallButton(Editor.copyAction));
        container.add(new SmallButton(Editor.cutAction));
        container.add(new SmallButton(Editor.pasteAction));
        container.add(new SmallButton(Editor.deleteAction));
    }
}

