/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayerSettingsDlg;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Domable;
import edu.xtec.util.Encryption;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public class PlayerSettings
implements Cloneable,
Constants,
Domable {
    public ResourceBridge rb;
    public LibraryManager libraryManager;
    public String language;
    public String country;
    public String variant;
    public String reporterClass;
    public String reporterParams;
    public boolean reporterEnabled;
    public boolean soundEnabled;
    public boolean systemSounds;
    public String lookAndFeel;
    public String skin;
    public HashMap misc;
    public String rootPath;
    public String mediaSystem;
    public FileSystem fileSystem;
    public static int MAX_RECENT = 8;
    public String[] recentFiles;
    public String preferredBrowser;
    protected String password;
    protected boolean passwordConfirmed;
    public String cfgFile;
    public boolean readOnly;
    protected static String defaultCfgFile = null;
    public static final String PROJECTS_PATH = "projects";
    public static final String CFG_FILE = "jclic.cfg";
    public static final String DEFAULT_SKIN = "@default.xml";
    public static final String DEFAULT_REPORTER = "TCPReporter";
    public static final String DEFAULT_REPORTER_PARAMS = "path=localhost:9000";
    public static final String ELEMENT_NAME = "JClicSettings";
    public static final String REPORTER = "reporter";
    public static final String CLASS = "class";
    public static final String PARAMS = "params";
    public static final String SOUND = "sound";
    public static final String SYSTEM = "system";
    public static final String MISC = "misc";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String ROOT = "root";
    public static final String RECENT_FILES = "recentFiles";
    public static final String FILE = "file";
    public static final String PASSWORD = "password";

    public PlayerSettings(ResourceBridge resourceBridge, String string) {
        File file;
        this.rb = resourceBridge;
        this.password = null;
        this.misc = new HashMap();
        this.reporterEnabled = false;
        this.reporterClass = DEFAULT_REPORTER;
        this.reporterParams = DEFAULT_REPORTER_PARAMS;
        this.soundEnabled = true;
        this.systemSounds = true;
        this.lookAndFeel = "default";
        this.preferredBrowser = "";
        this.skin = DEFAULT_SKIN;
        this.recentFiles = new String[MAX_RECENT];
        this.mediaSystem = "default";
        this.readOnly = false;
        this.rootPath = System.getProperty("user.home");
        this.cfgFile = string == null ? PlayerSettings.getDefaultCfgFile(resourceBridge.getOptions()) : string;
        this.fileSystem = new FileSystem(resourceBridge);
        this.readOnly = FileSystem.isStrUrl(this.cfgFile) ? true : !(file = new File(this.cfgFile)).canWrite();
        this.libraryManager = new LibraryManager(this);
        this.passwordConfirmed = false;
    }

    public static String getDefaultCfgFile(Options options) {
        if (defaultCfgFile == null) {
            defaultCfgFile = PersistentSettings.getFilePath("JClic", CFG_FILE, options);
        }
        return defaultCfgFile;
    }

    public static PlayerSettings loadPlayerSettings(ResourceBridge resourceBridge) {
        PlayerSettings playerSettings = null;
        String string = resourceBridge.getOptions().getString(ELEMENT_NAME);
        if (string != null) {
            try {
                playerSettings = new PlayerSettings(resourceBridge, string);
                playerSettings.loadSettings(playerSettings.fileSystem.getXMLDocument(string).getRootElement());
            }
            catch (Exception exception) {
                playerSettings = null;
                System.err.println("Unable to read settings from " + string + "\n" + exception);
            }
        }
        if (playerSettings == null) {
            string = PlayerSettings.getDefaultCfgFile(resourceBridge.getOptions());
            playerSettings = new PlayerSettings(resourceBridge, string);
            try {
                playerSettings.loadSettings(playerSettings.fileSystem.getXMLDocument(string).getRootElement());
            }
            catch (Exception exception) {
                playerSettings.initNewSettings();
            }
        }
        resourceBridge.getOptions().syncProperties(playerSettings.getProperties(), true);
        if (!resourceBridge.getOptions().getBoolean("languageByParam") && playerSettings.language != null) {
            resourceBridge.getOptions().put("language", playerSettings.language);
            if (playerSettings.country != null) {
                resourceBridge.getOptions().put("country", playerSettings.country);
            }
            if (playerSettings.variant != null) {
                resourceBridge.getOptions().put("variant", playerSettings.variant);
            }
        }
        return playerSettings;
    }

    private void initNewSettings() {
        try {
            Messages messages = this.rb.getOptions().getMessages();
            if (this.language == null) {
                this.language = messages.getLocale().getLanguage();
                this.country = messages.getLocale().getCountry();
                this.variant = messages.getLocale().getVariant();
            }
            this.readOnly = false;
            File file = new File(new File(this.cfgFile).getParentFile(), PROJECTS_PATH);
            file.mkdirs();
            this.rootPath = file.getAbsolutePath();
            this.fileSystem = new FileSystem(this.rootPath, this.rb);
        }
        catch (Exception exception) {
            System.err.println("Unable to create new settings!\n" + exception);
        }
    }

    public void checkLibrary() {
        if (!this.readOnly && this.libraryManager.isEmpty() && this.rootPath != null && !FileSystem.isStrUrl(this.rootPath)) {
            File file = new File(new File(this.rootPath), "library.jclic");
            try {
                this.libraryManager.addNewLibrary(file.getAbsolutePath(), null);
                this.save();
            }
            catch (Exception exception) {
                System.err.println("Unable to create new project library!\n" + exception);
            }
        }
    }

    public void save() {
        if (!this.readOnly) {
            try {
                FileOutputStream fileOutputStream = this.fileSystem.createSecureFileOutputStream(this.cfgFile);
                JDomUtility.saveDocument((OutputStream)fileOutputStream, this.getJDomElement());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("unable to save settings " + this.cfgFile);
                exception.printStackTrace();
            }
        }
    }

    public Element getJDomElement() {
        Element element;
        Element element2 = new Element(ELEMENT_NAME);
        element2.addContent(this.libraryManager.getJDomElement());
        if (this.password != null) {
            element2.setAttribute(PASSWORD, Encryption.Encrypt(this.password));
        }
        if (this.language != null) {
            element = new Element("language");
            element.setAttribute("id", this.language);
            if (this.country != null) {
                element.setAttribute("country", this.country);
            }
            if (this.variant != null) {
                element.setAttribute("variant", this.variant);
            }
            element2.addContent(element);
        }
        element = new Element(PATHS);
        Element element3 = new Element(PATH);
        element3.setAttribute("id", ROOT);
        element3.setAttribute(PATH, this.rootPath);
        element.addContent(element3);
        element2.addContent(element);
        element = new Element(REPORTER);
        element.setAttribute("enabled", JDomUtility.boolString(this.reporterEnabled));
        element.setAttribute(CLASS, this.reporterClass);
        element.setAttribute(PARAMS, this.reporterParams);
        element2.addContent(element);
        element = new Element(SOUND);
        element.setAttribute("enabled", JDomUtility.boolString(this.soundEnabled));
        element.setAttribute(SYSTEM, JDomUtility.boolString(this.systemSounds));
        element.setAttribute("mediaSystem", this.mediaSystem);
        element2.addContent(element);
        element = new Element("lookAndFeel");
        element.setAttribute("id", this.lookAndFeel);
        element2.addContent(element);
        element = new Element("browser");
        element.setAttribute("id", this.preferredBrowser);
        element2.addContent(element);
        element = new Element("skin");
        element.setAttribute("id", this.skin);
        element2.addContent(element);
        if (!this.misc.isEmpty()) {
            element = new Element(MISC);
            Iterator iterator = this.misc.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string == null || v == null || !(v instanceof String)) continue;
                element.setAttribute(string, (String)v);
            }
            element2.addContent(element);
        }
        element = new Element(RECENT_FILES);
        for (int i = 0; i < MAX_RECENT; ++i) {
            if (this.recentFiles[i] == null) continue;
            element3 = new Element(FILE);
            element3.setAttribute(PATH, this.recentFiles[i]);
            element.addContent(element3);
        }
        element2.addContent(element);
        return element2;
    }

    public void loadSettings(Element element) throws Exception {
        this.setProperties(element, null);
    }

    public void setProperties(Element element, Object object) throws Exception {
        Object object2;
        Iterator iterator;
        Element element2;
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.password = JDomUtility.getStringAttr(element, PASSWORD, this.password, false);
        if (this.password != null) {
            this.password = Encryption.Decrypt(this.password);
        }
        if ((element2 = element.getChild("libraryManager")) != null) {
            this.libraryManager = LibraryManager.getLibraryManager(this, element2);
        }
        if ((element2 = element.getChild(PATHS)) != null) {
            iterator = null;
            object2 = element2.getChildren(PATH).iterator();
            while (object2.hasNext()) {
                Element element3 = (Element)object2.next();
                if (!ROOT.equals(element3.getAttributeValue("id"))) continue;
                iterator = JDomUtility.getStringAttr(element3, PATH, this.rootPath, false);
            }
            if (iterator != null) {
                this.rootPath = iterator;
                if (!FileSystem.isStrUrl(this.rootPath)) {
                    this.fileSystem = new FileSystem(this.rootPath, this.rb);
                }
            }
        }
        if ((element2 = element.getChild("language")) != null) {
            this.language = JDomUtility.getStringAttr(element2, "id", this.language, false);
            this.country = JDomUtility.getStringAttr(element2, "country", this.country, false);
            this.variant = JDomUtility.getStringAttr(element2, "variant", this.variant, false);
        }
        if ((element2 = element.getChild(REPORTER)) != null) {
            this.reporterEnabled = JDomUtility.getBoolAttr(element2, "enabled", this.reporterEnabled);
            this.reporterClass = JDomUtility.getStringAttr(element2, CLASS, this.reporterClass, false);
            this.reporterParams = JDomUtility.getStringAttr(element2, PARAMS, this.reporterParams, false);
        }
        if ((element2 = element.getChild(SOUND)) != null) {
            this.soundEnabled = JDomUtility.getBoolAttr(element2, "enabled", this.soundEnabled);
            this.systemSounds = JDomUtility.getBoolAttr(element2, SYSTEM, this.systemSounds);
            this.mediaSystem = JDomUtility.getStringAttr(element2, "mediaSystem", this.mediaSystem, false);
        }
        if ((element2 = element.getChild("lookAndFeel")) != null) {
            this.lookAndFeel = JDomUtility.getStringAttr(element2, "id", this.lookAndFeel, false);
        }
        if ((element2 = element.getChild("browser")) != null) {
            this.preferredBrowser = JDomUtility.getStringAttr(element2, "id", this.preferredBrowser, false);
            BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
        }
        if ((element2 = element.getChild("skin")) != null) {
            this.skin = JDomUtility.getStringAttr(element2, "id", this.skin, false);
        }
        if ((element2 = element.getChild(MISC)) != null) {
            iterator = element2.getAttributes().iterator();
            while (iterator.hasNext()) {
                object2 = (Attribute)iterator.next();
                this.misc.put(((Attribute)object2).getName(), ((Attribute)object2).getValue());
            }
        }
        if ((element2 = element.getChild(RECENT_FILES)) != null) {
            iterator = element2.getChildren(FILE).iterator();
            for (int i = 0; i < MAX_RECENT; ++i) {
                this.recentFiles[i] = iterator.hasNext() ? JDomUtility.getStringAttr((Element)iterator.next(), PATH, null, false) : null;
            }
        }
    }

    public Messages getMessages() {
        return this.rb.getOptions().getMessages();
    }

    public HashMap getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "true";
        String string2 = "false";
        if (this.language != null) {
            hashMap.put("language", this.language);
            hashMap.put("country", this.country);
            hashMap.put("variant", this.variant);
        }
        if (this.reporterEnabled) {
            hashMap.put(REPORTER, this.reporterClass);
            hashMap.put("reporterParams", this.reporterParams);
        }
        hashMap.put("systemSounds", this.systemSounds ? string : string2);
        hashMap.put("audioEnabled", this.soundEnabled ? string : string2);
        hashMap.put("lookAndFeel", this.lookAndFeel);
        hashMap.put("browser", this.preferredBrowser);
        hashMap.put("mediaSystem", this.mediaSystem);
        hashMap.put("skin", this.skin);
        hashMap.putAll(this.misc);
        return hashMap;
    }

    public boolean edit(Component component) {
        boolean bl = false;
        if (this.promptPassword(component, null)) {
            PlayerSettingsDlg playerSettingsDlg = new PlayerSettingsDlg(this, component);
            playerSettingsDlg.setVisible(true);
            bl = playerSettingsDlg.result;
            if (bl) {
                BrowserLauncher.setPreferredBrowser(this.preferredBrowser);
            }
        }
        return bl;
    }

    public boolean promptPassword(Component component, String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = this.passwordConfirmed || this.password == null || this.password.length() == 0;
        while (!bl) {
            String string;
            if (stringArray == null) {
                stringArray = new String[]{"settings_passwordRequired"};
            }
            if ((string = this.getMessages().showInputDlg(component, stringArray, null, null, null, true)) == null) break;
            bl = this.password.equals(string);
            if (!bl) {
                this.getMessages().showAlert(component, "PASSWORD_INCORRECT");
                continue;
            }
            this.passwordConfirmed = true;
        }
        return bl;
    }

    public void addRecentFile(String string) {
        if (string != null) {
            String[] stringArray = this.recentFiles;
            this.recentFiles = new String[MAX_RECENT];
            this.recentFiles[0] = string.trim();
            int n = 1;
            for (int i = 0; i < MAX_RECENT && n < MAX_RECENT; ++i) {
                if (stringArray[i] == null || stringArray[i].equals(string)) continue;
                this.recentFiles[n++] = stringArray[i];
            }
        }
    }
}

