/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Player;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.JumpInfo;
import java.awt.Component;
import java.util.Stack;

public class PlayerHistory {
    protected Player player;
    protected Stack sequenceStack;
    protected boolean testMode;

    public PlayerHistory(Player player) {
        this.player = player;
        this.sequenceStack = new Stack();
    }

    public int storedElementsCount() {
        return this.sequenceStack.size();
    }

    public void clearHistory() {
        this.sequenceStack.clear();
    }

    public void push() {
        ActivitySequence activitySequence;
        int n;
        if (this.player.project != null && this.player.project.getFullPath() != null && (n = (activitySequence = this.player.project.activitySequence).getCurrentActNum()) >= 0) {
            if (!this.sequenceStack.isEmpty()) {
                HistoryElement historyElement = (HistoryElement)this.sequenceStack.peek();
                if (historyElement.projectPath.equals(this.player.project.getFullPath()) && historyElement.activity == n) {
                    return;
                }
            }
            this.sequenceStack.push(new HistoryElement(this.player.project.getFullPath(), activitySequence.getSequenceForElement(n), n));
        }
    }

    public boolean pop() {
        if (!this.sequenceStack.isEmpty()) {
            HistoryElement historyElement = (HistoryElement)this.sequenceStack.pop();
            if (historyElement.projectPath.equals(this.player.project.getFullPath())) {
                this.player.load(null, Integer.toString(historyElement.activity), null, null);
            } else if (this.testMode && historyElement.projectPath != null && historyElement.projectPath.length() > 0) {
                this.player.getMessages().showAlert((Component)this.player, new String[]{this.player.getMsg("test_alert_jump_to"), historyElement.projectPath});
            } else {
                this.player.load(historyElement.projectPath, Integer.toString(historyElement.activity), null, null);
            }
        }
        return true;
    }

    public boolean processJump(JumpInfo jumpInfo, boolean bl) {
        boolean bl2 = false;
        if (jumpInfo != null && this.player.project != null) {
            switch (jumpInfo.action) {
                case 1: {
                    break;
                }
                case 2: {
                    bl2 = this.pop();
                    break;
                }
                case 3: {
                    if (this.testMode) {
                        this.player.getMessages().showAlert((Component)this.player, "test_alert_exit");
                        break;
                    }
                    this.player.exit(jumpInfo.sequence);
                    break;
                }
                case 0: {
                    if (jumpInfo.sequence == null && jumpInfo.projectPath == null) {
                        ActivitySequenceElement activitySequenceElement = this.player.project.activitySequence.getElement(jumpInfo.actNum, true);
                        if (activitySequenceElement == null) break;
                        if (bl) {
                            this.push();
                        }
                        this.player.load(null, null, activitySequenceElement.getActivityName(), null);
                        bl2 = true;
                        break;
                    }
                    if (this.testMode && jumpInfo.projectPath != null && jumpInfo.projectPath.length() > 0) {
                        this.player.getMessages().showAlert((Component)this.player, new String[]{this.player.getMsg("test_alert_jump_to"), jumpInfo.projectPath});
                        break;
                    }
                    bl2 = this.jumpToSequence(jumpInfo.sequence, jumpInfo.projectPath, bl);
                }
            }
        }
        return bl2;
    }

    private boolean jumpToSequence(String string, String string2, boolean bl) {
        if (string == null && string2 == null) {
            return false;
        }
        if (string2 == null) {
            string2 = this.player.project.getFullPath();
        }
        if (!this.sequenceStack.isEmpty()) {
            HistoryElement historyElement = (HistoryElement)this.sequenceStack.peek();
            if (string2.equals(historyElement.projectPath)) {
                boolean bl2 = string.equals(historyElement.sequence);
                if (string2.equals(this.player.project.getFullPath())) {
                    ActivitySequenceElement activitySequenceElement = this.player.project.activitySequence.getElement(historyElement.activity, false);
                    boolean bl3 = bl2 = activitySequenceElement != null && string.equals(activitySequenceElement.getTag());
                }
                if (bl2) {
                    return this.pop();
                }
            }
        }
        if (bl) {
            this.push();
        }
        if (string2.equals(this.player.project.getFullPath())) {
            this.player.load(null, string, null, null);
        } else {
            this.player.load(string2, string, null, null);
        }
        return true;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean bl) {
        this.testMode = bl;
    }

    protected class HistoryElement {
        String projectPath;
        String sequence;
        int activity;

        HistoryElement(String string, String string2, int n) {
            this.projectPath = string;
            this.sequence = string2;
            this.activity = n;
        }
    }
}

