/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBox;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class HelpActivityComponent
extends JPanel
implements ListSelectionListener {
    public static final String PREFERRED_LOCATION = "prefLoc";
    public Activity.Panel ap;
    public AbstractBox markedBox;
    public boolean markedBoxWasVisible;

    public HelpActivityComponent(Activity.Panel panel) {
        this.ap = panel;
        this.markedBox = null;
        this.enableEvents(16L);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.putClientProperty(PREFERRED_LOCATION, new Point(this.ap.getLocationOnScreen()));
    }

    public void init() {
    }

    public void end() {
        this.unmarkBox();
    }

    public abstract void render(Graphics2D var1, Rectangle var2);

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        super.paintComponent(graphics2D);
        this.render(graphics2D, graphics2D.getClipBounds());
        graphics2D.setRenderingHints(renderingHints);
    }

    public void unmarkBox() {
        this.ap.ps.stopMedia(1);
        if (this.markedBox != null) {
            this.markedBox.setMarked(!this.markedBox.isMarked());
            this.markedBox.setInverted(!this.markedBox.isInverted());
            this.markedBox.setVisible(this.markedBoxWasVisible);
            this.markedBox = null;
        }
    }

    public void markBox(AbstractBox abstractBox, boolean bl) {
        this.unmarkBox();
        this.markedBox = abstractBox;
        if (abstractBox != null) {
            this.markedBoxWasVisible = abstractBox.isVisible();
            if (bl && abstractBox instanceof ActiveBox) {
                ((ActiveBox)abstractBox).playMedia(this.ap.ps);
            }
            abstractBox.setMarked(!abstractBox.isMarked());
            abstractBox.setInverted(!abstractBox.isInverted());
            abstractBox.setVisible(true);
        }
    }

    public void processMouse(MouseEvent mouseEvent) {
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            this.processMouse((MouseEvent)aWTEvent);
        }
        super.processEvent(aWTEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void doLayout() {
    }
}

