<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1" indent="yes"/>
		
		<xsl:template name="EscribeInmueble">
			<!-- Campos padre -->
			<DATO>
				<INMATRENTAS>
					<xsl:for-each select="current()/parent::*">
						<xsl:for-each select="current()/child::*">
							<xsl:choose>
								<xsl:when test="name() != 'INMATRENTAS'">
									<xsl:copy-of select="."></xsl:copy-of>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>	
					</xsl:for-each>
					<!-- Campos tabla hija -->
					<xsl:for-each select="current()/*">
						<xsl:copy-of select="."></xsl:copy-of>	
					</xsl:for-each>
				</INMATRENTAS>
			</DATO>
		</xsl:template>
		
		<!-- JUAN : La tabla de inmuebles de la pag 8 tiene campos comunes a los
			registros INMARENTAS como el nif etc... para hacer la impresion he de pasar
			del XML :
				../FREATRENTAS/DATO/NIF y cada inmueble es
				../FREATRENTAS/DATO/INMATRENTAS/VARPC 
			Al formato :
				../FREATRENTAS/DATO/INMATRENTAS/NIF y cada inmueble es
				../FREATRENTAS/DATO/INMATRENTAS/VARPC
			Asi podemos imprimir el grupo bien
			El problema es q la impresión no recorre 2 tablas anidadas y con la trasformacion
			la desanidamos repitiendo los campos de la tabla padre.
		 -->
		<xsl:template match="/DECLARACIONES/IRPF2013/FREATRENTAS/DATO">
			<xsl:choose>
				<!-- Si hay inmuebles se tratan -->
				<xsl:when test="count(current()/INMATRENTAS) > 0">
					<xsl:for-each select="current()/INMATRENTAS">
						<xsl:call-template name="EscribeInmueble"/>
					</xsl:for-each>					
				</xsl:when>
				<!-- Sino tal cual -->
				<xsl:otherwise>
					<DATO>
						<INMATRENTAS>
							<xsl:for-each select="current()/*">
								<xsl:copy-of select="."></xsl:copy-of>	
							</xsl:for-each>
						</INMATRENTAS>
					</DATO>					
				</xsl:otherwise>
			</xsl:choose>						
		</xsl:template>
	
		<!-- Todos los que tengan true se pasan a X y los false a blanco -->
		<xsl:template match="node()">
			<xsl:choose>
				<xsl:when test="text() = 'true'">
					<xsl:element name="{name()}">X</xsl:element>
				</xsl:when>
				<xsl:when test="text() = 'false'">
					<xsl:element name="{name()}"></xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="count(child::*) = 0">
							<xsl:copy-of select="."></xsl:copy-of>	
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy>
								<xsl:apply-templates select="child::*" />
							</xsl:copy>
						</xsl:otherwise>
					</xsl:choose>					
				</xsl:otherwise>
			</xsl:choose>
		</xsl:template>
											
</xsl:stylesheet>