/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem.xml;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.IPersistencia;
import es.aeat.pftw.mtrc.origenDatos.mem.OrigenDatosMem;
import es.aeat.pftw.mtrc.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.origenDatos.mem.TipoHijoTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoPersistencia;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Persistencia
implements IPersistencia,
Serializable {
    private static final long serialVersionUID = 1L;

    public void init(Object[] parametros) throws ExceptionMotor {
    }

    public void dispose() throws ExceptionMotor {
    }

    public boolean establece(IOrigenDatos objAPersistir, IOrigenDatos io, Object datos) throws ExceptionMotor {
        try {
            OrigenDatosMem objMem = (OrigenDatosMem)objAPersistir;
            objMem.setRaiz(null);
            Document doc = (Document)datos;
            if (doc != null && !this.generaArbol(doc.getChildNodes(), objMem.getRaiz(), io, objMem)) {
                objMem.setRaiz((Tabla)FuncionesUtiles.getFuncionesUtiles().getInstancia(Tabla.class, new Object[]{FuncionesUtiles.getFuncionesUtiles().dameNombreTablaRaiz(io.getGestorConfiguracion()), io}));
                throw new ExceptionMotor("No se pudo volcar XML sobre estructura");
            }
            doc = null;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean generaArbol(NodeList listaNodos, Tabla nActual, IOrigenDatos io, OrigenDatosMem objMem) throws ExceptionMotor {
        try {
            boolean ret = true;
            String elemento = null;
            Tabla paraAtributosTabla = null;
            for (int i = 0; i < listaNodos.getLength(); ++i) {
                elemento = this.sacaTabla(listaNodos.item(i), io);
                if (elemento != null) {
                    if (nActual == null) {
                        paraAtributosTabla = nActual = (Tabla)FuncionesUtiles.getFuncionesUtiles().getInstancia(Tabla.class, new Object[]{elemento, io});
                        objMem.setRaiz(nActual);
                        ret &= this.generaArbol(listaNodos.item(i).getChildNodes(), nActual, io, objMem);
                    } else {
                        long pos = nActual.addTablaHija(elemento);
                        paraAtributosTabla = nActual.getTablaHija(elemento, pos);
                        ret &= this.generaArbol(listaNodos.item(i).getChildNodes(), nActual.getTablaHija(elemento, pos), io, objMem);
                    }
                    List<ITipoDatosCampoValor> attrs = null;
                    attrs = this.dameListaAtributos(listaNodos.item(i).getAttributes());
                    for (int j = 0; j < attrs.size(); ++j) {
                        if (this.esCampo(attrs.get(j).getNombreCampo(), io)) {
                            paraAtributosTabla.establecerPartida(attrs.get(j).getNombreCampo(), attrs.get(j).getValor());
                            continue;
                        }
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso("Atributo (" + attrs.get(j) + ") de Tabla " + elemento + " no esperado, \u00bfposible error?");
                    }
                    elemento = null;
                } else {
                    elemento = listaNodos.item(i).getNodeName().toUpperCase();
                }
                if (elemento == null) continue;
                TipoDatosCampoPersistencia prop = null;
                prop = this.getCampo(listaNodos.item(i), io);
                if (prop.getNombreCampo().length() > 0) {
                    boolean retorno = false;
                    try {
                        retorno = nActual.establecerPartida(prop.getNombreCampo(), prop.getValor());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (retorno) {
                        for (int j = 0; j < prop.getAtributos().size(); ++j) {
                            if (((ITipoDatosCampoValor)prop.getAtributos().get(j)).getNombreCampo().equalsIgnoreCase("ESTADO")) {
                                nActual.establecerEstado(prop.getNombreCampo(), Integer.valueOf(((ITipoDatosCampoValor)prop.getAtributos().get(j)).getValor()));
                                continue;
                            }
                            FuncionesUtiles.getFuncionesUtiles().muestraAviso("Atributo (" + ((ITipoDatosCampoValor)prop.getAtributos().get(j)).getNombreCampo() + ") de entrada " + prop.getNombreCampo() + " no esperado, \u00bfposible error?");
                        }
                        continue;
                    }
                    FuncionesUtiles.getFuncionesUtiles().muestraError("Error al establecer Partida (" + elemento + "), \u00bfposible error?");
                    continue;
                }
                if (listaNodos.item(i).getChildNodes().getLength() > 0) {
                    ret &= this.generaArbol(listaNodos.item(i).getChildNodes(), nActual, io, objMem);
                    continue;
                }
                FuncionesUtiles.getFuncionesUtiles().muestraAviso(elemento + " en XML no es ni tabla ni campo, \u00bfposible error?");
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String sacaTabla(Node nodo, IOrigenDatos io) throws ExceptionMotor {
        try {
            String valor = nodo.getNodeName().toUpperCase();
            if (io.getGestorConfiguracion().getTabla(valor) != null) {
                return valor;
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean esCampo(String valor, IOrigenDatos io) throws ExceptionMotor {
        try {
            return io.getGestorConfiguracion().getEntrada(valor.toUpperCase()) != null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected TipoDatosCampoPersistencia getCampo(Node nodo, IOrigenDatos io) throws ExceptionMotor {
        try {
            String entrada = nodo.getNodeName().toUpperCase();
            TipoDatosCampoPersistencia dato = new TipoDatosCampoPersistencia();
            if (io.getGestorConfiguracion().getEntrada(entrada) == null) {
                return new TipoDatosCampoPersistencia();
            }
            String valor = nodo.getNodeValue();
            if (valor == null) {
                try {
                    valor = nodo.getChildNodes().item(0).getNodeValue();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            dato.setNombreCampo(nodo.getNodeName().toUpperCase());
            if (valor == null) {
                dato.setValor(io.getGestorConfiguracion().getEntrada(entrada).getValorInicial());
            } else {
                dato.setValor(valor);
            }
            dato.setAtributos(this.dameListaAtributos(nodo.getAttributes()));
            return dato;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected List<ITipoDatosCampoValor> dameListaAtributos(NamedNodeMap attrs) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> dato = new ArrayList<ITipoDatosCampoValor>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                dato.add((ITipoDatosCampoValor)new TipoDatosCampoValor(attrs.item(i).getNodeName(), attrs.item(i).getNodeValue()));
            }
            return dato;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Object obtener(ISesion sesion) throws ExceptionMotor {
        try {
            IGestorConfiguracion gc = sesion.getModelo().getGestorConfiguracion();
            OrigenDatosMem mem = (OrigenDatosMem)sesion.getOrigenDeDatos();
            Document doc = this.dameXMLVacioParaMotor(FuncionesUtiles.getFuncionesUtiles().dameNombreTablaRaiz(gc));
            doc.replaceChild(this.creaNodo(gc, mem, doc, mem.getRaiz(), doc.getFirstChild()), doc.getFirstChild());
            return doc;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean iguales(String valor1, String valor2, String tipo) {
        try {
            if (tipo.equalsIgnoreCase("DOBLE") || tipo.equalsIgnoreCase("BIGDECIMAL")) {
                if (valor1.trim().length() == 0) {
                    valor1 = "0";
                }
                if (valor2.trim().length() == 0) {
                    valor2 = "0";
                }
                return Double.parseDouble(valor1) == Double.parseDouble(valor2);
            }
            return valor1.equalsIgnoreCase(valor2);
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
            return valor1.equalsIgnoreCase(valor2);
        }
    }

    protected Node creaNodo(IGestorConfiguracion gc, OrigenDatosMem mem, Document doc, Tabla tab, Node nodoPadre) throws ExceptionMotor {
        try {
            Element nodo = doc.createElement(tab.getTabla());
            IRegEntrada ent = null;
            Set<String> s = tab.getRegistro().keySet();
            ITablaMotorEntrada tme = null;
            Node hijo = null;
            String campo = "";
            Iterator<String> it = s.iterator();
            while (it.hasNext()) {
                campo = it.next().toString();
                tme = tab.getRegistro().get(campo);
                campo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(campo);
                if (campo.equalsIgnoreCase("ID") || campo.equalsIgnoreCase("IDINF") || this.iguales((ent = gc.getEntrada(campo)).getValorInicial(), tme.getValor().toString(), ent.getTipoDato()) && ent.getEstadoInicial() == Integer.parseInt(tme.getEstado().toString())) continue;
                hijo = doc.createElement(campo);
                if (ent.getEstadoInicial() != Integer.parseInt(tme.getEstado().toString())) {
                    ((Element)hijo).setAttribute("ESTADO", tme.getEstado().toString());
                }
                hijo.appendChild(doc.createTextNode(tme.getValor().toString()));
                nodo.appendChild(hijo);
                hijo = null;
            }
            Map<String, TipoHijoTabla> tablasRelacionadas = tab.getTablasHijas();
            for (String tabNom : tablasRelacionadas.keySet()) {
                for (int j = 0; j < tablasRelacionadas.get(tabNom).getRecordCount(); ++j) {
                    hijo = this.creaNodo(gc, mem, doc, tablasRelacionadas.get(tabNom).getItem(j), nodo);
                    nodo.appendChild(hijo);
                    hijo = null;
                }
            }
            return nodo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Document dameXMLVacioParaMotor(String nodoRaiz) throws ExceptionMotor {
        try {
            String str = "ISO-8859-1";
            String sDatos = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><" + nodoRaiz + "></" + nodoRaiz + ">";
            InputSource iso = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(sDatos.getBytes(str)), Charset.forName(str)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(iso);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

