/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem.transacciones.clonado;

import es.aeat.pftw.mtrc.origenDatos.mem.OrigenDatosMem;
import es.aeat.pftw.mtrc.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.IGestorTransacciones;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GestorTransaccionesClonado
implements IGestorTransacciones,
Serializable {
    private static final long serialVersionUID = 1L;
    private int contadorTransacciones = 0;
    private List<Tabla> clonedRaiz = new ArrayList<Tabla>();
    private OrigenDatosMem origenDatos = null;

    public void dispose() throws ExceptionMotor {
        this.clonedRaiz = null;
        this.origenDatos = null;
    }

    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.origenDatos = (OrigenDatosMem)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected OrigenDatosMem getOrigenDatos() {
        return this.origenDatos;
    }

    @Override
    public boolean addEventoInicioTransaccion() throws ExceptionMotor {
        try {
            if (this.getOrigenDatos().getRaiz() == null) {
                return false;
            }
            this.clonedRaiz.add(this.getOrigenDatos().getRaiz().clone());
            if (this.clonedRaiz.size() == 0) {
                throw new ExceptionMotor("No se pudo clonar el Raiz!!!");
            }
            ++this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoCommitTransaccion() throws ExceptionMotor {
        try {
            if (this.contadorTransacciones == 0) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.clonedRaiz.remove(this.clonedRaiz.size() - 1);
            --this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoRollBackTransaccion() throws ExceptionMotor {
        try {
            if (this.contadorTransacciones == 0) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.getOrigenDatos().setRaiz(this.clonedRaiz.get(this.clonedRaiz.size() - 1));
            this.clonedRaiz.remove(this.clonedRaiz.size() - 1);
            --this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoValueChanged(ITablaMotor tab, ITablaMotorEntrada partida) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoAddedRecord(ITablaMotor tab, long id) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoDeletedRecord(ITablaMotor tab) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean enTransaccion() {
        return this.contadorTransacciones > 0;
    }
}

