/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem.transacciones.bitacora;

import es.aeat.pftw.mtrc.origenDatos.mem.OrigenDatosMem;
import es.aeat.pftw.mtrc.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.IGestorTransacciones;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.bitacora.TipoEventoTransaccion;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GestorTransaccionesBitacora
implements IGestorTransacciones,
Serializable {
    private static final long serialVersionUID = 1L;
    private int contadorTransacciones = 0;
    protected List<TipoEventoTransaccion> cuadernoBitacora = null;
    private OrigenDatosMem origenDatos = null;

    public void dispose() throws ExceptionMotor {
        this.cuadernoBitacora = null;
        this.origenDatos = null;
    }

    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.cuadernoBitacora = new ArrayList<TipoEventoTransaccion>();
            this.origenDatos = (OrigenDatosMem)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setCuadernoBitacora(List<TipoEventoTransaccion> cuadernoBitacora) {
        this.cuadernoBitacora = cuadernoBitacora;
    }

    protected List<TipoEventoTransaccion> getCuadernoBitacora() {
        return this.cuadernoBitacora;
    }

    protected OrigenDatosMem getOrigenDatos() {
        return this.origenDatos;
    }

    @Override
    public boolean addEventoInicioTransaccion() throws ExceptionMotor {
        try {
            ++this.contadorTransacciones;
            this.cuadernoBitacora.add(new TipoEventoTransaccion(1, this.contadorTransacciones));
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoCommitTransaccion() throws ExceptionMotor {
        try {
            if (this.contadorTransacciones == 0) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.cuadernoBitacora.add(new TipoEventoTransaccion(2, this.contadorTransacciones));
            --this.contadorTransacciones;
            if (!this.enTransaccion()) {
                this.cuadernoBitacora.clear();
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Tabla colocameEnLocalizacion(List<ITipoDatosCampoValor> localizacion, boolean enPadre) throws ExceptionMotor {
        try {
            Tabla posicionActual = this.origenDatos.getRaiz();
            int ultimo = localizacion.size();
            if (enPadre) {
                --ultimo;
            }
            for (int i = 0; i < ultimo; ++i) {
                if (posicionActual.getTabla().equalsIgnoreCase(localizacion.get(i).getNombreCampo())) continue;
                posicionActual = posicionActual.getTablaHija(localizacion.get(i).getNombreCampo(), Integer.valueOf(localizacion.get(i).getValor()).intValue());
            }
            return posicionActual;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoRollBackTransaccion() throws ExceptionMotor {
        try {
            if (!this.enTransaccion()) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.cuadernoBitacora.add(new TipoEventoTransaccion(3, this.contadorTransacciones));
            boolean salir = false;
            int contadorTransaccionesAnidadas = 0;
            List localizacion = null;
            Tabla posicionActual = null;
            while (this.cuadernoBitacora.size() > 0 && !salir) {
                switch (this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getTipoTransaccion()) {
                    case 1: {
                        if (--contadorTransaccionesAnidadas != 0) break;
                        salir = true;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ++contadorTransaccionesAnidadas;
                        break;
                    }
                    case 4: {
                        localizacion = (List)((Object[])this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getDatos())[0];
                        ITablaMotorEntrada partidaAnterior = (ITablaMotorEntrada)((Object[])this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getDatos())[1];
                        posicionActual = this.colocameEnLocalizacion(localizacion, false);
                        posicionActual.establecerPartida(partidaAnterior.getNombreEntrada(), partidaAnterior.getValor().toString());
                        posicionActual.establecerEstado(partidaAnterior.getNombreEntrada(), Integer.valueOf(partidaAnterior.getEstado().toString()));
                        posicionActual = null;
                        localizacion = null;
                        break;
                    }
                    case 5: {
                        localizacion = (List)this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getDatos();
                        posicionActual = this.colocameEnLocalizacion(localizacion, true);
                        posicionActual.borrarTablaHija(((ITipoDatosCampoValor)localizacion.get(localizacion.size() - 1)).getNombreCampo(), Integer.valueOf(((ITipoDatosCampoValor)localizacion.get(localizacion.size() - 1)).getValor()));
                        posicionActual = null;
                        localizacion = null;
                        break;
                    }
                    case 6: {
                        localizacion = (List)((Object[])this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getDatos())[0];
                        Tabla respaldo = (Tabla)((Object[])this.cuadernoBitacora.get(this.cuadernoBitacora.size() - 1).getDatos())[1];
                        posicionActual = this.colocameEnLocalizacion(localizacion, true);
                        posicionActual.addTablaHija(respaldo, Integer.valueOf(((ITipoDatosCampoValor)localizacion.get(localizacion.size() - 1)).getValor()).intValue());
                        posicionActual = null;
                        localizacion = null;
                        break;
                    }
                }
                this.cuadernoBitacora.remove(this.cuadernoBitacora.size() - 1);
            }
            --this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoValueChanged(ITablaMotor tab, ITablaMotorEntrada partida) throws ExceptionMotor {
        try {
            if (!this.enTransaccion()) {
                return true;
            }
            this.cuadernoBitacora.add(new TipoEventoTransaccion(4, new Object[]{((ArrayList)tab.getLocalizacion()).clone(), partida.clone()}));
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoAddedRecord(ITablaMotor tab, long id) throws ExceptionMotor {
        try {
            if (!this.enTransaccion()) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            List localizacion = (List)((ArrayList)tab.getLocalizacion()).clone();
            ((ITipoDatosCampoValor)localizacion.get(localizacion.size() - 1)).setValor(String.valueOf(id));
            this.cuadernoBitacora.add(new TipoEventoTransaccion(5, localizacion));
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean addEventoDeletedRecord(ITablaMotor tab) throws ExceptionMotor {
        try {
            if (!this.enTransaccion()) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            List localizacion = (List)((ArrayList)tab.getLocalizacion()).clone();
            Tabla posicionActual = this.colocameEnLocalizacion(localizacion, true);
            Tabla clon = posicionActual.getTablaHija(tab.getNombre(), tab.getClaveActiva()).clone();
            this.cuadernoBitacora.add(new TipoEventoTransaccion(6, new Object[]{localizacion, clon}));
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean enTransaccion() {
        return this.contadorTransacciones > 0;
    }
}

