/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TipoHijoTabla
implements Serializable,
IAop {
    private static final long serialVersionUID = 1L;
    private String nombreTabla = "";
    private List<Tabla> tablasHijas = null;
    private int recordCount = 0;
    private IOrigenDatos io = null;

    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (object instanceof IOrigenDatos) {
                    this.io = (IOrigenDatos)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                this.nombreTabla = object.toString();
            }
            this.tablasHijas = new ArrayList<Tabla>();
            this.recordCount = 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void dispose() throws ExceptionMotor {
        this.tablasHijas = null;
        this.io = null;
    }

    public IOrigenDatos getIo() {
        return this.io;
    }

    public Tabla getItem(int pos) {
        try {
            return this.tablasHijas.get(pos);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Tabla> getListaRegistros() {
        return this.tablasHijas;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    protected int rcAdded() throws ExceptionMotor {
        try {
            ++this.recordCount;
            return this.getRecordCount();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected int rcRemoved() throws ExceptionMotor {
        try {
            if (this.getRecordCount() < 1) {
                throw new ExceptionMotor("Intentado borrar registro y no existe!!!");
            }
            --this.recordCount;
            return this.getRecordCount();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long addTablaHija() throws ExceptionMotor {
        try {
            this.tablasHijas.add((Tabla)FuncionesUtiles.getFuncionesUtiles().getInstancia(Tabla.class, new Object[]{this.nombreTabla, this.getIo()}));
            return this.rcAdded();
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + this.nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + this.nombreTabla);
        }
    }

    public long addTablaHija(Tabla tTabla, long pos) throws ExceptionMotor {
        try {
            if (this.getRecordCount() > 0 && pos < (long)this.getRecordCount()) {
                this.tablasHijas.add((int)pos, tTabla);
                this.rcAdded();
                return pos;
            }
            this.rcAdded();
            this.tablasHijas.add(tTabla);
            return this.getRecordCount();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean borrarTablaHija(int pos) throws ExceptionMotor {
        try {
            if (this.getRecordCount() > 0 && pos < this.getRecordCount()) {
                this.tablasHijas.remove(pos);
                this.rcRemoved();
                return true;
            }
            return false;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

