/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.mem.TipoHijoTabla;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tabla
implements Serializable,
IAop {
    private static final long serialVersionUID = 1L;
    private Map<String, ITablaMotorEntrada> registro = null;
    private String tabla = "";
    private Map<String, TipoHijoTabla> tablasHijas = null;
    private IOrigenDatos io = null;

    public void dispose() throws ExceptionMotor {
        this.registro = null;
        this.tablasHijas = null;
        this.io = null;
    }

    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (object instanceof IOrigenDatos) {
                    this.io = (IOrigenDatos)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                this.tabla = object.toString();
            }
            this.tablasHijas = new HashMap<String, TipoHijoTabla>();
            HashMap<String, ITablaMotorEntrada> rg = new HashMap<String, ITablaMotorEntrada>();
            List listaCampos = this.getIo().getGestorConfiguracion().getCamposDeTabla(this.tabla);
            IRegEntrada regEnt = null;
            String tmpStr = "";
            if (listaCampos != null) {
                for (int i = 0; i < listaCampos.size(); ++i) {
                    String nombreCampo = ((String)listaCampos.get(i)).toString();
                    if (nombreCampo == null) continue;
                    regEnt = this.getIo().getGestorConfiguracion().getEntrada(nombreCampo);
                    tmpStr = regEnt.getTipoDato();
                    if (tmpStr.equalsIgnoreCase("ENTERO")) {
                        rg.put(nombreCampo, (ITablaMotorEntrada)new TablaMotorEntrada(nombreCampo, (Object)Integer.valueOf(regEnt.getValorInicial()), (Object)(regEnt.getEstadoInicial() + "")));
                    } else if (tmpStr.equalsIgnoreCase("DOBLE")) {
                        rg.put(nombreCampo, (ITablaMotorEntrada)new TablaMotorEntrada(nombreCampo, (Object)Double.valueOf(regEnt.getValorInicial()), (Object)(regEnt.getEstadoInicial() + "")));
                    } else if (tmpStr.equalsIgnoreCase("BIGDECIMAL")) {
                        rg.put(nombreCampo, (ITablaMotorEntrada)new TablaMotorEntrada(nombreCampo, (Object)regEnt.getValorInicial(), (Object)(regEnt.getEstadoInicial() + "")));
                    } else if (tmpStr.equalsIgnoreCase("LOGICO")) {
                        rg.put(nombreCampo, (ITablaMotorEntrada)new TablaMotorEntrada(nombreCampo, (Object)Boolean.valueOf(regEnt.getValorInicial()), (Object)(regEnt.getEstadoInicial() + "")));
                    } else {
                        rg.put(nombreCampo, (ITablaMotorEntrada)new TablaMotorEntrada(nombreCampo, (Object)regEnt.getValorInicial(), (Object)(regEnt.getEstadoInicial() + "")));
                    }
                    regEnt = null;
                }
            }
            regEnt = null;
            this.registro = rg;
            rg = null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Tabla() {
    }

    protected Tabla(IOrigenDatos io, String nombre) {
        this.setIo(io);
        this.tabla = nombre;
    }

    public String getTabla() {
        return this.tabla;
    }

    public boolean hasTabla(String tablaHija) {
        if (this.getTablasHijas() == null) {
            return false;
        }
        return this.getTablasHijas().containsKey(tablaHija.toUpperCase());
    }

    public Tabla getTablaHija(String tablaHija, long indice) {
        if (!this.hasTabla(tablaHija)) {
            return null;
        }
        return this.getTablasHijas().get(tablaHija.toUpperCase()).getItem((int)indice - 1);
    }

    public int recordCount(String tablaHija) {
        if (!this.hasTabla(tablaHija)) {
            return 0;
        }
        return this.getTablasHijas().get(tablaHija.toUpperCase()).getRecordCount();
    }

    public void clear() {
        if (this.getRegistro() != null) {
            this.getRegistro().clear();
        }
        this.getTablasHijas().clear();
    }

    public boolean limpiaRegistro() {
        if (this.getRegistro() != null) {
            this.getRegistro().clear();
        }
        return true;
    }

    public void setRegistro(Map<String, ITablaMotorEntrada> registro) {
        this.registro = registro;
    }

    public Map<String, ITablaMotorEntrada> getRegistro() {
        return this.registro;
    }

    protected void setTablasHijas(Map<String, TipoHijoTabla> tablasHijas) {
        this.tablasHijas = tablasHijas;
    }

    public Map<String, TipoHijoTabla> getTablasHijas() {
        return this.tablasHijas;
    }

    public boolean establecerPartida(String partida, String valor) throws ExceptionMotor {
        try {
            IRegEntrada ent = this.getIo().getGestorConfiguracion().getEntrada(partida);
            partida = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(partida);
            ITablaMotorEntrada e = this.registro.get(partida);
            if (e == null) {
                if (ent == null && (partida.equalsIgnoreCase("ID") || partida.equalsIgnoreCase("IDINF"))) {
                    ent = new RegEntrada();
                    ent.inicializaRegEntrada(partida, this.getTabla(), "ENTERO".toUpperCase(), "1");
                }
                if (!ent.getIdTabla().equalsIgnoreCase(this.getTabla())) {
                    throw new ExceptionMotor("La partida " + partida + " no pertenece a la tabla " + this.getTabla());
                }
                e = new TablaMotorEntrada(partida, (Object)ent.getValorInicial(), (Object)ent.getEstadoInicial());
                ent = null;
            }
            if (ent != null && ent.esTipoNumerico()) {
                String maximo = "";
                int max = 0;
                if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    try {
                        max = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS").toString());
                    }
                    catch (Exception ex) {}
                } else {
                    try {
                        max = Integer.valueOf(ent.getPropiedad("LONGITUD").toString());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (max == 0) {
                        try {
                            max = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS").toString());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                if (max != 0) {
                    maximo = FuncionesUtiles.getFuncionesUtiles().rellena("", '9', max);
                    int numeroDecimales = ent.getNumDecimales();
                    if (numeroDecimales > 0) {
                        maximo = maximo + "." + FuncionesUtiles.getFuncionesUtiles().rellena("", '9', numeroDecimales);
                    }
                    if (maximo.trim().length() == 0) {
                        maximo = "0";
                    }
                    if (this.getIo().isControlOverflow() && FuncionesUtiles.getFuncionesUtiles().mayorQue(valor, maximo)) {
                        FuncionesUtiles.getFuncionesUtiles().muestraError("OVERFLOW partida " + partida);
                        throw new ExceptionMotor("OVERFLOW_MOTOR");
                    }
                    if (this.getIo().isControlOverflow() && FuncionesUtiles.getFuncionesUtiles().menorQue(valor, "-" + maximo)) {
                        FuncionesUtiles.getFuncionesUtiles().muestraError("OVERFLOW partida " + partida);
                        throw new ExceptionMotor("OVERFLOW_MOTOR");
                    }
                }
            }
            e.setValor((Object)valor);
            this.registro.put(partida, e);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean establecerEstado(String partida, int valor) throws ExceptionMotor {
        try {
            partida = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(partida);
            ITablaMotorEntrada e = this.registro.get(partida);
            if (e == null) {
                IRegEntrada ent = this.getIo().getGestorConfiguracion().getEntrada(partida);
                if (!ent.getIdTabla().equalsIgnoreCase(this.getTabla())) {
                    throw new ExceptionMotor("La partida no pertenece a esta tabla");
                }
                e = new TablaMotorEntrada(partida, (Object)ent.getValorInicial(), (Object)ent.getEstadoInicial());
                ent = null;
            }
            e.setEstado((Object)valor);
            this.registro.put(partida, e);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public String obtenerPartidaString(String partida) throws ExceptionMotor {
        try {
            ITablaMotorEntrada e = this.registro.get(partida);
            if (e == null) {
                if (partida.equalsIgnoreCase("ID") || partida.equalsIgnoreCase("IDINF")) {
                    return "-1";
                }
                IRegEntrada ent = this.getIo().getGestorConfiguracion().getEntrada(partida);
                if (ent == null) {
                    throw new ExceptionMotor("Entrada " + partida + " no se encuentra en entradas!!!");
                }
                return ent.getValorInicial();
            }
            return e.getValor().toString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int obtenerEstado(String partida) throws ExceptionMotor {
        try {
            ITablaMotorEntrada e = this.registro.get(partida);
            if (e == null) {
                IRegEntrada ent = this.getIo().getGestorConfiguracion().getEntrada(partida);
                if (ent == null) {
                    throw new ExceptionMotor("Entrada " + partida + " no se encuentra en entradas!!!");
                }
                return ent.getEstadoInicial();
            }
            return Integer.valueOf(e.getEstado().toString());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tabla clone() throws CloneNotSupportedException {
        Tabla clon = null;
        try {
            clon = new Tabla(this.getIo(), this.getTabla());
            HashMap<String, TipoHijoTabla> relacionadas = null;
            if (this.getTablasHijas() != null) {
                relacionadas = new HashMap<String, TipoHijoTabla>();
                for (String tab : this.getTablasHijas().keySet()) {
                    TipoHijoTabla tht = new TipoHijoTabla();
                    tht.init(new Object[]{this.io, tab});
                    for (int j = 0; j < this.getTablasHijas().get(tab).getRecordCount(); ++j) {
                        tht.addTablaHija(this.getTablasHijas().get(tab).getItem(j).clone(), j);
                    }
                    relacionadas.put(tab, tht);
                    tht = null;
                }
            }
            clon.setTablasHijas(relacionadas);
            HashMap<String, ITablaMotorEntrada> reg = null;
            if (this.getRegistro() != null) {
                reg = new HashMap<String, ITablaMotorEntrada>();
                Collection<ITablaMotorEntrada> col = this.getRegistro().values();
                Iterator<ITablaMotorEntrada> i = col.iterator();
                ITablaMotorEntrada t = null;
                while (i.hasNext()) {
                    t = i.next();
                    reg.put(t.getNombreEntrada(), t.clone());
                    t = null;
                }
                t = null;
            }
            clon.setRegistro(reg);
            Tabla tabla = clon;
            return tabla;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            Tabla tabla = null;
            return tabla;
        }
        finally {
            clon = null;
        }
    }

    public String toString() {
        return this.getTabla();
    }

    public void setIo(IOrigenDatos io) {
        this.io = io;
        if (this.getTablasHijas() != null) {
            for (String tab : this.getTablasHijas().keySet()) {
                for (int j = 0; j < this.getTablasHijas().get(tab).getRecordCount(); ++j) {
                    this.getTablasHijas().get(tab).getItem(j).setIo(io);
                }
            }
        }
    }

    public IOrigenDatos getIo() {
        return this.io;
    }

    public long addTablaHija(String nTabla) throws ExceptionMotor {
        if (this.getTablasHijas().get(nTabla.toUpperCase()) == null) {
            TipoHijoTabla tht = new TipoHijoTabla();
            tht.init(new Object[]{this.io, nTabla.toUpperCase()});
            this.getTablasHijas().put(nTabla.toUpperCase(), tht);
        }
        return this.getTablasHijas().get(nTabla.toUpperCase()).addTablaHija();
    }

    public long addTablaHija(Tabla tTabla, long pos) throws ExceptionMotor {
        if (this.getTablasHijas().get(tTabla.getTabla()) == null) {
            TipoHijoTabla tht = new TipoHijoTabla();
            tht.init(new Object[]{this.io, tTabla.getTabla()});
            this.getTablasHijas().put(tTabla.getTabla(), tht);
        }
        return this.getTablasHijas().get(tTabla.getTabla()).addTablaHija(tTabla, pos - 1L);
    }

    public boolean borrarTablaHija(String nombreTabla, int pos) throws ExceptionMotor {
        if (this.getTablasHijas().get(nombreTabla.toUpperCase()) == null) {
            return false;
        }
        return this.getTablasHijas().get(nombreTabla.toUpperCase()).borrarTablaHija(pos - 1);
    }

    public int getRecordCountTotal() throws ExceptionMotor {
        try {
            int ret = 1;
            Set<String> s = this.getTablasHijas().keySet();
            Iterator<String> it = s.iterator();
            while (it.hasNext()) {
                String tabla = it.next().toString();
                TipoHijoTabla hijo = this.getTablasHijas().get(tabla);
                for (int i = 0; i < hijo.getRecordCount(); ++i) {
                    ret += hijo.getItem(i).getRecordCountTotal();
                }
            }
            return ret;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }
}

