/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.mem;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.excepciones.NotImplementedException;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.IPersistencia;
import es.aeat.pftw.mtrc.origenDatos.mem.CachePosicionamientos;
import es.aeat.pftw.mtrc.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.origenDatos.mem.TipoHijoTabla;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.IGestorTransacciones;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.bitacora.GestorTransaccionesBitacora;
import es.aeat.pftw.mtrc.origenDatos.mem.transacciones.clonado.GestorTransaccionesClonado;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.tipos.TipoDatosRegistro;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValorEx;
import es.aeat.pftw.mtrp.tipos.ITipoDatosRegistro;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class OrigenDatosMem
implements IOrigenDatos,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean controlOverflow = true;
    private boolean origenDeDatosOrdenadoPorCriterio = false;
    private IGestorTransacciones gestorTransacciones = null;
    private Tabla raiz = null;
    private boolean trabajandoConAtributo = false;
    private int modoTransaccion = 1;
    private transient ISesion sesion = null;
    private transient CachePosicionamientos cachePosicionamiento = null;
    private boolean cacheHabilitada = false;
    private transient ITipoDatosCampoValorEx cacheListaRegistrosIndexada = null;

    protected void limpiarCaches() throws ExceptionMotor {
        try {
            this.setCacheListaRegistrosIndexada(null);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void dispose() throws ExceptionMotor {
        try {
            this.cerrarAlmacenamiento();
            this.limpiarCaches();
            if (this.gestorTransacciones != null) {
                this.gestorTransacciones.dispose();
                this.gestorTransacciones = null;
            }
            this.cachePosicionamiento = null;
            this.raiz = null;
            this.sesion = null;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public ISesion getSesion() {
        return this.sesion;
    }

    public void setSesion(ISesion sesion) {
        this.sesion = sesion;
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor exceptionMotor) {
            // empty catch block
        }
    }

    protected CachePosicionamientos getCachePosicionamiento() {
        if (this.cachePosicionamiento == null) {
            this.cachePosicionamiento = new CachePosicionamientos(5);
        }
        return this.cachePosicionamiento;
    }

    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.sesion = (ISesion)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Object crearDeclaracionPorDefecto() throws ExceptionMotor {
        try {
            IRegTabla regTabla = this.getSesion().getModelo().getGestorConfiguracion().getTablaNivel(0);
            if (regTabla == null) {
                throw new ExceptionMotor("No se han recuperado la tabla de nivel 0.");
            }
            String nombreTablaRaiz = null;
            if (regTabla != null) {
                nombreTablaRaiz = regTabla.getIdTabla();
            }
            if (nombreTablaRaiz == null) {
                throw new ExceptionMotor("No se ha recuperado nombre de la tabla ra\u00edz.");
            }
            String str = "ISO-8859-1";
            String sDatos = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><" + nombreTablaRaiz.toUpperCase() + "></" + nombreTablaRaiz.toUpperCase() + ">";
            InputSource iso = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(sDatos.getBytes(str)), Charset.forName(str)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document docXML = builder.parse(iso);
            return docXML;
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean abrirAlmacenamiento() {
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor e) {
            // empty catch block
        }
        if (this.gestorTransacciones != null) {
            try {
                this.gestorTransacciones.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gestorTransacciones = null;
        }
        return this.getRaiz() != null;
    }

    public boolean abrirAlmacenamiento(Object origen) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            if (origen == null) {
                origen = this.crearDeclaracionPorDefecto();
            }
            if (origen == null) {
                return this.abrirAlmacenamiento();
            }
            if (this.gestorTransacciones != null) {
                try {
                    this.gestorTransacciones.dispose();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.gestorTransacciones = null;
            }
            return this.getPersist().establece((IOrigenDatos)this, (IOrigenDatos)this, origen);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean abrirAlmacenamiento(Object origen, Map<String, String> parametrosInicializacion) throws ExceptionMotor {
        return this.abrirAlmacenamiento(origen);
    }

    public IGestorConfiguracion getGestorConfiguracion() throws ExceptionMotor {
        return this.getSesion().getModelo().getGestorConfiguracion();
    }

    public boolean cerrarAlmacenamiento() {
        if (this.getRaiz() != null) {
            this.getRaiz().clear();
        }
        this.setRaiz(null);
        return true;
    }

    public boolean beginTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoInicioTransaccion();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean commitTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoCommitTransaccion();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean rollBack(boolean force) throws ExceptionMotor {
        return this.rollBack();
    }

    public boolean rollBack() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoRollBackTransaccion();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected Tabla comunPosicionarPuntero(List<ITipoDatosCampoValor> loc) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = null;
            if (this.isCacheHabilitada() && (paraPosicionar = this.getCachePosicionamiento().getElemento(loc.toString())) != null) {
                return paraPosicionar;
            }
            paraPosicionar = this.getRaiz();
            for (int i = 0; i < loc.size(); ++i) {
                if (loc.get(i).getNombreCampo().equalsIgnoreCase(paraPosicionar.getTabla())) continue;
                if (paraPosicionar.hasTabla(loc.get(i).getNombreCampo())) {
                    if ((paraPosicionar = paraPosicionar.getTablaHija(loc.get(i).getNombreCampo(), Integer.valueOf(loc.get(i).getValor()).intValue())) != null || !loc.get(i).getValor().equalsIgnoreCase("0")) continue;
                    return null;
                }
                return null;
            }
            if (this.isCacheHabilitada()) {
                this.getCachePosicionamiento().a\u00f1ade(loc.toString(), paraPosicionar);
            }
            return paraPosicionar;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected Tabla posicionarPuntero(ITablaMotor tab) throws ExceptionMotor {
        return this.comunPosicionarPuntero(tab.getLocalizacion());
    }

    protected Tabla posicionarPunteroEnPadre(ITablaMotor tab) throws ExceptionMotor {
        List loc = tab.getLocalizacion();
        loc.remove(loc.size() - 1);
        return this.comunPosicionarPuntero(loc);
    }

    public long anniadirRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = this.posicionarPunteroEnPadre(tab);
            if (paraPosicionar == null) {
                return 0L;
            }
            long id = paraPosicionar.addTablaHija(tab.getNombre());
            this.getGestorTransacciones().addEventoAddedRecord(tab, id);
            return id;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean borrarRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            Tabla paraPosicionar = this.posicionarPunteroEnPadre(tab);
            if (paraPosicionar == null) {
                return false;
            }
            this.getGestorTransacciones().addEventoDeletedRecord(tab);
            this.cachePosicionamiento = null;
            return paraPosicionar.borrarTablaHija(tab.getNombre(), (int)tab.getClaveActiva());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean limpiaRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            Tabla paraPosicionar = this.posicionarPuntero(tab);
            boolean ret = paraPosicionar.limpiaRegistro();
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public long recordCount(ITablaMotor tab) {
        try {
            if (tab.getNombre().equalsIgnoreCase(this.getRaiz().getTabla())) {
                return 1L;
            }
            Tabla paraPosicionar = this.posicionarPunteroEnPadre(tab);
            if (paraPosicionar == null) {
                return 0L;
            }
            return paraPosicionar.recordCount(tab.getNombre());
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, double valorDouble) throws ExceptionMotor {
        return this.establecerPartida(tab, nombrePartida, FuncionesUtiles.getFuncionesUtiles().doubleToString(valorDouble));
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, int valorInt) throws ExceptionMotor {
        return this.establecerPartida(tab, nombrePartida, (Object)valorInt);
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, long valorLong) throws ExceptionMotor {
        return this.establecerPartida(tab, nombrePartida, (Object)valorLong);
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, boolean valorBooleano) throws ExceptionMotor {
        return this.establecerPartida(tab, nombrePartida, (Object)valorBooleano);
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, String valorString) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = this.posicionarPuntero(tab);
            if (paraPosicionar == null) {
                return false;
            }
            if (!nombrePartida.equalsIgnoreCase("ID") && !nombrePartida.equalsIgnoreCase("IDINF") && paraPosicionar.obtenerPartidaString(nombrePartida) != null) {
                this.getGestorTransacciones().addEventoValueChanged(tab, (ITablaMotorEntrada)new TablaMotorEntrada(nombrePartida, (Object)paraPosicionar.obtenerPartidaString(nombrePartida), (Object)paraPosicionar.obtenerEstado(nombrePartida)));
            }
            return paraPosicionar.establecerPartida(nombrePartida, valorString);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean establecerEstado(ITablaMotor tab, String nombrePartida, int estado) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = this.posicionarPuntero(tab);
            if (paraPosicionar == null) {
                return false;
            }
            this.getGestorTransacciones().addEventoValueChanged(tab, (ITablaMotorEntrada)new TablaMotorEntrada(nombrePartida, (Object)paraPosicionar.obtenerPartidaString(nombrePartida), (Object)paraPosicionar.obtenerEstado(nombrePartida)));
            return paraPosicionar.establecerEstado(nombrePartida, estado);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean establecerEstado(ITablaMotor tab, String nombrePartida, String estado) throws ExceptionMotor {
        return this.establecerEstado(tab, nombrePartida, Integer.valueOf(estado));
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, Object valorObject) throws ExceptionMotor {
        return this.establecerPartida(tab, nombrePartida, valorObject.toString());
    }

    public Object obtenerPartida(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return this.obtenerPartidaString(tab, nombrePartida);
    }

    public String obtenerPartidaString(ITablaMotor tab, String nombrePartida, int index) throws ExceptionMotor {
        try {
            Tabla paraPosicionar;
            if (index > 0) {
                TipoHijoTabla tht;
                if (this.getCacheListaRegistrosIndexada() != null && this.getCacheListaRegistrosIndexada().getNombreCampo().equalsIgnoreCase(tab.getLocalizacion().toString())) {
                    return ((Tabla)((List)this.getCacheListaRegistrosIndexada().getValor()).get(index - 1)).obtenerPartidaString(nombrePartida);
                }
                Tabla padre = this.posicionarPunteroEnPadre(tab);
                if (padre.hasTabla(tab.getNombre()) && (tht = padre.getTablasHijas().get(tab.getNombre())).getListaRegistros() != null && tht.getListaRegistros().size() > 0) {
                    this.setCacheListaRegistrosIndexada((ITipoDatosCampoValorEx)new TipoDatosCampoValorEx(tab.getLocalizacion().toString(), tht.getListaRegistros()));
                    return tht.getListaRegistros().get(index - 1).obtenerPartidaString(nombrePartida);
                }
            }
            if ((paraPosicionar = this.posicionarPuntero(tab)) == null) {
                return null;
            }
            return paraPosicionar.obtenerPartidaString(nombrePartida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String obtenerPartidaString(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return this.obtenerPartidaString(tab, nombrePartida, 0);
    }

    public int obtenerEstado(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = this.posicionarPuntero(tab);
            if (paraPosicionar == null) {
                return -1;
            }
            return paraPosicionar.obtenerEstado(nombrePartida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Integer obtenerPartidaInteger(ITablaMotor tab, String nombrePartida) {
        try {
            return Integer.valueOf(this.obtenerPartidaString(tab, nombrePartida));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public Double obtenerPartidaDouble(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return Double.valueOf(this.obtenerPartidaString(tab, nombrePartida));
    }

    public BigDecimal obtenerPartidaBigDecimal(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return new BigDecimal(this.obtenerPartidaString(tab, nombrePartida).trim());
    }

    public Boolean obtenerPartidaBoolean(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return Boolean.valueOf(this.obtenerPartidaString(tab, nombrePartida));
    }

    protected long dameIDDeTablaMotor(ITablaMotor tAux) throws ExceptionMotor {
        try {
            String ret = tAux.obtenerPartidaString("ID");
            if (ret == null) {
                return 0L;
            }
            return Long.valueOf(ret);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public List<List<ITipoDatosRegistro>> obtenerTabla(ITablaMotor tAux) throws ExceptionMotor {
        if (tAux == null) {
            return null;
        }
        ArrayList<List<ITipoDatosRegistro>> ret = new ArrayList<List<ITipoDatosRegistro>>();
        long posicion = tAux.getClaveActiva();
        try {
            long rc = tAux.getRecordCount();
            int i = 0;
            while ((long)i < rc) {
                ArrayList<TipoDatosRegistro> dato = new ArrayList<TipoDatosRegistro>();
                tAux.setClaveActiva((long)(i + 1));
                tAux.setClaveUnica(0L);
                tAux.setClaveUnica(this.dameIDDeTablaMotor(tAux));
                Map d = tAux.getRsDatosReferencia();
                Set claves = d.keySet();
                String clave2 = "";
                for (String clave2 : claves) {
                    TipoDatosRegistro tr = new TipoDatosRegistro(clave2);
                    if (clave2.equalsIgnoreCase("IDINF") || clave2.equalsIgnoreCase("ID")) {
                        tr.setTipoDato("ENTERO");
                    } else {
                        tr.setTipoDato(this.sesion.getModelo().getGestorConfiguracion().getEntrada(clave2).getTipoDato());
                    }
                    tr.setValor(((ITablaMotorEntrada)d.get(clave2)).getValor());
                    tr.setEstado(((ITablaMotorEntrada)d.get(clave2)).getEstado());
                    dato.add(tr);
                    tr = null;
                }
                d = null;
                ret.add(dato);
                dato = null;
                ++i;
            }
            ArrayList<List<ITipoDatosRegistro>> arrayList = ret;
            return arrayList;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + tAux.getNombre() + " idPadre " + tAux.getClaveSuperior());
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + tAux.getNombre() + " idPadre " + tAux.getClaveSuperior());
        }
        finally {
            tAux.setClaveActiva(posicion);
            tAux.setClaveUnica(0L);
            tAux.setClaveUnica(this.dameIDDeTablaMotor(tAux));
        }
    }

    public List<Map<String, ITablaMotorEntrada>> obtenerTablaHashMap(ITablaMotor tAux) throws ExceptionMotor {
        if (tAux == null) {
            return null;
        }
        long claveSuperior = tAux.getClaveSuperior();
        ArrayList<Map<String, ITablaMotorEntrada>> ret = new ArrayList<Map<String, ITablaMotorEntrada>>();
        long posicion = tAux.getClaveActiva();
        try {
            long numRegistros = this.recordCount(tAux);
            int i = 1;
            while ((long)i <= numRegistros) {
                tAux.setClaveActiva((long)i);
                tAux.setClaveUnica(0L);
                tAux.setClaveUnica(this.dameIDDeTablaMotor(tAux));
                ret.add(this.obtenerRegistroFiltroEnPosicion(tAux));
                ++i;
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + tAux.getNombre() + " idPadre " + claveSuperior);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + tAux.getNombre() + " idPadre " + claveSuperior);
        }
        finally {
            tAux.setClaveActiva(posicion);
            tAux.setClaveUnica(0L);
            tAux.setClaveUnica(this.dameIDDeTablaMotor(tAux));
        }
        return ret;
    }

    protected Map<String, ITablaMotorEntrada> obtenerRegistroDeTabla(ITablaMotor tab) throws ExceptionMotor {
        try {
            Tabla paraPosicionar = this.posicionarPuntero(tab);
            if (paraPosicionar == null) {
                return null;
            }
            if (paraPosicionar.getRegistro().size() == 0) {
                return null;
            }
            return paraPosicionar.getRegistro();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Object obtenerValorSegunSuTipoDeDatos(String campo, String valor) {
        try {
            IRegEntrada ent = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(campo);
            String porDefecto = ent.getValorInicial();
            String tipo = ent.getTipoDato();
            if (tipo.equalsIgnoreCase("DOBLE")) {
                if (valor.length() == 0) {
                    if (porDefecto.length() == 0) {
                        porDefecto = "0";
                    }
                    return Double.valueOf(porDefecto);
                }
                return Double.valueOf(valor);
            }
            if (tipo.equalsIgnoreCase("BIGDECIMAL")) {
                return BigDecimal.ZERO;
            }
            if (tipo.equalsIgnoreCase("LOGICO") || tipo.equalsIgnoreCase("L\u00f3gico")) {
                if (valor.length() == 0) {
                    if (porDefecto.length() == 0) {
                        porDefecto = "false";
                    }
                    if (porDefecto.equalsIgnoreCase("0")) {
                        porDefecto = "false";
                    }
                    if (porDefecto.equalsIgnoreCase("1")) {
                        porDefecto = "true";
                    }
                    return Boolean.valueOf(porDefecto);
                }
                return Boolean.valueOf(valor);
            }
            if (tipo.equalsIgnoreCase("ENTERO")) {
                if (valor.length() == 0) {
                    if (porDefecto == null || porDefecto.length() == 0) {
                        porDefecto = "0";
                    }
                    return Integer.valueOf(porDefecto);
                }
                return Integer.valueOf(valor);
            }
            return valor;
        }
        catch (Exception ex) {
            return valor;
        }
    }

    public Map<String, ITablaMotorEntrada> obtenerRegistroFiltroEnPosicion(ITablaMotor tab) throws ExceptionMotor {
        try {
            return this.obtenerRegistroDeTabla(tab);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean inTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().enTransaccion();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void setRaiz(Tabla raiz) {
        this.cachePosicionamiento = null;
        this.raiz = raiz;
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor exceptionMotor) {
            // empty catch block
        }
    }

    public Tabla getRaiz() {
        return this.raiz;
    }

    public Object clona() throws ExceptionMotor {
        try {
            return this.getRaiz().clone();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean restauraDocumento(Object datos) {
        this.setRaiz(null);
        this.setRaiz((Tabla)datos);
        datos = null;
        return true;
    }

    protected IPersistencia getPersist() throws ExceptionMotor {
        try {
            return this.getSesion().getModelo().getPersistenciaObj();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setTrabajandoConAtributo(boolean trabajandoConAtributo) {
        this.trabajandoConAtributo = trabajandoConAtributo;
    }

    protected boolean isTrabajandoConAtributo() {
        return this.trabajandoConAtributo;
    }

    public void setModoTransacciones(int modoTransaccion) {
        this.modoTransaccion = modoTransaccion;
    }

    public int getModoTransacciones() throws ExceptionMotor {
        return this.modoTransaccion;
    }

    protected IGestorTransacciones getGestorTransacciones() throws ExceptionMotor {
        if (this.gestorTransacciones == null) {
            switch (this.getModoTransacciones()) {
                case 0: {
                    this.gestorTransacciones = (IGestorTransacciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestorTransaccionesClonado.class, new Object[]{this});
                    break;
                }
                case 1: {
                    this.gestorTransacciones = (IGestorTransacciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestorTransaccionesBitacora.class, new Object[]{this});
                    break;
                }
                default: {
                    throw new ExceptionMotor("Modo(" + this.getModoTransacciones() + ") de transaccion desconocido!!! ");
                }
            }
        }
        return this.gestorTransacciones;
    }

    public Object getPunteroADatos() {
        return this.getRaiz();
    }

    public List<Long> listaIdsTabla(ITablaMotor tab) {
        long rc = this.recordCount(tab);
        ArrayList<Long> ids = new ArrayList<Long>();
        int i = 1;
        while ((long)i <= rc) {
            ids.add(new Long(i));
            ++i;
        }
        return ids;
    }

    public void setOrigenDeDatosOrdenadoPorCriterio(boolean origenDeDatosOrdenadoPorCriterio) {
        this.origenDeDatosOrdenadoPorCriterio = origenDeDatosOrdenadoPorCriterio;
    }

    public boolean isOrigenDeDatosOrdenadoPorCriterio() {
        return this.origenDeDatosOrdenadoPorCriterio;
    }

    public boolean isCacheHabilitada() {
        return this.cacheHabilitada;
    }

    public void setCacheHabilitada(boolean cacheHabilitada) {
        this.cacheHabilitada = cacheHabilitada;
    }

    public void setControlOverflow(boolean controlOverflow) {
        this.controlOverflow = controlOverflow;
    }

    public boolean isControlOverflow() {
        return this.controlOverflow;
    }

    public int getDifferedWrite() {
        return 0;
    }

    public void setDifferedWrite(int Modo) {
    }

    public boolean establecerPartidas(ITablaMotor tab) throws ExceptionMotor, NotImplementedException {
        throw new NotImplementedException();
    }

    public boolean getSopportsSQL() {
        return false;
    }

    public Object ejecutaSQL(String sql) throws ExceptionMotor {
        throw new ExceptionMotor("Opcion no soportada en este origen de datos!!!!");
    }

    public boolean ejecutaAccion(String sql) throws ExceptionMotor {
        throw new ExceptionMotor("Opcion no soportada en este origen de datos!!!!");
    }

    public long getIdTablaRaiz() {
        return 1L;
    }

    public boolean isCreacionIDUnicoAutomatico() {
        return true;
    }

    public boolean getTablaIdInfCacheHabilitada() throws ExceptionMotor {
        return false;
    }

    public void setTablaIdInfCacheHabilitada(boolean b) {
    }

    public int getRecordCountTotal() throws ExceptionMotor {
        return this.getRaiz().getRecordCountTotal() - 1;
    }

    public ITipoDatosCampoValorEx getCacheListaRegistrosIndexada() {
        return this.cacheListaRegistrosIndexada;
    }

    public void setCacheListaRegistrosIndexada(ITipoDatosCampoValorEx cacheListaRegistrosIndexada) {
        this.cacheListaRegistrosIndexada = cacheListaRegistrosIndexada;
    }
}

