/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.cc14;

import es.aeat.pare.cc14.CalculosRenta;
import es.aeat.pare.cc14.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.cc14.Formatear;
import es.aeat.pare.cc14.FuncionesRentaValidador;
import es.aeat.pare.cc14.Validaciones;
import es.aeat.pare.cc14.ValidacionesAnxB2;
import es.aeat.pare.cc14.ValidacionesAnxB3;
import es.aeat.pare.cc14.ValidacionesAnxB4;
import es.aeat.pare.cc14.ValidacionesE;
import es.aeat.pare.cc14.ValidacionesTablas;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.excepciones.MtrrException;
import es.aeat.pftw.mtrc.api.motor.IValidador;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.TipoDatoRetornoMetodo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FuncionesRentaComprobacionDeclaracion
implements IValidador {
    private static final long serialVersionUID = 7977283450619556345L;
    private static final int TAMANIO_CIBAN = 29;
    private static final int CTE_DECLARANTE = 0;
    private static final int CTE_CONYUGE = 1;
    private static final int CTE_CONJUNTA = 15;
    private static final String CTE_ANDALUCIA = "01";
    private static final int CTE_INT_ANDALUCIA = 1;
    private static final String CTE_ARAGON = "02";
    private static final int CTE_INT_ARAGON = 2;
    private static final String CTE_ASTURIAS = "03";
    private static final int CTE_INT_ASTURIAS = 3;
    private static final String CTE_BALEARES = "04";
    private static final int CTE_INT_BALEARES = 4;
    private static final String CTE_CANARIAS = "05";
    private static final int CTE_INT_CANARIAS = 5;
    private static final String CTE_CANTABRIA = "06";
    private static final int CTE_INT_CANTABRIA = 6;
    private static final String CTE_CASTILLA_LA_MANCHA = "07";
    private static final int CTE_INT_CASTILLA_LA_MANCHA = 7;
    private static final String CTE_CASTILLA_LEON = "08";
    private static final int CTE_INT_CASTILLA_LEON = 8;
    private static final String CTE_CATALUNYA = "09";
    private static final int CTE_INT_CATALUNYA = 9;
    private static final String CTE_EXTREMADURA = "10";
    private static final int CTE_INT_EXTREMADURA = 10;
    private static final String CTE_GALICIA = "11";
    private static final int CTE_INT_GALICIA = 11;
    private static final String CTE_MADRID = "12";
    private static final int CTE_INT_MADRID = 12;
    private static final String CTE_MURCIA = "13";
    private static final int CTE_INT_MURCIA = 13;
    private static final String CTE_RIOJA = "16";
    private static final int CTE_INT_RIOJA = 16;
    private static final String CTE_VALENCIA = "17";
    private static final int CTE_INT_VALENCIA = 17;
    private static final String CTE_CEUTA = "18";
    private static final int CTE_INT_CEUTA = 18;
    private static final String CTE_MELILLA = "19";
    private static final int CTE_INT_MELILLA = 19;
    private static final double CTE_LORCA = 0.2;
    private static final int MAX_APORT_PREV_SOC_DISCAP = 24250;
    private static final int LEAVISOS = 1;
    private static final int LEIMPRIMIR = 2;
    private static final int LEINTERNET = 3;
    private CalculosRenta cr;
    private Map<String, Double> sumatoriosDeclarante = new HashMap<String, Double>();
    private Map<String, Double> sumatoriosConyuge = new HashMap<String, Double>();
    private Map<String, Map<String, Double>> sumatoriosHijos = new HashMap<String, Map<String, Double>>();
    private Map<String, Double> sumatoriosConjunta = new HashMap<String, Double>();
    private Map<String, Integer> contadoresDeclarante = new HashMap<String, Integer>();
    private Map<String, Integer> contadoresConyuge = new HashMap<String, Integer>();
    private Map<String, Map<String, Integer>> contadoresHijos = new HashMap<String, Map<String, Integer>>();
    private Map<String, Integer> contadoresConjunta = new HashMap<String, Integer>();
    private int contadorHijosMenoresOotraSitu2o4 = 0;
    private int contadorHijosMenoresOotraSitu2 = 0;
    private int contadorHijosMenoresNoRentas8000 = 0;
    private int contadorHijosRegla80054yRegla80055 = 0;
    private int uFhiRegla80063 = 0;
    private int hijosDregla80063 = 0;
    private int hijosCregla80063 = 0;
    private int hijosDregla80063Conjunta = 0;
    private int hijosCregla80063Conjunta = 0;
    private int hijosDAregla80075 = 0;
    private int hijos2DAregla80075 = 0;
    private int hijosDregla80075 = 0;
    private int hijos2Dregla80075 = 0;
    private int nADOPDA = 0;
    private int nADOPD = 0;
    private int nHD = 0;
    private int hijosCAregla80075 = 0;
    private int hijosCregla80075 = 0;
    private int hijos2CAregla80075 = 0;
    private int hijos2Cregla80075 = 0;
    private int nADOPCA = 0;
    private int nADOPC = 0;
    private int nHC = 0;
    private int cNHT = 0;
    private int cNHDIS = 0;
    private int cOTrs3o4 = 0;
    private int cOTrs2o4 = 0;
    private boolean fNum = false;
    private boolean bMULTIPLE = false;
    private boolean bPARTOMU = false;
    private boolean bFMP = true;
    private int nHDISD = 0;
    private int nHDISC = 0;
    private int nHDISDA = 0;
    private int nHDISCA = 0;
    private int nHDIS65D = 0;
    private int nHDIS65C = 0;
    private int nHDIS65DA = 0;
    private int nHDIS65CA = 0;
    private int iNUMEROA = 0;
    private int iNUMEROD = 0;
    private int iNUMEROC = 0;
    private int contadorAscDeduc = 0;
    private int contadorPCTMINAS3d = 0;
    private int contadorPCTMINAS3c = 0;
    private int contadorMINUS3d = 0;
    private int contadorMINUS3c = 0;
    private int numHijosMenoresDe4VinculacionXR80083d = 0;
    private int numHijosMenoresDe4OtrosNo1VinculacionXR800083d = 0;
    private int numHijosMenoresDe4VinculacionXR80083c = 0;
    private int numHijosMenoresDe4OtrosNo1VinculacionXR800083c = 0;
    private int numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntad = 0;
    private int numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntac = 0;
    private int numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083d = 0;
    private int numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083c = 0;
    private int numHijosR80084DevolOtrsVincuA = 0;
    private int numHijosR80084DevolOtrsVincuD = 0;
    private int numHijosR80084DevolOtrsVincuC = 0;
    private int numHijosR80084DevolOtrsVincuAConjunta = 0;
    private int numHijosR80084DevolOtrsVincuDConjunta = 0;
    private int numHijosR80084DevolOtrsVincuCConjunta = 0;
    private int numHijosEdadEscolarC = 0;
    private int numHijosEdadEscolarAD = 0;
    private int numHijosEdadEscolarB = 0;
    private int numHijosEdadEscolarAE = 0;
    private int numHijosEdadEscolarCConjunta = 0;
    private int numHijosEdadEscolarADConjunta = 0;
    private int numHijosEdadEscolarBConjunta = 0;
    private int numHijosEdadEscolarAEConjunta = 0;
    private int numHijosLibrosAragonD = 0;
    private int numHijosLibrosAragonC = 0;
    private int numHijosLibrosAragonOd = 0;
    private int numHijosLibrosAragonOc = 0;
    private int numHijosMaterialEscolarValenciaD = 0;
    private int numHijosMaterialEscolarValenciaC = 0;
    private int numHijosMaterialEscolarValenciaOD = 0;
    private int numHijosMaterialEscolarValenciaOC = 0;
    private int numHijosAragonD = 0;
    private int numHijosHminAragonD = 0;
    private int numHijosAragonNacD = 0;
    private int numHijosAragonC = 0;
    private int numHijosHminAragonC = 0;
    private int numHijosAragonNacC = 0;
    private int numHijosDerechoAyudaDomestica = 0;
    private int numHijos4R80093Individual = 0;
    private int numHijos4R80093Conjunta = 0;
    private boolean condicion8528d = false;
    private boolean condicion8528c = false;
    private String FMULTI = "";
    private int MESESd1314 = 0;
    private int MESESc1314 = 0;
    private int MESESAd1314 = 0;
    private int MESESAc1314 = 0;
    private int MESESd1213 = 0;
    private int MESESc1213 = 0;
    private int MESESBd1112 = 0;
    private int MESESBc1112 = 0;
    private boolean PM12d = false;
    private boolean PM12Ad = false;
    private boolean PM12c = false;
    private boolean PM12Ac = false;
    private boolean PMd = false;
    private boolean PMc = false;
    private boolean PMBd = false;
    private boolean PMBc = false;
    private String fechaDescendienteMenor2014d = "31122014";
    private String fechaDescendienteMenor2014c = "31122014";
    private String fechaDescendienteMenor2013d = "31122013";
    private String fechaDescendienteMenor2013c = "31122013";
    private String fechaDescendienteMayor2012d = "00000000";
    private String fechaDescendienteMayor2012c = "00000000";
    private String fechaDescendienteMayor2013d = "00000000";
    private String fechaDescendienteMayor2013c = "00000000";
    private String fechaDescendienteMayor2014d = "00000000";
    private String fechaDescendienteMayor2014c = "00000000";
    private String fechaDescendienteMayor2011d = "00000000";
    private String fechaDescendienteMayor2011c = "00000000";
    private String fechaDescendienteMenor2012c = "31122012";
    private String fechaDescendienteMenor2012d = "31122012";
    private String FMULTIRFd = "00000000";
    private String FMULTIRFc = "00000000";
    private int NUMERO13d = 0;
    private int NUMERO13c = 0;
    private int NUMPM12d = 0;
    private int NUMPM12c = 0;
    private int NUMERO12d = 0;
    private int NUMERO12c = 0;
    private int NUMERO11d = 0;
    private int NUMERO11c = 0;
    private int NUMDISd = 0;
    private int NUMDISc = 0;
    private int numHijosNacidosEnEjercicioActualOAnterior = 0;
    private int numHijosAdoptadosEnEjercicioActualOAnterior = 0;
    private int numTotalDeHijos = 0;
    private int numHijosMenoresDe4Anyos = 0;
    private boolean bPARTOM = false;
    long rcFUNCIONdameHijo = 0L;
    long posFUNCIONdameHijo = 0L;
    long posAntFUNCIONdameHijo = 0L;
    int contadorHijoActualFUNCIONdameHijo = 0;
    private double calculoD = 0.0;
    private double calculoC = 0.0;
    private int dechvfParaRegla80066 = 0;
    private int conhvfParaRegla80066 = 0;
    FuncionesRentaValidador funcrentaValidador;

    public void constructor(ISesion iSesion) throws ExceptionMotor {
        this.funcrentaValidador = (FuncionesRentaValidador)iSesion.getModelo().getFuncionalidadPersonalizadaModelo();
        this.cr = new CalculosRenta(iSesion);
    }

    protected Declarantes getMISesion(ISesion iSesion) throws Exception {
        return this.funcrentaValidador.cualDeclaracion(iSesion);
    }

    private boolean limpiarDatosComprobarDeclaracion(ISesion iSesion) throws Exception {
        this.limpiaMap(iSesion.getId(), this.sumatoriosDeclarante);
        this.limpiaMap(iSesion.getId(), this.sumatoriosConyuge);
        this.limpiaMap(iSesion.getId(), this.sumatoriosHijos);
        this.limpiaMap(iSesion.getId(), this.sumatoriosConjunta);
        this.limpiaMap(iSesion.getId(), this.contadoresDeclarante);
        this.limpiaMap(iSesion.getId(), this.contadoresConyuge);
        this.limpiaMap(iSesion.getId(), this.contadoresHijos);
        this.limpiaMap(iSesion.getId(), this.contadoresConjunta);
        return true;
    }

    private void limpiaMap(String string, Map<String, ?> map) {
        try {
            Object[] objectArray = map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!objectArray[i].toString().startsWith(string)) continue;
                map.remove(objectArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TipoDatoRetornoMetodo ejecutarFuncion(ISesion iSesion, String string, Object[] objectArray) throws ExceptionMotor {
        try {
            if (string.equalsIgnoreCase("dameEdad")) {
                return new TipoDatoRetornoMetodo(this.dameEdad(objectArray[0].toString()));
            }
            if (string.equalsIgnoreCase("compruebaTramos")) {
                return new TipoDatoRetornoMetodo((Object)this.compruebaTramos());
            }
            if (string.equalsIgnoreCase("dameDeclaracionActual")) {
                return new TipoDatoRetornoMetodo((Object)this.dameDeclaracionActual(iSesion));
            }
            if (string.equalsIgnoreCase("ejecutaFuncionSegunDeclaracion")) {
                return new TipoDatoRetornoMetodo((Object)this.ejecutaFuncionSegunDeclaracion(iSesion, objectArray[0].toString(), objectArray[1].toString()));
            }
            if (string.equalsIgnoreCase("deducInvEntidadesCotizadas")) {
                return new TipoDatoRetornoMetodo((Object)this.deducInvEntidadesCotizadas(iSesion));
            }
            if (string.equalsIgnoreCase("deduccionCastillaManchaMayores75")) {
                return new TipoDatoRetornoMetodo((Object)this.deduccionCastillaManchaMayores75(iSesion));
            }
            if (string.equalsIgnoreCase("recordatorioDeducAutonomicas")) {
                return new TipoDatoRetornoMetodo((Object)this.recordatorioDeducAutonomicas(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaDeduccionesAutonomicasFamiliaNum")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaDeduccionesAutonomicasFamiliaNum(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaBenefAyudasFamiliares")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaBenefAyudasFamiliares(iSesion));
            }
            if (string.equalsIgnoreCase("calcularSumatoriosyContadores")) {
                return new TipoDatoRetornoMetodo((Object)this.calcularSumatoriosyContadores(iSesion));
            }
            if (string.equalsIgnoreCase("compruebaCAutonoma")) {
                return new TipoDatoRetornoMetodo((Object)this.compruebaCAutonoma(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaDiscapBaleares")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaDiscapBaleares(iSesion));
            }
            if (string.equalsIgnoreCase("deducAscendientes")) {
                return new TipoDatoRetornoMetodo((Object)this.deducAscendientes(iSesion));
            }
            if (string.equalsIgnoreCase("deducFamiliaresDiscapacitados")) {
                return new TipoDatoRetornoMetodo((Object)this.deducFamiliaresDiscapacitados(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaVivHabGuarderia")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaVivHabGuarderia(iSesion));
            }
            if (string.equalsIgnoreCase("validarControlRentasH1")) {
                return new TipoDatoRetornoMetodo((Object)this.validarControlRentasH1(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaLibrosBaleares")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaLibrosBaleares(iSesion));
            }
            if (string.equalsIgnoreCase("coherenciaNacHijosDiscapacitados")) {
                return new TipoDatoRetornoMetodo((Object)this.coherenciaNacHijosDiscapacitados(iSesion));
            }
            if (string.equalsIgnoreCase("validarControlRentasH2")) {
                return new TipoDatoRetornoMetodo((Object)this.validarControlRentasH2(iSesion));
            }
            if (string.equalsIgnoreCase("validarControlRentasH3")) {
                return new TipoDatoRetornoMetodo((Object)this.validarControlRentasH3(iSesion));
            }
            if (string.equalsIgnoreCase("validarControlRentasH4")) {
                return new TipoDatoRetornoMetodo((Object)this.validarControlRentasH4(iSesion));
            }
            if (string.equalsIgnoreCase("validarObligacionDeclararHijos")) {
                return new TipoDatoRetornoMetodo((Object)this.validarObligacionDeclararHijos(iSesion));
            }
            if (string.equalsIgnoreCase("validacionesVariasH1H2")) {
                return new TipoDatoRetornoMetodo((Object)this.validacionesVariasH1H2(iSesion));
            }
            if (string.equalsIgnoreCase("validacionesComplementaria")) {
                return new TipoDatoRetornoMetodo((Object)this.validacionesComplementaria(iSesion));
            }
            if (string.equalsIgnoreCase("validacionesID")) {
                return new TipoDatoRetornoMetodo((Object)this.validacionesID(iSesion));
            }
            if (string.equalsIgnoreCase("validarFechaDeclaracion")) {
                return new TipoDatoRetornoMetodo((Object)this.validarFechaDeclaracion(iSesion));
            }
            if (string.equalsIgnoreCase("validacionEspecialDomicilio")) {
                return new TipoDatoRetornoMetodo((Object)this.validacionEspecialDomicilio(iSesion));
            }
            if (string.equalsIgnoreCase("deduccionObrasMejoraViviendaHabitual")) {
                return new TipoDatoRetornoMetodo((Object)this.deduccionObrasMejoraViviendaHabitual(iSesion));
            }
            if (string.equalsIgnoreCase("deduccionCuotasSS")) {
                return new TipoDatoRetornoMetodo((Object)this.deduccionCuotasSS(iSesion));
            }
            if (string.equalsIgnoreCase("validarNifOtroProgenitor")) {
                return new TipoDatoRetornoMetodo((Object)this.validarNifOtroProgenitor(iSesion));
            }
            if (string.equalsIgnoreCase("comprobarFormaPagoParaImpresion")) {
                return new TipoDatoRetornoMetodo((Object)this.comprobarFormaPagoParaImpresion(iSesion, this.funcrentaValidador.cualDeclaracion(iSesion)));
            }
            if (string.compareToIgnoreCase("erroresOverflow") == 0) {
                return new TipoDatoRetornoMetodo(this.erroresOverflow(iSesion));
            }
            if (string.equalsIgnoreCase("limpiarDatosComprobarDeclaracion")) {
                return new TipoDatoRetornoMetodo((Object)this.limpiarDatosComprobarDeclaracion(iSesion));
            }
            return new TipoDatoRetornoMetodo(-99998);
        }
        catch (Exception exception) {
            String string2 = "MAL" + iSesion.getGestionReglas().getUltimaReglaProcesada();
            System.out.println("***RENTA2014*** FALLO EN PROCESO DE REGLA:" + string2);
            String string3 = "";
            try {
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DF_NIF_D").trim().length() != 0) {
                    string3 = string3 + "NIF[" + this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DF_NIF_D") + "]";
                }
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DF_APE1_D").trim().length() != 0) {
                    string3 = string3 + " APE[" + this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DF_APE1_D") + "]";
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            System.out.println("***RENTA2014*** PARA CONTRIBUYENTE" + string3);
            this.addErrorOWarning(iSesion, string2, "E", "");
            if (exception.getClass().equals(InvocationTargetException.class) && exception.getCause().getClass().equals(ExceptionMotor.class)) {
                throw (ExceptionMotor)exception.getCause();
            }
            throw new ExceptionMotor(exception);
        }
    }

    protected long recordCount(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        long l = 0L;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        l = iSesion.getOperaciones().recordCount(string);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return l;
    }

    protected long moveFirst(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        long l = 0L;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        l = iSesion.getOperaciones().moveFirst(string);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return l;
    }

    protected boolean hasNext(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        boolean bl = false;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        bl = iSesion.getOperaciones().hasNext(string);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return bl;
    }

    protected long moveNext(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        long l = 0L;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        l = iSesion.getOperaciones().moveNext(string);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return l;
    }

    protected long move(ISesion iSesion, Declarantes declarantes, String string, long l) throws ExceptionMotor {
        long l2 = 0L;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        l2 = iSesion.getOperaciones().move(string, l);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return l2;
    }

    protected long obtenerClaveActiva(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        long l = 0L;
        Declarantes declarantes2 = null;
        declarantes2 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        l = iSesion.getOperaciones().obtenerClaveActiva(string);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return l;
    }

    protected long getPosicion(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        return this.obtenerClaveActiva(iSesion, declarantes, string);
    }

    private String dameComunidadDeclarante(ISesion iSesion, Declarantes declarantes) throws Exception {
        return this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim();
    }

    private String getNombrePartidaCCAAParaDeclarante(ISesion iSesion, Declarantes declarantes) throws ExceptionMotor {
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                return "CAC_D";
            }
            case 1: {
                return "CAC_C";
            }
            case 15: {
                return "CAOC";
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                return "CACHR";
            }
            ++n;
        }
        return "CAC_D";
    }

    private String getNombrePartidaDescripcionCCAAParaDeclarante(ISesion iSesion, Declarantes declarantes) throws ExceptionMotor {
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                return "CAD_D";
            }
            case 1: {
                return "CAD_C";
            }
            case 15: {
                return "CAOD";
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                return "CADHR";
            }
            ++n;
        }
        return "CAD_D";
    }

    private boolean comprobarCA(ISesion iSesion, Declarantes declarantes, String ... stringArray) throws Exception {
        for (String string : stringArray) {
            if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean deduccionMonoparental(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ANDALUCIA, CTE_ASTURIAS)) {
            return true;
        }
        boolean bl = true;
        if (declarantes != null) {
            double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A9"));
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PA12"));
            if (this.comprobarCA(iSesion, declarantes, CTE_ANDALUCIA) && d > 0.0 && this.contadorHijosMenoresOotraSitu2 == 0) {
                bl &= this.addErrorOWarning(iSesion, "100R572", "E", "A9(D)");
            }
            if (this.comprobarCA(iSesion, declarantes, CTE_ANDALUCIA) && declarantes2.equals(Declarantes.Declarante) && !this.bFMP && d > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P514", "W", "A9(D)");
            }
            if (d2 > 0.0 && this.contadorHijosMenoresNoRentas8000 == 0 && this.comprobarCA(iSesion, declarantes, CTE_ASTURIAS)) {
                bl &= this.addErrorOWarning(iSesion, "100P294", "W", "PA12(D)");
            }
        }
        return bl;
    }

    public boolean deduccionViviendaHabitualProtegidaAsturias(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_ASTURIAS)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PA4"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PA4"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PORPA4"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PORPA4"));
        if (iSesion.existsPtr("DEFAULT") && iSesion.existsPtr("CONYUGE") && d > 0.0 && d2 > 0.0 && (d3 == 1.0 || d4 == 1.0)) {
            bl = declarantes2.equals(Declarantes.UnidadFamiliar) ? (d3 == 1.0 ? (bl &= this.addErrorOWarning(iSesion, "100P306", "W", "PA4(D)")) : (bl &= this.addErrorOWarning(iSesion, "100P306", "W", "PA4(C)"))) : (bl &= this.addErrorOWarning(iSesion, "100P306", "W", "PA4(" + string + ")"));
        }
        return bl;
    }

    public boolean deduccionViviendaHabitualAsturiasConMinusvalidos(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_ASTURIAS)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        if (iSesion.existsPtr("DEFAULT") && iSesion.existsPtr("CONYUGE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PA3")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PA3")) > 0.0 && (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMPA3")) == 1.0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMPA3")) == 1.0)) {
            bl = this.switchMotor(iSesion, declarantes2) != 15 ? (bl &= this.addErrorOWarning(iSesion, "100P307", "W", "PA3(" + string + ")")) : (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMPA3")) == 1.0 ? (bl &= this.addErrorOWarning(iSesion, "100P307", "W", "PA3(D)")) : (bl &= this.addErrorOWarning(iSesion, "100P307", "W", "PA3(C)")));
        }
        return bl;
    }

    public boolean deduccionAutoRehabVivHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes2) == n + 1) {
                bl = true;
            }
            ++n;
        }
        if (bl || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        n = 1;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "LR5"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "LR5"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT7"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT7"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"));
        if ((this.switchMotor(iSesion, declarantes2) == 15 && d > 0.0 || this.switchMotor(iSesion, declarantes2) != 15 && d2 > 0.0) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPLR5")) > Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"))) {
            n &= this.addErrorOWarning(iSesion, "100R391", "W", "LR5(" + string + ")");
        }
        if ((this.switchMotor(iSesion, declarantes2) == 15 && d3 > 0.0 || this.switchMotor(iSesion, declarantes2) != 15 && d4 > 0.0) && d5 > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCT7")) > Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"))) {
            n &= this.addErrorOWarning(iSesion, "100P478", "W", "CT7(" + string + ")");
        }
        return n != 0;
    }

    public boolean comprobarAcogMenoresCastillaMancha(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        boolean bl2 = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CM11"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CM11"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "D02SCM11"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "D01SCM11"));
        if ((this.switchMotor(iSesion, declarantes2) == 15 && d > 0.0 || this.switchMotor(iSesion, declarantes2) != 15 && d2 > 0.0) && string2.equals(CTE_CASTILLA_LA_MANCHA) && d4 + d3 > 1.0) {
            bl &= this.addErrorOWarning(iSesion, "100R564", "E", "CM11(" + string + ")");
        }
        return bl;
    }

    public boolean comprobarAdquisionLibrosIdiomas(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        if (this.switchMotor(iSesion, declarantes) != 0 && this.switchMotor(iSesion, declarantes) != 1 && this.switchMotor(iSesion, declarantes) != 15) {
            return true;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string2.equals(CTE_CASTILLA_LA_MANCHA)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("INDV"));
            double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1CM10"));
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM2CM10"));
            double d3 = 0.0;
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CM10"));
            Map<String, String> map = this.dameHijo(iSesion, declarantes, true);
            while (map != null) {
                boolean bl3 = "SI".equals(map.get("bR8000"));
                boolean bl4 = "SI".equals(map.get("bDevol"));
                String string3 = map.get("vinculacion");
                int n4 = Integer.parseInt(map.get("edadh"));
                if (!(bl3 || bl4 && this.switchMotor(iSesion, declarantes) != 15 || n4 <= 5 || n4 >= 19)) {
                    if ("A".equals(string3)) {
                        ++n;
                    } else if ("B".equals(string3) || "D".equals(string3)) {
                        ++n2;
                    } else if ("C".equals(string3) || "E".equals(string3)) {
                        ++n3;
                    }
                }
                map = this.dameHijo(iSesion, declarantes, false);
            }
            switch (this.switchMotor(iSesion, declarantes2)) {
                case 0: {
                    if (!((double)n < d || (double)n2 < d2 && !bl2) && (!bl2 || !((double)(n2 + n) < d2)) || !(d4 > 0.0)) break;
                    bl &= this.addErrorOWarning(iSesion, "100P485", "W", "CM10(D)");
                    break;
                }
                case 1: {
                    if (!((double)n < d) && !((double)n3 < d2) || !(d4 > 0.0)) break;
                    bl &= this.addErrorOWarning(iSesion, "100P485", "W", "CM10(C)");
                    break;
                }
                case 15: {
                    if (!(d4 > 0.0)) break;
                    d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM2CM10"));
                    if ((double)n < d || (double)n2 < d2) {
                        bl &= this.addErrorOWarning(iSesion, "100P485", "W", "CM10(D)");
                        break;
                    }
                    if (!((double)n3 < d3)) break;
                    bl &= this.addErrorOWarning(iSesion, "100P485", "W", "CM10(C)");
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        return bl;
    }

    public boolean comprobarTotalNacAcogHijos(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        double d;
        ValidacionesAnxB4 validacionesAnxB4;
        double d2;
        double d3;
        Validaciones validaciones;
        boolean bl = true;
        boolean bl2 = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        String string2 = "";
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string3.equals(CTE_MADRID)) {
            validaciones = new ValidacionesAnxB3(iSesion);
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "M1").trim());
            if (d3 > 0.0 && (string2 = ((ValidacionesAnxB3)validaciones).validacion65_1_6y65_3_5(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM1M1")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1M1")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM2M1")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC2M1")), "M1")).length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R427", "E", "M1(" + string + ")");
            }
            if ((d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "M3").trim())) > 0.0 && (string2 = ((ValidacionesAnxB3)validaciones).validacion65_1_6y65_3_5(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM1M3")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1M3")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM2M3")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC2M3")), "M3")).length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R428", "E", "M3(" + string + ")");
            }
        }
        validaciones = new ValidacionesAnxB2(iSesion);
        if (string3.equals(CTE_CANARIAS) && (d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CAN7").trim())) > 0.0) {
            string2 = ((ValidacionesAnxB2)validaciones).validacion65_3_7(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO1CAN7")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DE1CAN7")));
            if (string2.length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R429", "E", "CAN7(" + string + ")");
            }
            if ((string2 = ((ValidacionesAnxB2)validaciones).validacion65_3_8(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO2CAN7")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DE2CAN7")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO3CAN7")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DE3CAN7")))).length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R430", "E", "CAN7(" + string + ")");
            }
            if ((string2 = ((ValidacionesAnxB2)validaciones).validacion65_3_7(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DCO1CAN7")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DDE1CAN7")))).length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R431", "E", "CAN7(" + string + ")");
            }
        }
        if (string3.equals(CTE_RIOJA) && (d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "LR1").trim())) > 0.0 && (string2 = (validacionesAnxB4 = new ValidacionesAnxB4(iSesion)).validacion74_1_6(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VG11LR1")), Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VG21LR1")))).length() > 0) {
            bl &= this.addErrorOWarning(iSesion, "100R432", "E", "LR1(" + string + ")");
        }
        if (string3.equals(CTE_VALENCIA) && (d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA3").trim())) > 0.0 && (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORCJVA3"))) + (d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORDVA3"))) > 1.0) {
            bl &= this.addErrorOWarning(iSesion, "100R433", "E", "VA3(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionCastillaLeonObrasInspeccionTecnica(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        if (this.switchMotor(iSesion, declarantes2) == 15) {
            string = "J";
        }
        return true;
    }

    public boolean deduccionCastillaLeonObrasViviHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        if (this.switchMotor(iSesion, declarantes2) == 15) {
            string = "J";
        }
        return true;
    }

    public boolean deduccionViviendaHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        boolean bl2 = this.switchMotor(iSesion, declarantes2) == 15;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes2) == n + 1) {
                return true;
            }
            ++n;
        }
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPVH_DIS"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCAN12"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "LR2"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "LR2"));
        if (d > 0.0 && d2 != d && this.dameComunidadDeclarante(iSesion, declarantes2).equals(CTE_CANARIAS)) {
            bl &= this.addErrorOWarning(iSesion, "100P473", "W", "CAN12(" + string + ")");
        }
        String string2 = "";
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BASE1"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"));
        double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CON1"));
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AMP1"));
        double d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPA3"));
        double d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR5"));
        double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR8"));
        double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPPA2"));
        double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPPA3"));
        double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCAN11"));
        double d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCL2"));
        double d16 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCL20"));
        double d17 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPE1"));
        double d18 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1MU1"));
        double d19 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2MU1"));
        double d20 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPLR2"));
        Declarantes declarantes3 = declarantes;
        if (bl2) {
            declarantes3 = Declarantes.UnidadFamiliar;
        }
        boolean bl3 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "A3"));
        boolean bl4 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "AR5"));
        boolean bl5 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "AR8"));
        boolean bl6 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "PA2"));
        boolean bl7 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "PA3"));
        boolean bl8 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "CL2"));
        boolean bl9 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "CL20"));
        boolean bl10 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "E1"));
        boolean bl11 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MU1"));
        boolean bl12 = 0.0 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "LR2"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bl3 && d5 + d6 > 0.0 && d9 > d5 + d6) {
            hashMap.put("A3", CTE_ANDALUCIA);
        }
        if (bl4 && d5 + d7 + d8 > 0.0 && d10 > d5 + d7 + d8) {
            hashMap.put("AR5", CTE_ARAGON);
        }
        if (bl5 && d5 + d7 + d6 + d8 > 0.0 && d11 > d5 + d7 + d6 + d8) {
            hashMap.put("AR8", CTE_ARAGON);
        }
        if (bl6 && d5 + d7 + d6 + d8 + d > 0.0 && d12 + d13 > d5 + d7 + d6 + d8 + d) {
            hashMap.put("PA2", CTE_ASTURIAS);
        }
        if (bl7 && d5 + d7 + d6 + d8 + d > 0.0 && d12 + d13 > d5 + d7 + d6 + d8 + d) {
            hashMap.put("PA3", CTE_ASTURIAS);
        }
        if (bl8 && d5 + d7 + d6 > 0.0 && d15 > d5 + d7 + d6) {
            hashMap.put("CL2", CTE_CASTILLA_LEON);
        }
        if (bl9 && d5 + d7 > 0.0 && d16 > d5 + d7) {
            hashMap.put("CL20", CTE_CASTILLA_LEON);
        }
        if (bl10 && d5 > 0.0 && d17 > d5) {
            hashMap.put("E1", CTE_EXTREMADURA);
        }
        if (bl11 && d5 + d7 + d6 + d8 > 0.0 && d18 + d19 > d5 + d7 + d6 + d8) {
            hashMap.put("MU1", CTE_MURCIA);
        }
        if (declarantes.equals(Declarantes.Declarante)) {
            if (hashMap.containsValue(this.dameComunidadDeclarante(iSesion, declarantes))) {
                string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.dameComunidadDeclarante(iSesion, declarantes)));
            } else if (this.funcrentaValidador.isBConyuge(iSesion) && hashMap.containsValue(this.dameComunidadDeclarante(iSesion, Declarantes.Conyuge))) {
                string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.dameComunidadDeclarante(iSesion, Declarantes.Conyuge)));
            }
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            if (hashMap.containsValue(this.dameComunidadDeclarante(iSesion, declarantes))) {
                string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.dameComunidadDeclarante(iSesion, declarantes)));
            } else if (hashMap.containsValue(this.dameComunidadDeclarante(iSesion, Declarantes.Declarante))) {
                string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.dameComunidadDeclarante(iSesion, Declarantes.Declarante)));
            }
        }
        if (string2.length() > 0) {
            bl &= this.addErrorOWarning(iSesion, "100P474", "W", string2 + "(" + string + ")");
        }
        double d21 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "BIGRALH"));
        double d22 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIGRALH"));
        if (d5 + d7 + d6 + d8 > 0.0 && d14 != d5 + d7 + d6 + d8 && this.dameComunidadDeclarante(iSesion, declarantes2).equals(CTE_CANARIAS) && (bl2 && d21 < 24107.2 || !bl2 && d22 < 24107.2)) {
            bl &= this.addErrorOWarning(iSesion, "100P474", "W", "CAN11(" + string + ")");
        }
        if (d20 > d5 + d7 + d8 && (bl2 && d4 > 0.0 || !bl2 && d3 > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100R578", "E", "LR2(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionAlquilerViviendaHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        double d;
        boolean bl = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        n = 1;
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIGRALH"));
        if (this.cr.redondea(d2 + (d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIAHOH"))), 2) < 24107.2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAL")) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A4")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR10")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PA5")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN13")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CANT1")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL5")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT4")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M5")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA14")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CM13")) > 0.0) {
            n &= this.addErrorOWarning(iSesion, "100P321", "W", "IMPAL(" + string + ")");
        }
        return n != 0;
    }

    public boolean deduccionAndaluciaConyugeDis(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes2.toInt() != 10 && declarantes2.toInt() != 20 || !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ANDALUCIA)) {
            return true;
        }
        boolean bl = true;
        String string2 = "";
        if (this.switchMotor(iSesion, declarantes) == 0) {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPGMIN_C").trim();
        } else if (this.switchMotor(iSesion, declarantes) == 1) {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPGMIN_D").trim();
        }
        if (iSesion.getOperaciones().obtenerPartidaString("CASADO").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECA15").trim().equalsIgnoreCase("TRUE") && !string2.equals("3")) {
            bl &= this.addErrorOWarning(iSesion, "100P407", "E", "A15(" + string + ")");
        }
        Declarantes declarantes3 = null;
        if (this.switchMotor(iSesion, declarantes) == 0) {
            declarantes3 = Declarantes.Conyuge;
        } else if (this.switchMotor(iSesion, declarantes) == 1) {
            declarantes3 = Declarantes.Declarante;
        }
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECA15").trim().equalsIgnoreCase("TRUE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "A8")) > 0.0 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "DECA15").trim().equalsIgnoreCase("TRUE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P410", "W", "A15(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionAndaluciaObrasVivi(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEDU2"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A14"));
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes2) == n + 1) {
                return true;
            }
            ++n;
        }
        if (!this.comprobarCA(iSesion, declarantes2, CTE_ANDALUCIA)) {
            return true;
        }
        n = 1;
        if (d > 0.0 && d2 == 0.0) {
            n &= this.addErrorOWarning(iSesion, "100P411", "W", "A14(" + string + ")");
        }
        if (d == 0.0 && d2 > 0.0) {
            n &= this.addErrorOWarning(iSesion, "100P503", "W", "CANTM2(" + string + ")");
        }
        return n != 0;
    }

    public boolean deduccionAndaluciaAyudaDomestica(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes2) == n + 1) {
                return true;
            }
            ++n;
        }
        if (!this.comprobarCA(iSesion, declarantes2, CTE_ANDALUCIA)) {
            return true;
        }
        n = 1;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A12"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "A12"));
        if ((!declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d2 > 0.0) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPA12")) > 0.0 && this.contadorHijosMenoresOotraSitu2o4 == 0) {
            n &= this.addErrorOWarning(iSesion, "100P372", "W", "A12(" + string + ")");
        }
        return n != 0;
    }

    public boolean deduccionA2Andalucia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes2) == n + 1) {
                return true;
            }
            ++n;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ANDALUCIA)) {
            return true;
        }
        n = 1;
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A2")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G11")) == 0.0) {
            n &= this.addErrorOWarning(iSesion, "100P189", "W", "G11(" + string + ")");
        }
        return n != 0;
    }

    public boolean deduccionGuarderiaCanarias(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CANARIAS)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = declarantes2.equals(Declarantes.UnidadFamiliar);
        if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMDCAN9")) == 1 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CAN9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CAN9")) > 0.0 && (!bl2 || bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAN9")) > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100R395", "W", "CAN9(" + string + ")");
        }
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INDV").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CASADO").trim().equalsIgnoreCase("TRUE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN9")) > 0.0 && (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CAN9")) == 0.0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CAN9")) == 0.0) && Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMDCAN9").trim()) == 2 && (!bl2 || bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAN9")) > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100R396", "W", "CAN9(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionCustodiaHijos(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_GALICIA)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        boolean bl = true;
        String string2 = "";
        boolean bl2 = declarantes2.equals(Declarantes.UnidadFamiliar);
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM1GA3").trim());
        int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM1GA3").trim());
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "GA3"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "GA3"));
        if (!bl2) {
            if (d > 0.0 && d2 > 0.0 && (n == 1 || n2 == 1) && (string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim()))).length() > 0) {
                bl &= this.addErrorOWarning(iSesion, "100R397", "W", "GA3(" + string + ")");
            }
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "GA3")) > 0.0 && (n == 1 && n2 > 0 || n > 0 && n2 == 1) && (string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim()))).length() > 0) {
            bl &= this.addErrorOWarning(iSesion, "100R397", "W", "GA3(" + string + ")");
        }
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim().equals(CTE_GALICIA) && !this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INDV").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CASADO").trim().equalsIgnoreCase("TRUE") && (d > 0.0 && d2 == 0.0 && n == 2 || d2 > 0.0 && d == 0.0 && n2 == 2) && (string2 = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim()))).length() > 0) {
            bl &= this.addErrorOWarning(iSesion, "100R398", "W", string2 + "(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionGuarderiaVariasComunidades(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CANARIAS, CTE_CASTILLA_LEON, CTE_GALICIA)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        d = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "INDV").equalsIgnoreCase("false") && this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CASADO").equalsIgnoreCase("true") ? (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPDIN")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "F1EH") != 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPDIN")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "F1EH") != 0.0 ? 1.0 : 0.0) : (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPDIN")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "F1EH") != 0.0 ? 1.0 : 0.0);
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN9")) > 0.0 && d == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P312", "W", "CAN9(" + string + ")");
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL14")) > 0.0 && d == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P313", "W", "CL14(" + string + ")");
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA3")) > 0.0 && d == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P313", "W", "GA3(" + string + ")");
        }
        return true;
    }

    private boolean deduccionCastillaManchaMayores75(ISesion iSesion) throws Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        if (n != 0 && n != 1 && n != 15) {
            return true;
        }
        if (!this.comprobarCA(iSesion, this.getMISesion(iSesion), CTE_CASTILLA_LA_MANCHA)) {
            return true;
        }
        boolean bl = true;
        if (n == 15) {
            String string = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim();
            int n2 = this.funcrentaValidador.diferenciaEnAnios(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZFNAC_D"), "3112" + Constantes.getEjercicio());
            int n3 = this.funcrentaValidador.diferenciaEnAnios(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZFNAC_C"), "3112" + Constantes.getEjercicio());
            if (string.equals(CTE_CASTILLA_LA_MANCHA)) {
                if (n2 > 74 && !this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZGMIN_D").trim().equals("3") && !Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DECCM5").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100P273", "W", "CM5(D)");
                } else if (n3 > 74 && !this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZGMIN_C").trim().equals("3") && !Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DECCM5").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100P273", "W", "CM5(C)");
                }
            }
            return bl;
        }
        String string = "";
        double d = 0.0;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim();
        if (n == 0) {
            string = "D";
            d = this.calculoD;
        }
        if (n == 1) {
            string = "C";
            d = this.calculoC;
        }
        int n4 = this.funcrentaValidador.diferenciaEnAnios(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZFNAC_D"), "3112" + Constantes.getEjercicio());
        if (string2.equals(CTE_CASTILLA_LA_MANCHA) && n4 > 74 && !this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ZGMIN_D").trim().equals("3") && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DECCM5").equalsIgnoreCase("false")) {
            bl &= this.addErrorOWarning(iSesion, "100P273", "W", "CM5(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionFomentoAutoempleo(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_MADRID)) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        if (this.funcrentaValidador.isBConjunta(iSesion) && declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "M12"));
        }
        if (Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECM12")) && this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1SUMA") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E4AC") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E5AB") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "F1EH") == 0.0 && (declarantes2 != Declarantes.UnidadFamiliar || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P366", "W", "M12(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionAlquilerCatalunya(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl;
        int n;
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_CATALUNYA)) {
            return true;
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        boolean bl2 = true;
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0};
        nArray[0] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM1CT4"));
        nArray[1] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM2CT4"));
        nArray[2] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM3CT4"));
        nArray2[0] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM1CT4"));
        nArray2[1] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM2CT4"));
        nArray2[2] = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM3CT4"));
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 3; ++n) {
            if (nArray[n] != 1 && nArray[n] != 0) {
                bl3 = false;
            }
            if (nArray[n] != 0) {
                if (n2 == 0) {
                    n2 = nArray[n];
                } else if (nArray[n] != n2) {
                    bl4 = false;
                }
            }
            if (nArray2[n] != 1 && nArray2[n] != 0) {
                bl5 = false;
            }
            if (nArray2[n] == 0) continue;
            if (n3 == 0) {
                n3 = nArray2[n];
                continue;
            }
            if (nArray2[n] == n3) continue;
            bl6 = false;
        }
        n = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CT4")) > 0.0 ? 1 : 0;
        boolean bl7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CT4")) > 0.0;
        boolean bl8 = false;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            bl8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT4")) > 0.0;
        }
        boolean bl9 = bl = !declarantes2.equals(Declarantes.UnidadFamiliar) && (bl3 || bl5) && n != 0 && bl7 || declarantes2.equals(Declarantes.UnidadFamiliar) && (bl3 && bl6 || bl5 && bl4) && bl8;
        if (bl) {
            if ((this.switchMotor(iSesion, declarantes2) != 15 || this.switchMotor(iSesion, declarantes2) == 15 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT4")) > 0.0) && this.switchMotor(iSesion, declarantes2) == 15) {
                string = bl3 ? "D" : "C";
            }
            bl2 &= this.addErrorOWarning(iSesion, "100P171", "W", "CT4(" + string + ")");
        }
        return bl2;
    }

    public boolean deduccionViudosCatalunya(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl;
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n7 = 1;
        while ((long)n7 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VINCUHR");
            boolean bl3 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "R8000HR"));
            bl = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEVOLHR"));
            boolean bl4 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FALLOPDLGHR"));
            if (this.funcrentaValidador.isBHijos(iSesion, n7)) {
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)n7);
                String string3 = iSesion.getOperaciones().obtenerPartidaString("FNACHR");
                if (string3 != null && !string3.equalsIgnoreCase("") && !string3.equalsIgnoreCase("0")) {
                    if (!bl3) {
                        if (string2.equals("B")) {
                            if (!bl) {
                                ++n;
                            }
                            ++n2;
                        } else if (string2.equals("C")) {
                            if (!bl) {
                                ++n3;
                            }
                            ++n4;
                        }
                    }
                    if (bl4) {
                        if (string2.equals("D")) {
                            ++n6;
                        } else if (string2.equals("E")) {
                            ++n5;
                        }
                    }
                }
            }
            ++n7;
        }
        iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
        l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTES");
        if (n < Constantes.getChijos()) {
            long l2 = 0L;
            long l3 = iSesion.getOperaciones().moveFirst("DESCENDIENTES");
            long l4 = iSesion.getOperaciones().recordCount("DESCENDIENTES");
            while (l2 != l3) {
                String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VINCU");
                String string5 = iSesion.getOperaciones().obtenerPartidaString("FNAC");
                if (string5 != null && !string5.equalsIgnoreCase("") && !string5.equalsIgnoreCase("0")) {
                    if (string4.equals("B")) {
                        ++n;
                    } else if (string4.equals("C")) {
                        ++n3;
                    }
                }
                l2 = l3;
                if (l3 == l4) continue;
                l3 = iSesion.getOperaciones().moveNext("DESCENDIENTES");
            }
        }
        iSesion.getOperaciones().move("DESCENDIENTES", l);
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DECCT6").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DECCT6").trim().equalsIgnoreCase("TRUE") && (!declarantes2.equals(Declarantes.UnidadFamiliar) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CT6")) > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT6")) > 0.0)) {
            bl2 &= this.addErrorOWarning(iSesion, "100P309", "W", "CT6(" + string + ")");
        }
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT6"));
            boolean bl5 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DESSRCT6"));
            bl = false;
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                bl = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DESSRCT6"));
            }
            if (d > 0.0 && (bl5 && n2 == 0 && n6 == 0 || bl && n4 == 0 && n5 == 0)) {
                String string6 = "D";
                string6 = bl5 && n2 == 0 && n6 == 0 ? "D" : "C";
                bl2 &= this.addErrorOWarning(iSesion, "100P519", "W", "CT6(" + string6 + ")");
            }
        } else {
            double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT6"));
            double d2 = 0.0;
            double d3 = 0.0;
            if (declarantes.equals(Declarantes.Declarante)) {
                d2 = n;
                d3 = n6;
            } else if (declarantes.equals(Declarantes.Conyuge)) {
                d2 = n3;
                d3 = n5;
            }
            if (d == 300.0 && d2 == 0.0 && d3 == 0.0) {
                bl2 &= this.addErrorOWarning(iSesion, "100P519", "W", "CT6(" + string + ")");
            }
        }
        return bl2;
    }

    public boolean deduccionAlquilerExtremadura(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n = this.switchMotor(iSesion, declarantes);
        if (n != 0 && n != 1 && n != 15) {
            return true;
        }
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim().equals(CTE_EXTREMADURA)) {
            return true;
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        boolean bl = true;
        return bl;
    }

    public boolean deduccionAlquilerGalicia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_GALICIA)) {
            return true;
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        ISesion iSesion2 = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            iSesion2 = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
            boolean bl3 = bl2 = iSesion2.getOperaciones().obtenerPartidaString("IMP11GA6").equals("1") || iSesion2.getOperaciones().obtenerPartidaString("IMP21GA6").equals("1") || iSesion2.getOperaciones().obtenerPartidaString("IMP31GA6").equals("1");
            if (!bl2) {
                iSesion2 = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
                bl2 = iSesion2.getOperaciones().obtenerPartidaString("IMP11GA6").equals("1") || iSesion2.getOperaciones().obtenerPartidaString("IMP21GA6").equals("1") || iSesion2.getOperaciones().obtenerPartidaString("IMP31GA6").equals("1");
                string = "C";
            }
            iSesion2 = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        } else {
            boolean bl4 = bl2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP11GA6").equals("1") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP21GA6").equals("1") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP31GA6").equals("1");
        }
        if (bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "GA6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "GA6")) > 0.0 && (declarantes2 != Declarantes.UnidadFamiliar || declarantes2 == Declarantes.UnidadFamiliar && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "GA6")) > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P171", "W", "GA6(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionGastosEducativosMadrid(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n;
        int n2;
        int n3;
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_MADRID)) {
            return true;
        }
        boolean bl = true;
        int n4 = 0;
        int n5 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMEROM8").trim());
        n4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CASADO").equalsIgnoreCase("true") ? 2 : 1;
        if (declarantes2.equals(Declarantes.Declarante) && n5 > n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0 || declarantes2.equals(Declarantes.Conyuge) && n5 > n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P311", "W", "M8(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n5 > n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P311", "W", "M8(D)");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n5 > n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P311", "W", "M8(C)");
        }
        if (declarantes2.equals(Declarantes.Declarante) && this.comprobarCA(iSesion, declarantes, CTE_MADRID) && iSesion.getOperaciones().obtenerPartidaString("CASADO").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INDV").trim().equalsIgnoreCase("false") && n5 > 0 && n5 < n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0 || declarantes2.equals(Declarantes.Conyuge) && this.comprobarCA(iSesion, declarantes, CTE_MADRID) && iSesion.getOperaciones().obtenerPartidaString("CASADO").trim().equalsIgnoreCase("TRUE") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INDV").trim().equalsIgnoreCase("false") && n5 > 0 && n5 < n4 + this.uFhiRegla80063 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P497", "W", "M8(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n5 > 0 && n5 < n4 + this.uFhiRegla80063 && iSesion.getOperaciones().obtenerPartidaString("CASADO").trim().equalsIgnoreCase("TRUE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P497", "W", "M8(D)");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n5 > 0 && n5 < n4 + this.uFhiRegla80063 && iSesion.getOperaciones().obtenerPartidaString("CASADO").trim().equalsIgnoreCase("TRUE") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P497", "W", "M8(C)");
        }
        int n6 = 0;
        int n7 = 0;
        for (n3 = 1; n3 < 7; ++n3) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, stringBuilder.append("IMP").append(String.valueOf(n3)).append("AM8").toString()).trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, stringBuilder2.append("IMP").append(String.valueOf(n3)).append("BM8").toString()).trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, stringBuilder3.append("IMP").append(String.valueOf(n3)).append("CM8").toString()).trim()) > 0.0) {
                ++n6;
            }
            if (!this.funcrentaValidador.isBConyuge(iSesion)) continue;
            StringBuilder stringBuilder4 = new StringBuilder();
            StringBuilder stringBuilder5 = new StringBuilder();
            StringBuilder stringBuilder6 = new StringBuilder();
            if (!(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, stringBuilder4.append("IMP").append(String.valueOf(n3)).append("AM8").toString()).trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, stringBuilder5.append("IMP").append(String.valueOf(n3)).append("BM8").toString()).trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, stringBuilder6.append("IMP").append(String.valueOf(n3)).append("CM8").toString()).trim()) > 0.0)) continue;
            ++n7;
        }
        if (declarantes2.equals(Declarantes.Declarante) && this.hijosDregla80063 < n6 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0 || declarantes2.equals(Declarantes.Conyuge) && this.hijosCregla80063 < n7 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P332", "E", "M8(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && this.hijosDregla80063Conjunta < n6 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P332", "E", "M8(D)");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && this.hijosCregla80063Conjunta < n7 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P332", "E", "M8(C)");
        }
        if (this.funcrentaValidador.isBConyuge(iSesion)) {
            double d = 0.0;
            double d2 = 0.0;
            for (n2 = 1; n2 < 7; ++n2) {
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CONV" + String.valueOf(n2) + "M8").trim().equalsIgnoreCase("1") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
                    d = d + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP" + String.valueOf(n2) + "AM8").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP" + String.valueOf(n2) + "BM8").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP" + String.valueOf(n2) + "CM8").trim());
                }
                if (!this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CONV" + String.valueOf(n2) + "M8").trim().equals("1") || !(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0)) continue;
                d2 = d2 + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP" + String.valueOf(n2) + "AM8").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP" + String.valueOf(n2) + "BM8").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP" + String.valueOf(n2) + "CM8").trim());
            }
            if (d != d2 && Boolean.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CASADO").trim()).booleanValue() && !Boolean.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "INDV").trim()).booleanValue()) {
                bl = declarantes2.equals(Declarantes.UnidadFamiliar) ? (bl &= this.addErrorOWarning(iSesion, "100P333", "W", "M8(D)")) : (bl &= this.addErrorOWarning(iSesion, "100P333", "W", "M8(" + string + ")"));
            }
        }
        n3 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        n2 = 0;
        int n11 = 0;
        for (int i = 1; i < 7; ++i) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CONV" + String.valueOf(i) + "M8").trim().equals("-1")) {
                ++n3;
            }
            if (!this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CONV" + String.valueOf(i) + "M8").trim().equals("-1")) continue;
            ++n8;
        }
        Map<String, String> map = this.dameHijo(iSesion, declarantes, true);
        while (map != null) {
            n = "SI".equals(map.get("bR8000"));
            boolean bl2 = "SI".equals(map.get("bDevol"));
            String string2 = map.get("vinculacion");
            if (n == 0) {
                if ("A".equals(string2) || "D".equals(string2)) {
                    if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                        ++n9;
                    } else if (!bl2) {
                        ++n9;
                    }
                }
                if ("A".equals(string2) || "E".equals(string2)) {
                    if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                        ++n10;
                    } else if (!bl2) {
                        ++n10;
                    }
                }
                if ("B".equals(string2)) {
                    if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                        ++n2;
                    } else if (!bl2) {
                        ++n2;
                    }
                }
                if ("C".equals(string2)) {
                    if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                        ++n11;
                    } else if (!bl2) {
                        ++n11;
                    }
                }
            }
            map = this.dameHijo(iSesion, declarantes, false);
        }
        if (declarantes2.equals(Declarantes.Declarante) && n3 > n2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0 || declarantes2.equals(Declarantes.Conyuge) && n8 > n11 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P391", "W", "M8(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n3 > n2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P391", "W", "M8(D)");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n8 > n11 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P391", "W", "M8(C)");
        }
        n3 = 0;
        n8 = 0;
        for (n = 1; n < 7; ++n) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CONV" + String.valueOf(n) + "M8").trim().equals("1")) {
                ++n3;
            }
            if (!this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CONV" + String.valueOf(n) + "M8").trim().equals("1")) continue;
            ++n8;
        }
        if (declarantes2.equals(Declarantes.Declarante) && n3 > n9 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0 || declarantes2.equals(Declarantes.Conyuge) && n8 > n10 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P502", "W", "M8(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n3 > n9 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P502", "W", "M8(D)");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && n8 > n10 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M8")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P502", "W", "M8(C)");
        }
        return true;
    }

    public boolean deducInvEntidadesCotizadasMadrid(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_MADRID)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPM11")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPM13")) > 0.0;
        boolean bl3 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl4 = bl3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 12;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P334", "W", "M11(" + string + ")");
        }
        return bl;
    }

    public boolean deducInvEntidadesCotizadasGalicia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_GALICIA)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPGA9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP3GA10")) > 0.0;
        boolean bl3 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl4 = bl3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 11;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "GA9")) > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P419", "W", "GA9(" + string + ")");
        }
        boolean bl5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPGA9")) > 0.0;
        boolean bl6 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl7 = bl6 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 11;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl5 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl5 && bl6) {
            bl &= this.addErrorOWarning(iSesion, "100P482", "W", "GA8(" + string + ")");
        }
        boolean bl8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP3GA10")) > 0.0;
        boolean bl9 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl10 = bl6 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 11;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl8 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl8 && bl9) {
            bl &= this.addErrorOWarning(iSesion, "100P483", "W", "GA8(" + string + ")");
        }
        return bl;
    }

    public boolean deducInvEntidadesCotizadasAragon(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ARAGON)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR7")) > 0.0;
        boolean bl3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR7")) > 0.0;
        boolean bl4 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl5 = bl4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 2;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl3 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl4 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P420", "W", "AR7(" + string + ")");
        }
        return bl;
    }

    public boolean deducInvEntidadesCotizadasMurcia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_MURCIA)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPMU6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPMU7")) > 0.0;
        boolean bl3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MU6")) > 0.0;
        boolean bl4 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl5 = bl4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 13;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl3 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl4 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P486", "W", "MU6(" + string + ")");
        }
        return bl;
    }

    public boolean deducInvAccionesEntidadesAragon(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ARAGON)) {
            return true;
        }
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1CANTRC"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2CANTRC"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR7"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BASEDEDU"));
        boolean bl = true;
        boolean bl2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED0E")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR7")) > 0.0;
        boolean bl3 = d + d2 - d4 < d3;
        boolean bl4 = true;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl5 = bl4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CAOC").trim()) == 2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "AR7")) > 0.0;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl3 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl2 && bl4 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P521", "W", "AR7(" + string + ")");
        }
        return bl;
    }

    private boolean deducInvEntidadesCotizadas(ISesion iSesion) throws Exception {
        if (!(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_MADRID) || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_GALICIA) || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_ARAGON))) {
            return true;
        }
        boolean bl = true;
        String string = "";
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                string = "D";
                break;
            }
            case 1: {
                string = "C";
                break;
            }
            case 15: {
                string = "J";
                if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC").trim()) == 12) {
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M11")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "M13")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P334", "W", "M11(D)");
                    } else if (this.funcrentaValidador.isBConyuge(iSesion) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M11")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "M13")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P334", "W", "M11(C)");
                    }
                } else if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC").trim()) == 11) {
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMPGA9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP3GA10")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P419", "W", "GA9(D)");
                    } else if (this.funcrentaValidador.isBConyuge(iSesion) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMPGA9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP3GA10")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P419", "W", "GA9(C)");
                    }
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMPGA9")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P482", "W", "GA8(D)");
                    } else if (this.funcrentaValidador.isBConyuge(iSesion) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMPGA9")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P482", "W", "GA8(C)");
                    }
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP3GA10")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P483", "W", "GA8(D)");
                    } else if (this.funcrentaValidador.isBConyuge(iSesion) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP3GA10")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P483", "W", "GA8(C)");
                    }
                } else if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC").trim()) == 2) {
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "AR6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "AR7")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P420", "W", "AR7(D)");
                    } else if (this.funcrentaValidador.isBConyuge(iSesion) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "AR6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "AR7")) > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100P420", "W", "AR7(C)");
                    }
                }
                return bl;
            }
            default: {
                return true;
            }
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "M11")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPM13")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P334", "W", "M11(" + string + ")");
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "GA9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPGA9")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMP3GA10")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P419", "W", "GA9(" + string + ")");
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "GA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPGA9")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P482", "W", "GA8(" + string + ")");
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "GA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPGA8")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMP3GA10")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P483", "W", "GA8(" + string + ")");
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "AR6")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IMPAR7")) > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P420", "W", "AR7(" + string + ")");
        }
        return bl;
    }

    private int compruebaNan(int n) {
        if (n == 0) {
            return 1;
        }
        return n;
    }

    public boolean coherenciaDeducAutonomicaHijos(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2)).trim();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        String string3 = string;
        Declarantes declarantes3 = Declarantes.Conyuge;
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                n = this.hijosDAregla80075;
                n2 = this.hijosCAregla80075;
                n3 = this.hijosDregla80075;
                n4 = this.hijosCregla80075;
                n5 = this.hijos2DAregla80075;
                n6 = this.hijos2CAregla80075;
                n7 = this.hijos2Dregla80075;
                n8 = this.hijos2Cregla80075;
                n9 = this.nADOPDA;
                n10 = this.nADOPD;
                break;
            }
            case 1: {
                declarantes3 = Declarantes.Declarante;
                n = this.hijosCAregla80075;
                n2 = this.hijosDAregla80075;
                n3 = this.hijosCregla80075;
                n4 = this.hijosDregla80075;
                n5 = this.hijos2CAregla80075;
                n6 = this.hijos2DAregla80075;
                n7 = this.hijos2Cregla80075;
                n8 = this.hijos2Dregla80075;
                n9 = this.nADOPCA;
                n10 = this.nADOPC;
                break;
            }
            default: {
                return true;
            }
        }
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            string3 = "J";
        }
        int n11 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONV1GA1").trim().equals("1")) {
            n11 = 2;
        }
        int n12 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONV2GA1").trim().equals("1")) {
            n12 = 2;
        }
        int n13 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONVM1").trim().equals("1")) {
            n13 = 2;
        }
        int n14 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONVLR1").trim().equals("1")) {
            n14 = 2;
        }
        int n15 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONVAR2").trim().equals("1")) {
            n15 = 2;
        }
        int n16 = 1;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONVM2").trim().equals("1")) {
            n16 = 2;
        }
        switch (this.cTEProvincia2Integer(string2)) {
            case 1: {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                int n17 = 0;
                int n18 = 0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A7").trim());
                    d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C01A7").trim());
                    d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C01A7").trim());
                    d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C02A7").trim());
                    d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C02A7").trim());
                    n17 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM1A7").trim());
                    if (this.funcrentaValidador.isBConyuge(iSesion)) {
                        d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C01A7").trim());
                        d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C02A7").trim());
                        n18 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM1A7").trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d > 0.0) || !((double)(n10 + n9) < d2 + d3) && !((double)(this.nADOPD + this.nADOPC) + 0.5 * (double)this.nADOPDA + 0.5 * (double)this.nADOPCA < Math.abs(0.5 * d4 + 0.5 * d5 + d6 / (double)this.compruebaNan(n17) + d7 / (double)this.compruebaNan(n18)))) break;
                bl &= this.addErrorOWarning(iSesion, "100R402", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 2: {
                double d = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                int n19 = 0;
                double d11 = 1.0;
                double d12 = 0.0;
                double d13 = 0.0;
                double d14 = 0.0;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                try {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    int n24 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONVAR14"));
                    d11 = 1.0;
                    if (n24 == 1) {
                        d11 = 2.0;
                    }
                    if ((string7 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM1AR14")).equalsIgnoreCase("true")) {
                        n20 = 1;
                    }
                    if ((string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM2AR14")).equalsIgnoreCase("true")) {
                        n21 = 1;
                    }
                    if ((string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1AR14")).equalsIgnoreCase("true")) {
                        n22 = 1;
                    }
                    if ((string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC2AR14")).equalsIgnoreCase("true")) {
                        n23 = 1;
                    }
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO1AR1").trim());
                    d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO1AR2").trim());
                    d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO2AR1").trim());
                    d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO2AR2").trim());
                    n19 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1AR1").trim());
                    d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR1").trim());
                    d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR2").trim());
                    d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR14").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d12 > 0.0 && (double)n3 + 0.5 * (double)n < 0.5 * d + d9 / (double)this.compruebaNan(n19)) {
                    bl &= this.addErrorOWarning(iSesion, "100R400", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                }
                if (d13 > 0.0 && (double)n10 + 0.5 * (double)n9 < 0.5 * d8 + d10 / (double)this.compruebaNan(n15)) {
                    bl &= this.addErrorOWarning(iSesion, "100R401", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                }
                if (!(d14 > 0.0) || !((double)n3 + 0.5 * (double)n < 0.5 * (double)(n20 + n21) + (double)(n22 + n23) / d11)) break;
                bl &= this.addErrorOWarning(iSesion, "100P520", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 3: {
                double d = 0.0;
                double d15 = 0.0;
                int n25 = 0;
                double d16 = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C01PA9").trim());
                    d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C02PA9").trim());
                    n25 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1PA9").trim());
                    d16 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PA9").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d16 > 0.0) || !((double)n10 + 0.5 * (double)n9 < 0.5 * d + d15 / (double)this.compruebaNan(n25))) break;
                bl &= this.addErrorOWarning(iSesion, "100R401", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 5: {
                double d = 0.0;
                int n26 = 0;
                int n27 = 0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN7").trim());
                    n26 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1CAN7").trim());
                    n27 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1CAN7").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d17 = this.sumatorioDobles(iSesion, declarantes, "CO", "CAN7", 1);
                double d18 = this.sumatorioDobles(iSesion, declarantes, "DE", "CAN7", 1);
                double d19 = this.sumatorioDobles(iSesion, declarantes3, "CO", "CAN7", 1);
                double d20 = this.sumatorioDobles(iSesion, declarantes3, "DE", "CAN7", 1);
                if (!(d > 0.0) || !((double)(n3 + n) < d17 + d18) && !((double)(n3 + n4) + 0.5 * (double)n + 0.5 * (double)n2 < 0.5 * d17 + 0.5 * d19 + d18 / (double)this.compruebaNan(n26) + d20 / (double)this.compruebaNan(n27))) break;
                bl &= this.addErrorOWarning(iSesion, "100R568", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 8: {
                double d = 0.0;
                double d21 = 0.0;
                double d22 = 0.0;
                int n28 = 0;
                int n29 = 0;
                double d23 = 0.0;
                double d24 = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL16").trim());
                    d21 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1CL16").trim());
                    d22 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC2CL16").trim());
                    n28 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1CL16").trim());
                    n29 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM2CL16").trim());
                    d23 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM1CL16").trim());
                    d24 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM2CL16").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d > 0.0) || !((double)n10 + 0.5 * (double)n9 < d21 / (double)this.compruebaNan(n28) + d22 / (double)this.compruebaNan(n29) + 0.5 * (d23 + d24))) break;
                bl &= this.addErrorOWarning(iSesion, "100R462", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 9: {
                double d = 0.0;
                double d25 = 0.0;
                double d26 = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT1").trim());
                    d25 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C01CT1").trim());
                    d26 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C02CT1").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d > 0.0) || (double)(n3 + n) == d25 + d26) break;
                bl &= this.addErrorOWarning(iSesion, "100R400", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                double d = 0.0;
                double d27 = 0.0;
                double d28 = 0.0;
                double d29 = 0.0;
                double d30 = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA1").trim());
                    d27 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "O1GA1").trim());
                    d28 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "D1GA1").trim());
                    d29 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "O2GA1").trim());
                    d30 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "D2GA1").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d > 0.0 && (double)n3 + 0.5 * (double)n != 0.5 * d27 + d28 / (double)this.compruebaNan(n11)) {
                    bl &= this.addErrorOWarning(iSesion, "100R400", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                }
                if (!(d > 0.0) || (double)n7 + 0.5 * (double)n5 == 0.5 * d29 + d30 / (double)this.compruebaNan(n12)) break;
                bl &= this.addErrorOWarning(iSesion, "100R569", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 12: {
                double d = this.sumatorioDobles(iSesion, declarantes, "COM", "M1", 1, 3);
                double d31 = this.sumatorioDobles(iSesion, declarantes, "DEC", "M1", 1, 3);
                double d32 = 0.0;
                double d33 = 0.0;
                double d34 = 0.0;
                try {
                    d32 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M1").trim());
                    d33 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M2").trim());
                    d34 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIGRALH").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d35 = 0.0;
                try {
                    d35 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIAHOH").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d32 > 0.0 && (double)n3 + 0.5 * (double)n != 0.5 * d + d31 / (double)this.compruebaNan(n13) && d34 + d35 <= 25620.0) {
                    bl &= this.addErrorOWarning(iSesion, "100R400", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                }
                double d36 = 0.0;
                double d37 = 0.0;
                try {
                    d36 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C01M2").trim());
                    d37 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C02M2").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d33 > 0.0) || !((double)n10 + 0.5 * (double)n9 < 0.5 * d36 + d37 / (double)this.compruebaNan(n16))) break;
                bl &= this.addErrorOWarning(iSesion, "100R401", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 16: {
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "LR1").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d38 = this.sumatorioDobles(iSesion, declarantes, "VG1", "LR1", 1);
                double d39 = this.sumatorioDobles(iSesion, declarantes, "VG2", "LR1", 1);
                if (!(d > 0.0) || !((double)n3 + 0.5 * (double)n < 0.5 * d38 + d39 / (double)this.compruebaNan(n14))) break;
                bl &= this.addErrorOWarning(iSesion, "100R400", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                break;
            }
            case 17: {
                double d = 0.0;
                double d40 = 0.0;
                double d41 = 0.0;
                double d42 = 0.0;
                double d43 = 0.0;
                double d44 = 0.0;
                double d45 = 0.0;
                double d46 = 0.0;
                double d47 = 0.0;
                double d48 = 0.0;
                double d49 = 0.0;
                try {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA1").trim());
                    d40 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1VA1").trim());
                    if (d40 == 0.0) {
                        d40 = 1.0;
                    }
                    if ((d41 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1VA1").trim())) == 0.0) {
                        d41 = 1.0;
                    }
                    d42 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORCJVA1").trim());
                    d43 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORCJVA1").trim());
                    d44 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORDVA1").trim());
                    d45 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORDVA1").trim());
                    d46 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOSCJVA1").trim());
                    d47 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSCJVA1").trim());
                    d48 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOSDVA1").trim());
                    d49 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSDVA1").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d > 0.0 && ((double)(n3 + n) < d42 + d44 || (double)(n3 + n4) + 0.5 * (double)n + 0.5 * (double)n2 < 0.5 * d42 + d44 / d40 + 0.5 * d43 + d45 / d41)) {
                    bl &= this.addErrorOWarning(iSesion, "100R568", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
                }
                if (!(d > 0.0) || !((double)(n7 + n5) < d46 + d48) && !((double)(n7 + n8) + 0.5 * (double)n5 + 0.5 * (double)n6 < 0.5 * d46 + d48 / d40 + 0.5 * d47 + d49 / d41)) break;
                bl &= this.addErrorOWarning(iSesion, "100R569", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string3 + ")");
            }
        }
        return bl;
    }

    public boolean coherenciaPartosMultiples(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        if (!this.comprobarCA(iSesion, declarantes, CTE_ASTURIAS, CTE_VALENCIA, CTE_EXTREMADURA)) {
            return true;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim();
        boolean bl = string2.equals(CTE_ASTURIAS);
        boolean bl2 = string2.equals(CTE_VALENCIA);
        boolean bl3 = string2.equals(CTE_EXTREMADURA);
        boolean bl4 = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BLGRAL"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BLAHOJ"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIGRALH"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BIAHOH"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PA10"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA2"));
        double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E7"));
        double d8 = 0.0;
        double d9 = 0.0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d8 = 40000.0;
            d9 = 24000.0;
        } else {
            d8 = 25000.0;
            d9 = 19000.0;
        }
        if (bl || bl2) {
            if (!this.bMULTIPLE && d5 + d6 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100R403", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
            }
            if (this.bMULTIPLE && bl && d5 == 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100R404", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
            } else if (this.bMULTIPLE && bl2 && d6 == 0.0 && this.cr.redondea(d + d2, 2) <= d8) {
                bl4 &= this.addErrorOWarning(iSesion, "100R404", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
            }
        } else if (bl3) {
            if (!this.bPARTOMU && d7 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100P369", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
            }
            if (bl3 && d7 == 0.0 && this.bPARTOMU && d3 + d4 <= d9) {
                bl4 &= this.addErrorOWarning(iSesion, "100P370", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
                this.bPARTOMU = false;
            }
        }
        return bl4;
    }

    private boolean coherenciaNacHijosDiscapacitados(ISesion iSesion, Declarantes declarantes) throws Exception {
        int n;
        Declarantes declarantes2 = declarantes;
        Declarantes declarantes3 = declarantes;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA3"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN7"));
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            declarantes3 = Declarantes.Declarante;
        }
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORCJVA3"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSCJVA3"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORDVA3"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSDVA3"));
        int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1VA3"));
        if (n2 == 0) {
            n2 = 1;
        }
        if ((n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1BCAN7"))) == 0) {
            n = 1;
        }
        double d7 = this.sumatorioDobles(iSesion, declarantes3, "DCO", "CAN7", 1);
        double d8 = this.sumatorioDobles(iSesion, declarantes3, "DDE", "CAN7", 1);
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d13 = 0.0;
        double d14 = 0.0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar) || declarantes2.equals(Declarantes.Declarante)) {
            declarantes3 = Declarantes.Conyuge;
        } else if (declarantes2.equals(Declarantes.Conyuge)) {
            declarantes3 = Declarantes.Declarante;
        }
        d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORCJVA3"));
        d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSCJVA3"));
        d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "MENORDVA3"));
        d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "HIJOSDVA3"));
        n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1VA3"));
        if (n3 == 0) {
            n3 = 1;
        }
        if ((n4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "NUM1BCAN7"))) == 0) {
            n4 = 1;
        }
        d13 = this.sumatorioDobles(iSesion, declarantes3, "DCO", "CAN7", 1);
        d14 = this.sumatorioDobles(iSesion, declarantes3, "DDE", "CAN7", 1);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        switch (this.switchMotor(iSesion, declarantes2)) {
            case 0: {
                n5 = this.nHDISD;
                n6 = this.nHDISDA;
                n7 = this.nHDIS65D;
                n8 = this.nHDIS65DA;
                break;
            }
            case 1: {
                n5 = this.nHDISC;
                n6 = this.nHDISCA;
                n7 = this.nHDIS65C;
                n8 = this.nHDIS65CA;
                break;
            }
            case 15: {
                n9 = this.nHDISD;
                n10 = this.nHDISDA;
                n11 = this.nHDIS65D;
                n12 = this.nHDIS65DA;
                n13 = this.nHDISC;
                n14 = this.nHDISCA;
                n15 = this.nHDIS65C;
                n16 = this.nHDIS65CA;
            }
        }
        int n17 = 0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            try {
                n17 = Integer.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CAOC").trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n17 == 17 && d > 0.0 && ((double)(n9 + n10) < d3 + d4 + (d5 + d6) || (double)(n13 + n14) < d9 + d10 + (d11 + d12) || (double)(this.nHDISD + this.nHDISC) + 0.5 * (double)this.nHDISDA + 0.5 * (double)this.nHDISCA < Math.abs(0.5 * (d3 + d4 + d9 + d10) + d5 / (double)n2 + d6 / (double)n2 + d11 / (double)n3 + d12 / (double)n3))) {
                return false;
            }
            if (n17 == 5 && d2 > 0.0 && ((double)(n11 + n12) < d7 + d8 || (double)(n15 + n16) < d13 + d14 || (double)(this.nHDIS65D + this.nHDIS65C) + 0.5 * (double)this.nHDIS65DA + 0.5 * (double)this.nHDIS65CA < Math.abs(0.5 * d7 + d8 / (double)n + d14 / (double)n4 + 0.5 * d13))) {
                return false;
            }
        } else {
            try {
                n17 = Integer.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZCCAD").trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n17 == 17 && d > 0.0 && ((double)(n5 + n6) < d3 + d4 + d5 + d6 || (double)(this.nHDISD + this.nHDISC) + 0.5 * (double)this.nHDISDA + 0.5 * (double)this.nHDISCA < Math.abs(0.5 * (d3 + d4 + d9 + d10) + d5 / (double)n2 + d6 / (double)n2 + d11 / (double)n3 + d12 / (double)n3))) {
                return false;
            }
            if (n17 == 5 && d2 > 0.0 && ((double)(n7 + n8) < d7 + d8 || (double)(this.nHDIS65D + this.nHDIS65C) + 0.5 * (double)this.nHDIS65DA + 0.5 * (double)this.nHDIS65CA < Math.abs(0.5 * d7 + d8 / (double)n + d14 / (double)n4 + 0.5 * d13))) {
                return false;
            }
        }
        return true;
    }

    private boolean coherenciaNacHijosDiscapacitados(ISesion iSesion) throws Exception {
        boolean bl = true;
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                if (!this.coherenciaNacHijosDiscapacitados(iSesion, this.getMISesion(iSesion))) {
                    bl &= this.addErrorOWarning(iSesion, "100R405", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))))) + "(D)");
                }
                return bl;
            }
            case 1: {
                if (!this.coherenciaNacHijosDiscapacitados(iSesion, this.getMISesion(iSesion))) {
                    bl &= this.addErrorOWarning(iSesion, "100R405", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))))) + "(C)");
                }
                return bl;
            }
            case 15: {
                if (!this.coherenciaNacHijosDiscapacitados(iSesion, Declarantes.UnidadFamiliar)) {
                    bl &= this.addErrorOWarning(iSesion, "100R405", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))))) + "(J)");
                }
                return bl;
            }
        }
        return true;
    }

    private boolean coherenciaDiscapBaleares(ISesion iSesion) throws Exception {
        boolean bl = true;
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_BALEARES)) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DPGMIN_D").trim().length() > 0) {
            n = 1;
        }
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DPGMIN_C").trim().length() > 0) {
            n2 = 1;
        }
        String string = "";
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                string = "D";
                break;
            }
            case 1: {
                string = "C";
                break;
            }
            case 15: {
                string = "J";
            }
        }
        int n3 = 1;
        while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, this.getMISesion(iSesion)) == n3 + 1) {
                string = "" + n3 + "";
                break;
            }
            ++n3;
        }
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IB3").trim()) > 0.0 && (double)(this.iNUMEROA + this.iNUMEROD + n + n2) < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM1IB3").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM2IB3").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100R406", "W", "IB3(" + string + ")");
                }
                return bl;
            }
            case 1: {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IB3").trim()) > 0.0 && (double)(this.iNUMEROA + this.iNUMEROC + n + n2) < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM1IB3").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM2IB3").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100R406", "W", "IB3(" + string + ")");
                }
                return bl;
            }
            case 15: {
                n3 = 0;
                try {
                    n3 = Integer.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 == 4 && (double)(this.iNUMEROA + this.iNUMEROD + this.iNUMEROC + n + n2) < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "UF1IB3").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "UF2IB3").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100R406", "W", "IB3(" + string + ")");
                }
                return bl;
            }
        }
        n3 = 1;
        while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, this.getMISesion(iSesion)) == n3 + 1) {
                boolean bl2 = false;
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)n3);
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "MINUSHR").trim().length() > 0) {
                    bl2 = true;
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "IB3").trim()) > 0.0 && (double)bl2 < Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM1IB3").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "COM2IB3").trim())) {
                    bl &= this.addErrorOWarning(iSesion, "100R407", "W", "IB3(" + string + ")");
                }
                return bl;
            }
            ++n3;
        }
        return bl;
    }

    private boolean coherenciaBenefAyudasFamiliares(ISesion iSesion) throws Exception {
        boolean bl = true;
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_ANDALUCIA)) {
            return true;
        }
        String string = "";
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                string = "D";
                break;
            }
            case 1: {
                string = "C";
                break;
            }
            case 15: {
                string = "J";
                break;
            }
            default: {
                return true;
            }
        }
        if ((this.numTotalDeHijos <= 2 || this.numHijosMenoresDe4Anyos <= 0) && !this.bPARTOM && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "A1").trim()) > 0.0) {
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim();
            bl &= this.addErrorOWarning(iSesion, "100R408", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
        }
        return bl;
    }

    private boolean deducAscendientes(ISesion iSesion) throws Exception {
        Declarantes declarantes;
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = 0;
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_VALENCIA)) {
            declarantes = null;
            declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
            d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C01VA8").trim());
            d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C02VA8").trim());
            n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM1VA8").trim());
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VA8").trim());
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
                d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C01VA8").trim());
                d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C02VA8").trim());
                n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM1VA8").trim());
                d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VA8").trim());
            }
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
            switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
                case 0: {
                    if (!(d2 > 0.0) || !((double)this.contadorAscDeduc < d4 + d5) && !((double)this.contadorAscDeduc < d5 / (double)n + d7 / (double)n2 + 0.5 * (d4 + d6))) break;
                    bl &= this.addErrorOWarning(iSesion, "100R409", "W", "VA8(D)");
                    break;
                }
                case 1: {
                    if (!(d3 > 0.0) || !((double)this.contadorAscDeduc < d6 + d7) && !((double)this.contadorAscDeduc < d5 / (double)n + d7 / (double)n2 + 0.5 * (d4 + d6))) break;
                    bl &= this.addErrorOWarning(iSesion, "100R409", "W", "VA8(C)");
                    break;
                }
                case 15: {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA8").trim());
                    if (!(d > 0.0) || !((double)this.contadorAscDeduc < d4 + d5) && !((double)this.contadorAscDeduc < d5 / (double)this.compruebaNan(n) + d7 / (double)this.compruebaNan(n2) + 0.5 * (d4 + d6))) break;
                    if (d2 > 0.0) {
                        bl &= this.addErrorOWarning(iSesion, "100R409", "W", "VA8(D)");
                        break;
                    }
                    if (!this.funcrentaValidador.isBConyuge(iSesion) || !(d3 > 0.0)) break;
                    bl &= this.addErrorOWarning(iSesion, "100R409", "W", "VA8(C)");
                }
            }
        } else {
            return true;
        }
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        return bl;
    }

    private boolean deducFamiliaresDiscapacitados(ISesion iSesion) throws NumberFormatException, Exception {
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_EXTREMADURA)) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "E3").trim());
                if (!(d4 > 0.0) || !((d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C01E3").trim())) + (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C02E3").trim())) > (double)(this.contadorPCTMINAS3d + this.contadorMINUS3d))) break;
                bl &= this.addErrorOWarning(iSesion, "100R410", "W", "E3(D)");
                break;
            }
            case 1: {
                d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "E3").trim());
                if (!(d4 > 0.0) || !((d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C01E3").trim())) + (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C02E3").trim())) > (double)(this.contadorPCTMINAS3c + this.contadorMINUS3c))) break;
                bl &= this.addErrorOWarning(iSesion, "100R410", "W", "E3(C)");
                break;
            }
            case 15: {
                d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "E3").trim());
                if (!(d3 > 0.0)) break;
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C01E3").trim());
                if (d + (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "C02E3").trim())) > (double)(this.contadorPCTMINAS3d + this.contadorMINUS3d)) {
                    bl &= this.addErrorOWarning(iSesion, "100R410", "W", "E3(D)");
                    break;
                }
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C01E3").trim());
                if (!(d + (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "C02E3").trim())) > (double)(this.contadorPCTMINAS3c + this.contadorMINUS3c))) break;
                bl &= this.addErrorOWarning(iSesion, "100R410", "W", "E3(C)");
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean coherenciaVivHabGuarderia(ISesion iSesion, Declarantes declarantes, int n) throws Exception {
        boolean bl = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FAMNUMCT4"));
        boolean bl2 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FAMNMU3"));
        boolean bl3 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "NCONIB6"));
        boolean bl4 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "NUMAR9"));
        boolean bl5 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FAMNUMCM10"));
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: 
            case 1: {
                switch (n) {
                    case 1: {
                        if (!bl || n2 != 9 || this.fNum) return true;
                        return false;
                    }
                    case 2: {
                        if (!bl2 || n2 != 13 || this.fNum) return true;
                        return false;
                    }
                    case 3: {
                        if (!bl3 || n2 != 4 || this.fNum) return true;
                        return false;
                    }
                    case 4: {
                        if (!bl4 || n2 != 2 || this.fNum) return true;
                        return false;
                    }
                    case 5: {
                        if (!bl5 || n2 != 7 || this.fNum) return true;
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    private boolean coherenciaVivHabGuarderia(ISesion iSesion) throws Exception {
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CT4").trim());
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "MU3").trim());
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "IB6").trim());
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "AR9").trim());
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CM10").trim());
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CT4").trim());
                d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "MU3").trim());
                d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IB6").trim());
                d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "AR9").trim());
                d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CM10").trim());
                if (d6 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 1)) {
                    bl &= this.addErrorOWarning(iSesion, "100R411", "W", "CT4(D)");
                }
                if (d7 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R412", "W", "MU3(D)");
                }
                if (d8 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 3)) {
                    bl &= this.addErrorOWarning(iSesion, "100R510", "W", "IB6(D)");
                }
                if (d9 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 4)) {
                    bl &= this.addErrorOWarning(iSesion, "100P475", "W", "AR9(D)");
                }
                if (!(d10 > 0.0) || this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 5)) break;
                bl &= this.addErrorOWarning(iSesion, "100P476", "W", "CM10(D)");
                break;
            }
            case 1: {
                d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CT4").trim());
                d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "MU3").trim());
                d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IB6").trim());
                d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "AR9").trim());
                d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CM10").trim());
                if (d6 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 1)) {
                    bl &= this.addErrorOWarning(iSesion, "100R411", "W", "CT4(C)");
                }
                if (d7 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R412", "W", "MU3(C)");
                }
                if (d8 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 3)) {
                    bl &= this.addErrorOWarning(iSesion, "100R510", "W", "IB6(C)");
                }
                if (d9 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 4)) {
                    bl &= this.addErrorOWarning(iSesion, "100P475", "W", "AR9(C)");
                }
                if (!(d10 > 0.0) || this.coherenciaVivHabGuarderia(iSesion, this.getMISesion(iSesion), 5)) break;
                bl &= this.addErrorOWarning(iSesion, "100P476", "W", "CM10(C)");
                break;
            }
            case 15: {
                if (d > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Declarante, 1)) {
                    bl &= this.addErrorOWarning(iSesion, "100R411", "W", "CT4(D)");
                } else if (d > 0.0 && this.funcrentaValidador.isBConyuge(iSesion) && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Conyuge, 1)) {
                    bl &= this.addErrorOWarning(iSesion, "100R411", "W", "CT4(C)");
                }
                if (d2 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Declarante, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R412", "W", "MU3(D)");
                } else if (d2 > 0.0 && this.funcrentaValidador.isBConyuge(iSesion) && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Conyuge, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R412", "W", "MU3(C)");
                }
                if (d3 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Declarante, 3)) {
                    bl &= this.addErrorOWarning(iSesion, "100R510", "W", "IB6(D)");
                } else if (d3 > 0.0 && this.funcrentaValidador.isBConyuge(iSesion) && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Conyuge, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R510", "W", "IB6(C)");
                }
                if (d4 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Declarante, 4)) {
                    bl &= this.addErrorOWarning(iSesion, "100P475", "W", "AR9(D)");
                } else if (d4 > 0.0 && this.funcrentaValidador.isBConyuge(iSesion) && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Conyuge, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100P475", "W", "AR9(C)");
                }
                if (d5 > 0.0 && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Declarante, 5)) {
                    bl &= this.addErrorOWarning(iSesion, "100P476", "W", "CM10(D)");
                } else if (d5 > 0.0 && this.funcrentaValidador.isBConyuge(iSesion) && !this.coherenciaVivHabGuarderia(iSesion, Declarantes.Conyuge, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100P476", "W", "CM10(C)");
                }
                return bl;
            }
            default: {
                return true;
            }
        }
        return bl;
    }

    public boolean coherenciaDescGuarderia(ISesion iSesion, Declarantes declarantes) throws Exception {
        double d;
        double d2;
        double d3;
        boolean bl = false;
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN9"));
        if (d4 + (d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MU3"))) + (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA5"))) + (d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E10"))) > 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean coherenciaDescCuidado(ISesion iSesion, Declarantes declarantes) throws Exception {
        boolean bl = false;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA3"));
        if (d > 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean coherenciaDescGuarderia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n = this.switchMotor(iSesion, declarantes);
        if (n != 0 && n != 1 && n != 15) {
            return true;
        }
        int n2 = this.switchMotor(iSesion, declarantes2);
        if (n2 != 0 && n2 != 1 && n2 != 15) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes)).trim();
        switch (this.cTEProvincia2Integer(string2)) {
            case 5: {
                bl = this.numHijosMenoresDe4VinculacionXR80083d > 0;
                bl2 = this.numHijosMenoresDe4VinculacionXR80083c > 0;
                break;
            }
            case 10: {
                if (n2 == 15) {
                    bl = this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntad > 0;
                    bl2 = this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntac > 0;
                    break;
                }
                bl = this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083d > 0;
                bl2 = this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083c > 0;
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                bl = this.numHijosMenoresDe4OtrosNo1VinculacionXR800083d > 0;
                bl2 = this.numHijosMenoresDe4OtrosNo1VinculacionXR800083c > 0;
                break;
            }
            default: {
                return true;
            }
        }
        boolean bl3 = true;
        switch (this.switchMotor(iSesion, declarantes2)) {
            case 0: {
                if (this.coherenciaDescGuarderia(iSesion, Declarantes.Declarante) && !bl) {
                    bl3 &= this.addErrorOWarning(iSesion, "100P437", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
                }
                if (!this.coherenciaDescCuidado(iSesion, Declarantes.Declarante) || bl) break;
                bl3 &= this.addErrorOWarning(iSesion, "100P438", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
                break;
            }
            case 1: {
                if (this.coherenciaDescGuarderia(iSesion, Declarantes.Conyuge) && !bl2) {
                    bl3 &= this.addErrorOWarning(iSesion, "100P437", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
                }
                if (!this.coherenciaDescCuidado(iSesion, Declarantes.Conyuge) || bl2) break;
                bl3 &= this.addErrorOWarning(iSesion, "100P438", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
                break;
            }
            case 15: {
                double d = 0.0;
                double d2 = 0.0;
                int n3 = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "VAL2" + String.valueOf(n3) + "CAN9")) {
                    d += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VAL2" + String.valueOf(n3) + "CAN9"));
                    d2 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VAL2" + String.valueOf(n3) + "CAN9"));
                    ++n3;
                }
                double d3 = 0.0;
                double d4 = 0.0;
                n3 = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "VAL" + String.valueOf(n3) + "OMU3")) {
                    d3 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VAL" + String.valueOf(n3) + "OMU3"));
                    d4 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VAL" + String.valueOf(n3) + "OMU3"));
                    ++n3;
                }
                double d5 = 0.0;
                double d6 = 0.0;
                n3 = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "VAL" + String.valueOf(n3) + "DMU3")) {
                    d5 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VAL" + String.valueOf(n3) + "DMU3"));
                    d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VAL" + String.valueOf(n3) + "DMU3"));
                    ++n3;
                }
                double d7 = 0.0;
                double d8 = 0.0;
                n3 = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "VAL2" + String.valueOf(n3) + "VA5")) {
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VAL2" + String.valueOf(n3) + "VA5"));
                    d8 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VAL2" + String.valueOf(n3) + "VA5"));
                    ++n3;
                }
                double d9 = 0.0;
                double d10 = 0.0;
                n3 = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "IMP" + String.valueOf(n3) + "E10")) {
                    d9 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP" + String.valueOf(n3) + "E10"));
                    d10 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP" + String.valueOf(n3) + "E10"));
                    ++n3;
                }
                if (this.coherenciaDescGuarderia(iSesion, Declarantes.UnidadFamiliar)) {
                    if (!bl && d + d3 + d5 + d7 + d9 > 0.0) {
                        bl3 &= this.addErrorOWarning(iSesion, "100P437", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(D)");
                    } else if (!bl2 && d2 + d4 + d6 + d8 + d10 > 0.0) {
                        bl3 &= this.addErrorOWarning(iSesion, "100P437", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(C)");
                    }
                }
                double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP11GA3"));
                double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP11GA3"));
                double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP12GA3"));
                double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP12GA3"));
                if (!this.coherenciaDescCuidado(iSesion, Declarantes.UnidadFamiliar) || !(!bl && d11 + d13 > 0.0) && (bl2 || !(d12 + d14 > 0.0))) break;
                bl3 &= this.addErrorOWarning(iSesion, "100P438", "W", this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2)) + "(" + string + ")");
            }
        }
        return bl3;
    }

    private boolean coherenciaLibrosBaleares(ISesion iSesion, Declarantes declarantes) throws Exception {
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1IB1").trim());
        int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM2IB1").trim());
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                if (this.numHijosR80084DevolOtrsVincuA >= n && this.numHijosR80084DevolOtrsVincuD >= n2) break;
                return false;
            }
            case 1: {
                if (this.numHijosR80084DevolOtrsVincuA >= n && this.numHijosR80084DevolOtrsVincuC >= n2) break;
                return false;
            }
        }
        return true;
    }

    private boolean coherenciaLibrosBalearesConjunta(ISesion iSesion, Declarantes declarantes) throws Exception {
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1IB1").trim());
        int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM2IB1").trim());
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                if (this.numHijosR80084DevolOtrsVincuAConjunta >= n && this.numHijosR80084DevolOtrsVincuDConjunta >= n2) break;
                return false;
            }
            case 1: {
                if (this.numHijosR80084DevolOtrsVincuAConjunta >= n && this.numHijosR80084DevolOtrsVincuCConjunta >= n2) break;
                return false;
            }
            case 15: {
                if (this.numHijosR80084DevolOtrsVincuAConjunta >= n) break;
                return false;
            }
        }
        return true;
    }

    private boolean coherenciaLibrosBaleares(ISesion iSesion) throws Exception {
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_BALEARES)) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IB1").trim());
                if (this.coherenciaLibrosBaleares(iSesion, Declarantes.Declarante) || !(d > 0.0)) break;
                bl &= this.addErrorOWarning(iSesion, "100R414", "W", "IB1(D)");
                break;
            }
            case 1: {
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IB1").trim());
                if (this.coherenciaLibrosBaleares(iSesion, Declarantes.Conyuge) || !(d > 0.0)) break;
                bl &= this.addErrorOWarning(iSesion, "100R414", "W", "IB1(C)");
                break;
            }
            case 15: {
                int n = 0;
                try {
                    n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 4 || !((d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "IB1").trim())) > 0.0)) break;
                if (!this.coherenciaLibrosBalearesConjunta(iSesion, Declarantes.Declarante) || !this.coherenciaLibrosBalearesConjunta(iSesion, Declarantes.UnidadFamiliar)) {
                    bl &= this.addErrorOWarning(iSesion, "100R414", "W", "IB1(D)");
                    break;
                }
                if (!this.funcrentaValidador.isBConyuge(iSesion) || this.coherenciaLibrosBalearesConjunta(iSesion, Declarantes.Conyuge)) break;
                bl &= this.addErrorOWarning(iSesion, "100R414", "W", "IB1(C)");
            }
        }
        return bl;
    }

    private double sumatorioDobles(ISesion iSesion, Declarantes declarantes, String string, String string2, int n, int n2) throws Exception {
        if (declarantes == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = n; this.funcrentaValidador.existeEntrada(iSesion, string + String.valueOf(i) + string2) && i <= n2; ++i) {
            d += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, string + String.valueOf(i) + string2).trim());
        }
        return d;
    }

    private double sumatorioDobles(ISesion iSesion, Declarantes declarantes, String string, String string2, int n) throws Exception {
        return this.sumatorioDobles(iSesion, declarantes, string, string2, n, Integer.MAX_VALUE);
    }

    private int getRT(ISesion iSesion, Declarantes declarantes) throws Exception {
        if (declarantes == null) {
            return 0;
        }
        int n = 0;
        int n2 = 1;
        while (this.funcrentaValidador.existeEntrada(iSesion, "IMP" + String.valueOf(n2) + "MU1")) {
            StringBuilder stringBuilder = new StringBuilder();
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, stringBuilder.append("IMP").append(String.valueOf(n2)).append("MU1").toString()).trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VP" + String.valueOf(n2) + "MU1").trim().equals("1")) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean controlRegimenTransitorioMurcia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_MURCIA)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        double d = this.getRT(iSesion, declarantes);
        double d2 = 0.0;
        String string2 = "";
        double d3 = 0.0;
        boolean bl4 = false;
        boolean bl5 = false;
        string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VIVFA");
        bl2 = this.funcrentaValidador.entreFechas("31121997", string2, "01012001") == 1;
        bl3 = this.funcrentaValidador.entreFechas("31121997", string2, "01012001") != 1;
        d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MU1"));
        boolean bl6 = bl4 = d == 0.0 && bl2 && d2 > 0.0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "MU1"));
            boolean bl7 = bl5 = d == 0.0 && bl2 && d3 > 0.0;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl4 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl5) {
            bl &= this.addErrorOWarning(iSesion, "100P181", "W", "MU1(" + string + ")");
        }
        boolean bl8 = bl4 = d >= 1.0 && !string2.equals("") && bl3 && d2 > 0.0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "MU1"));
            boolean bl9 = bl5 = d >= 1.0 && !string2.equals("") && bl3 && d3 > 0.0;
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl4 || declarantes2.equals(Declarantes.UnidadFamiliar) && bl5) {
            bl &= this.addErrorOWarning(iSesion, "100P335", "W", "MU1(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionPlanConciliaValencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        Declarantes declarantes3 = null;
        try {
            boolean bl;
            double d;
            double d2;
            declarantes3 = this.funcrentaValidador.cualDeclaracion(iSesion);
            if (!this.comprobarCA(iSesion, declarantes, CTE_VALENCIA)) {
                boolean bl2 = true;
                return bl2;
            }
            if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = true;
            boolean bl5 = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("CASADO_D"));
            boolean bl6 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "HOMBRE_D"));
            boolean bl7 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "HOMBRE_C"));
            boolean bl8 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "MUJER_D"));
            boolean bl9 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "MUJER_C"));
            double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA6"));
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VA6"));
            double d5 = 0.0;
            double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED1VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED2VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED3VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED4VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED5VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DED6VA6"));
            double d7 = 0.0;
            if (iSesion.existsPtr("CONYUGE")) {
                d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VA6"));
                d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED1VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED2VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED3VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED4VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED5VA6")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DED6VA6"));
            }
            if (iSesion.existsPtr("DEFAULT") && iSesion.existsPtr("CONYUGE")) {
                boolean bl10 = false;
                boolean bl11 = false;
                int n = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "PERSONAS" + String.valueOf(n) + "MATER")) {
                    bl10 = bl10 || this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PERSONAS" + String.valueOf(n) + "MATER").equals("2") || this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PERSONAS" + String.valueOf(n) + "VA6").equals("2");
                    bl11 = bl11 || this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PERSONAS" + String.valueOf(n) + "MATER").equals("2") || this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PERSONAS" + String.valueOf(n) + "VA6").equals("2");
                    ++n;
                }
                bl10 = !bl10;
                boolean bl12 = bl11 = !bl11;
                if (declarantes2.equals(Declarantes.Declarante) && d4 > 0.0 && d5 > 0.0 && bl10 && bl11) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P507", "W", "VA6(D)");
                }
                if (declarantes2.equals(Declarantes.Conyuge) && d4 > 0.0 && d5 > 0.0 && bl10 && bl11) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P507", "W", "VA6(C)");
                }
                if (declarantes2.equals(Declarantes.UnidadFamiliar) && d6 > 0.0 && d7 > 0.0 && bl10 && bl11 && d3 > 0.0) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P316", "W", "VA6(" + string + ")");
                }
            }
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
            long l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
            long l2 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
            long l3 = 0L;
            long l4 = iSesion.getOperaciones().recordCount("FREATRENTAS");
            boolean bl13 = false;
            while (l3 != l2) {
                double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "F1EH"));
                if (d8 != 0.0) {
                    bl13 = true;
                    break;
                }
                l3 = l2;
                if (l2 == l4) continue;
                l2 = iSesion.getOperaciones().moveNext("FREATRENTAS");
            }
            iSesion.getOperaciones().move("FREATRENTAS", l);
            if (this.dechvfParaRegla80066 > 0 && (this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPING")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1SUMA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AC") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5AB"), 2) != 0.0 || bl13) && bl8 && d4 == 0.0 && this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "BLGRAL")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "BLAHOJ")), 2) <= 25000.0 && declarantes2.equals(Declarantes.Declarante)) {
                bl4 &= this.addErrorOWarning(iSesion, "100P317", "W", "VA6(D)");
            }
            boolean bl14 = false;
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
                l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
                l2 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
                l3 = 0L;
                l4 = iSesion.getOperaciones().recordCount("FREATRENTAS");
                while (l3 != l2) {
                    d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "F1EH"));
                    if (d2 != 0.0) {
                        bl14 = true;
                        break;
                    }
                    l3 = l2;
                    if (l2 == l4) continue;
                    l2 = iSesion.getOperaciones().moveNext("FREATRENTAS");
                }
                iSesion.getOperaciones().move("FREATRENTAS", l);
                if (this.conhvfParaRegla80066 > 0 && (this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPING")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1SUMA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AC") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5AB"), 2) != 0.0 || bl14) && bl9 && d5 == 0.0 && this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "BLGRAL")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "BLAHOJ")), 2) <= 25000.0 && declarantes2.equals(Declarantes.Conyuge)) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P317", "W", "VA6(C)");
                }
            }
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes3);
            if (this.funcrentaValidador.isBConjunta(iSesion)) {
                try {
                    if ((this.conhvfParaRegla80066 > 0 && (this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPING")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1SUMA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AC") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5AB"), 2) != 0.0 || bl14) && bl9 || this.dechvfParaRegla80066 > 0 && (this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPING")) + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1INGRESO") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1SUMA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AC") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5II") + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5AB"), 2) != 0.0 || bl13) && bl8) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA6")) == 0.0 && this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "BLGRAL")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "BLAHOJ")), 2) <= 40000.0 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                        bl4 &= this.addErrorOWarning(iSesion, "100P317", "W", "VA6(J)");
                    }
                }
                catch (Exception exception) {
                    if (this.cr == null) {
                        System.out.println("***RENTA2014*** FALLO EN CONCILIACION: cr es NULL");
                    }
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: conhvfParaRegla80066 = " + this.conhvfParaRegla80066);
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: TPING = " + this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPING"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E1INGRESO = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1INGRESO"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E1SUMA = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1SUMA"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E4AC = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AC"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E4AA = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AA"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E5II = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5II"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: E5AB = " + this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5AB"));
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: existeF1EHC = " + bl14);
                    System.out.println("***RENTA2014*** FALLO EN CONCILIACION: bMujerC = " + bl9);
                }
            }
            if (d4 > 0.0 && d5 > 0.0 && (bl8 && bl7 || bl9 && bl6)) {
                bl4 &= this.addErrorOWarning(iSesion, "100R365", "E", "VA6(" + string + ")");
            }
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPING"));
            double d9 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1INGRESO");
            double d10 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AA");
            double d11 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5II");
            double d12 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E1SUMA");
            double d13 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E4AC");
            double d14 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Declarante, "E5AB");
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
            l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
            l2 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
            l3 = 0L;
            l4 = iSesion.getOperaciones().recordCount("FREATRENTAS");
            boolean bl15 = true;
            while (l3 != l2) {
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "F1EH"));
                if (d != 0.0) {
                    bl15 = false;
                    break;
                }
                l3 = l2;
                if (l2 == l4) continue;
                l2 = iSesion.getOperaciones().moveNext("FREATRENTAS");
            }
            if (d6 > 0.0 && this.cr.redondea(d2 + d9 + d12 + d10 + d13 + d14 + d11, 2) == 0.0 && bl15 && (declarantes2.equals(Declarantes.Declarante) && d4 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d3 > 0.0)) {
                bl4 &= this.addErrorOWarning(iSesion, "100P367", "W", "VA6(D)");
            }
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPING"));
                d9 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1INGRESO");
                d10 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AA");
                d11 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5II");
                d12 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E1SUMA");
                d13 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E4AC");
                d14 = this.obtenerSumatorioHashMapDeMotor(iSesion, Declarantes.Conyuge, "E5AB");
                this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
                l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
                l2 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
                l3 = 0L;
                l4 = iSesion.getOperaciones().recordCount("FREATRENTAS");
                bl15 = true;
                while (l3 != l2) {
                    d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "F1EH"));
                    if (d != 0.0) {
                        bl15 = false;
                        break;
                    }
                    l3 = l2;
                    if (l2 == l4) continue;
                    l2 = iSesion.getOperaciones().moveNext("FREATRENTAS");
                }
                if (d7 > 0.0 && this.cr.redondea(d2 + d9 + d12 + d13 + d10 + d14 + d11, 2) == 0.0 && bl15 && (declarantes2.equals(Declarantes.Conyuge) && d5 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d3 > 0.0)) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P367", "W", "VA6(C)");
                }
            }
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes3);
            if (declarantes2.equals(Declarantes.Declarante) && bl6 && d6 > 0.0 && d4 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100P368", "W", "VA6(D)");
            }
            if (declarantes2.equals(Declarantes.Conyuge) && bl7 && d7 > 0.0 && d5 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100P368", "W", "VA6(C)");
            }
            if (declarantes2.equals(Declarantes.UnidadFamiliar) && bl6 && d6 > 0.0 && d3 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100P368", "W", "VA6(D)");
            }
            if (declarantes2.equals(Declarantes.UnidadFamiliar) && bl7 && d7 > 0.0 && d3 > 0.0) {
                bl4 &= this.addErrorOWarning(iSesion, "100P368", "W", "VA6(C)");
            }
            if (bl5) {
                if (bl6 && bl9 && d6 > 0.0 && d7 > 0.0) {
                    bl4 &= this.addErrorOWarning(iSesion, "100R509", "E", "VA6(D)");
                }
                if (bl7 && bl8 && d6 > 0.0 && d7 > 0.0) {
                    bl4 &= this.addErrorOWarning(iSesion, "100R509", "E", "VA6(C)");
                }
            }
            boolean bl16 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "INDV").equalsIgnoreCase("true");
            if (bl5 && !bl16) {
                bl = false;
                boolean bl17 = false;
                int n = 1;
                while (this.funcrentaValidador.existeEntrada(iSesion, "PERSONAS" + String.valueOf(n) + "VA6")) {
                    bl = bl || Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PERSONAS" + String.valueOf(n) + "VA6")) > 1;
                    bl17 = bl17 || Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PERSONAS" + String.valueOf(n) + "VA6")) > 1;
                    ++n;
                }
                if (declarantes2.equals(Declarantes.Declarante) && (bl8 && bl9 || bl6 && bl7) && d4 > 0.0 && d5 == 0.0 && bl) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P436", "W", "VA6(D)");
                }
                if (declarantes2.equals(Declarantes.Conyuge) && (bl8 && bl9 || bl6 && bl7) && d5 > 0.0 && d4 == 0.0 && bl17) {
                    bl4 &= this.addErrorOWarning(iSesion, "100P436", "W", "VA6(C)");
                }
            }
            bl = bl4;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes3);
        }
    }

    public boolean coherenciaDeduccionVA10Valencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_VALENCIA)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        boolean bl = true;
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA13")) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G11")) == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P318", "W", "G11(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionArrendamientoValencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_VALENCIA)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        boolean bl = true;
        int n = this.funcrentaValidador.diferenciaEnAnios(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZFNAC_D"), "3112" + Constantes.getEjercicio());
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZGMIN_D").trim();
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA14"));
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA14"));
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 1;
        while (this.funcrentaValidador.existeEntrada(iSesion, "CLAVE" + String.valueOf(n2) + "VA14")) {
            bl3 = bl3 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLAVE" + String.valueOf(n2) + "VA14").equals("1");
            bl4 = bl4 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLAVE" + String.valueOf(n2) + "VA14").equals("2") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLAVE" + String.valueOf(n2) + "VA14").equals("3");
            bl5 = bl5 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLAVE" + String.valueOf(n2) + "VA14").equals("3");
            ++n2;
        }
        bl2 = n < 36 && bl3 || n > 36 && string2.equals("") && bl4 || string2.equals("") && bl5 || n > 36 && bl5;
        if (bl2 && d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P266", "W", "VA14(" + string + ")");
        }
        if (!declarantes2.equals(Declarantes.UnidadFamiliar)) {
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VA14"));
            double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VA14"));
            boolean bl6 = true;
            boolean bl7 = true;
            for (int i = 1; i <= 4; ++i) {
                if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM" + String.valueOf(i) + "VA14").trim()) > 0 && Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM" + String.valueOf(i) + "VA14")) != 1) {
                    bl6 = false;
                }
                if (Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM" + String.valueOf(i) + "VA14").trim()) <= 0 || Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM" + String.valueOf(i) + "VA14")) == 1) continue;
                bl7 = false;
            }
            if ((bl6 || bl7) && d2 > 0.0 && d3 > 0.0) {
                bl = declarantes2.equals(Declarantes.Declarante) ? (bl &= this.addErrorOWarning(iSesion, "100P171", "W", "VA14(D)")) : (bl &= this.addErrorOWarning(iSesion, "100P171", "W", "VA14(C)"));
            }
        } else {
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA14"));
            boolean bl8 = true;
            boolean bl9 = true;
            boolean bl10 = true;
            boolean bl11 = true;
            double d5 = 0.0;
            double d6 = 0.0;
            boolean bl12 = false;
            boolean bl13 = false;
            for (int i = 1; i <= 4; ++i) {
                String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TIPO" + String.valueOf(i) + "VA14");
                int n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUM" + String.valueOf(i) + "VA14"));
                if (!string3.equals("1") && !string3.equals("")) {
                    bl12 = true;
                    if (d5 != 0.0) {
                        if (d5 != (double)n3) {
                            bl10 = false;
                        }
                    } else {
                        d5 = n3;
                    }
                    if (n3 != 1) {
                        bl8 = false;
                    }
                }
                string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TIPO" + String.valueOf(i) + "VA14");
                n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUM" + String.valueOf(i) + "VA14"));
                if (string3.equals("1") || string3.equals("")) continue;
                bl13 = true;
                if (d6 != 0.0) {
                    if (d6 != (double)n3) {
                        bl11 = false;
                    }
                } else {
                    d6 = n3;
                }
                if (n3 == 1) continue;
                bl9 = false;
            }
            if (d4 > 0.0 && (bl8 && bl11 && bl12 && bl13 || bl9 && bl10 && bl13 && bl12)) {
                string = bl8 ? "D" : "C";
                bl &= this.addErrorOWarning(iSesion, "100P171", "W", "VA14(" + string + ")");
            }
        }
        return bl;
    }

    public boolean deduccionVivHabitualValencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_VALENCIA)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        String string2 = "00000000";
        string2 = this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VFA1"));
        if (this.funcrentaValidador.comparaFechas(string2, "19012007") > 0) {
            bl2 = true;
        }
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BASE1"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "IMP1VA10"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA10"));
        if (d3 > d2 + d * (double)bl2 && d4 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P259", "W", "VA10(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionesHijosValencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_VALENCIA)) {
            return true;
        }
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORCJVA3"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOSCJVA3"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORCJVA1"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORDVA3"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOSDVA3"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORDVA1"));
        double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA3"));
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA2"));
        double d9 = 0.0;
        double d10 = 0.0;
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA3"));
            d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "VA2"));
        }
        if ((d + d2 > d3 || d4 + d5 > d6) && (!declarantes2.equals(Declarantes.UnidadFamiliar) && d7 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d9 > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P174", "E", "VA3(" + string + ")");
        }
        if ((this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COM1VA2").equalsIgnoreCase("true") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORCJVA1")) < 2.0 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1VA2").equalsIgnoreCase("true") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MENORDVA1")) < 2.0) && (!declarantes2.equals(Declarantes.UnidadFamiliar) && d8 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d10 > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100R364", "E", "VA2(" + string + ")");
        }
        return bl;
    }

    private String dameDeclaracionActual(ISesion iSesion) throws Exception {
        switch (this.switchMotor(iSesion, this.getMISesion(iSesion))) {
            case 0: {
                return "Declarante";
            }
            case 1: {
                return "C\u00f3nyuge";
            }
            case 15: {
                return "Unidad familiar";
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, this.getMISesion(iSesion)) == n + 1) {
                return "Hijo" + n;
            }
            ++n;
        }
        return "";
    }

    private String anioAnterior(int n) {
        return String.valueOf(Constantes.getEjercicio() - n);
    }

    private Boolean compruebaCAutonoma(ISesion iSesion) throws Exception {
        if (this.switchMotor(iSesion, this.getMISesion(iSesion)) == 15) {
            int n;
            int n2;
            int n3 = 2 + Constantes.getNumhijosrentas();
            double[] dArray = new double[n3];
            boolean[] blArray = new boolean[n3];
            Declarantes declarantes = null;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = -1.0;
                blArray[n2] = false;
                declarantes = this.switchOrdinalMotor(iSesion, n2);
                if (declarantes != null) {
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMARDTO")) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMAGG")) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMAPG")) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMAGA")) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMAPA")) == 0.0 && !(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HPDTEAH")) > 0.0) && !(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HSALDOPGP1")) > 0.0) && !(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HCMBIAH")) > 0.0)) continue;
                    dArray[n2] = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BLGGRAV")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BLAHOJ"));
                    blArray[n2] = true;
                    continue;
                }
                blArray[n2] = false;
                dArray[n2] = -1.0;
            }
            n2 = -1;
            double d = dArray[0] - 1.0;
            for (n = 0; n < n3; ++n) {
                if (!blArray[n] || !(this.cr.redondea(dArray[n], 2) > d)) continue;
                n2 = n;
                d = this.cr.redondea(dArray[n], 2);
            }
            n = 0;
            for (int i = 0; i < n3; ++i) {
                if (this.cr.redondea(dArray[i], 2) != d) continue;
                declarantes = this.switchOrdinalMotor(iSesion, i);
                if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "CAOC").trim().equals(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZCCAD").trim())) continue;
                n = 1;
                break;
            }
            if (n2 != -1 && n == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean hijoAplicableADeclaracion(Map<String, String> map, int n) {
        switch (n) {
            case 0: {
                if (!map.get("perteneceADeclarante").equalsIgnoreCase("NO")) break;
                return false;
            }
            case 1: {
                if (!map.get("perteneceAConyuge").equalsIgnoreCase("NO")) break;
                return false;
            }
        }
        return true;
    }

    public boolean compruebaEstadoHijosyAscendientes(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        int n = this.switchMotor(iSesion, declarantes);
        if (n != 0 && n != 1 && n != 15) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        Map<String, String> map = this.dameHijo(iSesion, declarantes, true);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl2 = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("INDV"));
        String string10 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECFAL");
        while (map != null) {
            string2 = map.get("nif");
            string3 = map.get("fechaNacimientoNumerico");
            string4 = map.get("vinculacion");
            string5 = map.get("bFallh");
            string6 = map.get("fechaFallecidoNumerico");
            boolean bl3 = false;
            if (n == 0 && (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("B") || string4.equalsIgnoreCase("D"))) {
                bl3 = true;
            } else if (n == 1 && (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("C") || string4.equalsIgnoreCase("E"))) {
                bl3 = true;
            } else if (n == 15) {
                bl3 = true;
            }
            if (string3.compareTo(String.valueOf(Constantes.getEjercicio() - 13) + "0101") < 0 && string2.equals("") && bl3 && string5.equalsIgnoreCase("NO") || string5.equalsIgnoreCase("SI") && string2.equals("") && bl3 && this.sumaAfechaANumerico(string3, 14).compareTo(string6) <= 0) {
                bl &= this.addErrorOWarning(iSesion, "100R072", "E", "DATOSPERSONALES#1:NOMHR");
            }
            if (string10.length() != 0 && this.funcrentaValidador.comparaFechas(string6, string10) == 1) {
                bl &= this.addErrorOWarning(iSesion, "100R144", "E", "DATOSPERSONALES#1:NOMHR");
            }
            if (bl2 && (string4.equalsIgnoreCase("C") || string4.equalsIgnoreCase("E"))) {
                bl &= this.addErrorOWarning(iSesion, "100R201", "E", "DATOSPERSONALES#1:NOMHR");
            }
            map = this.dameHijo(iSesion, declarantes, false);
        }
        if (this.switchMotor(iSesion, declarantes2) == 15) {
            map = this.dameHijo(iSesion, declarantes, true);
            int n2 = 0;
            try {
                n2 = Integer.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJREN"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 1; i <= n2; ++i) {
                string2 = map.get("nif");
                string9 = map.get("CONRENTAS");
                if (string2.equals("") && string9.equalsIgnoreCase("SI")) {
                    bl &= this.addErrorOWarning(iSesion, "100R301", "E", "DATOSPERSONALES#1:NOMHR");
                    break;
                }
                map = this.dameHijo(iSesion, declarantes, false);
            }
        }
        String string11 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFOP");
        String string12 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NOMAPEOP");
        boolean bl4 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NONIFOP"));
        map = this.dameHijo(iSesion, declarantes, true);
        while (map != null) {
            string4 = map.get("vinculacion");
            string7 = map.get("bDevol");
            string8 = map.get("bR8000");
            if (n == 0 && string4.equalsIgnoreCase("D") && string7.equalsIgnoreCase("NO") && string8.equalsIgnoreCase("NO")) {
                if (!bl4 && string11.equals("") || string12.trim().equals("")) {
                    bl &= this.addErrorOWarning(iSesion, "100R461", "E", "NIFOP");
                }
                if (!string12.equalsIgnoreCase("") && string12.trim().indexOf(32) == -1) {
                    bl &= this.addErrorOWarning(iSesion, "100R531", "E", "NOMAPEOP");
                }
            }
            if (n == 1) {
                if (string4.equalsIgnoreCase("E") && string7.equalsIgnoreCase("NO") && string8.equalsIgnoreCase("NO")) {
                    if (!bl4 && string11.equals("") || string12.trim().equals("")) {
                        bl &= this.addErrorOWarning(iSesion, "100R461", "E", "NIFOP");
                    }
                    if (!string12.equalsIgnoreCase("") && string12.trim().indexOf(32) == -1) {
                        bl &= this.addErrorOWarning(iSesion, "100R531", "E", "NOMAPEOP");
                    }
                }
            } else if (n == 15 && (string4.equalsIgnoreCase("D") || string4.equalsIgnoreCase("E"))) {
                if (!bl4 && string11.equals("") || string12.trim().equals("")) {
                    bl &= this.addErrorOWarning(iSesion, "100R461", "E", "NIFOP");
                }
                if (!string12.equalsIgnoreCase("") && string12.trim().indexOf(32) == -1) {
                    bl &= this.addErrorOWarning(iSesion, "100R531", "E", "NOMAPEOP");
                }
            }
            map = this.dameHijo(iSesion, declarantes, false);
        }
        for (int i = 1; i <= 4; ++i) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZANOAS" + i).trim().length() == 0 || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZDNIAS" + i).trim().length() != 0) continue;
            bl &= this.addErrorOWarning(iSesion, "100R073", "E", "DATOSPERSONALES#2:DNIAS");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    private boolean ejecutarMetodo(ISesion iSesion, String string, Declarantes declarantes, String string2, Declarantes declarantes2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method = null;
        Class[] classArray = null;
        classArray = new Class[]{ISesion.class, Declarantes.class, String.class, Declarantes.class};
        method = this.getClass().getMethod(string, classArray);
        return (Boolean)method.invoke((Object)this, iSesion, declarantes, string2, declarantes2);
    }

    private boolean ejecutaFuncionSegunDeclaracion(ISesion iSesion, String string, String string2) throws Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: {
                return this.ejecutarMetodo(iSesion, string, Declarantes.Declarante, "D", Declarantes.Declarante);
            }
            case 1: {
                return this.ejecutarMetodo(iSesion, string, Declarantes.Conyuge, "C", Declarantes.Conyuge);
            }
            case 15: {
                boolean bl = true;
                if (string2.contains("D") && iSesion.existsPtr("DEFAULT")) {
                    bl &= this.ejecutarMetodo(iSesion, string, Declarantes.Declarante, "D", Declarantes.UnidadFamiliar);
                }
                if (string2.contains("C") && iSesion.existsPtr("CONYUGE")) {
                    bl &= this.ejecutarMetodo(iSesion, string, Declarantes.Conyuge, "C", Declarantes.UnidadFamiliar);
                }
                if (string2.contains("1")) {
                    int n2 = 1;
                    while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                        if (iSesion.existsPtr("HIJO" + n2)) {
                            bl &= this.ejecutarMetodo(iSesion, string, Declarantes.parseInt(20 + n2 * 10), "" + n2 + "", Declarantes.UnidadFamiliar);
                        }
                        ++n2;
                    }
                }
                if (string2.contains("J") && iSesion.existsPtr("CONJUNTA")) {
                    bl &= this.ejecutarMetodo(iSesion, string, Declarantes.UnidadFamiliar, "J", Declarantes.UnidadFamiliar);
                }
                return bl;
            }
        }
        int n3 = 1;
        while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (n == 1 + n3) {
                return this.ejecutarMetodo(iSesion, string, Declarantes.parseInt(20 + n3 * 10), "" + n3 + "", Declarantes.parseInt(20 + n3 * 10));
            }
            ++n3;
        }
        return false;
    }

    public boolean validarRegDiscapacitados(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        int n = this.switchMotor(iSesion, declarantes2);
        if (n != 15) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        int n2 = 0;
        Declarantes declarantes3 = null;
        int n3 = 2 + Constantes.getNumhijosrentas();
        for (int i = 0; i <= n3; ++i) {
            declarantes3 = this.switchOrdinalMotor(iSesion, i);
            if (declarantes3 == null) continue;
            n2 += this.obtenerContadorHashMapDeMotor(iSesion, declarantes3, "NUMEROT").intValue();
        }
        long l = this.moveFirst(iSesion, declarantes, "DLGTRABAJO");
        long l2 = 0L;
        while (l != l2) {
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IEIP").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REGIMEN").trim().equals("2") && this.obtenerContadorHashMapDeMotor(iSesion, declarantes, "NUMEROT") == 0 && n2 == n3) {
                return false;
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "DLGTRABAJO");
        }
        iSesion.unfreeze(this.toString());
        return true;
    }

    public boolean validarPrimaSeColectivo(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        double d = 0.0;
        boolean bl = true;
        long l = this.moveFirst(iSesion, declarantes, "DLGTRABAJO");
        long l2 = 0L;
        while (l != l2) {
            d += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PRIMAS").trim());
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "DLGTRABAJO");
        }
        if (d > 5000.0) {
            bl &= this.addErrorOWarning(iSesion, "100P452", "W", "TPPRIMA(" + string + ")", "%" + l + "$DLGTRABAJO");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean reduccionesRdtosIrregulares(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        long l = this.moveFirst(iSesion, declarantes, "DLGTRABAJO");
        long l2 = 0L;
        while (l != l2) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GGRE"));
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IDII"));
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IEVA"));
            d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IEIC"));
            d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IEIR"));
            double d6 = 0.4 * (d2 + d3 + d4 - d5) + 0.5;
            double d7 = Double.parseDouble(Formatear.getFormatear().redondea(d6, (Object)2).toString());
            if (d > d7) {
                bl &= this.addErrorOWarning(iSesion, "100P008", "W", "TPRI(" + string + ")", "%" + l + "$DLGTRABAJO");
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "DLGTRABAJO");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    protected boolean registroTablaVacio(ISesion iSesion, String string, Declarantes declarantes, Declarantes declarantes2) throws ExceptionMotor {
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        List list = iSesion.getModelo().getGestorConfiguracion().getCamposDeTabla(string);
        RegEntrada regEntrada = null;
        for (String string2 : list) {
            regEntrada = (RegEntrada)iSesion.getModelo().getGestorConfiguracion().getEntrada(string2);
            if (regEntrada.esValorPorDefecto(iSesion.getOperaciones().obtenerPartidaString(string2))) continue;
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
            return false;
        }
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes2);
        return true;
    }

    public boolean validarActividadesEstimacionDirecta(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        long l = this.recordCount(iSesion, declarantes, "E1REGESTDIR");
        long l2 = this.moveFirst(iSesion, declarantes, "E1REGESTDIR");
        long l3 = 0L;
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1ITEMP"));
        while (l2 != l3) {
            if (!this.registroTablaVacio(iSesion, "E1REGESTDIR", declarantes, declarantes2)) {
                try {
                    n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TACT").trim());
                }
                catch (Exception exception) {
                    n = 0;
                }
                d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RN").trim());
                d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1REDU").trim());
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RNR").trim());
                if ((n == 1 || n == 4 || n == 5) && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IAE").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100I010", "W", "IAE(" + string + ")", "%" + l2 + "$E1REGESTDIR");
                }
                if (Math.abs(d2) > this.cr.redondea(Math.abs(0.4 * d3) + 0.5, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100P025", "W", "E1REDU(" + string + ")", "%" + l2 + "$E1REGESTDIR");
                }
                if (d2 > 0.0 && d3 < 0.0 || d2 < 0.0 && d3 > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100P026", "W", "E1REDU(" + string + ")", "%" + l2 + "$E1REGESTDIR");
                }
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "E1REGESTDIR");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarCoherenciaImputacionTemporal(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        iSesion.freezeSesionSoloPosicion(this.toString());
        String string2 = "";
        long l = this.moveFirst(iSesion, declarantes, "E1REGESTDIR");
        long l2 = 0L;
        while (l != l2) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TACT").trim().length() > 0) {
                if (string2.length() == 0) {
                    string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1ITEMP").trim();
                }
                if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1ITEMP").trim().equalsIgnoreCase(string2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R446", "E", "E1ITEMP(" + string + ")", "%1$E1REGESTDIR");
                }
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "E1REGESTDIR");
        }
        l = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
        l2 = 0L;
        while (l != l2) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AEP").trim().length() > 0) {
                if (string2.length() == 0) {
                    string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4ITEO").trim();
                }
                if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4ITEO").trim().equalsIgnoreCase(string2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R446", "E", "E4ITEO(" + string + ")", "%1$E2REGESTOBJ");
                }
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
        }
        l = this.moveFirst(iSesion, declarantes, "E3REGESTAGR");
        l2 = 0L;
        while (l != l2) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5ADE").trim().length() > 0) {
                if (string2.length() == 0) {
                    string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5ACI").trim();
                }
                if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5ACI").trim().equalsIgnoreCase(string2)) {
                    bl &= this.addErrorOWarning(iSesion, "100R446", "E", "E5ACI(" + string + ")", "%1$E3REGESTAGR");
                }
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "E3REGESTAGR");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarActividadesLorca(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        long l = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
        long l2 = 0L;
        while (l != l2) {
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "LORCA").trim());
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AE").trim());
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AF").trim());
            if (d3 > 0.0 && d3 > this.cr.redondea(0.2 * (d - d2), 2)) {
                bl &= this.addErrorOWarning(iSesion, "100R474", "E", "LORCA(" + string + ")", "%" + l + "$E2REGESTOBJ");
            }
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AEP").trim();
            d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU1").trim());
            d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU2").trim());
            n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IN1").trim());
            boolean bl2 = false;
            if (string2.equals("644.1") || string2.equals("644.2") || string2.equals("644.3") || string2.equals("644.6")) {
                bl2 = true;
            }
            if (bl2 && d4 + d5 > (double)n && n > 0 || d4 > (double)n && n > 0) {
                bl &= this.addErrorOWarning(iSesion, "100P386", "W", "E4AU1(" + string + ")", "%" + l + "$E2REGESTOBJ");
            }
            l2 = l;
            l = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    private int validacionE1RED1Individual(ISesion iSesion, Declarantes declarantes) throws NumberFormatException, Exception {
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RED1").trim()) > 0.0 && (this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E5II") > 0.0 || this.obtenerContadorHashMapDeMotor(iSesion, declarantes, "E1INGRESO") > 1)) {
            return 1;
        }
        return 0;
    }

    private int validacionE1RED1Conjunta(ISesion iSesion, Declarantes declarantes, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RED1").trim()) > 0.0 && (this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes2, "E4AA") + this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes2, "E5II") > 0.0 || this.obtenerContadorHashMapDeMotor(iSesion, declarantes2, "E1INGRESO") > 1)) {
            return 1;
        }
        return 0;
    }

    private String dameDeclaracion(String string) {
        if (string.equals("1")) {
            return "H1";
        }
        if (string.equals("2")) {
            return "H2";
        }
        if (string.equalsIgnoreCase("J")) {
            return "D";
        }
        return string;
    }

    public boolean validarControlRequisitosCasilla137(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (declarantes == null) {
            return true;
        }
        if (!this.existePuntero(iSesion, declarantes)) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl2 = this.switchMotor(iSesion, declarantes) == 15;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1REQ_RED1").trim();
        if (!bl2 && this.switchMotor(iSesion, declarantes2) != 15 && this.validacionE1RED1Individual(iSesion, declarantes) == 1) {
            bl &= this.addErrorOWarning(iSesion, "100I028", "W", "E1REQ_RED1(" + string + ")");
        }
        if (this.switchMotor(iSesion, declarantes) != 15 && this.switchMotor(iSesion, declarantes2) == 15) {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1REQ_RED1").trim();
            if (this.validacionE1RED1Conjunta(iSesion, declarantes2, declarantes) == 1 && string2.length() != 0) {
                bl &= this.addErrorOWarning(iSesion, "100I028", "W", "E1REQ_RED1(" + string + ")");
            }
            int n = 0;
            double d = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1INGRESO");
            double d2 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1SUMA");
            double d3 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1N1");
            long l = this.recordCount(iSesion, declarantes, "E1REGESTDIR");
            long l2 = this.moveFirst(iSesion, declarantes, "E1REGESTDIR");
            long l3 = 0L;
            while (l2 != l3) {
                try {
                    n += Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TACT").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l3 = l2;
                if (l == l2) break;
                l2 = this.moveNext(iSesion, declarantes, "E1REGESTDIR");
            }
            if (!string2.equals("") && (n == 0 || d == 0.0 && d2 == 0.0 && d3 == 0.0)) {
                bl &= this.addErrorOWarning(iSesion, "100R370", "E", "E1REQ_RED1(" + string + ")");
            }
        }
        String string3 = "";
        boolean bl3 = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl3 = true;
            }
            ++n;
        }
        if (bl3) {
            long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)Integer.parseInt(string));
            string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSHR").trim();
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
        } else {
            string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPGMIN_" + this.dameDeclaracion(string)).trim();
        }
        if (this.switchMotor(iSesion, declarantes) != 15) {
            boolean bl4;
            boolean bl5 = bl4 = string2.equalsIgnoreCase("1") && string3.length() != 0;
            if (bl4 || string2.equals("2") && !string3.equals("1") || string2.equals("3") && !string3.equals("2") && !string3.equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P283", "W", "E1REQ_RED1(" + string + ")");
            }
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarControlRequisitosCasilla138etc(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        double d;
        boolean bl = true;
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RED2").trim());
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RED3").trim());
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4REDU").trim());
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5REDU").trim());
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RDTOINI").trim());
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        int n = 0;
        int n2 = 0;
        long l = this.recordCount(iSesion, declarantes, "E3REGESTAGR");
        long l2 = this.moveFirst(iSesion, declarantes, "E3REGESTAGR");
        long l3 = 0L;
        while (l2 != l3) {
            d8 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5II").trim());
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "E3REGESTAGR");
        }
        l = this.recordCount(iSesion, declarantes, "E2REGESTOBJ");
        l2 = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
        l3 = 0L;
        while (l2 != l3) {
            d14 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AA").trim());
            d10 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AB").trim());
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
        }
        String string2 = "";
        l = this.recordCount(iSesion, declarantes, "E1REGESTDIR");
        l2 = this.moveFirst(iSesion, declarantes, "E1REGESTDIR");
        l3 = 0L;
        while (l2 != l3) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1INGRESO").trim());
            d7 += d;
            d15 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1G2").trim());
            d16 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1G4").trim());
            if (string2.length() == 0) {
                string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECE1RED2").trim();
            }
            if (d > 0.0) {
                ++n;
            }
            if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECE1RED2").trim().equalsIgnoreCase(string2)) {
                bl &= this.addErrorOWarning(iSesion, "100P501", "W", "DECE1RED2(" + string + ")", "%1$E1REGESTDIR");
            }
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "E1REGESTDIR");
        }
        l = this.recordCount(iSesion, declarantes, "FREATRENTAS");
        l2 = this.moveFirst(iSesion, declarantes, "FREATRENTAS");
        l3 = 0L;
        while (l2 != l3) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EH").trim());
            d9 += d;
            d11 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EI").trim());
            d12 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REDMI").trim());
            d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RDTOINI").trim());
            if (d > 0.0) {
                ++n2;
            }
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "FREATRENTAS");
        }
        if (d7 + d8 + d9 >= 5000000.0) {
            if (d3 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R369", "E", "E1RED3(" + string + ")");
            }
            if (d4 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R369", "E", "E4REDU(" + string + ")");
            }
            if (d5 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R369", "E", "E5REDU(" + string + ")");
            }
            if (d11 - d12 - d13 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R369", "E", "F1EI(" + string + ")", "%1$FREATRENTAS");
            }
        }
        if (d14 + d8 == 0.0 && d3 > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPEMP").trim()) > d15 + d16) {
            bl &= this.addErrorOWarning(iSesion, "100R384", "E", "E1RED3(" + string + ")");
        }
        if (d3 + d4 > 0.0 && d15 == 0.0 && d10 == 0.0 && d8 == 0.0) {
            bl = d3 > 0.0 ? (bl &= this.addErrorOWarning(iSesion, "100R425", "E", "E1RED3(" + string + ")")) : (bl &= this.addErrorOWarning(iSesion, "100R425", "E", "E4REDU(" + string + ")"));
        }
        if (d2 > 0.0 && (d14 > 0.0 || d8 > 0.0 || d9 > 0.0 || n > 1) || d6 > 0.0 && (d7 > 0.0 || d14 > 0.0 || d8 > 0.0 || n2 > 1)) {
            bl &= this.addErrorOWarning(iSesion, "100R570", "W", "E1RED2(" + string + ")");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean actividadesEmpresarialesEstimacionObjetiva(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        long l = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
        long l2 = this.recordCount(iSesion, declarantes, "E2REGESTOBJ");
        long l3 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        while (l != l3) {
            boolean bl2;
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AM").trim());
            if (d > this.cr.redondea(0.4 * (d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AK").trim())), 2) + 0.5) {
                bl &= this.addErrorOWarning(iSesion, "100P459", "E", "E4AM(" + string + ")", "%" + l + "$E2REGESTOBJ");
            }
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD2");
            String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD3");
            String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD4");
            String string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD5");
            String string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD6");
            String string7 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AD7");
            double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU2"));
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU3"));
            double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU4"));
            double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU5"));
            double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU6"));
            double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AU7"));
            String string8 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AEP");
            boolean bl3 = bl2 = "644.1".equals(string8) || "644.2".equals(string8) || "644.3".equals(string8) || "644.6".equals(string8);
            if (!bl2 && (!string2.equals("") && d3 == 0.0 || !string3.equals("") && d4 == 0.0 || !string4.equals("") && d5 == 0.0 || !string5.equals("") && d6 == 0.0 || !string6.equals("") && d7 == 0.0 || !string7.equals("") && d8 == 0.0) || bl2 && (!string3.equals("") && d4 == 0.0 || !string4.equals("") && d5 == 0.0 || !string5.equals("") && d6 == 0.0 || !string6.equals("") && d7 == 0.0 || !string7.equals("") && d8 == 0.0)) {
                bl &= this.addErrorOWarning(iSesion, "100P363", "W", "E4AEP(" + string + ")", "%" + l + "$E2REGESTOBJ");
            }
            l6 = this.recordCount(iSesion, declarantes, "MODULOOBJ");
            l4 = this.moveFirst(iSesion, declarantes, "MODULOOBJ");
            l5 = 0L;
            if (l4 == 0L && Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IN1").trim()) != 0) {
                bl &= this.addErrorOWarning(iSesion, "100R090", "E", "E4AEP(" + string + ")", "%" + l + "$E2REGESTOBJ");
                break;
            }
            while (l4 != l5) {
                ValidacionesE validacionesE = new ValidacionesE(iSesion);
                if (!validacionesE.validarPersonalAsalariado(iSesion, declarantes, true)) {
                    bl &= this.addErrorOWarning(iSesion, "100R090", "E", "E4AEP(" + string + ")", "%" + l + "$E2REGESTOBJ");
                    break;
                }
                l5 = l4;
                if (l6 == l4) break;
                l4 = this.moveNext(iSesion, declarantes, "MODULOOBJ");
            }
            l3 = l;
            if (l == l2) break;
            l = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean actividadesAgrariasEstimacionObjetiva(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        long l = this.recordCount(iSesion, declarantes, "E3REGESTAGR");
        long l2 = this.moveFirst(iSesion, declarantes, "E3REGESTAGR");
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AG").trim());
        while (l2 != l3) {
            if (!this.registroTablaVacio(iSesion, "E3REGESTAGR", declarantes, declarantes2)) {
                double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AL").trim());
                double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AK").trim());
                l6 = this.recordCount(iSesion, declarantes, "MODULOAGR");
                l4 = this.moveFirst(iSesion, declarantes, "MODULOAGR");
                l5 = 0L;
                while (l4 != l5) {
                    try {
                        ValidacionesE validacionesE = new ValidacionesE(iSesion);
                        if (!validacionesE.validaE5(iSesion, declarantes, "E5AB", true)) {
                            bl &= this.addErrorOWarning(iSesion, "100P195", "W", "E5AB(" + string + ")", "%1$E3REGESTAGR");
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (exception.getMessage().equals("campoErrorE5ADE")) {
                            bl &= this.addErrorOWarning(iSesion, "100P195", "W", "E5ADE(" + string + ")", "%1$E3REGESTAGR");
                            break;
                        }
                        throw exception;
                    }
                    l5 = l4;
                    if (l6 == l4) break;
                    l4 = this.moveNext(iSesion, declarantes, "MODULOAGR");
                }
                if (d2 != 0.0 && Math.abs(d2) > this.cr.redondea(0.4 * Math.abs(d3) + 0.5, 2)) {
                    bl &= this.addErrorOWarning(iSesion, "100P465", "W", "E5AL(" + string + ")", "%" + l2 + "$E3REGESTAGR");
                }
                if (d2 > 0.0 && d3 < 0.0 || d2 < 0.0 && d3 > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100P466", "W", "E5AL(" + string + ")", "%" + l2 + "$E3REGESTAGR");
                }
                double d4 = 0.0;
                try {
                    d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5ADE").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AG").trim());
                if (d4 > 0.0 && (d == 0.0 && d5 != 0.0 || d != 0.0 && d5 == 0.0)) {
                    bl &= this.addErrorOWarning(iSesion, "100R263", "W", "E5AJ(" + string + ")", "%1$E3REGESTAGR");
                }
                boolean bl2 = false;
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REG").equalsIgnoreCase("1")) {
                    double d6 = 0.0;
                    this.move(iSesion, declarantes, "MODULOAGR", 2L);
                    d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPREE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAREE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU02").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 5L);
                    d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPREE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAREE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU05").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 8L);
                    d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPREE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAREE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU08").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 10L);
                    d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPREE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAREE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU10").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 11L);
                    if ((d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPREE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAREE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU11").trim())) == 0.0) {
                        bl2 = true;
                    }
                }
                boolean bl3 = false;
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AE").equalsIgnoreCase("1")) {
                    double d7 = 0.0;
                    this.move(iSesion, declarantes, "MODULOAGR", 1L);
                    d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01RNRAEE5AU01").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01RNAAEE5AU01").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 3L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01RNRAEE5AU03").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01RNAAEE5AU03").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 2L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPAEE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAAEE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU02").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU02").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 5L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPAEE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAAEE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU05").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU05").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 8L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPAEE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAAEE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU08").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU08").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 10L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPAEE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAAEE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU10").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU10").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 11L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPAEE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAAEE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNPERE5AU11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAERE5AU11").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 4L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU04").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 6L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU06").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 7L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU07").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 9L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU09").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 12L);
                    d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU12").trim());
                    this.move(iSesion, declarantes, "MODULOAGR", 13L);
                    if ((d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V02RNAEE5AU13").trim())) == 0.0) {
                        bl3 = true;
                    }
                }
                if (bl2 || bl3) {
                    bl &= this.addErrorOWarning(iSesion, "100P529", "W", "E5ADE(" + string + ")", "%1$E3REGESTAGR");
                }
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "E3REGESTAGR");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean regimenEspecialAtribucionRentas(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        long l = this.recordCount(iSesion, declarantes, "FREATRENTAS");
        long l2 = this.moveFirst(iSesion, declarantes, "FREATRENTAS");
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        String string2 = "";
        String string3 = "";
        while (l2 != l3) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EA").trim());
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVEX").trim());
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORBO").trim());
            d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EE").trim());
            d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EH").trim());
            d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EK").trim());
            d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EKT").trim());
            d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EM").trim());
            d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EO").trim());
            d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1PCT").trim());
            string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1NIFAR");
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1NONIF");
            if (d10 != 0.0 && string3.equalsIgnoreCase("") && string2.equalsIgnoreCase("") || d10 == 0.0 && (!string3.equalsIgnoreCase("") || !string2.equalsIgnoreCase(""))) {
                bl &= this.addErrorOWarning(iSesion, "100R097", "E", "F1NIFAR(" + string + ")", "%" + l2 + "$FREATRENTAS");
            }
            if (!bl2 && d + d2 + d3 > 0.0 && d9 == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100I011", "W", "F1EO(" + string + ")", "%" + l2 + "$FREATRENTAS");
                bl2 = true;
            }
            if (!bl3 && d + d2 + d3 + d4 + d5 + d6 + d7 + d8 == 0.0 && d9 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100I012", "W", "F1EO(" + string + ")", "%" + l2 + "$FREATRENTAS");
                bl3 = true;
            }
            l6 = this.recordCount(iSesion, declarantes, "INMATRENTAS");
            l4 = this.moveFirst(iSesion, declarantes, "INMATRENTAS");
            l5 = 0L;
            while (l4 != l5) {
                if (!bl4 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARPC").trim()) > d10) {
                    bl &= this.addErrorOWarning(iSesion, "100P267", "W", "F1EE(" + string + ")", "%" + l2 + "$FREATRENTAS");
                    bl4 = true;
                }
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARCL").trim().equals("3")) {
                    bl &= this.addErrorOWarning(iSesion, "100P322", "W", "F1EE(" + string + ")", "%" + l2 + "$FREATRENTAS");
                }
                l5 = l4;
                if (l6 == l4) break;
                l4 = this.moveNext(iSesion, declarantes, "INMATRENTAS");
            }
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "FREATRENTAS");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean regEspAtribRentasParaDatosFiscales(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        iSesion.freezeSesionSoloPosicion(this.toString());
        long l = this.recordCount(iSesion, declarantes, "FREATRENTAS");
        long l2 = this.moveFirst(iSesion, declarantes, "FREATRENTAS");
        long l3 = 0L;
        long l4 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl3 = false;
        while (l2 != l3) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1").trim());
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2").trim());
            l4 = this.recordCount(iSesion, declarantes, "INMATRENTAS");
            if (!(bl2 || l4 != 0L || d == 0.0 && d2 == 0.0)) {
                bl &= this.addErrorOWarning(iSesion, "100R472", "E", "F1EE(" + string + ")", "%" + l2 + "$FREATRENTAS");
                bl2 = true;
            }
            if (l4 > 0L) {
                long l5 = this.moveFirst(iSesion, declarantes, "INMATRENTAS");
                long l6 = 0L;
                while (l5 != l6) {
                    string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARCL").trim();
                    string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARNAT").trim();
                    string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARRC").trim();
                    string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VARPC").trim();
                    if (!(bl3 || string4.equals("") && string2.equals("1") && string2.equals("2") || !string5.equals("0") && !string3.equals(""))) {
                        bl &= this.addErrorOWarning(iSesion, "100R473", "E", "F1EE(" + string + ")", "%" + l2 + "$FREATRENTAS");
                        bl3 = true;
                    }
                    l6 = l5;
                    l5 = this.moveNext(iSesion, declarantes, "INMATRENTAS");
                }
            }
            if (bl2 && bl3) {
                return bl;
            }
            if (l == l2) break;
            l3 = l2;
            l2 = this.moveNext(iSesion, declarantes, "FREATRENTAS");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarTrabajadorEnActivoDiscapacitado(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl;
        iSesion.freezeSesionSoloPosicion(this.toString());
        if (declarantes == null) {
            return true;
        }
        boolean bl2 = true;
        String string2 = "";
        String string3 = "";
        Object var8_8 = null;
        Object var9_9 = null;
        String string4 = "";
        String string5 = "";
        int n = 0;
        double d = 0.0;
        if (!(string.equalsIgnoreCase("D") || string.equalsIgnoreCase("C") || string.equalsIgnoreCase("J"))) {
            long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)Integer.parseInt(string));
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSHR").trim();
            n = this.dameEdad(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FNACHR").trim());
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
        } else {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPGMIN_" + this.dameDeclaracion(string)).trim();
            n = this.dameEdad(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPFNAC_" + this.dameDeclaracion(string)).trim());
        }
        string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TADDLG").trim();
        string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PALDLG").trim();
        d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TPDIN").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TPVA").trim());
        if (string2.length() != 0 && string4.length() == 0 & n < Constantes.getEdadJubilacion() & d > 0.0) {
            bl2 &= this.addErrorOWarning(iSesion, "100P236", "W", "TPDIN(" + string + ")");
        }
        boolean bl3 = bl = (string2.equals("2") || string2.equals("3")) && string4.equals("1");
        if (string2.equals("1") && string4.equals("2") || bl || string2.length() == 0 && (string4.equals("1") || string4.equals("2"))) {
            bl2 &= this.addErrorOWarning(iSesion, "100P274", "W", "TPDIN(" + string + ")");
        }
        if (n > Constantes.getEdadJubilacion() && (string4.equals("1") || string4.equals("2")) && string5.equalsIgnoreCase("false")) {
            bl2 &= this.addErrorOWarning(iSesion, "100P015", "W", "TPDIN(" + string + ")");
        }
        if (n < Constantes.getEdadJubilacion() && string5.equalsIgnoreCase("true")) {
            bl2 &= this.addErrorOWarning(iSesion, "100R585", "E", "TPDIN(" + string + ")");
        }
        iSesion.unfreeze(this.toString());
        return bl2;
    }

    public boolean validarUSOVivienda(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        boolean bl2 = false;
        long l = this.moveFirst(iSesion, declarantes, "INMUEBLES");
        long l2 = this.recordCount(iSesion, declarantes, "INMUEBLES");
        long l3 = 0L;
        while (l != l3) {
            int n;
            int n2;
            if (!bl2 && (n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01D"))) > (n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIASPERIODO"))) && n != Constantes.getDiasanyo()) {
                bl &= this.addErrorOWarning(iSesion, "100R265", "E", "PC(" + string + ")", "%" + l + "$INMUEBLES");
                bl2 = true;
            }
            l3 = l;
            if (l2 == l) break;
            l = this.moveNext(iSesion, declarantes, "INMUEBLES");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarDomicilio(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl;
        if (declarantes == null) {
            return true;
        }
        boolean bl2 = true;
        Declarantes declarantes3 = declarantes;
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            declarantes3 = Declarantes.Declarante;
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DOMICILIO")) {
            iSesion.getOperaciones().move("DOMICILIO", (long)n);
            String string2 = declarantes3.getNombreUnico();
            if (iSesion.getOperaciones().obtenerPartidaString("TITDOMICILIO").equalsIgnoreCase(string2)) break;
            ++n;
        }
        n = iSesion.getOperaciones().obtenerPartidaString("NAC").trim().equalsIgnoreCase("true") ? 1 : 0;
        boolean bl3 = iSesion.getOperaciones().obtenerPartidaString("EXT").trim().equalsIgnoreCase("true");
        String string3 = "";
        String string4 = "";
        if (n != 0) {
            if (iSesion.getOperaciones().obtenerPartidaString("CALLE").trim().length() == 0) {
                string3 = "CALLE";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZVIAP").trim().length() == 0) {
                string3 = "ZVIAP";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().length() == 0) {
                string3 = "ZTIPNUM";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZNUM").trim().length() == 0 && !iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().equalsIgnoreCase("S/N") && !iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().equalsIgnoreCase("OTR")) {
                string3 = "ZTIPNUM";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZCODP").trim().length() == 0) {
                string3 = "ZCODP";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZMUNI").trim().length() == 0) {
                string3 = "ZMUNI";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZPROV").trim().length() == 0) {
                string3 = "ZPROV";
            }
            if (string3.length() != 0) {
                bl2 &= this.addErrorOWarning(iSesion, "WIN019", "E", string3 + "(" + string + ")");
            }
        } else if (bl3) {
            if (iSesion.getOperaciones().obtenerPartidaString("ZDOM1E").trim().length() == 0) {
                string4 = "ZDOM1E";
            } else if (iSesion.getOperaciones().obtenerPartidaString("ZPOBLAE").trim().length() == 0) {
                string4 = "ZPOBLAE";
            }
        }
        if (string4.length() != 0) {
            bl2 &= this.addErrorOWarning(iSesion, "100R557", "E", string4 + "(" + string + ")");
        }
        if (!(bl = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("CAMBIODOMI")))) {
            bl2 &= this.addErrorOWarning(iSesion, "100P510", "W", "CAMBIODOMI(" + string + ")");
        }
        return bl2;
    }

    private boolean validacionEspecialDomicilio(ISesion iSesion) throws Exception {
        boolean bl;
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        if (n != 15) {
            return true;
        }
        if (n == 15 && iSesion.existsPtr("CONYUGE") && (bl = iSesion.getOperaciones().obtenerPartidaString("DDCYDLG").equalsIgnoreCase("true"))) {
            boolean bl2;
            int n2 = 1;
            while ((long)n2 <= iSesion.getOperaciones().recordCount("DOMICILIO")) {
                iSesion.getOperaciones().move("DOMICILIO", (long)n2);
                String string = Declarantes.Conyuge.getNombreUnico();
                if (iSesion.getOperaciones().obtenerPartidaString("TITDOMICILIO").equalsIgnoreCase(string)) break;
                ++n2;
            }
            n2 = iSesion.getOperaciones().obtenerPartidaString("CALLE").trim().length() == 0 || iSesion.getOperaciones().obtenerPartidaString("ZVIAP").trim().length() == 0 || iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().length() == 0 ? 1 : 0;
            boolean bl3 = iSesion.getOperaciones().obtenerPartidaString("ZNUM").trim().length() == 0 && !iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().equalsIgnoreCase("S/N") && !iSesion.getOperaciones().obtenerPartidaString("ZTIPNUM").trim().equalsIgnoreCase("OTR");
            boolean bl4 = bl2 = iSesion.getOperaciones().obtenerPartidaString("EXT").trim().equalsIgnoreCase("true") && (iSesion.getOperaciones().obtenerPartidaString("ZDOM1E").trim().length() == 0 || iSesion.getOperaciones().obtenerPartidaString("ZPOBLAE").trim().length() == 0);
            if (iSesion.getOperaciones().obtenerPartidaString("NAC").trim().equalsIgnoreCase("true") && (n2 != 0 || bl3 || iSesion.getOperaciones().obtenerPartidaString("ZCODP").trim().length() == 0 || iSesion.getOperaciones().obtenerPartidaString("ZMUNI").trim().length() == 0 || iSesion.getOperaciones().obtenerPartidaString("ZPROV").trim().length() == 0) || bl2) {
                return false;
            }
        }
        return true;
    }

    private boolean addErrorOWarning(ISesion iSesion, String string, String string2, String string3) throws ExceptionMotor {
        return this.addErrorOWarning(iSesion, string, string2, string3, "");
    }

    private boolean addErrorOWarning(ISesion iSesion, String string, int n, String string2, String string3) throws ExceptionMotor {
        return this.addErrorOWarning(iSesion, string, n, string2, string3, "");
    }

    private boolean addErrorOWarning(ISesion iSesion, String string, String string2, String string3, String string4) throws ExceptionMotor {
        if (!string4.equals("")) {
            string3 = string3 + string4;
        }
        iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{string, string2, string3});
        if (!string2.equals("")) {
            return !string2.trim().equals("E");
        }
        return false;
    }

    private boolean addErrorOWarning(ISesion iSesion, String string, int n, String string2, String string3, String string4) throws ExceptionMotor {
        if (!string4.equals("")) {
            string3 = string3 + string4;
        }
        iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{string, n, string2, string3});
        if (!string2.equals("")) {
            return !string2.trim().equals("E");
        }
        return false;
    }

    public Object erroresOverflow(ISesion iSesion) throws MtrrException, Exception {
        List list = iSesion.getListaOverFlow();
        if (!list.isEmpty()) {
            return this.addErrorOWarning(iSesion, "100ROVF", "E", ((ITipoDatosCampoValor)list.get(0)).getNombreCampo());
        }
        return true;
    }

    public boolean validarInmuebles(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        long l = this.recordCount(iSesion, declarantes, "INMUEBLES");
        long l2 = this.moveFirst(iSesion, declarantes, "INMUEBLES");
        long l3 = 0L;
        while (l2 != l3) {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "USO").trim();
            string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NAT").trim();
            string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RC").trim();
            string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL").trim();
            string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PC").trim();
            string7 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "USUFC").trim();
            double d = Double.parseDouble(string6);
            double d2 = Double.parseDouble(string7);
            bl2 = bl2 || string2.equals("1") || string2.equals("3");
            boolean bl4 = bl3 = bl3 || string2.equals("4") || string2.equals("5");
            if ((string2.equals("1") || string2.equals("3")) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_IIC").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_GEA").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_GD").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_OGD").trim()) == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R274", "E", "PC(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            if (string5.equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P471", "W", "CL(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            if ((string2.equals("2") || string2.equals("3") || string2.equals("5")) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_RII").trim()) == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R272", "E", "PC(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            if ((string4.trim().length() > 0 || string5.equals("1") || string5.equals("2")) && (string6.length() == 0 && string7.length() == 0 || string3.length() == 0 || string2.length() == 0)) {
                bl &= this.addErrorOWarning(iSesion, "100R318", "E", "PC(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            if ((string2.equals("2") || string2.equals("3") || string2.equals("5")) && string3.equals("2")) {
                bl &= this.addErrorOWarning(iSesion, "100R335", "W", "PC(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            if (d + d2 > 100.0) {
                bl &= this.addErrorOWarning(iSesion, "100R542", "E", "PC(" + string + ")", "%" + l2 + "$INMUEBLES");
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "INMUEBLES");
        }
        if (bl3 && !bl2) {
            bl &= this.addErrorOWarning(iSesion, "100R316", "E", "PC(" + string + ")");
        }
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        long l4 = this.recordCount(iSesion, declarantes, "INMAFECTO");
        long l5 = this.moveFirst(iSesion, declarantes, "INMAFECTO");
        long l6 = 0L;
        while (l5 != l6) {
            double d;
            string8 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PCD").trim();
            string9 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "USUFD").trim();
            string10 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLD").trim();
            string11 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RCD").trim();
            string12 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NATD").trim();
            double d3 = Double.parseDouble(string8);
            if (d3 + (d = Double.parseDouble(string9)) > 100.0) {
                bl &= this.addErrorOWarning(iSesion, "100R542", "E", "PCD(" + string + ")", "%" + l2 + "$INMAFECTO");
            }
            if (string10.equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P219", "W", "CLD(" + string + ")", "%" + l2 + "$INMAFECTO");
            }
            if (!(string11.equals("") && string10.equals("1") && string10.equals("2") || !string8.equals("0") && !string9.equals("0") && !string12.equals(""))) {
                bl &= this.addErrorOWarning(iSesion, "100R558", "E", "TITD(" + string + ")", "%" + l2 + "$INMAFECTO");
            }
            l6 = l5;
            if (l5 == l4) break;
            l5 = this.moveNext(iSesion, declarantes, "INMAFECTO");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarViviendaHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT1");
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT2");
        String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT3");
        String string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT4");
        String string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT5");
        String string7 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT6");
        String string8 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT7");
        String string9 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZT8");
        String string10 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFARPAG1");
        String string11 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NONIFVH");
        if (string2.equals("3") && string3.equals("3") && string4.equals("3") && string5.equals("3") && string6.equals("3") && string7.equals("3") && string8.equals("3") && string9.equals("3") && string10.equals("") && string11.equals("")) {
            bl &= this.addErrorOWarning(iSesion, "100R562", "E", "ZT1(" + string + ")");
        }
        if (string2.trim().length() == 0 && string3.trim().length() == 0 && string4.length() == 0 && string5.trim().length() == 0 && string6.trim().length() == 0 && string7.trim().length() == 0 && string8.trim().length() == 0 && string9.trim().length() == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R203", "E", "ZT1(" + string + ")");
        }
        for (int i = 1; i <= 8; ++i) {
            double d;
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PORD" + i + "DLG"));
            if (!(d2 + (d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PORC" + i + "DLG"))) > 100.0)) continue;
            bl &= this.addErrorOWarning(iSesion, "100R225", "E", "ZT1(" + string + ")");
            break;
        }
        return bl;
    }

    public boolean validarNifPromotor(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        int n = this.switchMotor(iSesion, declarantes);
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFPRO");
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PAGOSPRO").trim());
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            String string3 = "";
            double d2 = 0.0;
            String string4 = "";
            double d3 = 0.0;
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NIFPRO");
                d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "PAGOSPRO").trim());
                if (d3 > 0.0 && string4.equals("")) {
                    string = "C";
                }
            }
            string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NIFPRO");
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PAGOSPRO").trim());
            if (d2 > 0.0 && string3.equals("")) {
                string = "D";
            }
        }
        if ((n == 0 || n == 1 || n == 15) && d > 0.0 && string2.equals("")) {
            bl &= this.addErrorOWarning(iSesion, "100P186", "E", "VHADQ(" + string + ")");
        }
        return bl;
    }

    public boolean validarFechaAdquisicionVivHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VFA1");
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CON1"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REHB1"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AMP1"));
        if (this.funcrentaValidador.comparaFechas(string2, "31122012") == 1) {
            bl &= this.addErrorOWarning(iSesion, "100P456", "W", "VHADQ(" + string + ")");
        }
        if (d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P509", "W", "VHCONS(" + string + ")");
        }
        if (d2 + d3 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P498", "W", "VHREHB(" + string + ")");
        }
        return bl;
    }

    public boolean validarPorcentajePrestamoVivHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TPC1"));
        if (d <= 50.0 && d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P457", "W", "VHADQ(" + string + ")");
        }
        return bl;
    }

    public boolean validarReinversionTransmisionVivHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3DC");
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3DD");
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3DN"));
        int n = this.funcrentaValidador.totalDias(string3, string2);
        if (d > 0.0 && n < 1096) {
            bl &= this.addErrorOWarning(iSesion, "100P467", "W", "G3DB(" + string + ")");
        }
        return bl;
    }

    public boolean validarAnualidadesAlimentosMinimoDescendientes(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPALIM"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MDES"));
        if (d > 0.0 && d2 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P468", "W", "IMPALIM(" + string + ")");
        }
        return bl;
    }

    public boolean validarDeduccionAdquisicionAccionesEntidades(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CANTRC"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED0E"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED8E"));
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFRC1");
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFRC2");
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "A6"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "AR6"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IB5"));
        double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CANT6"));
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT9"));
        double d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CT10"));
        double d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E9"));
        double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA9"));
        double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA10"));
        double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M11"));
        double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M13"));
        double d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MU6"));
        double d16 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MU7"));
        if (d > 0.0 && "".equals(string2) && "".equals(string3)) {
            bl &= this.addErrorOWarning(iSesion, "100R553", "E", "CANTRC(" + string + ")");
        }
        if (d2 > 0.0 && (d4 + d5 + d6 + d7 + d8 + d9 + d10 + d11 + d12 + d13 + d14 + d15 + d16 > 0.0 || d3 > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P469", "W", "CANTRC(" + string + ")");
        }
        return bl;
    }

    public boolean validarObrasVivHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        if (this.switchMotor(iSesion, declarantes) >= 2 && this.switchMotor(iSesion, declarantes) < 10) {
            return true;
        }
        boolean bl = true;
        return bl;
    }

    public boolean validarObrasVivHabitualParte2(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        if (this.switchMotor(iSesion, declarantes) >= 2 && this.switchMotor(iSesion, declarantes) < 10) {
            return true;
        }
        boolean bl = true;
        return bl;
    }

    public boolean validarFondosDeInversion(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        long l = this.recordCount(iSesion, declarantes, "G2GPFONDOS");
        long l2 = this.moveFirst(iSesion, declarantes, "G2GPFONDOS");
        long l3 = 0L;
        while (l2 != l3) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G2A_T").trim().length() > 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G2A_NIF").trim().length() == 0) {
                bl &= this.addErrorOWarning(iSesion, "100I013", "W", "G2A_NIF(" + string + ")", "%" + l2 + "$G2GPFONDOS");
                break;
            }
            l3 = l2;
            if (l == l2) break;
            l2 = this.moveNext(iSesion, declarantes, "G2GPFONDOS");
        }
        long l4 = this.recordCount(iSesion, declarantes, "G3GPFONDOS");
        long l5 = this.moveFirst(iSesion, declarantes, "G3GPFONDOS");
        long l6 = 0L;
        while (l5 != l6) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3A_T").trim().length() > 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3A_NIF").trim().length() == 0) {
                bl &= this.addErrorOWarning(iSesion, "100I013", "W", "G3A_NIF(" + string + ")", "%" + l5 + "$G3GPFONDOS");
                break;
            }
            l6 = l5;
            if (l4 == l5) break;
            l5 = this.moveNext(iSesion, declarantes, "G3GPFONDOS");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean compruebaAportacionesPatrProtegidoDiscapacidad(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, ExceptionMotor, Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PPROA0")) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PPRONIF0").trim().length() == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R175", "E", "PPRONIF0(" + string + ")");
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PPROA1")) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PPRONIF1").trim().length() == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R175", "E", "PPRONIF1(" + string + ")");
        }
        return bl;
    }

    public boolean validarGananciasPatrimoniales(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        long l = this.recordCount(iSesion, declarantes, "G2GPOTROS");
        long l2 = this.moveFirst(iSesion, declarantes, "G2GPOTROS");
        long l3 = 0L;
        while (l2 != l3) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G2CL").trim().equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P220", "W", "G2DB(" + string + ")", "%" + l2 + "$G2GPOTROS");
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "G2GPOTROS");
        }
        long l4 = this.recordCount(iSesion, declarantes, "G3GPOTROS");
        long l5 = this.moveFirst(iSesion, declarantes, "G3GPOTROS");
        long l6 = 0L;
        while (l5 != l6) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3CL").trim().equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P463", "W", "G3DB(" + string + ")", "%" + l5 + "$G3GPOTROS");
            }
            l6 = l5;
            if (l5 == l4) break;
            l5 = this.moveNext(iSesion, declarantes, "G3GPOTROS");
        }
        l = this.recordCount(iSesion, declarantes, "INMAFECTO");
        l2 = this.moveFirst(iSesion, declarantes, "INMAFECTO");
        l3 = 0L;
        while (l2 != l3) {
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CLD").trim().equals("3")) {
                bl &= this.addErrorOWarning(iSesion, "100P219", "W", "CLD(" + string + ")", "%" + l2 + "$INMAFECTO");
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "INMAFECTO");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarDeducDblImpInternacional(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RTEXVRBG1")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RTEXVRBG2")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RTEXVRBG3"));
        if (d != 0.0 && d > Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TPRDTO"))) {
            bl &= this.addErrorOWarning(iSesion, "100P299", "W", "CLDED1(" + string + ")");
        }
        double d2 = 0.0;
        String string2 = iSesion.getOperaciones().obtenerPartidaString("CBMETODO");
        if (string2.equals("ED")) {
            d2 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "F1EH");
        }
        if ((d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RAEEXVRBG1")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RAEEXVRBG2")) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RAEEXVRBG3"))) != 0.0 && d > this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1RNR") + d2) {
            bl &= this.addErrorOWarning(iSesion, "100P300", "E", "CLDED1(" + string + ")");
        }
        int n = 0;
        double d3 = 0.0;
        String string3 = "B_B13";
        double d4 = 0.0;
        long l = 0L;
        long l2 = this.obtenerClaveActiva(iSesion, declarantes, string3);
        long l3 = this.moveFirst(iSesion, declarantes, string3);
        long l4 = this.recordCount(iSesion, declarantes, string3);
        while (l != l3) {
            n = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TIPDB13").equals("") ? Integer.parseInt("0") : Integer.parseInt("" + this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TIPDB13"));
            d3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1DB13").equals("") ? Double.parseDouble("0") : Double.parseDouble("" + this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1DB13"));
            if (n == 1) {
                d4 += d3;
            }
            l = l3;
            if (l4 == l3) break;
            l3 = this.moveNext(iSesion, declarantes, string3);
        }
        this.move(iSesion, declarantes, string3, l2);
        string3 = "FREATRENTAS";
        double d5 = 0.0;
        l = 0L;
        l2 = this.obtenerClaveActiva(iSesion, declarantes, string3);
        l3 = this.moveFirst(iSesion, declarantes, string3);
        l4 = this.recordCount(iSesion, declarantes, string3);
        while (l != l3) {
            d5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVEX").equals("") ? (d5 += Double.parseDouble("0")) : (d5 += Double.parseDouble("" + this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVEX")));
            l = l3;
            if (l4 == l) break;
            l3 = this.moveNext(iSesion, declarantes, string3);
        }
        this.move(iSesion, declarantes, string3, l2);
        double d6 = d4 + d5;
        double d7 = 0.0;
        d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVVRBE1").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVVRBE2").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DIVVRBE3").trim());
        if (d7 > d6) {
            bl &= this.addErrorOWarning(iSesion, "100P301", "E", "CLDED1(" + string + ")");
        }
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORBAHVRBE1").trim());
        double d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORBAHVRBE2").trim());
        double d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORBAHVRBE3").trim());
        double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "SUMAGA").trim());
        double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B11").trim());
        double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B12").trim());
        double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B14").trim());
        double d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B15").trim());
        double d16 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B16").trim());
        double d17 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B17").trim());
        double d18 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORBO").trim());
        double d19 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BJJ3").trim());
        double d20 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1PFPT").trim());
        if (d12 < 0.0) {
            d12 = 0.0;
        }
        if (d13 < 0.0) {
            d13 = 0.0;
        }
        if (d14 < 0.0) {
            d14 = 0.0;
        }
        if (d15 < 0.0) {
            d15 = 0.0;
        }
        if (d16 < 0.0) {
            d16 = 0.0;
        }
        if (d17 < 0.0) {
            d17 = 0.0;
        }
        if (d18 < 0.0) {
            d18 = 0.0;
        }
        if (d8 + d9 + d10 > d11 + d12 + d13 + d14 + d15 + d16 + d17 + d18 + d19 + d20) {
            bl &= this.addErrorOWarning(iSesion, "100P470", "W", "CLDED1(" + string + ")");
        }
        return bl;
    }

    public boolean validarDeduccionesAutonomicas(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        if (this.switchMotor(iSesion, declarantes) >= 2 && this.switchMotor(iSesion, declarantes) < 10) {
            return true;
        }
        boolean bl = true;
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2)).trim();
        if (string2.equals(CTE_ANDALUCIA) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "A4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFAND").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFAND").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPA4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNIFA4").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIFA4").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(1) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(1) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_ARAGON) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "AR10").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFAR").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFAR").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR10").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNIFAR10").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIFAR10").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(2) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(2) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_ASTURIAS) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "PA5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFAST").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFAST").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1PA5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1PA5").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF1PA5").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2PA5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2PA5").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF2PA5").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(3) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(3) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_CANTABRIA) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CANT1").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFCANT1").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFCANT1").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPCANT1").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNIFCANT1").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIFCANT1").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(6) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(6) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_CASTILLA_LA_MANCHA) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CM13").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFCM").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFCM").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1CM13").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1CM13").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2CM13").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2CM13").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(7) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(7) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_CASTILLA_LEON) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CL5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFCL").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFCL").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1CL5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1CL5").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF1CL5").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2CL5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2CL5").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF2CL5").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(8) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(8) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_CATALUNYA) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CT4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFCAT").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFCAT").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1CT4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1CT4").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF1CT4").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2CT4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2CT4").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF2CT4").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP3CT4").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF3CT4").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF3CT4").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(9) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(9) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_GALICIA) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "GA6").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFGAL").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFGAL").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP12GA6").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP13GA6").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP22GA6").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP23GA6").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP32GA6").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP33GA6").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(11) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(11) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_MADRID) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "M5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFMAD").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFMAD").trim().length() == 0) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPM5").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNIFM5").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIFM5").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(12) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(12) + "(" + string + ")");
            }
        }
        if (string2.equals(CTE_VALENCIA) && (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA14").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFVAL1").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFVAL1").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA15").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFVAL2").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NONIFVAL2").trim().length() == 0)) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1VA14").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1VA14").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF1VA14").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2VA14").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2VA14").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF2VA14").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP3VA14").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF3VA14").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF3VA14").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(17) + "(" + string + ")");
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP11VA15").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP13VA15").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF1VA15").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP21VA15").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP23VA15").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF2VA15").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP31VA15").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP33VA15").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNONIF3VA15").trim().length() == 0) {
                    bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(17) + "(" + string + ")");
                }
            } else {
                bl &= this.addErrorOWarning(iSesion, "100R110", "E", this.damePrimerCampoDeducAutonomicas(17) + "(" + string + ")");
            }
        }
        return bl;
    }

    private String quitarTildes(String string) {
        String string2 = "";
        block12: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u00e1': {
                    string2 = string2 + "a";
                    continue block12;
                }
                case '\u00c1': {
                    string2 = string2 + "A";
                    continue block12;
                }
                case '\u00e9': {
                    string2 = string2 + "e";
                    continue block12;
                }
                case '\u00c9': {
                    string2 = string2 + "E";
                    continue block12;
                }
                case '\u00ed': {
                    string2 = string2 + "i";
                    continue block12;
                }
                case '\u00cd': {
                    string2 = string2 + "I";
                    continue block12;
                }
                case '\u00f3': {
                    string2 = string2 + "o";
                    continue block12;
                }
                case '\u00d3': {
                    string2 = string2 + "O";
                    continue block12;
                }
                case '\u00fa': {
                    string2 = string2 + "u";
                    continue block12;
                }
                case '\u00da': {
                    string2 = string2 + "U";
                    continue block12;
                }
                default: {
                    string2 = string2 + string.charAt(i);
                }
            }
        }
        return string2;
    }

    private int cTEProvincia2Integer(String string) {
        return Integer.parseInt(string);
    }

    private String dameCCAAdeProvincia(ISesion iSesion, Declarantes declarantes) throws Exception {
        boolean bl;
        String string;
        Declarantes declarantes2 = declarantes;
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            declarantes2 = Declarantes.Declarante;
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DOMICILIO")) {
            iSesion.getOperaciones().move("DOMICILIO", (long)n);
            string = declarantes2.getNombreUnico();
            if (iSesion.getOperaciones().obtenerPartidaString("TITDOMICILIO").equalsIgnoreCase(string)) break;
            ++n;
        }
        String string2 = this.quitarTildes(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZPROV").trim());
        string = this.quitarTildes(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZPAISE").trim());
        boolean bl2 = string2.equalsIgnoreCase("ALMERIA") || string2.equalsIgnoreCase("CADIZ") || string2.equalsIgnoreCase("CORDOBA") || string2.equalsIgnoreCase("GRANADA");
        boolean bl3 = bl = string2.equalsIgnoreCase("HUELVA") || string2.equalsIgnoreCase("JAEN") || string2.equalsIgnoreCase("MALAGA") || string2.equalsIgnoreCase("SEVILLA");
        if (bl2 || bl) {
            return CTE_ANDALUCIA;
        }
        if (string2.equalsIgnoreCase("HUESCA") || string2.equalsIgnoreCase("TERUEL") || string2.equalsIgnoreCase("ZARAGOZA")) {
            return CTE_ARAGON;
        }
        if (string2.equalsIgnoreCase("ASTURIAS")) {
            return CTE_ASTURIAS;
        }
        if (string2.contains("BALEARS")) {
            return CTE_BALEARES;
        }
        if (string2.contains("PALMAS") || string2.contains("TENERIFE")) {
            return CTE_CANARIAS;
        }
        if (string2.equalsIgnoreCase("CANTABRIA")) {
            return CTE_CANTABRIA;
        }
        if (string2.equalsIgnoreCase("ALBACETE") || string2.equalsIgnoreCase("CIUDAD REAL") || string2.equalsIgnoreCase("CUENCA") || string2.equalsIgnoreCase("GUADALAJARA") || string2.equalsIgnoreCase("TOLEDO")) {
            return CTE_CASTILLA_LA_MANCHA;
        }
        bl2 = string2.equalsIgnoreCase("AVILA") || string2.equalsIgnoreCase("BURGOS") || string2.equalsIgnoreCase("LEON") || string2.equalsIgnoreCase("PALENCIA") || string2.equalsIgnoreCase("SALAMANCA");
        boolean bl4 = bl = string2.equalsIgnoreCase("SEGOVIA") || string2.equalsIgnoreCase("SORIA") || string2.equalsIgnoreCase("VALLADOLID") || string2.equalsIgnoreCase("ZAMORA");
        if (bl2 || bl) {
            return CTE_CASTILLA_LEON;
        }
        if (string2.equalsIgnoreCase("BARCELONA") || string2.equalsIgnoreCase("GIRONA") || string2.equalsIgnoreCase("LLEIDA") || string2.equalsIgnoreCase("TARRAGONA")) {
            return CTE_CATALUNYA;
        }
        if (string2.equalsIgnoreCase("BADAJOZ") || string2.equalsIgnoreCase("CACERES")) {
            return CTE_EXTREMADURA;
        }
        if (string2.contains("CORU\u00d1A") || string2.equalsIgnoreCase("LUGO") || string2.equalsIgnoreCase("OURENSE") || string2.equalsIgnoreCase("PONTEVEDRA")) {
            return CTE_GALICIA;
        }
        if (string2.equalsIgnoreCase("MADRID")) {
            return CTE_MADRID;
        }
        if (string2.equalsIgnoreCase("MURCIA")) {
            return CTE_MURCIA;
        }
        if (string2.contains("RIOJA")) {
            return CTE_RIOJA;
        }
        if (string2.equalsIgnoreCase("ALICANTE/ALACANT") || string2.equalsIgnoreCase("CASTELLON/CASTELLO") || string2.equalsIgnoreCase("VALENCIA/VALENCIA")) {
            return CTE_VALENCIA;
        }
        if (string2.equalsIgnoreCase("CEUTA")) {
            return CTE_CEUTA;
        }
        if (string2.equalsIgnoreCase("MELILLA")) {
            return CTE_MELILLA;
        }
        if (string.length() != 0) {
            return "20";
        }
        if (string2.length() == 0 && string.length() == 0) {
            return "";
        }
        return "-1";
    }

    private boolean validacionesVariasH1H2(ISesion iSesion) throws Exception {
        boolean bl = true;
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: 
            case 1: 
            case 15: {
                int n2 = Constantes.getNumhijosrentas();
                double[] dArray = new double[n2];
                boolean[] blArray = new boolean[n2];
                boolean[] blArray2 = new boolean[n2];
                for (int i = 1; i <= n2; ++i) {
                    dArray[i - 1] = 0.0;
                    blArray[i - 1] = false;
                    blArray2[i - 1] = false;
                }
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                int n3 = 1;
                while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                    iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)n3);
                    dArray[n3 - 1] = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim());
                    blArray[n3 - 1] = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DEVOLHR").trim().equalsIgnoreCase("true");
                    blArray2[n3 - 1] = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "R8000HR").trim().equalsIgnoreCase("true");
                    ++n3;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
                if (n != 15) {
                    n3 = 1;
                    while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                        if (8000.0 >= dArray[n3 - 1] && dArray[n3 - 1] > 1800.0 && !blArray[n3 - 1]) {
                            bl = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB")) ? (bl &= this.addErrorOWarning(iSesion, "100P183" + n3, "W", "DATOSPERSONALES#1:NOMHR")) : (bl &= this.addErrorOWarning(iSesion, "100P183", "W", "DATOSPERSONALES#1:NOMHR"));
                        }
                        if (blArray[n3 - 1] && dArray[n3 - 1] <= 1800.0) {
                            bl = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB")) ? (bl &= this.addErrorOWarning(iSesion, "100P238" + n3, "W", "DATOSPERSONALES#1:NOMHR")) : (bl &= this.addErrorOWarning(iSesion, "100P238", "W", "DATOSPERSONALES#1:NOMHR"));
                        }
                        ++n3;
                    }
                }
                n3 = 1;
                while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                    if (blArray2[n3 - 1] && dArray[n3 - 1] <= 8000.0) {
                        bl = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB")) ? (bl &= this.addErrorOWarning(iSesion, "100P241" + n3, "W", "DATOSPERSONALES#1:NOMHR")) : (bl &= this.addErrorOWarning(iSesion, "100P241", "W", "DATOSPERSONALES#1:NOMHR"));
                    }
                    ++n3;
                }
                break;
            }
        }
        return bl;
    }

    private boolean validarObligacionDeclararHijos(ISesion iSesion) throws Exception {
        boolean bl = true;
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        String string = "";
        switch (n) {
            case 0: 
            case 1: {
                boolean bl2 = false;
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                int n2 = 1;
                while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                    bl2 = false;
                    if (iSesion.existsPtr("HIJO" + n2)) {
                        bl2 = this.cr.obligacionDeclarar(iSesion, Declarantes.parseInt(20 + n2 * 10));
                        iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)n2);
                        if (bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) > 1800.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) <= 8000.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DEVOLHR").trim().equalsIgnoreCase("false")) {
                            string = "100P179";
                            bl = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB")) ? (bl &= this.addErrorOWarning(iSesion, string + n2, "W", "DATOSPERSONALES#1:NOMHR")) : (bl &= this.addErrorOWarning(iSesion, string, "W", "DATOSPERSONALES#1:NOMHR"));
                        }
                    }
                    ++n2;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
            }
        }
        return bl;
    }

    private boolean comprobarFormaPagoParaImpresion(ISesion iSesion, Declarantes declarantes) throws Exception {
        return this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FPAGOC").equals("3");
    }

    private boolean validacionesID(ISesion iSesion) throws ExceptionMotor, Exception {
        Object object;
        boolean bl = true;
        if (Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB"))) {
            String string = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "T1_CUENTACORRIENTE");
            double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "YDEVOL").trim());
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RESINGDEV").trim());
            if (string.length() != 0) {
                if (d > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100P494", "W", "T1_CUENTACORRIENTE");
                }
                if (d2 > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100P495", "W", "T1_CUENTACORRIENTE");
                }
            }
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "T1_FORMAPAGO");
            String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "T1_FORMAPAGO_PF1");
            if (string2.equals("U") || string3.equals("U")) {
                String string4 = "T1_FORMAPAGO";
                if (string3.length() > 0) {
                    string4 = "T1_FORMAPAGO_PF1";
                }
                String string5 = iSesion.getMotor().getClaseGestionReglas().getDiscriminante(iSesion);
                Integer n = 1;
                if (string5.contains("F")) {
                    n = 3;
                } else if (string5.contains("O")) {
                    n = 2;
                }
                if (n == 1) {
                    bl &= this.addErrorOWarning(iSesion, "100R197", "W", string4);
                } else if (n == 3) {
                    bl &= this.addErrorOWarning(iSesion, "100P182", "W", string4);
                } else if (n == 2) {
                    bl &= this.addErrorOWarning(iSesion, "100R197", "E", string4);
                }
            }
            return bl;
        }
        String string = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "Y81");
        if (string.length() == 25 && ((String[])(object = string.split("-"))).length == 2) {
            try {
                string = string.substring(0, 5) + string.substring(5, 9) + "-" + string.substring(9, 13) + "-" + string.substring(13, 17) + "-" + string.substring(17, 21) + "-" + string.substring(21, 25);
                iSesion.getOperaciones().establecerPartida("Y81", (Object)string);
            }
            catch (Exception exception) {
                bl &= this.addErrorOWarning(iSesion, "WIN030", "E", "Y81");
            }
        }
        if (iSesion.getOperaciones().obtenerEstadoPartida("Y81") == 255 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "Y81").trim().length() < 29 && (this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FORMADEVC").equals("1") || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "Y41").trim().equalsIgnoreCase("true") || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FPAGOC").equals("2") || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FPAGOC").equals("3"))) {
            bl &= this.addErrorOWarning(iSesion, "WIN030", "E", "Y81");
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "YDEVOL").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FORMADEVC").trim().length() == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R579", "E", "FORMADEVC");
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "Y1PLAZO").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "FPAGOC").trim().length() == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R190", "E", "FPAGOC");
        }
        if (this.comprobarFormaPagoParaImpresion(iSesion, this.getMISesion(iSesion))) {
            object = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "INFORMACION"));
            if ((Integer)object == 1) {
                bl &= this.addErrorOWarning(iSesion, "100R197", "W", "FPAGOC");
            } else if ((Integer)object == 3) {
                bl &= this.addErrorOWarning(iSesion, "100P182", "W", "FPAGOC");
            } else if ((Integer)object == 2) {
                bl &= this.addErrorOWarning(iSesion, "100R197", "E", "FPAGOC");
            }
        }
        object = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "Y81");
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "YDEVOL").trim());
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RESINGDEV").trim());
        if (!((String)object).substring(2, 3).equalsIgnoreCase("-")) {
            if (d > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P494", "W", "Y81");
            }
            if (d3 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P495", "W", "Y81");
            }
        }
        return bl;
    }

    private int convertirCadNum2(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean fechaNoEsValida1(int n, String string, int n2) {
        return n2 < 2015 && n2 != 0;
    }

    private boolean fechaNoEsValida2(int n, String string, int n2) {
        return n2 == 2015 && !string.equalsIgnoreCase("abril") && !string.equalsIgnoreCase("mayo") && !string.equalsIgnoreCase("junio") && !string.equalsIgnoreCase("julio") && !string.equalsIgnoreCase("agosto") && !string.equalsIgnoreCase("septiembre") && !string.equalsIgnoreCase("octubre") && !string.equalsIgnoreCase("noviembre") && !string.equalsIgnoreCase("diciembre") && !string.equalsIgnoreCase("MAIG") && !string.equalsIgnoreCase("JUNY") && !string.equalsIgnoreCase("JULIOL") && !string.equalsIgnoreCase("AGOST") && !string.equalsIgnoreCase("SETEMBRE") && !string.equalsIgnoreCase("NOVEMBRE") && !string.equalsIgnoreCase("DESEMBRE") && !string.equalsIgnoreCase("MAIO") && !string.equalsIgnoreCase("XU\u00d1O") && !string.equalsIgnoreCase("XULLO") && !string.equalsIgnoreCase("XU\u00d1O") && !string.equalsIgnoreCase("SETEMBRO") && !string.equalsIgnoreCase("OUTUBRO") && !string.equalsIgnoreCase("NOVEMBRO") && !string.equalsIgnoreCase("DECEMBRO");
    }

    private boolean validarFechaDeclaracion(ISesion iSesion) throws Exception {
        boolean bl = true;
        String string = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "LUGARDECLA").trim();
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "DDDECLAR").trim());
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "MMDECLAR").trim();
        int n2 = this.convertirCadNum2(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "ADECLAR").trim());
        if (n != 0 && (string2.equals("") || n2 == 0) || !string2.equals("") && (n == 0 || n2 == 0) || n2 != 0 && (n == 0 || string2.equals(""))) {
            String string3 = "DDDECLAR";
            if (n == 0) {
                string3 = "DDDECLAR";
            } else if (string2.equals("")) {
                string3 = "MMDECLAR";
            } else if (n2 == 0) {
                string3 = "ADECLAR";
            }
            bl &= this.addErrorOWarning(iSesion, "100P385", "E", string3);
        } else if (string.equals("") || n == 0 || string2.equals("") || n2 == 0) {
            bl &= this.addErrorOWarning(iSesion, "100P384", "W", "LUGARDECLA");
        } else if (this.fechaNoEsValida1(n, string2, n2) || this.fechaNoEsValida2(n, string2, n2)) {
            bl &= this.addErrorOWarning(iSesion, "100P385", "W", "LUGARDECLA");
        }
        return bl;
    }

    private boolean validacionesComplementaria(ISesion iSesion) throws NumberFormatException, Exception {
        boolean bl = true;
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        int n2 = 29;
        if (Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("ENTORNOWEB"))) {
            n2 = 24;
        }
        switch (n) {
            case 0: 
            case 1: {
                if (!(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RESULTADO").trim()) < 0.0) || !(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "TCNN110").trim()) > 0.0) || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "TCNN112").trim()) != 0.0 || this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "TCCC").trim().length() >= n2) break;
                return false;
            }
        }
        return bl;
    }

    private boolean validarControlRentasH1(ISesion iSesion) throws NumberFormatException, Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: 
            case 1: 
            case 15: {
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", 1L);
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) > 8000.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "R8000HR").trim().equalsIgnoreCase("false")) {
                    return false;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
            }
        }
        return true;
    }

    private boolean validarControlRentasH2(ISesion iSesion) throws NumberFormatException, Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: 
            case 1: 
            case 15: {
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                long l2 = iSesion.getOperaciones().move("DESCENDIENTESRENTAS", 2L);
                if (l2 != 2L) {
                    return true;
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) > 8000.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "R8000HR").trim().equalsIgnoreCase("false")) {
                    return false;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
            }
        }
        return true;
    }

    private boolean validarControlRentasH3(ISesion iSesion) throws NumberFormatException, Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: 
            case 1: 
            case 15: {
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                long l2 = iSesion.getOperaciones().move("DESCENDIENTESRENTAS", 3L);
                if (l2 != 3L) {
                    return true;
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) > 8000.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "R8000HR").trim().equalsIgnoreCase("false")) {
                    return false;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
            }
        }
        return true;
    }

    private boolean validarControlRentasH4(ISesion iSesion) throws NumberFormatException, Exception {
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        switch (n) {
            case 0: 
            case 1: 
            case 15: {
                long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
                long l2 = iSesion.getOperaciones().move("DESCENDIENTESRENTAS", 4L);
                if (l2 != 4L) {
                    return true;
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "RENTASHR").trim()) > 8000.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), "R8000HR").trim().equalsIgnoreCase("false")) {
                    return false;
                }
                iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
            }
        }
        return true;
    }

    public boolean validarDeduccionAlquilerViviendaHabitual(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, ExceptionMotor, Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        int n = this.switchMotor(iSesion, declarantes);
        boolean bl2 = true;
        int n2 = 1;
        while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (n != n2 + 1) {
                bl2 = false;
            }
            ++n2;
        }
        if (bl2 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "DEDAL").trim()) > 0.0 && (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "IMPAL1").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFAL1").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIF1ALQ").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "IMPAL2").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIFAL2").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "NIF2ALQ").trim().length() == 0)) {
            if (declarantes2 != declarantes) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP1IMPAL").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1IMPAL").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF1ALQ").trim().length() == 0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP2IMPAL").trim()) > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2IMPAL").trim().length() == 0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIF2ALQ").trim().length() == 0) {
                    return this.addErrorOWarning(iSesion, "100R323", "E", "IMPAL(" + string + ")");
                }
            } else {
                return this.addErrorOWarning(iSesion, "100R323", "E", "IMPAL(" + string + ")");
            }
        }
        return bl;
    }

    public boolean validarCoherenciaCCAAyMuni(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (declarantes == null) {
            return bl;
        }
        String string2 = this.dameCCAAdeProvincia(iSesion, declarantes);
        if (string2 != null && string2.length() > 0 && !this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZCCAD").trim().equalsIgnoreCase(string2)) {
            bl &= this.addErrorOWarning(iSesion, "100P192", "W", "DATOSPERSONALES#3:" + this.getNombrePartidaDescripcionCCAAParaDeclarante(iSesion, declarantes));
        }
        return bl;
    }

    public boolean validarTfno(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        String string2;
        if (declarantes == null) {
            return true;
        }
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            string = "D";
        }
        Declarantes declarantes3 = declarantes2;
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            declarantes3 = Declarantes.Declarante;
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DOMICILIO")) {
            iSesion.getOperaciones().move("DOMICILIO", (long)n);
            string2 = declarantes3.getNombreUnico();
            if (iSesion.getOperaciones().obtenerPartidaString("TITDOMICILIO").equalsIgnoreCase(string2)) break;
            ++n;
        }
        n = "true".equalsIgnoreCase(iSesion.getOperaciones().obtenerPartidaString("NAC")) ? 1 : 0;
        string2 = iSesion.getOperaciones().obtenerPartidaString("ZTELE").trim();
        String string3 = iSesion.getOperaciones().obtenerPartidaString("ZTELEM").trim();
        String string4 = iSesion.getOperaciones().obtenerPartidaString("ZTELEE").trim();
        String string5 = iSesion.getOperaciones().obtenerPartidaString("ZTELEME").trim();
        if (string2.equals("0") && string3.equals("") && string4.equals("0") && string5.equals("")) {
            if (n != 0) {
                return this.addErrorOWarning(iSesion, "100I009", "W", "CALLE(" + string + ")");
            }
            return this.addErrorOWarning(iSesion, "100I009", "W", "ZDOM1E(" + string + ")");
        }
        return true;
    }

    public boolean validarReducSistPrevisionSocialMinusvalidos(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        long l;
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        if (!(string.equalsIgnoreCase("D") || string.equalsIgnoreCase("C") || string.equalsIgnoreCase("J"))) {
            l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)Integer.parseInt(string));
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSHR").trim();
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
        } else {
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPGMIN_" + this.dameDeclaracion(string)).trim();
        }
        l = this.recordCount(iSesion, declarantes, "IRDISCAPACIDAD");
        long l2 = this.moveFirst(iSesion, declarantes, "IRDISCAPACIDAD");
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VNIF").trim();
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PP0").trim());
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PP1").trim());
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PP2").trim());
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PP3").trim());
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PP4").trim());
        long l3 = 0L;
        while (l2 != l3) {
            if (!bl2 && string2.length() == 0 && d3 + d5 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P049", "W", "IPPMIMI(" + string + ")", "%" + l2 + "$IRDISCAPACIDAD");
                bl2 = true;
            }
            if (!bl3 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMINIF").trim().length() == 0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIMI").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIPA").trim()) > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P062", "E", "IPPMINIF(" + string + ")", "%" + l2 + "$IRDISCAPACIDAD");
                bl3 = true;
            }
            if (!bl4 && !"".equals(string3) && d + d2 + d3 + d4 + d5 == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P493", "E", "IPPMINIF(" + string + ")", "%" + l2 + "$IRDISCAPACIDAD");
                bl4 = true;
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "IRDISCAPACIDAD");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarReducSistPrevisionSocialMinusvalidos2(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        boolean bl2 = false;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        String string2 = "";
        double d = 0.0;
        long l = this.recordCount(iSesion, declarantes, "IRDISCAPACIDAD");
        long l2 = this.moveFirst(iSesion, declarantes, "IRDISCAPACIDAD");
        long l3 = 0L;
        Integer n = new Integer(-1);
        while (l2 != l3) {
            if (!bl2 && (string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMINIF").trim()) != null && !string2.equals("")) {
                String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TIT2").trim();
                boolean bl3 = false;
                for (int i = 1; i <= Constantes.getNumhijosrentas(); ++i) {
                    if (!string3.endsWith("" + i)) continue;
                    n = i + 1;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    n = string3.startsWith("C") ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                if (hashMap2.get(string2) == null || ((Integer)hashMap2.get(string2)).equals("")) {
                    hashMap2.put(string2, n);
                }
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIMI").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIPA").trim());
                if (hashMap.get(string2) == null) {
                    hashMap.put(string2, new Double(0.0));
                }
                hashMap.put(string2, (Double)hashMap.get(string2) + d);
                if (hashMap2.get(string2) == null || ((Integer)hashMap2.get(string2)).equals("")) {
                    hashMap2.put(string2, n);
                } else {
                    Integer n2 = (Integer)hashMap2.get(string2);
                    if (n2 > n) {
                        hashMap2.put(string2, n);
                    }
                }
                if ((Double)hashMap.get(string2) > 24250.0) {
                    String string4 = "";
                    boolean bl4 = false;
                    for (int i = 1; i <= Constantes.getNumhijosrentas(); ++i) {
                        if ((Integer)hashMap2.get(string2) != i + 1) continue;
                        string4 = "" + i;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        string4 = (Integer)hashMap2.get(string2) == 1 ? "C" : "D";
                    }
                    bl &= this.addErrorOWarning(iSesion, "100R199", "E", "IPPMINIF(" + string4 + ")", "%" + l2 + "$IRDISCAPACIDAD");
                    bl2 = true;
                }
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "IRDISCAPACIDAD");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean validarComplementaria(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        if ((this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z8").equalsIgnoreCase("true") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z9").equalsIgnoreCase("true") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z10").equalsIgnoreCase("true") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z12").equalsIgnoreCase("true")) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RESCOMP")) <= 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R079", "E", "Z8(" + string + ")");
        }
        if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z11").equalsIgnoreCase("true") && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RESULTADO")) >= 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R362", "E", "Z11(" + string + ")");
        }
        return bl;
    }

    public boolean validarIncompatibilidadT682(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        return true;
    }

    public boolean validarPorcentajePrestamoHipotecario(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        String string2 = "";
        int n = this.switchMotor(iSesion, declarantes);
        switch (n) {
            case 0: {
                string2 = "D";
                break;
            }
            case 1: {
                string2 = "C";
                break;
            }
            default: {
                return true;
            }
        }
        if (!this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            string2 = "D";
        }
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "TPC1").trim());
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VNI1").trim();
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "TPC1").trim());
        String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VNI1").trim();
        if (d != d2 && string3.equals(string4)) {
            bl &= this.addErrorOWarning(iSesion, "100R385", "W", "VHADQ(" + string2 + ")");
        }
        return bl;
    }

    private String buscarCasillaFoco80Punto33(ISesion iSesion, Declarantes declarantes) throws Exception {
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21RGS").trim()) != 0.0) {
            return "M21RGS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21RES").trim()) != 0.0) {
            return "M21RES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21ICS").trim()) != 0.0) {
            return "M21ICS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21IBS").trim()) != 0.0) {
            return "M21IBS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21A38S").trim()) != 0.0) {
            return "M21A38S";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21MAS").trim()) != 0.0) {
            return "M21MAS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21FPS").trim()) != 0.0) {
            return "M21FPS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21CES").trim()) != 0.0) {
            return "M21CES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21PCES").trim()) != 0.0) {
            return "M21PCES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21A11S").trim()) != 0.0) {
            return "M21A11S";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21BWS").trim()) != 0.0) {
            return "M21BWS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21RHS").trim()) != 0.0) {
            return "M21RHS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21BIS").trim()) != 0.0) {
            return "M21BIS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21LOS").trim()) != 0.0) {
            return "M21LOS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21AZS").trim()) != 0.0) {
            return "M21AZS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21JMS").trim()) != 0.0) {
            return "M21JMS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21DS16CS").trim()) != 0.0) {
            return "M21DS16CS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21EXPMS").trim()) != 0.0) {
            return "M21EXPMS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21GLS").trim()) != 0.0) {
            return "M21GLS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21AOS").trim()) != 0.0) {
            return "M21AOS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21MBS").trim()) != 0.0) {
            return "M21MBS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21CMEGS").trim()) != 0.0) {
            return "M21CMEGS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21BNS").trim()) != 0.0) {
            return "M21BNS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21GRS").trim()) != 0.0) {
            return "M21GRS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21LORS").trim()) != 0.0) {
            return "M21LORS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21UIGS").trim()) != 0.0) {
            return "M21UIGS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21CCPS").trim()) != 0.0) {
            return "M21CCPS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21BWJS").trim()) != 0.0) {
            return "M21BWJS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21PARS").trim()) != 0.0) {
            return "M21PARS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21BMWS").trim()) != 0.0) {
            return "M21BMWS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21CTOS").trim()) != 0.0) {
            return "M21CTOS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21MAHWS").trim()) != 0.0) {
            return "M21MAHWS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21AIDMS").trim()) != 0.0) {
            return "M21AIDMS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21RAES").trim()) != 0.0) {
            return "M21RAES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21ALS").trim()) != 0.0) {
            return "M21ALS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21EXPS").trim()) != 0.0) {
            return "M21EXPS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21QUIS").trim()) != 0.0) {
            return "M21QUIS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21WCLS").trim()) != 0.0) {
            return "M21WCLS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21JMES").trim()) != 0.0) {
            return "M21JMES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21TCMS").trim()) != 0.0) {
            return "M21TCMS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M21ABES").trim()) != 0.0) {
            return "M21ABES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22AFS").trim()) != 0.0) {
            return "M22AFS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22RMS").trim()) != 0.0) {
            return "M22RMS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22ICS").trim()) != 0.0) {
            return "M22ICS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22IBS").trim()) != 0.0) {
            return "M22IBS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22A38S").trim()) != 0.0) {
            return "M22A38S";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22FPS").trim()) != 0.0) {
            return "M22FPS";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22CES").trim()) != 0.0) {
            return "M22CES";
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "M22ADS").trim()) != 0.0) {
            return "M22ADS";
        }
        return "M21RGS";
    }

    public boolean validarVariosANivelDeDeclaracion(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = string.startsWith("1") || string.startsWith("2") || string.startsWith("3") || string.startsWith("4");
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TPING").trim());
        double d2 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1INGRESO");
        double d3 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E1SUMA");
        double d4 = this.obtenerContadorHashMapDeMotor(iSesion, declarantes, "E1INGRESOespecial").intValue();
        double d5 = this.obtenerContadorHashMapDeMotor(iSesion, declarantes, "E1INGRESOespecial13").intValue();
        double d6 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E4AA");
        double d7 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E4AC");
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AK"));
        double d9 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E5AB");
        double d10 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "E5II");
        double d11 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "F1EH");
        double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED1MATER"));
        double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED2MATER"));
        double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED3MATER"));
        double d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED4MATER"));
        double d16 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED5MATER"));
        double d17 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED6MATER"));
        double d18 = d12 + d13 + d14 + d15 + d16 + d17;
        double d19 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ABONOMATER").trim());
        double d20 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RET9").trim());
        double d21 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RET4").trim());
        double d22 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RET1RET3").trim());
        double d23 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RAOC").trim());
        double d24 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RAOCP").trim());
        int n = this.switchMotor(iSesion, declarantes);
        double d25 = 0.0;
        switch (n) {
            case 0: 
            case 1: {
                d25 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RSUMAD" + n).trim());
            }
        }
        if (!bl2) {
            double d26;
            double d27 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "REDPMIN").trim());
            if (d27 + d25 > 24250.0) {
                bl &= this.addErrorOWarning(iSesion, "100P075", "E", "RGAP" + n + "(" + string + ")");
            }
            if (d23 + d24 > 2000.0) {
                bl &= this.addErrorOWarning(iSesion, "100P511", "W", "APORTOT(" + string + ")");
            }
            if (d19 == 0.0 && d18 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100I029", "W", "MATER(" + string + ")");
            }
            if (d19 + d18 > 0.0 && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HOMBRE_" + this.dameDeclaracion(string)).trim().equalsIgnoreCase("true")) {
                bl &= this.addErrorOWarning(iSesion, "100P071", "W", "MATER(" + string + ")");
            }
            if (d19 > 0.0 && d18 == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P114", "W", "MATER(" + string + ")");
            }
            boolean bl3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MUJER_" + this.dameDeclaracion(string)).trim().equalsIgnoreCase("true");
            if (this.obtenerContadorHashMapDeMotor(iSesion, declarantes, "DECHIM") > 0 && d + d2 + d3 + d6 + d7 + d10 + d9 + d11 != 0.0 && bl3 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MATER").trim()) == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P297", "W", "MATER(" + string + ")");
            }
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MATER").trim()) > 0.0 && d + d2 + d3 + d6 + d7 + d10 + d9 + d11 == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P356", "W", "MATER(" + string + ")");
            }
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED96").trim()) != 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT96E").trim()) == 0.0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED96").trim()) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT96E").trim()) != 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R182", "E", "DED96(" + string + ")");
            }
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED97E").trim()) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT97E").trim()) != 0.0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED97E").trim()) != 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT97E").trim()) == 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R182", "E", "DED97E(" + string + ")");
            }
            if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED98A").trim()) != 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT98A").trim()) == 0.0 || Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED98A").trim()) == 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "INT98A").trim()) != 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100R182", "E", "DED98A(" + string + ")");
            }
            if (!(!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FCALCULOINTD").trim().equals("") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EJERINTDEST").trim().equals("") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EJERINTD1").trim().equals("") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EJERINTD2").trim().equals("") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EJERINTD3").trim().equals("") && this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EJERINTDAUT").trim().equals(""))) {
                bl &= this.addErrorOWarning(iSesion, "100R559", "E", "INT96E(" + string + ")");
            }
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FCALCULOINTD").trim();
            String string3 = "";
            if (this.switchMotor(iSesion, declarantes2) == 15 && this.switchMotor(iSesion, declarantes) == 0 && iSesion.existsPtr("DEFAULT") && iSesion.existsPtr("CONYUGE") && iSesion.existsPtr("DEFAULT") && iSesion.existsPtr("CONYUGE")) {
                string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "FCALCULOINTD").trim();
            }
            boolean bl4 = true;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            bl4 = bl4 && this.addFechaCalculo(hashMap, string2);
            boolean bl5 = bl4 = bl4 && this.addFechaCalculo(hashMap, string3);
            if (!bl4 && declarantes2.equals(Declarantes.UnidadFamiliar) && iSesion.existsPtr("CONYUGE")) {
                bl &= this.addErrorOWarning(iSesion, "100P298", "E", "CEXGE1(J)");
            }
            double d28 = 0.0;
            Declarantes declarantes3 = null;
            declarantes3 = this.funcrentaValidador.cualDeclaracion(iSesion);
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
            long l = iSesion.getOperaciones().obtenerClaveActiva("E1REGESTDIR");
            long l2 = iSesion.getOperaciones().moveFirst("E1REGESTDIR");
            long l3 = 0L;
            long l4 = iSesion.getOperaciones().recordCount("E1REGESTDIR");
            while (l3 != l2) {
                double d29 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RNR"));
                if (d29 > 0.0) {
                    d28 += d29;
                }
                l3 = l2;
                if (l2 == l4) continue;
                l2 = iSesion.getOperaciones().moveNext("E1REGESTDIR");
            }
            iSesion.getOperaciones().move("E1REGESTDIR", l);
            boolean bl6 = false;
            l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
            l2 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
            l3 = 0L;
            l4 = iSesion.getOperaciones().recordCount("FREATRENTAS");
            while (l3 != l2) {
                double d30 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EH"));
                if (d30 != 0.0) {
                    bl6 = true;
                }
                l3 = l2;
                if (l2 == l4) continue;
                l2 = iSesion.getOperaciones().moveNext("FREATRENTAS");
            }
            iSesion.getOperaciones().move("FREATRENTAS", l);
            boolean bl7 = false;
            l = iSesion.getOperaciones().obtenerClaveActiva("FRETRFISCAL");
            l2 = iSesion.getOperaciones().moveFirst("FRETRFISCAL");
            l3 = 0L;
            l4 = iSesion.getOperaciones().recordCount("FRETRFISCAL");
            while (l3 != l2) {
                d26 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F2EA"));
                if (d26 != 0.0) {
                    bl7 = true;
                }
                l3 = l2;
                if (l2 == l4) continue;
                l2 = iSesion.getOperaciones().moveNext("FRETRFISCAL");
            }
            iSesion.getOperaciones().move("FRETRFISCAL", l);
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes3);
            d26 = 0.0;
            String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CBMETODO");
            if (string4.equals("ED")) {
                d26 = this.obtenerSumatorioHashMapDeMotor(iSesion, declarantes, "F1EH");
            }
            double d31 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED5E"));
            double d32 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED6E"));
            if (!bl7 && d26 == 0.0) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEDEMPR").trim()) > 0.0 && this.cr.redondea(d2, 2) == 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100I017", "W", this.buscarCasillaFoco80Punto33(iSesion, declarantes) + "(" + string + ")");
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED5E").trim()) > 0.0 && this.cr.redondea(d2, 2) == 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100I018", "E", "M2414S(" + string + ")");
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED6E").trim()) > 0.0 && this.cr.redondea(d2, 2) == 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100I019", "E", "DED6E(" + string + ")");
                }
            }
            if (!bl7 && d31 > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01MA1M2414S").trim()) > d28 + d26) {
                bl &= this.addErrorOWarning(iSesion, "100P461", "W", "DED6E(" + string + ")");
            }
            if (!bl7 && d32 > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPBICOCA").trim()) > d28 + d26) {
                bl &= this.addErrorOWarning(iSesion, "100P462", "W", "DED6E(" + string + ")");
            }
        }
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RSEG1").trim()) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RSEG1").trim()) > this.cr.redondea(Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B16").trim()) - Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B1RED").trim()), 2)) {
            bl &= this.addErrorOWarning(iSesion, "100P217", "W", "CLDED5(" + string + ")");
        }
        boolean bl8 = true;
        boolean bl9 = false;
        Declarantes declarantes4 = null;
        declarantes4 = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        long l = iSesion.getOperaciones().obtenerClaveActiva("FREATRENTAS");
        long l5 = iSesion.getOperaciones().moveFirst("FREATRENTAS");
        long l6 = 0L;
        long l7 = iSesion.getOperaciones().recordCount("FREATRENTAS");
        while (l6 != l5) {
            double d33 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EH"));
            if (d33 != 0.0) {
                bl8 = false;
            }
            if (d33 > 0.0) {
                bl9 = true;
            }
            l6 = l5;
            if (l5 == l7) continue;
            l5 = iSesion.getOperaciones().moveNext("FREATRENTAS");
        }
        iSesion.getOperaciones().move("FREATRENTAS", l);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes4);
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RCT1").trim()) > 0.0 && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "RCT1").trim()) > Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B11").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "B15").trim())) {
            bl &= this.addErrorOWarning(iSesion, "100P218", "W", "CLDED5(" + string + ")");
        }
        if (d2 + d6 + d8 + d10 == 0.0 && bl8 && d20 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R180", "E", "RET9(" + string + ")");
        }
        if (d2 + d6 + d8 + d10 == 0.0 && d21 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R181", "E", "RET4(" + string + ")");
        }
        if ((d2 + d6 + d10 > 0.0 || bl9) && d20 == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P166", "W", "RET9(" + string + ")");
        }
        if (d4 + d10 > 0.0 && d21 == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P167", "W", "RET4(" + string + ")");
        }
        if (d22 > 0.0 && d5 == 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R556", "E", "RET3(" + string + ")");
        }
        return bl;
    }

    public boolean addFechaCalculo(HashMap<String, String> hashMap, String string) {
        boolean bl = true;
        if (!string.trim().equals("")) {
            if (!hashMap.containsKey(string) && hashMap.size() != 0) {
                return false;
            }
            hashMap.put(string, "");
        }
        return bl;
    }

    private int dameEdad(String string) {
        if (string.trim().length() == 0 || string.trim().length() == 2) {
            return 0;
        }
        return Constantes.getEjercicio() - Integer.parseInt(string.substring(string.length() - 4, string.length()));
    }

    private String formateaFecha(String string) {
        if (string.length() == 10) {
            return string.substring(0, 2) + string.substring(3, 5) + string.substring(6);
        }
        return "00000000";
    }

    private Boolean compruebaTramos() {
        boolean bl = true;
        return bl;
    }

    public boolean comprobarDeclaranteYConyuge(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws ExceptionMotor, Exception {
        boolean bl = true;
        int n = this.switchMotor(iSesion, declarantes);
        if (n != 0 && n != 1 && n != 15) {
            Declarantes declarantes3 = null;
            declarantes3 = Declarantes.parseInt(20 + (n - 1) * 10);
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "SPNIF").trim().length() == 0 && declarantes3.equals(Declarantes.parseInt(20 + (n - 1) * 10))) {
                return this.addErrorOWarning(iSesion, "WIN103", "E", "DATOSPERSONALES#1:NOMHR");
            }
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "ZNOM_D").trim().length() == 0 && declarantes3.equals(Declarantes.parseInt(20 + (n - 1) * 10))) {
                return this.addErrorOWarning(iSesion, "WIN103", "E", "DATOSPERSONALES#1:NOMHR");
            }
            String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes3, "ZAPE1_D").trim();
            if (string2.length() == 0 && declarantes3.equals(Declarantes.parseInt(20 + (n - 1) * 10))) {
                return this.addErrorOWarning(iSesion, "WIN103", "E", "DATOSPERSONALES#1:NOMHR");
            }
            if (string2.length() > 2 && string2.charAt(0) == string2.charAt(1) && string2.charAt(1) == string2.charAt(2) && declarantes3.equals(Declarantes.parseInt(20 + (n - 1) * 10))) {
                return this.addErrorOWarning(iSesion, "100R577", "E", "DATOSPERSONALES#1:NOMHR");
            }
        } else {
            if (!iSesion.existsPtr("DEFAULT")) {
                return bl;
            }
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "SPNIF").trim().length() == 0) {
                return this.addErrorOWarning(iSesion, "WIN015", "E", "DATOSPERSONALES#0:DPNIF_C");
            }
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZNOM_D").trim().length() == 0) {
                return this.addErrorOWarning(iSesion, "WIN015", "E", "DATOSPERSONALES#0:DPNOM_D");
            }
            String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZAPE1_D").trim();
            if (string3.length() == 0) {
                return this.addErrorOWarning(iSesion, "WIN015", "E", "DATOSPERSONALES#0:DPAPE1_D");
            }
            if (string3.length() > 2 && string3.charAt(0) == string3.charAt(1) && string3.charAt(1) == string3.charAt(2)) {
                return this.addErrorOWarning(iSesion, "100R481", "E", "DATOSPERSONALES#0:DPAPE1_D");
            }
            if (iSesion.existsPtr("CONYUGE") && (string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZAPE1_C").trim()).length() > 2 && string3.charAt(0) == string3.charAt(1) && string3.charAt(1) == string3.charAt(2)) {
                return this.addErrorOWarning(iSesion, "100R481", "E", "DATOSPERSONALES#0:DPAPE1_C");
            }
            if (Boolean.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CASADO_D")).booleanValue()) {
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZNORESIDENTE_C").trim().equalsIgnoreCase("false") && this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZNIF_C").trim().length() == 0) {
                    return this.addErrorOWarning(iSesion, "WIN015", "E", "DATOSPERSONALES#0:DPNIF_C");
                }
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZNOM_C").trim().length() == 0) {
                    return this.addErrorOWarning(iSesion, "100R069", "E", "DATOSPERSONALES#0:DPNOM_C");
                }
                if (this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "ZAPE1_C").trim().length() == 0) {
                    return this.addErrorOWarning(iSesion, "100R069", "E", "DATOSPERSONALES#0:DPAPE1_C");
                }
            }
        }
        return bl;
    }

    public boolean existePuntero(ISesion iSesion, Declarantes declarantes) throws ExceptionMotor {
        if (declarantes.equals(Declarantes.Declarante)) {
            return iSesion.existsPtr("DEFAULT") || iSesion.existsPtr("DECLARANTE");
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return iSesion.existsPtr("CONYUGE");
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (declarantes.equals(Declarantes.parseInt(20 + 10 * n))) {
                return iSesion.existsPtr("HIJO" + n);
            }
            ++n;
        }
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            return iSesion.existsPtr("CONJUNTA");
        }
        return false;
    }

    public int switchMotor(ISesion iSesion, String string) throws ExceptionMotor {
        if (string.equalsIgnoreCase("Declarante") || string.equalsIgnoreCase("Default")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Conyuge")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Conjunta")) {
            return 15;
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (string.equalsIgnoreCase("Hijo" + n)) {
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    public int switchMotor(ISesion iSesion, Declarantes declarantes) throws ExceptionMotor {
        if (declarantes.equals(Declarantes.Declarante)) {
            return 0;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return 1;
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (declarantes.equals(Declarantes.parseInt(20 + 10 * n))) {
                return n + 1;
            }
            ++n;
        }
        if (declarantes.equals(Declarantes.UnidadFamiliar)) {
            return 15;
        }
        return -1;
    }

    private Declarantes switchOrdinalMotor(ISesion iSesion, int n) throws ExceptionMotor {
        switch (n) {
            case 0: {
                return Declarantes.Declarante;
            }
            case 1: {
                if (this.funcrentaValidador.isBConyuge(iSesion)) {
                    return Declarantes.Conyuge;
                }
                return null;
            }
            case 15: {
                if (this.funcrentaValidador.isBConjunta(iSesion)) {
                    return Declarantes.UnidadFamiliar;
                }
                return null;
            }
        }
        int n2 = 1;
        while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (n == 1 + n2) {
                if (this.funcrentaValidador.isBHijos(iSesion, n2)) {
                    return Declarantes.parseInt(20 + n2 * 10);
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    private Integer obtenerContadorHashMapDeMotor(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                return this.contadoresDeclarante.get(iSesion.getId() + string);
            }
            case 1: {
                return this.contadoresConyuge.get(iSesion.getId() + string);
            }
            case 15: {
                return this.contadoresConjunta.get(iSesion.getId() + string);
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                return this.contadoresHijos.get(iSesion.getId() + n).get(iSesion.getId() + string);
            }
            ++n;
        }
        return 0;
    }

    private Double obtenerSumatorioHashMapDeMotor(ISesion iSesion, Declarantes declarantes, String string) throws ExceptionMotor {
        switch (this.switchMotor(iSesion, declarantes)) {
            case 0: {
                return this.sumatoriosDeclarante.get(iSesion.getId() + string);
            }
            case 1: {
                return this.sumatoriosConyuge.get(iSesion.getId() + string);
            }
            case 15: {
                return this.sumatoriosConjunta.get(iSesion.getId() + string);
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                return this.sumatoriosHijos.get(iSesion.getId() + n).get(iSesion.getId() + string);
            }
            ++n;
        }
        return 0.0;
    }

    private void establecePropiedadHashMapDeMotor(ISesion iSesion, int n, String string, Double d) throws ExceptionMotor {
        switch (n) {
            case 0: {
                this.sumatoriosDeclarante.put(iSesion.getId() + string, d);
                break;
            }
            case 1: {
                this.sumatoriosConyuge.put(iSesion.getId() + string, d);
                break;
            }
            case 15: {
                this.sumatoriosConjunta.put(iSesion.getId() + string, d);
            }
        }
        int n2 = 1;
        while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (n == n2 + 1) {
                this.sumatoriosHijos.get(iSesion.getId() + n2).put(iSesion.getId() + string, d);
            }
            ++n2;
        }
    }

    private void establecePropiedadHashMapDeMotor(ISesion iSesion, int n, String string, Integer n2) throws ExceptionMotor {
        switch (n) {
            case 0: {
                this.contadoresDeclarante.put(iSesion.getId() + string, n2);
                break;
            }
            case 1: {
                this.contadoresConyuge.put(iSesion.getId() + string, n2);
                break;
            }
            case 15: {
                this.contadoresConjunta.put(iSesion.getId() + string, n2);
            }
        }
        int n3 = 1;
        while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (n == n3 + 1) {
                this.contadoresHijos.get(iSesion.getId() + n3).put(iSesion.getId() + string, n2);
            }
            ++n3;
        }
    }

    private boolean descendienteConDatos(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7, String string8) {
        boolean bl;
        String string9 = string;
        String string10 = string2;
        if (string.equals("00000000") || string.equals("00-00-0000") || string.equals("00/00/0000") || string.equals(" - - -") || string.equals(" / / /")) {
            string9 = "";
        }
        if (string2.equals("00000000") || string2.equals("00-00-0000") || string2.equals("00/00/0000") || string2.equals(" - - -") || string2.equals(" / / /")) {
            string10 = "";
        }
        boolean bl2 = string9.length() == 0 && string10.length() == 0 && string3.length() == 0 && string4.length() == 0 && n == 0;
        boolean bl3 = bl = string5.length() == 0 && string6.length() == 0 && string7.length() == 0 && string8.length() == 0;
        return !bl2 || !bl;
    }

    private String fechaANumerico(String string) {
        while (string.length() < 10) {
            string = string + "0";
        }
        return string.substring(6) + string.substring(3, 5) + string.substring(0, 2);
    }

    private String sumaAfechaANumerico(String string, int n) {
        int n2 = Integer.parseInt(string.substring(0, 4)) + n;
        return String.valueOf(n2) + string.substring(4);
    }

    private Map<String, String> dameHijo(ISesion iSesion, Declarantes declarantes, boolean bl) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bl) {
            this.contadorHijoActualFUNCIONdameHijo = 0;
            this.posFUNCIONdameHijo = this.moveFirst(iSesion, declarantes, "DESCENDIENTES");
            this.posAntFUNCIONdameHijo = 0L;
        }
        int n = 0;
        try {
            n = Integer.valueOf(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJREN").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.contadorHijoActualFUNCIONdameHijo < n) {
            ++this.contadorHijoActualFUNCIONdameHijo;
            hashMap.put("CONRENTAS", "SI");
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)this.contadorHijoActualFUNCIONdameHijo);
            hashMap.put("nif", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFHR"));
            hashMap.put("fechaAdopcion", this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOPDLGHR")));
            hashMap.put("fechaAdopcionAcog", this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOPHR")));
            hashMap.put("fechaAdopcionNumerico", this.fechaANumerico(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOPDLGHR")));
            hashMap.put("vinculacion", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VINCUHR"));
            hashMap.put("fechaNacimiento", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FNACDLGHR"));
            hashMap.put("fechaNacimientoNumerico", this.fechaANumerico(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FNACDLGHR")));
            if (Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FALLOPHR"))) {
                hashMap.put("fechaFallOP", "SI");
            }
            if (Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "R8000HR"))) {
                hashMap.put("bR8000", "SI");
            } else {
                hashMap.put("bR8000", "NO");
            }
            if (Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEVOLHR"))) {
                hashMap.put("bDevol", "SI");
            } else {
                hashMap.put("bDevol", "NO");
            }
            hashMap.put("otras", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "OTRSHR"));
            hashMap.put("minus", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSHR"));
            hashMap.put("edadh", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EDADHR"));
            hashMap.put("fechaFallecido", "00000000");
            hashMap.put("fechaFallecidoNumerico", "0000000000");
            hashMap.put("perteneceADeclarante", "NO");
            if (((String)hashMap.get("vinculacion")).equalsIgnoreCase("A") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("B") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("D")) {
                hashMap.put("perteneceADeclarante", "SI");
            }
            hashMap.put("perteneceAConyuge", "NO");
            if (((String)hashMap.get("vinculacion")).equalsIgnoreCase("A") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("C") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("E")) {
                hashMap.put("perteneceAConyuge", "SI");
            }
            hashMap.put("bFallh", "NO");
            return hashMap;
        }
        this.rcFUNCIONdameHijo = this.recordCount(iSesion, declarantes, "DESCENDIENTES");
        while (this.posFUNCIONdameHijo <= this.rcFUNCIONdameHijo && this.rcFUNCIONdameHijo > 0L) {
            if (this.posAntFUNCIONdameHijo != 0L) {
                this.posFUNCIONdameHijo = this.moveNext(iSesion, declarantes, "DESCENDIENTES");
                if (this.posFUNCIONdameHijo == this.posAntFUNCIONdameHijo) break;
            }
            ++this.contadorHijoActualFUNCIONdameHijo;
            hashMap.put("CONRENTAS", "NO");
            hashMap.put("nif", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFH"));
            hashMap.put("fechaAdopcion", this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOPDLG")));
            hashMap.put("fechaAdopcionAcog", this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOP")));
            hashMap.put("fechaAdopcionNumerico", this.fechaANumerico(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FADOPDLG")));
            hashMap.put("vinculacion", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VINCUDLG"));
            hashMap.put("fechaNacimiento", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FNAC"));
            hashMap.put("fechaNacimientoNumerico", this.fechaANumerico(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FNAC")));
            hashMap.put("bR8000", "NO");
            hashMap.put("bDevol", "NO");
            hashMap.put("otras", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "OTRSDLG"));
            hashMap.put("minus", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSDLG"));
            hashMap.put("edadh", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "EDADH"));
            hashMap.put("fechaFallecido", this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FALLDLG")));
            if (((String)hashMap.get("fechaFallecido")).trim().length() == 0) {
                hashMap.put("fechaFallecido", "00000000");
            }
            hashMap.put("fechaFallecidoNumerico", this.fechaANumerico(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FALLDLG")));
            hashMap.put("perteneceADeclarante", "NO");
            if (((String)hashMap.get("vinculacion")).equalsIgnoreCase("A") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("B") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("D")) {
                hashMap.put("perteneceADeclarante", "SI");
            }
            hashMap.put("perteneceAConyuge", "NO");
            if (((String)hashMap.get("vinculacion")).equalsIgnoreCase("A") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("C") || ((String)hashMap.get("vinculacion")).equalsIgnoreCase("E")) {
                hashMap.put("perteneceAConyuge", "SI");
            }
            if (this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "BFALLH").equalsIgnoreCase("true")) {
                hashMap.put("bFallh", "SI");
            } else {
                hashMap.put("bFallh", "NO");
            }
            this.posAntFUNCIONdameHijo = this.posFUNCIONdameHijo;
            if (!this.descendienteConDatos((String)hashMap.get("fechaAdopcion"), (String)hashMap.get("fechaNacimiento"), (String)hashMap.get("vinculacion"), (String)hashMap.get("otras"), Integer.parseInt((String)hashMap.get("edadh")), this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NOMH"), this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "APE1DLG"), this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "APE2DLG"), this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFH"))) continue;
            return hashMap;
        }
        return null;
    }

    private void calculosDescendientesQueSeHacenSoloUnaVez(List<String> list, List<String> list2, String string, String string2, String string3, String string4, String string5, int n, boolean bl, List<String> list3, List<String> list4, boolean bl2, boolean bl3, String string6) throws Exception {
        if (!this.bMULTIPLE && !string2.equals("1")) {
            if (string.endsWith(String.valueOf(Constantes.getEjercicio()))) {
                if (list.contains(string + string2)) {
                    this.bMULTIPLE = true;
                } else {
                    list.add(string + string2);
                }
            }
            if (string6.endsWith(String.valueOf(Constantes.getEjercicio()))) {
                if (list.contains(string6 + string2)) {
                    this.bMULTIPLE = true;
                } else {
                    list.add(string6 + string2);
                }
            }
        }
        if (!this.bPARTOMU && !string2.equals("1") && string.endsWith(String.valueOf(Constantes.getEjercicio()))) {
            if (list2.contains(string + string2)) {
                this.bPARTOMU = true;
            } else {
                list2.add(string + string2);
            }
        }
        if ((string.endsWith(String.valueOf(Constantes.getEjercicio())) || string3.endsWith(String.valueOf(Constantes.getEjercicio()))) && !string2.equals("1") && string4.length() > 0) {
            if ("B".equalsIgnoreCase(string5)) {
                ++this.nHDISD;
                if (string4.equals("3")) {
                    ++this.nHDIS65D;
                }
            }
            if ("C".equalsIgnoreCase(string5)) {
                ++this.nHDISC;
                if (string4.equals("3")) {
                    ++this.nHDIS65C;
                }
            }
            if ("A".equalsIgnoreCase(string5) || "D".equalsIgnoreCase(string5)) {
                ++this.nHDISDA;
                if (string4.equals("3")) {
                    ++this.nHDIS65DA;
                }
            }
            if ("A".equalsIgnoreCase(string5) || "E".equalsIgnoreCase(string5)) {
                ++this.nHDISCA;
                if (string4.equals("3")) {
                    ++this.nHDIS65CA;
                }
            }
        }
        if (string.endsWith(String.valueOf(Constantes.getEjercicio())) || string.endsWith(String.valueOf(Constantes.getEjercicio() - 1))) {
            ++this.numHijosNacidosEnEjercicioActualOAnterior;
        } else if (string3.endsWith(String.valueOf(Constantes.getEjercicio())) || string3.endsWith(String.valueOf(Constantes.getEjercicio() - 1))) {
            ++this.numHijosAdoptadosEnEjercicioActualOAnterior;
        }
        if (string4.length() > 0 && (n < 18 && !string2.equals("1") || string2.equals("2") || string2.equals("4")) && !bl) {
            if ("A".equalsIgnoreCase(string5)) {
                ++this.iNUMEROA;
            } else if ("B".equalsIgnoreCase(string5) || "D".equalsIgnoreCase(string5)) {
                ++this.iNUMEROD;
            } else if ("C".equalsIgnoreCase(string5) || "E".equalsIgnoreCase(string5)) {
                ++this.iNUMEROC;
            }
        }
        if (n < 18 && !string2.equals("1") || string2.equals("2") || string2.equals("4")) {
            ++this.numHijosDerechoAyudaDomestica;
        }
        ++this.numTotalDeHijos;
        if (n < 4) {
            ++this.numHijosMenoresDe4Anyos;
        }
        int n2 = 0;
        if (!this.bPARTOM) {
            if (string.length() > 4 && (n2 = Integer.parseInt(string.substring(string.length() - 4))) > Constantes.getEjercicio() - 4) {
                if (list4.contains(string)) {
                    this.bPARTOM = true;
                } else {
                    list4.add(string);
                }
            }
            if (!this.bPARTOM && string3.length() > 4 && (n2 = Integer.parseInt(string3.substring(string3.length() - 4))) > Constantes.getEjercicio() - 4) {
                if (list3.contains(string3)) {
                    this.bPARTOM = true;
                } else {
                    list3.add(string3);
                }
            }
        }
        if (string4.equals("3")) {
            if ("A".equalsIgnoreCase(string5)) {
                ++this.contadorMINUS3d;
                ++this.contadorMINUS3c;
            } else if ("B".equalsIgnoreCase(string5) || "D".equalsIgnoreCase(string5)) {
                ++this.contadorMINUS3d;
            } else if ("C".equalsIgnoreCase(string5) || "E".equalsIgnoreCase(string5)) {
                ++this.contadorMINUS3c;
            }
        }
        if (n < 4 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D"))) {
            ++this.numHijosMenoresDe4VinculacionXR80083d;
            if (!string2.equals("1")) {
                ++this.numHijosMenoresDe4OtrosNo1VinculacionXR800083d;
            }
        }
        if (n < 4 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E"))) {
            ++this.numHijosMenoresDe4VinculacionXR80083c;
            if (!string2.equals("1")) {
                ++this.numHijosMenoresDe4OtrosNo1VinculacionXR800083c;
            }
        }
        if (!(string.equals("") || n >= 4 || string2.equals("1") || bl || !string5.equalsIgnoreCase("A") && !string5.equalsIgnoreCase("B") && !string5.equalsIgnoreCase("D") || bl2)) {
            ++this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntad;
            if (!bl3) {
                ++this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083d;
            }
        }
        if (!(string.equals("") || n >= 4 || string2.equals("1") || bl || !string5.equalsIgnoreCase("A") && !string5.equalsIgnoreCase("C") && !string5.equalsIgnoreCase("E") || bl2)) {
            ++this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntac;
            if (!bl3) {
                ++this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083c;
            }
        }
        if (n < 4 && !string2.equals("1") && !bl2) {
            ++this.numHijos4R80093Individual;
            if (!bl3) {
                ++this.numHijos4R80093Conjunta;
            }
        }
        if (!bl2 && !string2.equals("1") && string5.equalsIgnoreCase("A")) {
            ++this.numHijosR80084DevolOtrsVincuAConjunta;
            if (!bl3) {
                ++this.numHijosR80084DevolOtrsVincuA;
            }
        }
        if (!bl2 && !string2.equals("1") && (string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D"))) {
            ++this.numHijosR80084DevolOtrsVincuDConjunta;
            if (!bl3) {
                ++this.numHijosR80084DevolOtrsVincuD;
            }
        }
        if (!bl2 && !string2.equals("1") && (string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E"))) {
            ++this.numHijosR80084DevolOtrsVincuCConjunta;
            if (!bl3) {
                ++this.numHijosR80084DevolOtrsVincuC;
            }
        }
        if (!bl2 && 5 < n && n < 16 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("D"))) {
            ++this.numHijosEdadEscolarADConjunta;
            if (!bl3) {
                ++this.numHijosEdadEscolarAD;
            }
        }
        if (!bl2 && 5 < n && n < 16 && string5.equalsIgnoreCase("B")) {
            ++this.numHijosEdadEscolarBConjunta;
            if (!bl3) {
                ++this.numHijosEdadEscolarB;
            }
        }
        if (!bl2 && 5 < n && n < 16 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("E"))) {
            ++this.numHijosEdadEscolarAEConjunta;
            if (!bl3) {
                ++this.numHijosEdadEscolarAE;
            }
        }
        if (!bl2 && 5 < n && n < 16 && string5.equalsIgnoreCase("C")) {
            ++this.numHijosEdadEscolarCConjunta;
            if (!bl3) {
                ++this.numHijosEdadEscolarC;
            }
        }
        if (!bl2 && 5 < n && n < 19 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D"))) {
            if (!bl3) {
                ++this.numHijosLibrosAragonD;
            }
            ++this.numHijosLibrosAragonOd;
        }
        if (!bl2 && 5 < n && n < 19 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E"))) {
            if (!bl3) {
                ++this.numHijosLibrosAragonC;
            }
            ++this.numHijosLibrosAragonOc;
        }
        if (!bl2 && !bl && !string2.equals("1") && 2 < n && n < 22 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D"))) {
            if (!bl3) {
                ++this.numHijosMaterialEscolarValenciaD;
            }
            ++this.numHijosMaterialEscolarValenciaOD;
        }
        if (!bl2 && !bl && !string2.equals("1") && 2 < n && n < 22 && (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E"))) {
            if (!bl3) {
                ++this.numHijosMaterialEscolarValenciaC;
            }
            ++this.numHijosMaterialEscolarValenciaOC;
        }
        if (!string2.equals("1")) {
            if (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D")) {
                ++this.numHijosAragonD;
                if (string4.length() > 0) {
                    ++this.numHijosHminAragonD;
                } else if (string.endsWith(String.valueOf(Constantes.getEjercicio())) || string6.endsWith(String.valueOf(Constantes.getEjercicio()))) {
                    ++this.numHijosAragonNacD;
                }
            }
            if (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E")) {
                ++this.numHijosAragonC;
                if (string4.length() > 0) {
                    ++this.numHijosHminAragonC;
                } else if (string.endsWith(String.valueOf(Constantes.getEjercicio())) || string6.endsWith(String.valueOf(Constantes.getEjercicio()))) {
                    ++this.numHijosAragonNacC;
                }
            }
        }
        if (!("".equalsIgnoreCase(string4) || this.funcrentaValidador.entreFechas("31122011", string, "01012014") != 1 && this.funcrentaValidador.entreFechas("31122011", string3, "01012014") != 1 || bl2 || bl3)) {
            if (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("B") || string5.equalsIgnoreCase("D")) {
                this.condicion8528d = true;
            }
            if (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("C") || string5.equalsIgnoreCase("E")) {
                this.condicion8528c = true;
            }
        }
        String string7 = this.FMULTI = "00000000".equals(string3) ? string : string3;
        if (!bl2 && !bl3 && !string2.equals("1") && ("A".equalsIgnoreCase(string5) || "B".equalsIgnoreCase(string5) || "D".equalsIgnoreCase(string5))) {
            if (this.FMULTI.endsWith("2013")) {
                ++this.NUMERO12d;
                if (!"".equalsIgnoreCase(string4)) {
                    ++this.NUMDISd;
                }
                if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.FMULTIRFd) == 1 || this.funcrentaValidador.comparaFechas(this.FMULTI, this.FMULTIRFd) == 0) {
                    ++this.NUMPM12d;
                }
            } else if (this.FMULTI.endsWith("2014")) {
                ++this.NUMERO13d;
            } else if (this.FMULTI.endsWith("2012")) {
                ++this.NUMERO11d;
            }
        }
        if (!bl2 && !bl3 && !string2.equals("1") && ("A".equalsIgnoreCase(string5) || "C".equalsIgnoreCase(string5) || "E".equalsIgnoreCase(string5))) {
            if (this.FMULTI.endsWith("2013")) {
                ++this.NUMERO12c;
                if (!"".equalsIgnoreCase(string4)) {
                    ++this.NUMDISc;
                }
                if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.FMULTIRFc) == 1 || this.funcrentaValidador.comparaFechas(this.FMULTI, this.FMULTIRFc) == 0) {
                    ++this.NUMPM12c;
                }
            } else if (this.FMULTI.endsWith("2014")) {
                ++this.NUMERO13c;
            } else if (this.FMULTI.endsWith("2012")) {
                ++this.NUMERO11c;
            }
        }
    }

    private List<Integer> getHijosDerechoReduccion(ISesion iSesion, Declarantes declarantes, boolean bl) throws NumberFormatException, Exception {
        Map<String, String> map;
        this.FMULTI = "";
        this.cNHT = 0;
        this.cNHDIS = 0;
        this.cOTrs3o4 = 0;
        this.cOTrs2o4 = 0;
        this.contadorHijosMenoresOotraSitu2o4 = 0;
        this.contadorHijosMenoresOotraSitu2 = 0;
        this.contadorHijosMenoresNoRentas8000 = 0;
        this.uFhiRegla80063 = 0;
        if (bl) {
            this.hijosDregla80063 = 0;
            this.hijosDregla80063Conjunta = 0;
            this.condicion8528d = false;
            this.condicion8528c = false;
            this.NUMERO13d = 0;
            this.NUMERO12d = 0;
            this.NUMERO11d = 0;
            this.NUMPM12d = 0;
            this.NUMDISd = 0;
            this.NUMERO13c = 0;
            this.NUMERO12c = 0;
            this.NUMERO11c = 0;
            this.NUMPM12c = 0;
            this.NUMDISc = 0;
            this.PM12d = false;
            this.PM12c = false;
            this.PM12Ad = false;
            this.PM12Ac = false;
            this.PMd = false;
            this.PMc = false;
            this.PMBd = false;
            this.PMBc = false;
            this.FMULTIRFd = "00000000";
            this.FMULTIRFc = "00000000";
            this.fechaDescendienteMenor2014d = "31122014";
            this.fechaDescendienteMenor2014c = "31122014";
            this.fechaDescendienteMayor2014d = "00000000";
            this.fechaDescendienteMayor2014c = "00000000";
            this.fechaDescendienteMenor2013d = "31122013";
            this.fechaDescendienteMenor2013c = "31122013";
            this.fechaDescendienteMayor2013d = "00000000";
            this.fechaDescendienteMayor2013c = "00000000";
            this.fechaDescendienteMayor2012d = "00000000";
            this.fechaDescendienteMayor2012c = "00000000";
            this.fechaDescendienteMenor2012c = "31122012";
            this.fechaDescendienteMenor2012d = "31122012";
            this.fechaDescendienteMayor2011d = "00000000";
            this.fechaDescendienteMayor2011c = "00000000";
        } else {
            this.hijosCregla80063 = 0;
            this.hijosCregla80063Conjunta = 0;
        }
        this.contadorHijosRegla80054yRegla80055 = 0;
        this.hijosDAregla80075 = 0;
        this.hijosDregla80075 = 0;
        this.hijos2DAregla80075 = 0;
        this.hijos2Dregla80075 = 0;
        this.nADOPDA = 0;
        this.nADOPD = 0;
        this.nHD = 0;
        this.hijosCAregla80075 = 0;
        this.hijosCregla80075 = 0;
        this.hijos2CAregla80075 = 0;
        this.hijos2Cregla80075 = 0;
        this.nADOPCA = 0;
        this.nADOPC = 0;
        this.nHC = 0;
        this.bFMP = true;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = this.formateaFecha(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECFAL"));
        if (string7.trim().length() == 0) {
            string7 = "00000000";
        }
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string8 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ZCCAD");
        String string9 = "";
        int n4 = 0;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FECHORD1").equals("")) {
            hashMap.put(Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORD1")), "");
        }
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FECHORD2").equals("")) {
            hashMap.put(Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORD2")), "");
        }
        if (bl) {
            this.dechvfParaRegla80066 = 0;
        } else {
            this.conhvfParaRegla80066 = 0;
        }
        if (bl) {
            map = this.dameHijo(iSesion, declarantes, true);
            while (map != null) {
                string2 = map.get("fechaAdopcion");
                string4 = map.get("vinculacion");
                string = map.get("fechaNacimiento");
                bl4 = map.get("bR8000").equalsIgnoreCase("SI");
                bl5 = map.get("bDevol").equalsIgnoreCase("SI");
                string5 = map.get("otras");
                this.FMULTI = "".equals(string2) || "00000000".equals(string2) ? string : string2;
                if (!bl4 && !bl5 && !string5.equals("1") && ("A".equalsIgnoreCase(string4) || "B".equalsIgnoreCase(string4) || "D".equalsIgnoreCase(string4))) {
                    if (this.FMULTI.endsWith("2013")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2013d) == -1) {
                            this.fechaDescendienteMenor2013d = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2013d.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2013d) == 1) {
                            this.fechaDescendienteMayor2013d = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2014")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2014d) == -1) {
                            this.fechaDescendienteMenor2014d = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2014d.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2014d) == 1) {
                            this.fechaDescendienteMayor2014d = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2012")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2012d) == -1) {
                            this.fechaDescendienteMenor2012d = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2012d.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2012d) == 1) {
                            this.fechaDescendienteMayor2012d = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2011") && (this.fechaDescendienteMayor2011d.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2011d) == 1)) {
                        this.fechaDescendienteMayor2011d = this.FMULTI;
                    }
                }
                if (!bl4 && !bl5 && !string5.equals("1") && ("A".equalsIgnoreCase(string4) || "C".equalsIgnoreCase(string4) || "E".equalsIgnoreCase(string4))) {
                    if (this.FMULTI.endsWith("2013")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2013c) == -1) {
                            this.fechaDescendienteMenor2013c = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2013c.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2013c) == 1) {
                            this.fechaDescendienteMayor2013c = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2014")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2014c) == -1) {
                            this.fechaDescendienteMenor2014c = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2014c.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2014c) == 1) {
                            this.fechaDescendienteMayor2014c = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2012")) {
                        if (this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMenor2012c) == -1) {
                            this.fechaDescendienteMenor2012c = this.FMULTI;
                        }
                        if (this.fechaDescendienteMayor2012c.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2012c) == 1) {
                            this.fechaDescendienteMayor2012c = this.FMULTI;
                        }
                    } else if (this.FMULTI.endsWith("2011") && (this.fechaDescendienteMayor2011c.equalsIgnoreCase("00000000") || this.funcrentaValidador.comparaFechas(this.FMULTI, this.fechaDescendienteMayor2011c) == 1)) {
                        this.fechaDescendienteMayor2011c = this.FMULTI;
                    }
                }
                map = this.dameHijo(iSesion, declarantes, false);
            }
            if (this.fechaDescendienteMenor2014d.equalsIgnoreCase("29022014")) {
                this.FMULTIRFd = "28022013";
            } else if (this.fechaDescendienteMenor2014d.endsWith("2014")) {
                this.FMULTIRFd = this.fechaDescendienteMenor2014d.substring(0, this.fechaDescendienteMenor2014d.length() - 4) + "2013";
            }
            if (this.fechaDescendienteMenor2014c.equalsIgnoreCase("29022014")) {
                this.FMULTIRFc = "28022013";
            } else if (this.fechaDescendienteMenor2014c.endsWith("2014")) {
                this.FMULTIRFc = this.fechaDescendienteMenor2014c.substring(0, this.fechaDescendienteMenor2014c.length() - 4) + "2013";
            }
            this.MESESd1213 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2012d, this.fechaDescendienteMenor2013d);
            this.MESESBd1112 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2011d, this.fechaDescendienteMenor2012d);
            this.MESESc1213 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2012c, this.fechaDescendienteMenor2013c);
            this.MESESBc1112 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2011c, this.fechaDescendienteMenor2012c);
            this.MESESd1314 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2013d, this.fechaDescendienteMenor2014d);
            this.MESESAd1314 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2013d, this.fechaDescendienteMayor2014d);
            this.MESESc1314 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2013c, this.fechaDescendienteMenor2014c);
            this.MESESAc1314 = this.funcrentaValidador.diferenciaEnMeses(this.fechaDescendienteMayor2013c, this.fechaDescendienteMayor2014c);
            this.PM12d = this.MESESd1314 <= Constantes.getCmeses();
            this.PM12c = this.MESESc1314 <= Constantes.getCmeses();
            this.PM12Ad = this.MESESAd1314 <= Constantes.getCmeses();
            this.PM12Ac = this.MESESAc1314 <= Constantes.getCmeses();
            this.PMd = this.MESESd1213 <= Constantes.getCmeses();
            this.PMc = this.MESESc1213 <= Constantes.getCmeses();
            this.PMBd = this.MESESBd1112 <= Constantes.getCmeses();
            this.PMBc = this.MESESBc1112 <= Constantes.getCmeses();
        }
        map = this.dameHijo(iSesion, declarantes, true);
        while (map != null) {
            boolean bl7;
            ++n4;
            bl6 = map.get("CONRENTAS").equalsIgnoreCase("SI");
            bl4 = map.get("bR8000").equalsIgnoreCase("SI");
            bl5 = map.get("bDevol").equalsIgnoreCase("SI");
            string2 = map.get("fechaAdopcion");
            string3 = map.get("fechaAdopcionAcog");
            string4 = map.get("vinculacion");
            string = map.get("fechaNacimiento");
            string5 = map.get("otras");
            string9 = map.get("minus");
            n = Integer.valueOf(map.get("edadh"));
            bl2 = map.get("bFallh").equalsIgnoreCase("SI");
            if (!bl2) {
                ++this.cNHT;
                if (string9.trim().length() > 0) {
                    ++this.cNHDIS;
                }
            }
            if (string5.trim().equals("3") || string5.trim().equals("4")) {
                ++this.cOTrs3o4;
            }
            if (string5.trim().equals("2") || string5.trim().equals("4")) {
                ++this.cOTrs2o4;
            }
            if (bl) {
                bl3 = map.get("perteneceADeclarante").equalsIgnoreCase("SI");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList2 = new ArrayList<String>();
                    this.bMULTIPLE = false;
                    this.nHDISD = 0;
                    this.nHDISC = 0;
                    this.nHDISDA = 0;
                    this.nHDISCA = 0;
                    this.nHDIS65D = 0;
                    this.nHDIS65C = 0;
                    this.nHDIS65DA = 0;
                    this.nHDIS65CA = 0;
                    this.iNUMEROA = 0;
                    this.iNUMEROD = 0;
                    this.iNUMEROC = 0;
                    this.numTotalDeHijos = 0;
                    this.numHijosMenoresDe4Anyos = 0;
                    this.numHijosNacidosEnEjercicioActualOAnterior = 0;
                    this.numHijosAdoptadosEnEjercicioActualOAnterior = 0;
                    arrayList3 = new ArrayList();
                    arrayList4 = new ArrayList();
                    this.bPARTOM = false;
                    this.bPARTOMU = false;
                    this.contadorMINUS3d = 0;
                    this.contadorMINUS3c = 0;
                    this.numHijosMenoresDe4VinculacionXR80083d = 0;
                    this.numHijosMenoresDe4VinculacionXR80083c = 0;
                    this.numHijosMenoresDe4OtrosNo1VinculacionXR800083d = 0;
                    this.numHijosMenoresDe4OtrosNo1VinculacionXR800083c = 0;
                    this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntad = 0;
                    this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083Conjuntac = 0;
                    this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083d = 0;
                    this.numHijosMenoresDe4OtrosNo1NoFallVinculacionXR800083c = 0;
                    this.numHijos4R80093Individual = 0;
                    this.numHijos4R80093Conjunta = 0;
                    this.numHijosAragonD = 0;
                    this.numHijosHminAragonD = 0;
                    this.numHijosAragonNacD = 0;
                    this.numHijosAragonC = 0;
                    this.numHijosHminAragonC = 0;
                    this.numHijosAragonNacC = 0;
                    this.numHijosR80084DevolOtrsVincuA = 0;
                    this.numHijosR80084DevolOtrsVincuD = 0;
                    this.numHijosR80084DevolOtrsVincuC = 0;
                    this.numHijosR80084DevolOtrsVincuAConjunta = 0;
                    this.numHijosR80084DevolOtrsVincuDConjunta = 0;
                    this.numHijosR80084DevolOtrsVincuCConjunta = 0;
                    this.numHijosDerechoAyudaDomestica = 0;
                    this.numHijosEdadEscolarC = 0;
                    this.numHijosEdadEscolarAD = 0;
                    this.numHijosEdadEscolarB = 0;
                    this.numHijosEdadEscolarAE = 0;
                    this.numHijosEdadEscolarADConjunta = 0;
                    this.numHijosEdadEscolarBConjunta = 0;
                    this.numHijosEdadEscolarAEConjunta = 0;
                    this.numHijosEdadEscolarCConjunta = 0;
                    this.numHijosMaterialEscolarValenciaD = 0;
                    this.numHijosMaterialEscolarValenciaC = 0;
                    this.numHijosMaterialEscolarValenciaOD = 0;
                    this.numHijosMaterialEscolarValenciaOC = 0;
                    this.numHijosLibrosAragonD = 0;
                    this.numHijosLibrosAragonC = 0;
                    this.numHijosLibrosAragonOd = 0;
                    this.numHijosLibrosAragonOc = 0;
                }
                this.calculosDescendientesQueSeHacenSoloUnaVez(arrayList, arrayList2, string, string5, string2, string9, string4, n, bl2, arrayList3, arrayList4, bl4, bl5, string3);
            } else {
                bl3 = map.get("perteneceAConyuge").equalsIgnoreCase("SI");
            }
            if ((this.funcrentaValidador.comparaFechas(string, "3112" + this.anioAnterior(1)) > 0 || this.funcrentaValidador.comparaFechas(string2, "3112" + this.anioAnterior(1)) > 0) && !string5.equals("1") && bl3) {
                ++n2;
            }
            if (!string.equals("") && (n < 18 && !string5.equals("1") || n > 17 && (string5.equals("2") || string5.equals("4"))) && !bl2) {
                ++this.uFhiRegla80063;
            }
            if (!bl6 && bl3 || bl6 && bl3 && !bl4) {
                if (bl) {
                    ++this.hijosDregla80063Conjunta;
                    if (!bl5) {
                        ++this.hijosDregla80063;
                    }
                } else {
                    ++this.hijosCregla80063Conjunta;
                    if (!bl5) {
                        ++this.hijosCregla80063;
                    }
                }
            }
            if (!string.equals("") && (n < 18 || n > 17 && string9.trim().length() > 0) && !bl4) {
                ++this.contadorHijosMenoresNoRentas8000;
            }
            if ((string.endsWith(String.valueOf(Constantes.getEjercicio())) || string2.endsWith(String.valueOf(Constantes.getEjercicio()))) && !string5.equals("1")) {
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("D")) {
                    ++this.hijosDAregla80075;
                }
                if (string4.equalsIgnoreCase("B")) {
                    ++this.hijosDregla80075;
                }
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("E")) {
                    ++this.hijosCAregla80075;
                }
                if (string4.equalsIgnoreCase("C")) {
                    ++this.hijosCregla80075;
                }
            } else if ((string.endsWith(String.valueOf(Constantes.getEjercicio() - 1)) || string2.endsWith(String.valueOf(Constantes.getEjercicio() - 1)) || string.endsWith(String.valueOf(Constantes.getEjercicio() - 2)) || string2.endsWith(String.valueOf(Constantes.getEjercicio() - 2))) && !string5.equals("1")) {
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("D")) {
                    ++this.hijos2DAregla80075;
                }
                if (string4.equalsIgnoreCase("B")) {
                    ++this.hijos2Dregla80075;
                }
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("E")) {
                    ++this.hijos2CAregla80075;
                }
                if (string4.equalsIgnoreCase("C")) {
                    ++this.hijos2Cregla80075;
                }
            }
            if (string2.endsWith(String.valueOf(Constantes.getEjercicio())) && !string5.equals("1")) {
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("D")) {
                    ++this.nADOPDA;
                }
                if (string4.equalsIgnoreCase("B")) {
                    ++this.nADOPD;
                }
                if (string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("E")) {
                    ++this.nADOPCA;
                }
                if (string4.equalsIgnoreCase("C")) {
                    ++this.nADOPC;
                }
            }
            if (!string5.equals("1") && map.get("perteneceADeclarante").equalsIgnoreCase("SI")) {
                ++this.nHD;
            }
            if (!string5.equals("1") && map.get("perteneceAConyuge").equalsIgnoreCase("SI")) {
                ++this.nHC;
            }
            if (!(string.equals("") || (this.funcrentaValidador.comparaFechas(string, "3101" + this.anioAnterior(3)) <= 0 || string5.equals("1")) && this.funcrentaValidador.comparaFechas(string2, "3101" + this.anioAnterior(3)) <= 0 || !bl3 || bl2 || bl4 || bl5 || (!bl || !string7.equals("00000000")) && bl)) {
                ++n3;
            }
            if (!string.equals("00000000") && (n < 18 && !string5.equals("1") || string5.equals("2") || string5.equals("4"))) {
                ++this.contadorHijosMenoresOotraSitu2o4;
            }
            if (!string.equals("00000000") && (n < 18 && !string5.equals("1") || string5.equals("2"))) {
                ++this.contadorHijosMenoresOotraSitu2;
            }
            if (!string.equals("00000000") && (string6.equals("SI") || (n < 18 && !string5.equals("1") || string5.equals("2")) && string4.equalsIgnoreCase("D"))) {
                this.bFMP = false;
            }
            if (!string5.equals("1") && !string.equals("00000000")) {
                ++this.contadorHijosRegla80054yRegla80055;
            }
            boolean bl8 = bl7 = this.funcrentaValidador.comparaFechas(string, "0101" + this.anioAnterior(2)) < 0 && this.funcrentaValidador.comparaFechas(string, "3101" + this.anioAnterior(5)) > 0 && !string5.equals("1") || this.funcrentaValidador.comparaFechas(string2, "0101" + this.anioAnterior(2)) < 0 && this.funcrentaValidador.comparaFechas(string2, "3101" + this.anioAnterior(5)) > 0 && !string5.equals("1");
            if (bl) {
                if (bl7 && bl3 && string8.equals(CTE_VALENCIA) && !hashMap.containsKey(n4) && string7.equals("00000000") && !bl2 && !bl4 && !bl5) {
                    ++this.dechvfParaRegla80066;
                }
            } else if (bl7 && bl3 && string8.equals(CTE_VALENCIA) && !hashMap.containsKey(n4) && !bl2 && !bl4 && !bl5) {
                ++this.conhvfParaRegla80066;
            }
            map = this.dameHijo(iSesion, declarantes, false);
        }
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        arrayList5.add(n2);
        arrayList5.add(n3);
        return arrayList5;
    }

    private String damePrimerCampoDeducAutonomicas(int n) {
        switch (n) {
            case 1: {
                return "A1";
            }
            case 2: {
                return "AR1";
            }
            case 3: {
                return "PA1";
            }
            case 4: {
                return "IB1";
            }
            case 5: {
                return "CAN1";
            }
            case 6: {
                return "CANT1";
            }
            case 7: {
                return "CM1EA";
            }
            case 8: {
                return "CL1";
            }
            case 9: {
                return "CT1";
            }
            case 10: {
                return "E1";
            }
            case 11: {
                return "GA1";
            }
            case 12: {
                return "M1";
            }
            case 13: {
                return "MU1";
            }
            case 16: {
                return "LR1";
            }
            case 17: {
                return "VA1";
            }
        }
        return "";
    }

    private boolean recordatorioDeducAutonomicas(ISesion iSesion) throws NumberFormatException, ExceptionMotor, Exception {
        String string;
        if (Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("SUMADEDAUT").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("A8").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("A10").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("AR12").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("IB2").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("IB4").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CAN8").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CM2").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CM3").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CM4").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("E2").trim()) - Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("VA9").trim()) <= 0.0 && (string = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion)))))).length() > 0) {
            return this.addErrorOWarning(iSesion, "100R392", "W", string);
        }
        return true;
    }

    private boolean coherenciaDeduccionesAutonomicasFamiliaNum(ISesion iSesion) throws Exception {
        String string;
        boolean bl = true;
        Declarantes declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim();
        if ((declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar)) && !this.fNum) {
            switch (this.cTEProvincia2Integer(string2)) {
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: 
                case 17: {
                    if (!(Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("PA11").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CAN10").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CM8").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("CL11").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("GA2").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("VA4").trim()) > 0.0) || (string = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2))).length() <= 0) break;
                    bl &= this.addErrorOWarning(iSesion, "100R393", "W", string);
                }
            }
        }
        if ((declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.UnidadFamiliar)) && this.cOTrs3o4 > 0 && (string2.equalsIgnoreCase(CTE_ANDALUCIA) || string2.equalsIgnoreCase(CTE_ASTURIAS)) && Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("A9").trim()) + Double.valueOf(iSesion.getOperaciones().obtenerPartidaString("PA12").trim()) > 0.0 && (string = this.damePrimerCampoDeducAutonomicas(this.cTEProvincia2Integer(string2))).length() > 0) {
            bl &= this.addErrorOWarning(iSesion, "100R572", "E", string + "(D)");
        }
        return bl;
    }

    private void calcularDescendientes(ISesion iSesion) throws NumberFormatException, Exception {
        iSesion.freezeSesionSoloPosicion(this.toString());
        List<Integer> list = this.getHijosDerechoReduccion(iSesion, Declarantes.Declarante, true);
        this.establecePropiedadHashMapDeMotor(iSesion, 0, "DECHI", list.get(0));
        this.establecePropiedadHashMapDeMotor(iSesion, 0, "DECHIM", list.get(1));
        if (this.funcrentaValidador.isBConyuge(iSesion)) {
            list = this.getHijosDerechoReduccion(iSesion, Declarantes.Conyuge, false);
            this.establecePropiedadHashMapDeMotor(iSesion, 1, "DECHI", list.get(0));
            this.establecePropiedadHashMapDeMotor(iSesion, 1, "DECHIM", list.get(1));
        }
        iSesion.unfreeze(this.toString());
    }

    private double sumarArray(ArrayList<Double> arrayList) {
        double d = 0.0;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                d += Double.parseDouble(arrayList.get(i).toString());
            }
        }
        return d;
    }

    private void calcularAscendientes(ISesion iSesion) throws Exception {
        iSesion.freezeSesionSoloPosicion(this.toString());
        this.contadorAscDeduc = 0;
        this.contadorPCTMINAS3d = 0;
        this.contadorPCTMINAS3c = 0;
        String string = "";
        double d = 0.0;
        String string2 = "";
        int n = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList.clear();
        arrayList2.clear();
        long l = this.getPosicion(iSesion, Declarantes.Declarante, "ASCENDIENTES");
        long l2 = this.recordCount(iSesion, Declarantes.Declarante, "ASCENDIENTES");
        long l3 = this.moveFirst(iSesion, Declarantes.Declarante, "ASCENDIENTES");
        long l4 = 0L;
        while (l3 != l4) {
            int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "EDADA").trim());
            string = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CONVAS").trim();
            d = 0.0;
            try {
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "PCTMINAS"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VINAS").trim();
            if (n2 > 74 && d != 3.0) {
                if (string.length() == 0) {
                    n = 1;
                } else {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                }
                if (string2.equals("D")) {
                    arrayList.add(1.0 / (double)n);
                }
                if (string2.equals("C")) {
                    arrayList2.add(1.0 / (double)n);
                }
            } else {
                arrayList.add(0.0);
                arrayList2.add(0.0);
            }
            if (d != 0.0 && n2 >= 65 || n2 >= 75) {
                ++this.contadorAscDeduc;
            }
            if (d == 3.0 && string2.equals("D")) {
                ++this.contadorPCTMINAS3d;
            }
            if (d == 3.0 && string2.equals("C")) {
                ++this.contadorPCTMINAS3c;
            }
            l4 = l3;
            if (l3 == l2) break;
            l3 = this.moveNext(iSesion, Declarantes.Declarante, "ASCENDIENTES");
        }
        this.calculoD = this.sumarArray(arrayList);
        this.calculoC = this.sumarArray(arrayList2);
        this.move(iSesion, Declarantes.Declarante, "ASCENDIENTES", l);
        iSesion.unfreeze(this.toString());
    }

    private boolean calcularSumatoriosyContadores(ISesion iSesion) throws NumberFormatException, Exception {
        Declarantes declarantes = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d14 = 0.0;
        int n5 = 0;
        iSesion.freezeSesionSoloPosicion(this.toString());
        int n6 = 1;
        while ((long)n6 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            this.sumatoriosHijos.put(iSesion.getId() + n6, new HashMap());
            this.contadoresHijos.put(iSesion.getId() + n6, new HashMap());
            ++n6;
        }
        for (n6 = 0; n6 <= 3 + Constantes.getChijos(); ++n6) {
            declarantes = this.switchOrdinalMotor(iSesion, n6);
            if (declarantes == null) continue;
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E4AA", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E4AC", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5II", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5AA", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5AB", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EH", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EHporVALORD", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EHporVALORO", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESO", new Integer(0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESO", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1SUMA", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1N1", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1RNR", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESOespecial", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESOespecial13", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "DECHI", new Integer(0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "DECHIM", new Integer(0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F2EA", new Double(0.0));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "NUMEROT", new Integer(0));
            if (declarantes == null) continue;
            d8 = 0.0;
            d5 = 0.0;
            d6 = 0.0;
            n = 0;
            n2 = 0;
            n3 = 0;
            d12 = 0.0;
            d13 = 0.0;
            d9 = 0.0;
            d10 = 0.0;
            d11 = 0.0;
            d7 = 0.0;
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            long l = this.recordCount(iSesion, declarantes, "E3REGESTAGR");
            long l2 = this.moveFirst(iSesion, declarantes, "E3REGESTAGR");
            long l3 = 0L;
            while (l2 != l3) {
                d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5II").trim());
                d7 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AA").trim());
                d2 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E5AB").trim());
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "E3REGESTAGR");
            }
            l = this.recordCount(iSesion, declarantes, "E2REGESTOBJ");
            l2 = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
            l3 = 0L;
            while (l2 != l3) {
                d5 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AA").trim());
                d += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E4AC").trim());
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
            }
            l = this.recordCount(iSesion, declarantes, "E1REGESTDIR");
            l2 = this.moveFirst(iSesion, declarantes, "E1REGESTDIR");
            l3 = 0L;
            while (l2 != l3) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1INGRESO").trim()) != 0.0) {
                    ++n;
                    d12 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1INGRESO").trim());
                    n4 = 0;
                    try {
                        n4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TACT").trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n4 == 2 || n4 == 4 || n4 == 5 || n4 == 6) {
                        n2 = (int)((double)n2 + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1INGRESO").trim()));
                    } else if (n4 == 1 || n4 == 3) {
                        n3 = (int)((double)n3 + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1INGRESO").trim()));
                    }
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RNR").trim()) != 0.0) {
                    d13 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1RNR").trim());
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1SUMA").trim()) != 0.0) {
                    d3 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1SUMA").trim());
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1N1").trim()) != 0.0) {
                    d4 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "E1N1").trim());
                }
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "E1REGESTDIR");
            }
            l = this.recordCount(iSesion, declarantes, "FREATRENTAS");
            l2 = this.moveFirst(iSesion, declarantes, "FREATRENTAS");
            l3 = 0L;
            while (l2 != l3) {
                d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EH").trim());
                d9 += d14;
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "FREATRENTAS");
            }
            l = this.recordCount(iSesion, declarantes, "FRETRFISCAL");
            l2 = this.moveFirst(iSesion, declarantes, "FRETRFISCAL");
            l3 = 0L;
            while (l2 != l3) {
                d8 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F2EA").trim());
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "FRETRFISCAL");
            }
            n5 = 0;
            l = this.recordCount(iSesion, declarantes, "IRDISCAPACIDAD");
            l2 = this.moveFirst(iSesion, declarantes, "IRDISCAPACIDAD");
            l3 = 0L;
            ValidacionesTablas validacionesTablas = new ValidacionesTablas(iSesion);
            int n7 = validacionesTablas.getMaximo(iSesion, "IRDISCAPACIDAD");
            while (l2 != l3 & n6 != n7) {
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIEX").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIMI").trim()) + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IPPMIPA").trim()) > 0.0) {
                    ++n5;
                }
                l3 = l2;
                if (l2 == l) break;
                l2 = this.moveNext(iSesion, declarantes, "IRDISCAPACIDAD");
            }
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E4AA", this.cr.redondea(d5, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E4AC", this.cr.redondea(d, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5II", this.cr.redondea(d6, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5AA", this.cr.redondea(d7, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E5AB", this.cr.redondea(d2, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EH", this.cr.redondea(d9, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EHporVALORD", this.cr.redondea(d10, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F1EHporVALORO", this.cr.redondea(d11, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESO", n);
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESO", this.cr.redondea(d12, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1RNR", this.cr.redondea(d13, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1SUMA", this.cr.redondea(d3, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1N1", this.cr.redondea(d4, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESOespecial", n2);
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "E1INGRESOespecial13", n3);
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "F2EA", this.cr.redondea(d8, 2));
            this.establecePropiedadHashMapDeMotor(iSesion, n6, "NUMEROT", n5);
        }
        iSesion.unfreeze(this.toString());
        this.calcularDescendientes(iSesion);
        this.calcularAscendientes(iSesion);
        String string = iSesion.getOperaciones().obtenerPartidaString("DPGMIN_D").trim();
        String string2 = iSesion.getOperaciones().obtenerPartidaString("DPGMIN_C").trim();
        this.fNum = this.cNHT > 2 || this.cNHT > 1 && this.cNHDIS > 0 || string.length() > 0 && string2.length() > 0 && this.cNHT > 1 || (string.equals("3") || string2.equals("3")) && this.cNHT > 1;
        return true;
    }

    private boolean deduccionCuotasSS(ISesion iSesion) throws Exception {
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_CASTILLA_LEON)) {
            return true;
        }
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        String string = "";
        switch (n) {
            case 0: {
                string = "D";
                break;
            }
            case 1: {
                string = "C";
                break;
            }
            case 15: {
                string = "J";
                break;
            }
            default: {
                return true;
            }
        }
        boolean bl = true;
        boolean bl2 = true;
        bl = n == 0 || n == 1 ? this.numHijos4R80093Individual != 0 : (n == 15 ? this.numHijos4R80093Conjunta != 0 : true);
        if (Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("CL7").trim()) > 0.0 && !bl) {
            bl2 &= this.addErrorOWarning(iSesion, "100P373", "W", "CL7(" + string + ")");
        }
        return bl2;
    }

    public boolean deduccionPaternidad(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, this.getMISesion(iSesion))).trim().equals(CTE_CASTILLA_LEON)) {
            return true;
        }
        int n = this.switchMotor(iSesion, declarantes2);
        boolean bl = true;
        double d = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("CL15").trim());
        String string2 = "";
        switch (this.switchMotor(iSesion, declarantes2)) {
            case 0: {
                string2 = "D";
                break;
            }
            case 1: {
                string2 = "C";
                break;
            }
            case 15: {
                string2 = "J";
                break;
            }
            default: {
                return true;
            }
        }
        if (this.numHijosNacidosEnEjercicioActualOAnterior == 0 && this.numHijosAdoptadosEnEjercicioActualOAnterior == 0 && d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P374", "W", "CL15(" + string + ")");
        }
        if ((n == 0 || n == 1 || n == 15 && d > 0.0) && Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("MUJER_" + string)) && Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DECCL15"))) {
            bl &= this.addErrorOWarning(iSesion, "100P355", "W", "CL15(" + string + ")");
        }
        return bl;
    }

    public boolean comprobarCL12(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL12"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "ORDENCL12"));
        boolean bl3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HABCL12").equals("");
        if (!declarantes2.equals(Declarantes.UnidadFamiliar) && bl3 && d > 0.0 && d2 > 0.0) {
            bl2 = true;
        } else if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CL12")) > 0.0 && bl3 && d > 0.0 && d2 > 0.0) {
            bl2 = true;
        }
        if (bl2) {
            bl &= this.addErrorOWarning(iSesion, "100I042", "E", "CL12(" + string + ")");
        }
        return bl;
    }

    private boolean validarNifOtroProgenitor(ISesion iSesion) throws Exception {
        String string;
        int n = this.switchMotor(iSesion, this.getMISesion(iSesion));
        String string2 = "";
        switch (n) {
            case 0: {
                string2 = "D";
                break;
            }
            case 1: {
                string2 = "C";
                break;
            }
            case 15: {
                string2 = "J";
                break;
            }
            default: {
                return true;
            }
        }
        String string3 = iSesion.getOperaciones().obtenerPartidaString("DPNIF_D");
        String string4 = iSesion.getOperaciones().obtenerPartidaString("DPNIF_C");
        int n2 = (int)iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS");
        String[] stringArray = new String[n2];
        long l = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n3 = 1;
        while ((long)n3 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            iSesion.getOperaciones().move("DESCENDIENTESRENTAS", (long)n3);
            stringArray[n3 - 1] = iSesion.getOperaciones().obtenerPartidaString("NIFHR");
            ++n3;
        }
        iSesion.getOperaciones().move("DESCENDIENTESRENTAS", l);
        String string5 = iSesion.getOperaciones().obtenerPartidaString("NIFOP");
        String string6 = "";
        boolean bl = this.funcrentaValidador.isBConyuge(iSesion);
        if (bl) {
            if ("D".equals(string2)) {
                string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NIFOP");
            } else if ("C".equals(string2)) {
                string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NIFOP");
            }
            if (!"".equals(string5) && string5.equals(string6)) {
                this.addErrorOWarning(iSesion, "100R540", "E", "NIFOP(" + string2 + ")");
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string5, "");
        if (!string3.equals("")) {
            if (hashMap.containsKey(string3)) {
                this.addErrorOWarning(iSesion, "WIN106", "E", "NIFOP(" + string2 + ")");
                return true;
            }
            hashMap.put(string3, "");
        }
        if (!string4.equals("")) {
            if (hashMap.containsKey(string4)) {
                this.addErrorOWarning(iSesion, "WIN106", "E", "NIFOP(" + string2 + ")");
                return true;
            }
            hashMap.put(string4, "");
        }
        int n4 = 1;
        while ((long)n4 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (!stringArray[n4 - 1].equals("")) {
                if (hashMap.containsKey(stringArray[n4 - 1])) {
                    this.addErrorOWarning(iSesion, "WIN106", "E", "NIFOP(" + string2 + ")");
                    return true;
                }
                hashMap.put(stringArray[n4 - 1], "");
            }
            ++n4;
        }
        long l2 = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTES");
        l = 0L;
        long l3 = 0L;
        l = iSesion.getOperaciones().moveFirst("DESCENDIENTES");
        long l4 = iSesion.getOperaciones().recordCount("DESCENDIENTES");
        l3 = 0L;
        while (l != l3) {
            string = iSesion.getOperaciones().obtenerPartidaString("NIFH");
            if (!string.equals("")) {
                if (hashMap.containsKey(string)) {
                    this.addErrorOWarning(iSesion, "WIN106", "E", "NIFOP(" + string2 + ")");
                    return true;
                }
                hashMap.put(string, "");
            }
            l3 = l;
            if (l == l4) break;
            l = iSesion.getOperaciones().moveNext("DESCENDIENTES");
        }
        iSesion.getOperaciones().move("DESCENDIENTES", l2);
        l2 = iSesion.getOperaciones().obtenerClaveActiva("ASCENDIENTES");
        l4 = iSesion.getOperaciones().recordCount("ASCENDIENTES");
        l = iSesion.getOperaciones().moveFirst("ASCENDIENTES");
        l3 = 0L;
        while (l != l3) {
            string = iSesion.getOperaciones().obtenerPartidaString("DNIAS");
            if (!string.equalsIgnoreCase("")) {
                if (hashMap.containsKey(string)) {
                    this.addErrorOWarning(iSesion, "WIN106", "E", "NIFOP(" + string2 + ")");
                    return true;
                }
                hashMap.put(string, "DNIAS");
            }
            l3 = l;
            if (l == l4) break;
            l = iSesion.getOperaciones().moveNext("ASCENDIENTES");
        }
        iSesion.getOperaciones().move("ASCENDIENTES", l2);
        return true;
    }

    public boolean esFabricacion(ISesion iSesion, Declarantes declarantes) throws Exception {
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IDIAE"));
        return !(d < 119.0) && !(d > 122.0);
    }

    public boolean validarHorasActividades(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        long l = this.obtenerClaveActiva(iSesion, declarantes, "E2REGESTOBJ");
        long l2 = this.moveFirst(iSesion, declarantes, "E2REGESTOBJ");
        long l3 = 0L;
        long l4 = this.recordCount(iSesion, declarantes, "E2REGESTOBJ");
        long l5 = this.obtenerClaveActiva(iSesion, declarantes, "MODULOOBJ");
        long l6 = this.recordCount(iSesion, declarantes, "MODULOOBJ");
        long l7 = 0L;
        while (l2 != l3) {
            int n = 2;
            l7 = this.moveFirst(iSesion, declarantes, "MODULOOBJ");
            long l8 = 0L;
            if (this.esFabricacion(iSesion, declarantes)) {
                n = 3;
            }
            while (l7 != l8) {
                if (l7 != (long)n) {
                    l8 = l7;
                    l7 = this.moveNext(iSesion, declarantes, "MODULOOBJ");
                    continue;
                }
                double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V6D01E4AU" + n));
                double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V6D02E4AU" + n));
                double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V6D03E4AU" + n));
                double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V6D04E4AU" + n));
                if (d < 450.0 && d + d2 + d3 + d4 > 0.0) {
                    bl2 = true;
                    break;
                }
                l8 = l7;
                if (l7 == l6) break;
                l7 = this.moveNext(iSesion, declarantes, "MODULOOBJ");
            }
            l3 = l2;
            if (l2 == l4 || bl2) break;
            l2 = this.moveNext(iSesion, declarantes, "E2REGESTOBJ");
        }
        this.move(iSesion, declarantes, "E2REGESTOBJ", l);
        this.move(iSesion, declarantes, "MODULOOBJ", l5);
        if (bl2) {
            bl &= this.addErrorOWarning(iSesion, "100P395", "W", "E4AEP(" + string + ")", "%" + l2 + "$E2REGESTOBJ");
        }
        return bl;
    }

    public boolean incentivosInversionEmpresarial(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (!(declarantes.equals(Declarantes.Declarante) || declarantes.equals(Declarantes.Conyuge) || declarantes.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        double d = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED4E"));
        double d2 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("CINTEST"));
        double d3 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED0E"));
        double d4 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED1E"));
        double d5 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED2E"));
        double d6 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED3E"));
        double d7 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED5E"));
        double d8 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED6E"));
        double d9 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED7E"));
        double d10 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED8E"));
        double d11 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED9E"));
        double d12 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED10E"));
        double d13 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED11E"));
        double d14 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED4A"));
        double d15 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("CINTAUT"));
        double d16 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED1A"));
        double d17 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED2A"));
        double d18 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED3A"));
        double d19 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED5A"));
        double d20 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED6A"));
        double d21 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED7A"));
        double d22 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED8A"));
        double d23 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("DED9A"));
        double d24 = Double.parseDouble(iSesion.getOperaciones().obtenerPartidaString("SUMADEDAUT"));
        if (d > 0.0 && d > d2 - d3 - d4 - d5 - d6 - d7 - d8 - d9 - d10 - d11 - d12 - d13 || d14 > 0.0 && d14 > d15 - d16 - d17 - d18 - d19 - d20 - d21 - d22 - d23 - d24) {
            bl &= this.addErrorOWarning(iSesion, "100R541", "W", "DED6E(" + string + ")");
        }
        return bl;
    }

    public boolean controlImpresionComplementaria(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (this.funcrentaValidador.isBConjunta(iSesion)) {
            boolean bl2 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "Z8"));
            boolean bl3 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "Z9"));
            boolean bl4 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "Z10"));
            boolean bl5 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "Z11"));
            boolean bl6 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "Z12"));
            if (bl2 || bl3 || bl4 || bl5 || bl6) {
                boolean bl7 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z8"));
                boolean bl8 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z9"));
                boolean bl9 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z10"));
                boolean bl10 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z11"));
                boolean bl11 = Boolean.parseBoolean(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Z12"));
                if (this.switchMotor(iSesion, declarantes2) == 15) {
                    string = "J";
                }
                if (bl7 || bl8 || bl9 || bl10 || bl11) {
                    bl &= this.addErrorOWarning(iSesion, "100R511", "E", "Z8(" + string + ")");
                }
            }
        }
        return bl;
    }

    public boolean deduccionMaterialEscolarExtremadura(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!(declarantes2.equals(Declarantes.Declarante) || declarantes2.equals(Declarantes.Conyuge) || declarantes2.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        if (!this.dameComunidadDeclarante(iSesion, declarantes2).equals(CTE_EXTREMADURA)) {
            return true;
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        if (declarantes.equals(Declarantes.Declarante)) {
            if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                d = this.numHijosEdadEscolarBConjunta;
                d2 = this.numHijosEdadEscolarADConjunta;
            } else {
                d = this.numHijosEdadEscolarB;
                d2 = this.numHijosEdadEscolarAD;
            }
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                d = this.numHijosEdadEscolarCConjunta;
                d2 = this.numHijosEdadEscolarAEConjunta;
            } else {
                d = this.numHijosEdadEscolarC;
                d2 = this.numHijosEdadEscolarAE;
            }
        }
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C01E8"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C02E8"));
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUM1E8"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "E8"));
        if (d + 0.5 * d2 < 0.5 * d3 + d4 / (double)this.compruebaNan(n) && d5 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P416", "W", "E8(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionFamiliaNumerosa(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!(declarantes2.equals(Declarantes.Declarante) || declarantes2.equals(Declarantes.Conyuge) || declarantes2.equals(Declarantes.UnidadFamiliar))) {
            return true;
        }
        String string2 = iSesion.getOperaciones().obtenerPartidaString("CAC_D");
        String string3 = iSesion.getOperaciones().obtenerPartidaString("CAC_C");
        boolean bl = true;
        boolean bl2 = Boolean.parseBoolean(iSesion.getOperaciones().obtenerPartidaString("CASADO_D"));
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CM8"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL11"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "PA11"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN10"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "GA2"));
        int n = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMCM8"));
        int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMCL11"));
        int n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMPA11"));
        int n4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMCAN10"));
        int n5 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMGA2"));
        if (bl2 && !declarantes2.equals(Declarantes.UnidadFamiliar)) {
            if (d > 0.0 && n == 1) {
                bl &= this.addErrorOWarning(iSesion, "100P439", "W", "CM8(" + string + ")");
            } else if (d2 > 0.0 && n2 == 1) {
                bl &= this.addErrorOWarning(iSesion, "100P439", "W", "CL11(" + string + ")");
            } else if (d3 > 0.0 && n3 == 1) {
                bl &= this.addErrorOWarning(iSesion, "100P439", "W", "PA11(" + string + ")");
            } else if (d5 > 0.0 && n5 == 1) {
                bl &= this.addErrorOWarning(iSesion, "100P439", "W", "GA2(" + string + ")");
            } else if (d4 > 0.0 && n4 == 1) {
                bl &= this.addErrorOWarning(iSesion, "100P439", "W", "CAN10(" + string + ")");
            }
        }
        if (bl2) {
            int n6 = 0;
            int n7 = 0;
            if (string2.equals(CTE_ASTURIAS) || string3.equals(CTE_ASTURIAS)) {
                n6 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMPA11"));
                n7 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMPA11"));
            }
            int n8 = 0;
            int n9 = 0;
            if (string2.equals(CTE_CANARIAS) || string3.equals(CTE_CANARIAS)) {
                n8 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMCAN10"));
                n9 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMCAN10"));
            }
            int n10 = 0;
            int n11 = 0;
            if (string2.equals(CTE_CASTILLA_LA_MANCHA) || string3.equals(CTE_CASTILLA_LA_MANCHA)) {
                n10 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMCM8"));
                n11 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMCM8"));
            }
            int n12 = 0;
            int n13 = 0;
            if (string2.equals(CTE_CASTILLA_LEON) || string3.equals(CTE_CASTILLA_LEON)) {
                n12 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMCL11"));
                n13 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMCL11"));
            }
            int n14 = 0;
            int n15 = 0;
            if (string2.equals(CTE_GALICIA) || string3.equals(CTE_GALICIA)) {
                n14 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMGA2"));
                n15 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMGA2"));
            }
            int n16 = 0;
            int n17 = 0;
            if (string2.equalsIgnoreCase(CTE_VALENCIA) || string3.equals(CTE_VALENCIA)) {
                n16 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "NUMVA4"));
                n17 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "NUMVA4"));
            }
            String string4 = "";
            string4 = !declarantes2.equals(Declarantes.UnidadFamiliar) ? string : "C";
            if (n6 == 1 && n7 > 0 || n6 > 0 && n7 == 1) {
                if (n6 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "PA11(" + string4 + ")");
            } else if (n8 == 1 && n9 > 0 || n8 > 0 && n9 == 1) {
                if (n8 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "CAN10(" + string4 + ")");
            } else if (n10 == 1 && n11 > 0 || n10 > 0 && n11 == 1) {
                if (n10 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "CM8(" + string4 + ")");
            } else if (n12 == 1 && n13 > 0 || n12 > 0 && n13 == 1) {
                if (n12 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "CL11(" + string4 + ")");
            } else if (n14 == 1 && n15 > 0 || n14 > 0 && n15 == 1) {
                if (n14 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "GA2(" + string4 + ")");
            } else if (n16 == 1 && n17 > 0 || n16 > 0 && n17 == 1) {
                if (n16 == 1 && declarantes2.equals(Declarantes.UnidadFamiliar)) {
                    string4 = "D";
                }
                bl &= this.addErrorOWarning(iSesion, "100R536", "E", "VA4(" + string4 + ")");
            }
        }
        return bl;
    }

    public boolean comprobarArrendamientoViviendaSocialAragon(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        boolean bl2 = false;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string2.equals(CTE_ARAGON)) {
            double d;
            long l = this.obtenerClaveActiva(iSesion, declarantes, "INMUEBLES");
            long l2 = this.moveFirst(iSesion, declarantes, "INMUEBLES");
            long l3 = 0L;
            long l4 = this.recordCount(iSesion, declarantes, "INMUEBLES");
            double d2 = 0.0;
            double d3 = 0.0;
            while (l3 != l2) {
                double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_RNR"));
                if (d4 > 0.0) {
                    d2 += d4;
                }
                d3 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "C_IIC"));
                l3 = l2;
                if (l2 == l4) continue;
                l2 = this.moveNext(iSesion, declarantes, "INMUEBLES");
            }
            this.move(iSesion, declarantes, "INMUEBLES", l);
            long l5 = this.obtenerClaveActiva(iSesion, declarantes, "FREATRENTAS");
            long l6 = this.moveFirst(iSesion, declarantes, "FREATRENTAS");
            long l7 = 0L;
            long l8 = this.recordCount(iSesion, declarantes, "FREATRENTAS");
            double d5 = 0.0;
            double d6 = 0.0;
            while (l7 != l6) {
                d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EG"));
                if (d > 0.0) {
                    d5 += d;
                }
                d6 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "F1EE"));
                l7 = l6;
                if (l6 == l8) continue;
                l6 = this.moveNext(iSesion, declarantes, "FREATRENTAS");
            }
            this.move(iSesion, declarantes, "FREATRENTAS", l5);
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMPAR11"));
            double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "AR11"));
            if (d7 > 0.0) {
                if (d > d2 + d5) {
                    bl &= this.addErrorOWarning(iSesion, "100P484", "W", "AR11(" + string + ")");
                }
                if (d > 0.0 && d3 == 0.0 && d6 == 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100R567", "E", "AR11(" + string + ")");
                }
            }
        }
        return bl;
    }

    public boolean comprobarAdquisicionLibrosAragon(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        boolean bl2 = false;
        double d = 0.0;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        if (declarantes.equals(Declarantes.Declarante)) {
            d = declarantes2.equals(Declarantes.UnidadFamiliar) ? (double)this.numHijosLibrosAragonOd : (double)this.numHijosLibrosAragonD;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            d = declarantes2.equals(Declarantes.UnidadFamiliar) ? (double)this.numHijosLibrosAragonOc : (double)this.numHijosLibrosAragonC;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string2.equals(CTE_ARAGON)) {
            double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "AR9"));
            int n2 = 0;
            int n3 = 0;
            for (int i = 1; i < 7; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, stringBuilder.append("IMP").append(i).append("AR9").toString())) > 0.0) {
                    ++n2;
                }
                if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CONY" + i + "AR9")) != 1.0) continue;
                n3 = (int)((double)n3 + Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "IMP" + i + "AR9")));
            }
            if (d2 > 0.0 && d < (double)n2) {
                bl &= this.addErrorOWarning(iSesion, "100P487", "W", "AR9(" + string + ")");
            }
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "AR9"));
                double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "AR9"));
                double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "AR9"));
                boolean bl3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "INDV").equalsIgnoreCase("false");
                boolean bl4 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CASADO").equalsIgnoreCase("true");
                for (int i = 1; i < 7; ++i) {
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CONY" + i + "AR9")) == 1.0) {
                        d3 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMP" + i + "AR9"));
                    }
                    if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CONY" + i + "AR9")) != 1.0) continue;
                    d4 += Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMP" + i + "AR9"));
                }
                if (bl4 && bl3 && d3 != d4 && (d5 > 0.0 || d6 > 0.0 || d7 > 0.0)) {
                    bl &= this.addErrorOWarning(iSesion, "100P488", "W", "AR9(" + string + ")");
                }
            }
        }
        return bl;
    }

    public boolean comprobarMaterialEscolarValencia(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        if (declarantes.equals(Declarantes.Declarante)) {
            d = this.numHijosMaterialEscolarValenciaD;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            d = this.numHijosMaterialEscolarValenciaC;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string2.equals(CTE_VALENCIA)) {
            boolean bl3 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "INDV").equalsIgnoreCase("false");
            boolean bl4 = this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CASADO").equalsIgnoreCase("true");
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOS1VA25"));
            double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOS3VA25"));
            double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "HIJOS4VA25"));
            double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "VA25"));
            double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "VA25"));
            double d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "VA25"));
            int n2 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DIASTVA25"));
            int n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DIASTVA25"));
            int n4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DIASOPVA25"));
            int n5 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DIASOPVA25"));
            if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
                d2 = this.numHijosMaterialEscolarValenciaOD;
                d3 = this.numHijosMaterialEscolarValenciaOC;
                double d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "HIJOS1VA25"));
                double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "HIJOS3VA25"));
                double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "HIJOS4VA25"));
                double d13 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "HIJOS1VA25"));
                double d14 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "HIJOS3VA25"));
                double d15 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "HIJOS4VA25"));
                if ((d2 < d10 + d11 + d12 || d3 < d13 + d14 + d15) && d7 > 0.0) {
                    if (d2 < d10 + d11 + d12) {
                        bl &= this.addErrorOWarning(iSesion, "100P489", "W", "VA25(D)");
                    } else if (d3 < d13 + d14 + d15) {
                        bl &= this.addErrorOWarning(iSesion, "100P489", "W", "VA25(C)");
                    }
                }
                if (bl4 && bl3 && d4 > 0.0 && (n4 != n3 || n5 != n2) && d7 > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100R571", "E", "VA25(" + string + ")");
                }
            } else {
                if (d < d4 + d5 + d6 && d7 > 0.0) {
                    bl &= this.addErrorOWarning(iSesion, "100P489", "W", "VA25(" + string + ")");
                }
                if (bl4 && bl3 && d4 > 0.0 && (n4 != n3 || n5 != n2) && (d8 > 0.0 || d9 > 0.0)) {
                    bl &= this.addErrorOWarning(iSesion, "100R571", "E", "VA25(" + string + ")");
                }
            }
        }
        return bl;
    }

    public boolean deduccionNacimientoAdopcionAragon(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        boolean bl = true;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.switchMotor(iSesion, declarantes) == n + 1) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2 || this.switchMotor(iSesion, declarantes) == 1 && !this.funcrentaValidador.isBConyuge(iSesion)) {
            return true;
        }
        if (declarantes.equals(Declarantes.Declarante)) {
            d = this.numHijosAragonD;
            d2 = this.numHijosHminAragonD;
            d3 = this.numHijosAragonNacD;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            d = this.numHijosAragonC;
            d2 = this.numHijosHminAragonC;
            d3 = this.numHijosAragonNacC;
        }
        String string2 = this.funcrentaValidador.obtenerPartidaString(iSesion, this.getMISesion(iSesion), this.getNombrePartidaCCAAParaDeclarante(iSesion, declarantes2));
        if (string2.equals(CTE_ARAGON)) {
            boolean bl3;
            double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "AR1"));
            double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO1AR1"));
            double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CO2AR1"));
            double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "AR14"));
            String string3 = iSesion.getOperaciones().obtenerPartidaString("COM1AR14");
            String string4 = iSesion.getOperaciones().obtenerPartidaString("COM2AR14");
            boolean bl4 = string3.equalsIgnoreCase("true") || string4.equalsIgnoreCase("true");
            String string5 = iSesion.getOperaciones().obtenerPartidaString("DEC1AR14");
            String string6 = iSesion.getOperaciones().obtenerPartidaString("DEC2AR14");
            boolean bl5 = bl3 = string5.equalsIgnoreCase("true") || string6.equalsIgnoreCase("true");
            if (d4 > 0.0 && (d < 3.0 && d2 == 0.0 || d == 1.0) && d3 > 0.0 && d5 + d6 > 0.0) {
                bl &= this.addErrorOWarning(iSesion, "100P515", "W", "AR1(" + string + ")");
            }
            if (d7 > 0.0 && (d > 2.0 || d == 2.0 && d2 > 0.0) && (bl4 || bl3) && d3 == 1.0) {
                bl &= this.addErrorOWarning(iSesion, "100P516", "W", "AR14(" + string + ")");
            }
            if (d4 > 0.0 && d7 > 0.0 && d5 + d6 > 0.0 && d < 3.0 && (string4.equalsIgnoreCase("true") || string6.equalsIgnoreCase("true") || (string3.equalsIgnoreCase("true") || string5.equalsIgnoreCase("true")) && (string4.equalsIgnoreCase("true") || string6.equalsIgnoreCase("true")))) {
                bl &= this.addErrorOWarning(iSesion, "100P517", "W", "AR14(" + string + ")");
            }
            if (d7 > 0.0 && (d == 1.0 && d3 == 1.0 && (string4.equalsIgnoreCase("true") || string6.equalsIgnoreCase("true")) || d == 2.0 && d3 < 2.0 && (string3.equalsIgnoreCase("true") || string5.equalsIgnoreCase("true")))) {
                bl &= this.addErrorOWarning(iSesion, "100P518", "W", "AR14(" + string + ")");
            }
        }
        return bl;
    }

    public boolean deduccionContribuyentesDiscapacitadosCyL(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        if (declarantes.equals(Declarantes.Declarante)) {
            string2 = "BD";
            string3 = "A";
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            string2 = "CE";
            string3 = "A";
        }
        int n3 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "TITCL1"));
        int n4 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COMCL1"));
        long l = 0L;
        long l2 = iSesion.getOperaciones().moveFirst("DESCENDIENTES");
        long l3 = iSesion.getOperaciones().recordCount("DESCENDIENTES");
        long l4 = iSesion.getOperaciones().obtenerClaveActiva("DESCENDIENTES");
        while (l != l2) {
            String string4 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VINCU");
            String string5 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "OTRSDLG");
            String string6 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "FALLDLG");
            String string7 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "MINUSDLG");
            String string8 = iSesion.getOperaciones().obtenerPartidaString("FNAC");
            if (string8 != null && !string8.equalsIgnoreCase("") && !string8.equalsIgnoreCase("0") && !"1".equalsIgnoreCase(string5) && "".equals(string6) && (this.funcrentaValidador.comparaFechas(string8, "31/12/1996") == 1 || "2".equalsIgnoreCase(string5) || "4".equalsIgnoreCase(string5)) && "3".equals(string7)) {
                if (string3.contains(string4)) {
                    ++n;
                } else if (string2.contains(string4)) {
                    ++n2;
                }
            }
            l = l2;
            if (l2 == l3) continue;
            l2 = iSesion.getOperaciones().moveNext("DESCENDIENTES");
        }
        iSesion.getOperaciones().move("DESCENDIENTES", l4);
        if (n + n2 > 0 && n4 + n3 == 0) {
            bl &= this.addErrorOWarning(iSesion, "100R592", "W", "CL1(" + string + ")");
        }
        if (n < n4 || n2 < n3) {
            bl &= this.addErrorOWarning(iSesion, "100R593", "E", "CL1(" + string + ")");
        }
        return bl;
    }

    public boolean valorPatrimonio2005(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws NumberFormatException, Exception {
        if (declarantes == null) {
            return true;
        }
        iSesion.freezeSesionSoloPosicion(this.toString());
        boolean bl = true;
        long l = this.recordCount(iSesion, declarantes, "G3GPOTROS");
        long l2 = this.moveFirst(iSesion, declarantes, "G3GPOTROS");
        long l3 = 0L;
        while (l2 != l3) {
            if ((this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3DB").trim().equals("4") || this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "COT").trim().equalsIgnoreCase("true")) && Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "V01VIP")) == 0.0 && this.funcrentaValidador.comparaFechas("31121994", this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "G3DD")) == 1) {
                bl &= this.addErrorOWarning(iSesion, "100R251", "E", "G3DE(" + string + ")", "%" + l2 + "$G3GPOTROS");
            }
            l3 = l2;
            if (l2 == l) break;
            l2 = this.moveNext(iSesion, declarantes, "G3GPOTROS");
        }
        iSesion.unfreeze(this.toString());
        return bl;
    }

    public boolean deduccionAscendientesMayores75CM(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        int n;
        boolean bl = true;
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LA_MANCHA)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n <= 4; ++n) {
            if ("".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NOM" + n + "CM6").trim())) continue;
            ++n2;
        }
        for (n = 1; n <= 4; ++n) {
            if (!"true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DED" + n + "CM6").trim())) continue;
            ++n3;
        }
        if (n2 > 0 && n3 == 0) {
            bl &= this.addErrorOWarning(iSesion, "100P431", "W", "CM6(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionNacimientoAdopcionCL(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "IMPCL12"));
        double d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "IMPCL12"));
        double d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "CL12"));
        double d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "CL12"));
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CL12"));
        if (declarantes2.equals(Declarantes.Declarante)) {
            bl2 = !this.condicion8528d && d > 0.0 && d3 > 0.0;
        } else if (declarantes2.equals(Declarantes.Conyuge)) {
            bl2 = !this.condicion8528c && d2 > 0.0 && d4 > 0.0;
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            boolean bl3 = bl2 = d5 > 0.0 && (declarantes.toInt() == 10 && !this.condicion8528d && d > 0.0 || declarantes.toInt() == 20 && !this.condicion8528c && d2 > 0.0);
        }
        if (bl2) {
            bl &= this.addErrorOWarning(iSesion, "100P417", "W", "CL12(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionPartosMultiplesCL(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (declarantes.equals(Declarantes.Declarante)) {
            n = this.NUMERO13d;
            n2 = this.NUMERO12d;
            bl2 = this.PM12d;
            bl3 = this.PM12Ad;
            n3 = this.NUMPM12d;
            n4 = this.NUMDISd;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            n = this.NUMERO13c;
            n2 = this.NUMERO12c;
            bl2 = this.PM12c;
            bl3 = this.PM12Ac;
            n3 = this.NUMPM12c;
            n4 = this.NUMDISc;
        } else {
            return true;
        }
        if (declarantes2.equals(Declarantes.UnidadFamiliar)) {
            d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CL13"));
            d2 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.UnidadFamiliar, "CL12"));
            d3 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DH12BCL13"));
            d4 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DH12BCL13"));
        }
        double d5 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DH11CL13"));
        double d6 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DH11BCL13"));
        double d7 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPM11CL13"));
        double d8 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DPM11BCL13"));
        double d9 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DH12CL13"));
        double d10 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DH12BCL13"));
        double d11 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL12"));
        double d12 = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CL13"));
        int n5 = Integer.parseInt(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NUMPMCL13"));
        if (d5 + d6 > 0.0 && n2 == 0 && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P425", "W", "CL13(" + string + ")");
        }
        if (d7 + d8 > 0.0 && n2 < 2 && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P426", "W", "CL13(" + string + ")");
        }
        if (d10 > 0.0 && n == 0 && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P427", "W", "CL13(" + string + ")");
        }
        if ((d6 > 0.0 && !bl2 || d5 > 0.0 && !bl3) && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P428", "W", "CL13(" + string + ")");
        }
        if (d9 == 0.0 && d6 == 0.0 && bl2 || d9 > 0.0 && d5 == 0.0 && bl3) {
            bl &= this.addErrorOWarning(iSesion, "100P429", "W", "CL13(" + string + ")");
        }
        if ((n5 > 2 && n3 < 2 || 0 < n5 && n5 < 3 && n3 > 1) && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P430", "W", "CL13(" + string + ")");
        }
        if (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 && d10 > d11) {
            bl &= this.addErrorOWarning(iSesion, "100R527", "E", "CL13(" + string + ")");
        } else if (declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0 && d3 + d4 > d2 + 0.5) {
            bl &= this.addErrorOWarning(iSesion, "100R527", "E", "CL13(J)");
        }
        if ((d5 > 1586.9250000000002 * (double)n2 + 1586.9250000000002 * (double)n4 || d6 > 1586.9250000000002 * (double)n2 + 1586.9250000000002 * (double)n4) && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100R528", "W", "CL13(" + string + ")");
        }
        if (d9 > 0.0 && d10 > 0.0 && (declarantes2 != Declarantes.UnidadFamiliar && d12 > 0.0 || declarantes2.equals(Declarantes.UnidadFamiliar) && d > 0.0)) {
            bl &= this.addErrorOWarning(iSesion, "100P435", "W", "CL13(" + string + ")");
        }
        if (n5 == 0 && d10 + d6 + d8 > 0.0 && d12 > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100R535", "E", "CL13(" + string + ")");
        }
        return bl;
    }

    public boolean deduccionPartosMultiplesCL2013(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        if (!this.comprobarCA(iSesion, declarantes, CTE_CASTILLA_LEON)) {
            return true;
        }
        if (!declarantes.equals(Declarantes.Declarante) && !declarantes.equals(Declarantes.Conyuge)) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC1CL13B"));
        boolean bl5 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DEC1CL13B"));
        boolean bl6 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DEC1CL13B"));
        boolean bl7 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DEC2CL13B"));
        boolean bl8 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DEC2CL13B"));
        boolean bl9 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC3CL13B"));
        boolean bl10 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DEC3CL13B"));
        boolean bl11 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DEC3CL13B"));
        boolean bl12 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC4CL13B"));
        boolean bl13 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Declarante, "DEC5CL13B"));
        boolean bl14 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, Declarantes.Conyuge, "DEC5CL13B"));
        boolean bl15 = "true".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "DEC6CL13B"));
        double d = Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes2, "CL13B"));
        if (declarantes.equals(Declarantes.Declarante)) {
            n = this.NUMERO12d;
            n2 = this.NUMERO11d;
            bl2 = this.PMd;
            bl3 = this.PMBd;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            n = this.NUMERO12c;
            n2 = this.NUMERO11c;
            bl2 = this.PMc;
            bl3 = this.PMBc;
        } else {
            return true;
        }
        if (bl4 && n2 < 2 && !bl3 && d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P513", "W", "CL13B(" + string + ")");
        }
        if (!bl4 && (n2 > 1 || bl3) || !bl9 && (n > 1 || bl2)) {
            bl &= this.addErrorOWarning(iSesion, "100P442", "W", "CL13B(" + string + ")");
        }
        if (bl9 && n < 2 && !bl2 && d > 0.0) {
            bl &= this.addErrorOWarning(iSesion, "100P479", "W", "CL13B(" + string + ")");
        }
        if (d > 0.0 && (bl5 && bl6 && (bl7 || bl8) || bl10 && bl11 && (bl13 || bl14))) {
            bl = declarantes2.equals(Declarantes.UnidadFamiliar) ? (bl7 || bl13 ? (bl &= this.addErrorOWarning(iSesion, "100P443", "W", "CL13B(D)")) : (bl &= this.addErrorOWarning(iSesion, "100P443", "W", "CL13B(C)"))) : (bl &= this.addErrorOWarning(iSesion, "100P443", "W", "CL13B(" + string + ")"));
        }
        if (d > 0.0 && (n < 4 && !bl2 && bl12 || n2 < 4 && !bl3 && bl15)) {
            bl &= this.addErrorOWarning(iSesion, "100P481", "W", "CL13B(" + string + ")");
        }
        return bl;
    }

    private boolean deduccionObrasMejoraViviendaHabitual(ISesion iSesion) throws Exception {
        if (!this.getMISesion(iSesion).equals(Declarantes.Declarante)) {
            return true;
        }
        if (!this.comprobarCA(iSesion, this.getMISesion(iSesion), CTE_EXTREMADURA)) {
            return true;
        }
        boolean bl = true;
        return bl;
    }

    public boolean validarCAN13(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "CAN13")) > 0.0 && "".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFCAN")) && "".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NONIFCAN"))) {
            bl &= this.addErrorOWarning(iSesion, "100R534", "E", "CAN13(" + string + ")");
        }
        return bl;
    }

    public boolean validarVA26(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (Double.parseDouble(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "VA26")) > 0.0 && "".equalsIgnoreCase(this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "NIFVAL3"))) {
            bl &= this.addErrorOWarning(iSesion, "100R587", "E", "VA26(" + string + ")");
        }
        return bl;
    }

    public boolean comprobarCCCDF(ISesion iSesion, Declarantes declarantes, String string, Declarantes declarantes2) throws Exception {
        boolean bl = true;
        if (!"D".equals(string) && !"C".equals(string)) {
            return true;
        }
        String string2 = iSesion.getOperaciones().obtenerPartidaString("DF_CCC_" + string);
        String string3 = this.funcrentaValidador.obtenerPartidaString(iSesion, declarantes, "Y81");
        if (!"".equals(string3) && string3.equals(string2)) {
            bl &= this.addErrorOWarning(iSesion, "100P446", "W", "Y81(" + string + ")");
        }
        return bl;
    }

    public void dispose() throws ExceptionMotor {
    }

    public void init(Object[] objectArray) throws ExceptionMotor {
    }
}

