/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.cc14;

import es.aeat.pare.cc14.CalculosA;
import es.aeat.pare.cc14.CalculosE1;
import es.aeat.pare.cc14.CalculosF1;
import es.aeat.pare.cc14.CalculosL;
import es.aeat.pare.cc14.CalculosRenta;
import es.aeat.pare.cc14.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;

public final class CalculosB
extends CalculosRenta {
    private static final long serialVersionUID = 8983781932970663734L;
    private double biTotal;
    private double exenTotal;
    private int indiceExcesos;
    private double[] imp;
    private double[] exen;
    private double[] suj;

    public CalculosB(ISesion iSesion) throws ExceptionMotor {
        super(iSesion);
    }

    public void inicializaValores(ISesion iSesion) throws ExceptionMotor {
        int n = Constantes.getNumhijosrentas() + 2;
        this.imp = new double[n];
        this.exen = new double[n];
        this.suj = new double[n];
        this.biTotal = 0.0;
        this.exenTotal = 0.0;
        if (iSesion.getOperaciones().recordCount("DIVIDENDOS") > 0L) {
            iSesion.getOperaciones().borrarRegistros("DIVIDENDOS");
        }
        for (int i = 1; i <= n; ++i) {
            iSesion.getOperaciones().anniadirRegistro("DIVIDENDOS");
            if (i == 1) {
                iSesion.getOperaciones().establecerPartida("DIV_TIT", (Object)this.funcrentaValidador.leerTitularD(iSesion));
                continue;
            }
            if (i == 2 && this.funcrentaValidador.isBConyuge(iSesion)) {
                iSesion.getOperaciones().establecerPartida("DIV_TIT", (Object)this.funcrentaValidador.leerTitularC(iSesion));
                continue;
            }
            int n2 = 1;
            while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                if (i == 2 + n2 && this.funcrentaValidador.isBHijos(iSesion, n2)) {
                    iSesion.getOperaciones().establecerPartida("DIV_TIT", (Object)this.funcrentaValidador.leerTitularH(iSesion, n2));
                }
                ++n2;
            }
        }
    }

    public void calculaBInd(ISesion iSesion, String string, int n) throws ExceptionMotor {
        int n2;
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        if (string.equalsIgnoreCase("B13")) {
            this.indiceExcesos = n - 1;
        }
        this.calcularBIInd(iSesion, string);
        int n3 = this.calculaCuantos(string);
        int n4 = (int)iSesion.getOperaciones().recordCount("B_" + string + "");
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        String[] stringArray3 = new String[n4];
        String[] stringArray4 = new String[n4];
        String[] stringArray5 = new String[n4];
        String[] stringArray6 = new String[n4];
        String[] stringArray7 = new String[n4];
        long l = iSesion.getOperaciones().obtenerClaveActiva("B_" + string + "");
        for (n2 = 0; n2 < n4; ++n2) {
            iSesion.getOperaciones().move("B_" + string + "", (long)(n2 + 1));
            stringArray[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IMP1D" + string);
            if (n3 > 1) {
                stringArray2[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IMP2D" + string);
                if (n3 > 2) {
                    if (string.equalsIgnoreCase("B13") || string.equalsIgnoreCase("B25")) {
                        stringArray6[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("TIPD" + string);
                    }
                    stringArray3[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IMP3D" + string);
                    if (n3 > 3) {
                        stringArray4[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IMP4D" + string);
                        if (n3 > 4) {
                            stringArray5[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IMP5D" + string);
                        }
                    }
                }
            }
            stringArray7[n2] = "" + iSesion.getOperaciones().obtenerPartidaString("IND" + string);
        }
        if (this.funcrentaValidador.isBConjunta(iSesion)) {
            iSesion = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.UnidadFamiliar);
            n2 = (int)iSesion.getOperaciones().recordCount("B_" + string + "");
            for (int i = 0; i < n4; ++i) {
                int n5 = Integer.parseInt(stringArray7[i]);
                if (n5 <= 0) continue;
                boolean bl = false;
                int n6 = 0;
                for (int j = 0; j < n2; ++j) {
                    iSesion.getOperaciones().move("B_" + string + "", (long)(j + 1));
                    n6 = Integer.parseInt("" + iSesion.getOperaciones().obtenerPartidaString("IND" + string));
                    if (n5 != n6 && n6 != 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    iSesion.getOperaciones().anniadirRegistro("B_" + string + "");
                    iSesion.getOperaciones().establecerPartida("IND" + string, (Object)("" + n5));
                } else if (n6 == 0) {
                    iSesion.getOperaciones().establecerPartida("IND" + string, (Object)("" + n5));
                }
                iSesion.getOperaciones().establecerPartida("IMP1D" + string, (Object)stringArray[i]);
                if (n3 <= 1) continue;
                iSesion.getOperaciones().establecerPartida("IMP2D" + string, (Object)stringArray2[i]);
                if (n3 <= 2) continue;
                if (string.equalsIgnoreCase("B13") || string.equalsIgnoreCase("B25")) {
                    iSesion.getOperaciones().establecerPartida("TIPD" + string, (Object)stringArray6[i]);
                }
                iSesion.getOperaciones().establecerPartida("IMP3D" + string, (Object)stringArray3[i]);
                if (n3 <= 3) continue;
                iSesion.getOperaciones().establecerPartida("IMP4D" + string, (Object)stringArray4[i]);
                if (n3 <= 4) continue;
                iSesion.getOperaciones().establecerPartida("IMP5D" + string, (Object)stringArray5[i]);
            }
        }
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        iSesion.getOperaciones().move("B_" + string + "", l);
    }

    public void calculaBTotales(ISesion iSesion, String string) throws NumberFormatException, ExceptionMotor {
        String string2 = string.substring(1, 2);
        if (string2.equals("1")) {
            this.calcularB1RNR(iSesion);
        } else if (string2.equals("2")) {
            this.calcularB2RNR(iSesion);
        }
        this.calcularRET2(iSesion);
    }

    public void calculaBConj(ISesion iSesion, String string) throws ExceptionMotor {
        this.calcularBIConj(iSesion, string);
    }

    public Double calcularBIConj(ISesion iSesion, String string) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        String string2 = "B_" + string + "";
        double d = 0.0;
        if (!string.equals("B13")) {
            long l = iSesion.getOperaciones().obtenerClaveActiva(string2);
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount(string2)) {
                iSesion.getOperaciones().move(string2, (long)n);
                double d2 = 0.0;
                d2 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("IMP1D" + string));
                d += d2;
                ++n;
            }
            iSesion.getOperaciones().establecerPartida(string, (Object)("" + d));
            iSesion.getOperaciones().move(string2, l);
        } else {
            d = this.calcularDividendos(iSesion, string);
        }
        return new Double(d);
    }

    public Double calcularBIInd(ISesion iSesion, String string) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        String string2 = "B_" + string + "";
        double d = 0.0;
        if (!string.equals("B13")) {
            long l = iSesion.getOperaciones().obtenerClaveActiva(string2);
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount(string2)) {
                iSesion.getOperaciones().move(string2, (long)n);
                double d2 = 0.0;
                d2 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("IMP1D" + string));
                d += d2;
                ++n;
            }
            iSesion.getOperaciones().establecerPartida(string, (Object)("" + d));
            iSesion.getOperaciones().move(string2, l);
        } else {
            this.imp[this.indiceExcesos] = 0.0;
            this.exen[this.indiceExcesos] = 0.0;
            this.suj[this.indiceExcesos] = 0.0;
            long l = iSesion.getOperaciones().obtenerClaveActiva(string2);
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount(string2)) {
                iSesion.getOperaciones().move(string2, (long)n);
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                d3 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("IMP1D" + string));
                if (iSesion.getOperaciones().obtenerPartidaString("TIPD" + string).equals("1")) {
                    d4 = 1.0;
                }
                d5 = d4 * d3;
                int n2 = this.indiceExcesos;
                this.imp[n2] = this.imp[n2] + d3;
                int n3 = this.indiceExcesos;
                this.exen[n3] = this.exen[n3] + d5;
                this.biTotal += d3;
                this.exenTotal += d5;
                ++n;
            }
            if (this.exen[this.indiceExcesos] > 1500.0) {
                this.exen[this.indiceExcesos] = 1500.0;
            }
            this.suj[this.indiceExcesos] = this.imp[this.indiceExcesos] - this.exen[this.indiceExcesos];
            iSesion.getOperaciones().establecerPartida(string, (Object)("" + this.suj[this.indiceExcesos]));
            this.calcularDividVentana(iSesion);
            iSesion.getOperaciones().move(string2, l);
        }
        return new Double(d);
    }

    public Double calcularDividendos(ISesion iSesion, String string) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        if (this.exenTotal > 1500.0) {
            this.exenTotal = 1500.0;
        }
        double d = this.biTotal - this.exenTotal;
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DIVIDENDOS")) {
            iSesion.getOperaciones().move("DIVIDENDOS", (long)n);
            iSesion.getOperaciones().establecerPartida("DIV_IMP", (Object)("" + this.imp[n - 1]));
            iSesion.getOperaciones().establecerPartida("DIV_EXEN", (Object)("" + this.exen[n - 1]));
            iSesion.getOperaciones().establecerPartida("DIV_SUJ", (Object)("" + this.suj[n - 1]));
            ++n;
        }
        iSesion.getOperaciones().establecerPartida("IMPO", (Object)("" + this.biTotal));
        iSesion.getOperaciones().establecerPartida("EXENO", (Object)("" + this.exenTotal));
        iSesion.getOperaciones().establecerPartida("SUJO", (Object)("" + d));
        iSesion.getOperaciones().establecerPartida(string, (Object)("" + d));
        double d2 = d;
        return new Double(d2);
    }

    public Double calcularDividVentana(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        String string = "B_B13";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        long l = iSesion.getOperaciones().obtenerClaveActiva(string);
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount(string)) {
            iSesion.getOperaciones().move(string, (long)n);
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            d6 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("IMP1DB13"));
            if (iSesion.getOperaciones().obtenerPartidaString("TIPDB13").equals("1")) {
                d7 = 1.0;
            }
            d8 = d7 * d6;
            d += d6;
            d2 += d8;
            d4 += d6;
            d5 += d8;
            ++n;
        }
        iSesion.getOperaciones().move(string, l);
        if (d2 > 1500.0) {
            d2 = 1500.0;
        }
        d3 = d - d2;
        if (declarantes.equals(Declarantes.Declarante)) {
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                iSesion.getOperaciones().move("DIVIDENDOS", 2L);
                d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
                d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
            }
            n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                iSesion.getOperaciones().move("DIVIDENDOS", (long)(2 + n));
                d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
                d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
                ++n;
            }
            iSesion.getOperaciones().move("DIVIDENDOS", 1L);
            iSesion.getOperaciones().establecerPartida("DIV_IMP", (Object)("" + d));
            iSesion.getOperaciones().establecerPartida("DIV_EXEN", (Object)("" + d2));
            iSesion.getOperaciones().establecerPartida("DIV_SUJ", (Object)("" + d3));
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            iSesion.getOperaciones().move("DIVIDENDOS", 1L);
            d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
            d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
            n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                iSesion.getOperaciones().move("DIVIDENDOS", (long)(2 + n));
                d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
                d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
                ++n;
            }
            iSesion.getOperaciones().move("DIVIDENDOS", 2L);
            iSesion.getOperaciones().establecerPartida("DIV_IMP", (Object)("" + d));
            iSesion.getOperaciones().establecerPartida("DIV_EXEN", (Object)("" + d2));
            iSesion.getOperaciones().establecerPartida("DIV_SUJ", (Object)("" + d3));
        } else {
            iSesion.getOperaciones().move("DIVIDENDOS", 1L);
            d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
            d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
            iSesion.getOperaciones().move("DIVIDENDOS", 2L);
            d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
            d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
            n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                if (declarantes.equals(Declarantes.parseInt(20 + 10 * n))) {
                    int n2 = 1;
                    while ((long)n2 <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                        if (n != n2) {
                            iSesion.getOperaciones().move("DIVIDENDOS", (long)(2 + n2));
                            d4 += this.obtenerValorPartida(iSesion, "DIV_IMP");
                            d5 += this.obtenerValorPartida(iSesion, "DIV_EXEN");
                        }
                        ++n2;
                    }
                    iSesion.getOperaciones().move("DIVIDENDOS", (long)(2 + n));
                    iSesion.getOperaciones().establecerPartida("DIV_IMP", (Object)("" + d));
                    iSesion.getOperaciones().establecerPartida("DIV_EXEN", (Object)("" + d2));
                    iSesion.getOperaciones().establecerPartida("DIV_SUJ", (Object)("" + d3));
                }
                ++n;
            }
        }
        if (this.funcrentaValidador.isBConjunta(iSesion)) {
            if (d5 > 1500.0) {
                d5 = 1500.0;
            }
            double d9 = d4 - d5;
            iSesion.getOperaciones().establecerPartida("IMPO", (Object)("" + d4));
            iSesion.getOperaciones().establecerPartida("EXENO", (Object)("" + d5));
            iSesion.getOperaciones().establecerPartida("SUJO", (Object)("" + d9));
        }
        return d3;
    }

    public double calcularPartidaBI(ISesion iSesion, String string, String string2) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        String string3 = "B_" + string + "";
        if (string.equals("B13") && string2.equals("IMP1")) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            long l = iSesion.getOperaciones().obtenerClaveActiva(string3);
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount(string3)) {
                iSesion.getOperaciones().move(string3, (long)n);
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                d5 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString(string2 + "D" + string));
                if (iSesion.getOperaciones().obtenerPartidaString("TIPDB13").equals("1")) {
                    d6 = 1.0;
                }
                d7 = d6 * d5;
                d2 += d5;
                d3 += d7;
                ++n;
            }
            if (d3 > 1500.0) {
                d3 = 1500.0;
            }
            d = d4 = d2 - d3;
            iSesion.getOperaciones().move(string3, l);
        } else {
            long l = iSesion.getOperaciones().obtenerClaveActiva(string3);
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount(string3)) {
                iSesion.getOperaciones().move(string3, (long)n);
                double d8 = 0.0;
                d8 = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString(string2 + "D" + string));
                d += d8;
                ++n;
            }
            iSesion.getOperaciones().move(string3, l);
        }
        return d;
    }

    public Double calcularB1II(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B11", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B12", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B13", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B14", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B15", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B16", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B17", "IMP1");
        d += this.calcularPartidaBI(iSesion, "BJJ3", "IMP1");
        iSesion.getOperaciones().establecerPartida("B1II", (Object)("" + (d -= this.obtenerValorPartida(iSesion, "BJJ4"))));
        return new Double(d);
    }

    public Double calcularB1GD(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B11", "IMP3");
        d += this.calcularPartidaBI(iSesion, "B12", "IMP4");
        d += this.calcularPartidaBI(iSesion, "B13", "IMP3");
        iSesion.getOperaciones().establecerPartida("B1GD", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B15", "IMP3"))));
        return new Double(d);
    }

    public Double calcularB1RN(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        this.calcularB1II(iSesion);
        this.calcularB1GD(iSesion);
        double d = 0.0;
        d = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B1II"));
        iSesion.getOperaciones().establecerPartida("B1RN", (Object)("" + (d -= Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B1GD")))));
        return new Double(d);
    }

    public Double calcularB1RED(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        iSesion.getOperaciones().establecerPartida("B1RED", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B16", "IMP3"))));
        return new Double(d);
    }

    public Double calcularB1RNR(ISesion iSesion) throws NumberFormatException, ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        this.calcularB1RN(iSesion);
        this.calcularB1RED(iSesion);
        double d = 0.0;
        d = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B1RN"));
        iSesion.getOperaciones().establecerPartida("B1RNR", (Object)("" + (d -= Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B1RED")))));
        return new Double(d);
    }

    public Double calcularB2II(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B21", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B22", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B23", "IMP1");
        d += this.calcularPartidaBI(iSesion, "B24", "IMP1");
        iSesion.getOperaciones().establecerPartida("B2II", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B25", "IMP1"))));
        return new Double(d);
    }

    public Double calcularB2GD(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B21", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B22", "IMP2");
        iSesion.getOperaciones().establecerPartida("B2GD", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B25", "IMP2"))));
        return new Double(d);
    }

    public Double calcularB2RN(ISesion iSesion) throws NumberFormatException, ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        this.calcularB2II(iSesion);
        this.calcularB2GD(iSesion);
        double d = 0.0;
        d = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B2II"));
        iSesion.getOperaciones().establecerPartida("B2RN", (Object)("" + (d -= Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B2GD")))));
        return new Double(d);
    }

    public Double calcularB2RED(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B21", "IMP4");
        d += this.calcularPartidaBI(iSesion, "B22", "IMP4");
        d += this.calcularPartidaBI(iSesion, "B23", "IMP3");
        d += this.calcularPartidaBI(iSesion, "B24", "IMP3");
        iSesion.getOperaciones().establecerPartida("B2RED", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B25", "IMP5"))));
        return new Double(d);
    }

    public Double calcularB2RNR(ISesion iSesion) throws NumberFormatException, ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        this.calcularB2RN(iSesion);
        this.calcularB2RED(iSesion);
        double d = 0.0;
        d = Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B2RN"));
        iSesion.getOperaciones().establecerPartida("B2RNR", (Object)("" + (d -= Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString("B2RED")))));
        return new Double(d);
    }

    public Double calcularRET2(ISesion iSesion) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        double d = 0.0;
        d += this.calcularPartidaBI(iSesion, "B11", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B12", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B13", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B15", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B16", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B17", "IMP2");
        d += this.calcularPartidaBI(iSesion, "BJJ3", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B21", "IMP3");
        d += this.calcularPartidaBI(iSesion, "B22", "IMP3");
        d += this.calcularPartidaBI(iSesion, "B23", "IMP2");
        d += this.calcularPartidaBI(iSesion, "B24", "IMP2");
        iSesion.getOperaciones().establecerPartida("RET2", (Object)("" + (d += this.calcularPartidaBI(iSesion, "B25", "IMP3"))));
        return new Double(d);
    }

    public String preparaIndiceTit10Dat1(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        return "true";
    }

    public String preparaIndiceTit10Dat2(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D", "IMP2D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        return "true";
    }

    public String preparaIndiceTit10Dat3(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D", "IMP2D", "IMP3D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        return "true";
    }

    public String preparaIndiceDividendos(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D", "IMP2D", "IMP3D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        this.calcularDividVentana(iSesion);
        return "true";
    }

    public String preparaIndiceTit10Dat4(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D", "IMP2D", "IMP3D", "IMP4D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        return "true";
    }

    public String preparaIndiceTit10Dat6(ISesion iSesion, String string) throws ExceptionMotor {
        String[] stringArray = new String[]{"IMP1D", "IMP2D", "IMP3D", "IMP4D", "IMP5D"};
        this.daValorAlIndice(iSesion, string, stringArray);
        return "true";
    }

    public void daValorAlIndice(ISesion iSesion, String string, String[] stringArray) throws ExceptionMotor {
        String string2;
        int n;
        int n2 = 0;
        boolean bl = false;
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        for (n = 0; n < stringArray.length; ++n) {
            string2 = iSesion.getOperaciones().obtenerPartidaString(stringArray[n] + string);
            if (string2 == null || string2.equals("0.0")) continue;
            bl = true;
        }
        string2 = iSesion.getOperaciones().obtenerPartidaString("IND" + string);
        n = Integer.parseInt("" + iSesion.getOperaciones().obtenerPartidaString("IND" + string));
        if (bl) {
            if (n == 0) {
                String string3 = iSesion.getOperaciones().obtenerPartidaString("INDICE" + string);
                n2 = Integer.parseInt(string3);
                ++n2;
            }
            if (string2 != null && !string2.equals("0")) {
                n2 = Integer.parseInt(string2);
            } else {
                iSesion.getGestionReglas().partidaModificada("IND" + string, (Object)("" + n2));
                iSesion.getGestionReglas().partidaModificada("INDICE" + string, (Object)("" + n2));
            }
        }
    }

    public String borrarRendimientos(ISesion iSesion, String string) throws ExceptionMotor {
        this.imp = new double[4];
        this.exen = new double[4];
        this.suj = new double[4];
        this.biTotal = 0.0;
        this.exenTotal = 0.0;
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        long l = iSesion.getOperaciones().obtenerClaveActiva("B_" + string + "");
        String string2 = iSesion.getOperaciones().obtenerPartidaString("IND" + string);
        int n = Integer.parseInt(string2);
        if (this.funcrentaValidador.isBConjunta(iSesion)) {
            iSesion = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.UnidadFamiliar);
            int n2 = 1;
            while ((long)n2 <= iSesion.getOperaciones().recordCount("B_" + string + "")) {
                iSesion.getOperaciones().move("B_" + string + "", (long)n2);
                String string3 = iSesion.getOperaciones().obtenerPartidaString("IND" + string);
                int n3 = Integer.parseInt(string3);
                if (n == n3) {
                    iSesion.getOperaciones().borrarRegistro("B_" + string + "");
                    break;
                }
                ++n2;
            }
        }
        iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        iSesion.getOperaciones().move("B_" + string + "", l);
        iSesion.getOperaciones().borrarRegistro("B_" + string + "");
        this.calcularBIInd(iSesion, string);
        String string4 = string.substring(1, 2);
        if (string4.equals("1")) {
            this.calcularB1RNR(iSesion);
        } else if (string4.equals("2")) {
            this.calcularB2RNR(iSesion);
        }
        this.calcularRET2(iSesion);
        return "true";
    }

    public String calculosBDesdeReglas(ISesion iSesion) throws Exception {
        this.calculosB(iSesion, "false");
        CalculosA calculosA = new CalculosA(iSesion);
        CalculosE1 calculosE1 = new CalculosE1(iSesion);
        CalculosF1 calculosF1 = new CalculosF1(iSesion);
        CalculosRenta calculosRenta = new CalculosRenta(iSesion);
        calculosA.calculosA(iSesion, "false");
        calculosE1.calculosE1(iSesion, "false", "true");
        calculosF1.calculosF1(iSesion, "false", "true");
        calculosRenta.calculaLiquidacion(iSesion);
        return "true";
    }

    public String calculosB(ISesion iSesion, String string) throws Exception {
        boolean bl = false;
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        }
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        if (declarantes != null) {
            this.inicializaValores(iSesion);
            double d = 0.0;
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
            this.calculaBInd(iSesion, "B11", 1);
            this.calculaBInd(iSesion, "B12", 1);
            this.calculaBInd(iSesion, "B13", 1);
            this.calculaBInd(iSesion, "B14", 1);
            this.calculaBInd(iSesion, "B15", 1);
            this.calculaBInd(iSesion, "B16", 1);
            this.calculaBInd(iSesion, "B17", 1);
            this.calculaBInd(iSesion, "BJJ3", 1);
            d += this.obtenerValorPartida(iSesion, "BJJ4");
            this.calculaBInd(iSesion, "B21", 1);
            this.calculaBInd(iSesion, "B22", 1);
            this.calculaBInd(iSesion, "B23", 1);
            this.calculaBInd(iSesion, "B24", 1);
            this.calculaBInd(iSesion, "B25", 1);
            this.calculaBTotales(iSesion, "B11");
            this.calculaBTotales(iSesion, "B21");
            if (bl) {
                CalculosL calculosL = new CalculosL(iSesion);
                calculosL.inicializaValores();
                calculosL.calculosPrevios(iSesion);
                this.calculaLiqui(iSesion, declarantes, Declarantes.Declarante, 1);
            }
            if (this.funcrentaValidador.isBConyuge(iSesion)) {
                this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
                this.calculaBInd(iSesion, "B11", 2);
                this.calculaBInd(iSesion, "B12", 2);
                this.calculaBInd(iSesion, "B13", 2);
                this.calculaBInd(iSesion, "B14", 2);
                this.calculaBInd(iSesion, "B15", 2);
                this.calculaBInd(iSesion, "B16", 2);
                this.calculaBInd(iSesion, "B17", 2);
                this.calculaBInd(iSesion, "BJJ3", 2);
                d += this.obtenerValorPartida(iSesion, "BJJ4");
                this.calculaBInd(iSesion, "B21", 2);
                this.calculaBInd(iSesion, "B22", 2);
                this.calculaBInd(iSesion, "B23", 2);
                this.calculaBInd(iSesion, "B24", 2);
                this.calculaBInd(iSesion, "B25", 2);
                this.calculaBTotales(iSesion, "B11");
                this.calculaBTotales(iSesion, "B21");
                if (bl) {
                    this.calculaLiqui(iSesion, declarantes, Declarantes.Conyuge, 2);
                }
            }
            int n = 1;
            while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
                if (this.funcrentaValidador.isBHijos(iSesion, n)) {
                    iSesion = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.parseInt(20 + n * 10));
                    this.calculaBInd(iSesion, "B11", n + 2);
                    this.calculaBInd(iSesion, "B12", n + 2);
                    this.calculaBInd(iSesion, "B13", n + 2);
                    this.calculaBInd(iSesion, "B14", n + 2);
                    this.calculaBInd(iSesion, "B15", n + 2);
                    this.calculaBInd(iSesion, "B16", n + 2);
                    this.calculaBInd(iSesion, "B17", n + 2);
                    this.calculaBInd(iSesion, "BJJ3", n + 2);
                    d += this.obtenerValorPartida(iSesion, "BJJ4");
                    this.calculaBInd(iSesion, "B21", n + 2);
                    this.calculaBInd(iSesion, "B22", n + 2);
                    this.calculaBInd(iSesion, "B23", n + 2);
                    this.calculaBInd(iSesion, "B24", n + 2);
                    this.calculaBInd(iSesion, "B25", n + 2);
                    this.calculaBTotales(iSesion, "B11");
                    this.calculaBTotales(iSesion, "B21");
                    if (bl) {
                        this.calculaLiqui(iSesion, declarantes, Declarantes.parseInt(20 + n * 10), n + 2);
                        if (n == 2) {
                            if (declarantes.equals(Declarantes.parseInt(20 + n * 10))) {
                                this.calculaLiquidacionInd(iSesion, n + 2, true);
                            } else {
                                this.calculaLiquidacionInd(iSesion, n + 2, false);
                            }
                        }
                    }
                }
                ++n;
            }
            if (this.funcrentaValidador.isBConjunta(iSesion)) {
                this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.UnidadFamiliar);
                this.calculaBConj(iSesion, "B11");
                this.calculaBConj(iSesion, "B12");
                this.calculaBConj(iSesion, "B13");
                this.calculaBConj(iSesion, "B14");
                this.calculaBConj(iSesion, "B15");
                this.calculaBConj(iSesion, "B16");
                this.calculaBConj(iSesion, "B17");
                this.calculaBConj(iSesion, "BJJ3");
                iSesion.getOperaciones().establecerPartida("BJJ4", (Object)("" + d));
                this.calculaBConj(iSesion, "B21");
                this.calculaBConj(iSesion, "B22");
                this.calculaBConj(iSesion, "B23");
                this.calculaBConj(iSesion, "B24");
                this.calculaBConj(iSesion, "B25");
                this.calculaBTotales(iSesion, "B11");
                this.calculaBTotales(iSesion, "B21");
                if (bl) {
                    this.calculaLiquidacionConj(iSesion);
                }
            }
            this.calculoAutonomicas(iSesion, bl);
            this.funcrentaValidador.irDeclaracion(iSesion, declarantes);
        }
        return "true";
    }

    private double obtenerValorPartida(ISesion iSesion, String string) throws ExceptionMotor {
        Declarantes declarantes = null;
        declarantes = this.funcrentaValidador.cualDeclaracion(iSesion);
        if ((iSesion = this.funcrentaValidador.irDeclaracion(iSesion, declarantes)).getOperaciones().obtenerPartidaString(string) == null || iSesion.getOperaciones().obtenerPartidaString(string).equals("")) {
            return 0.0;
        }
        return Double.parseDouble("" + iSesion.getOperaciones().obtenerPartidaString(string));
    }

    private int calculaCuantos(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("B11") || string.equalsIgnoreCase("B15") || string.equalsIgnoreCase("B16") || string.equalsIgnoreCase("B23") || string.equalsIgnoreCase("B24")) {
            n = 3;
        } else if (string.equalsIgnoreCase("B12") || string.equalsIgnoreCase("B21") || string.equalsIgnoreCase("B22")) {
            n = 4;
        } else if (string.equalsIgnoreCase("B17") || string.equalsIgnoreCase("BJJ3")) {
            n = 2;
        } else if (string.equalsIgnoreCase("B25")) {
            n = 6;
        } else if (string.equalsIgnoreCase("B14")) {
            n = 1;
        } else if (string.equalsIgnoreCase("B13")) {
            n = 3;
        }
        return n;
    }

    private void calculoAutonomicas(ISesion iSesion, boolean bl) throws Exception {
        this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Declarante);
        if (bl) {
            this.calculaLiquidacion2Ind(iSesion, 1);
        }
        if (this.funcrentaValidador.isBConyuge(iSesion)) {
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.Conyuge);
            if (bl) {
                this.calculaLiquidacion2Ind(iSesion, 2);
            }
        }
        int n = 1;
        while ((long)n <= iSesion.getOperaciones().recordCount("DESCENDIENTESRENTAS")) {
            if (this.funcrentaValidador.isBHijos(iSesion, n)) {
                iSesion = this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.parseInt(20 + n * 10));
                if (bl) {
                    this.calculaLiquidacion2Ind(iSesion, n + 2);
                }
            }
            ++n;
        }
        if (this.funcrentaValidador.isBConjunta(iSesion)) {
            this.funcrentaValidador.irDeclaracion(iSesion, Declarantes.UnidadFamiliar);
            if (bl) {
                this.calculaLiquidacion2Conj(iSesion);
            }
        }
    }

    private void calculaLiqui(ISesion iSesion, Declarantes declarantes, Declarantes declarantes2, int n) throws Exception {
        if (declarantes.equals(declarantes2)) {
            this.calculaLiquidacionInd(iSesion, n, true);
        } else {
            this.calculaLiquidacionInd(iSesion, n, false);
        }
    }
}

