/*
 * Decompiled with CFR 0.152.
 */
package com.aeat.versprog.gui;

import com.aeat.versprog.Conexion;
import com.aeat.versprog.ControladorVersiones;
import com.aeat.versprog.IModeloVersiones;
import com.aeat.versprog.IVistaVersiones;
import com.aeat.versprog.ModeloVersiones;
import com.aeat.versprog.VistaVersiones;
import com.aeat.versprog.gui.Bienvenida;
import com.aeat.versprog.gui.CancelaActualizacion;
import com.aeat.versprog.gui.Descarga;
import com.aeat.versprog.gui.FinDescarga;
import com.aeat.versprog.gui.IGui;
import com.aeat.versprog.gui.Messages;
import com.aeat.versprog.gui.NoVersion;
import com.aeat.versprog.gui.NuevaVersion;
import com.aeat.versprog.gui.PanelError;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXHeader;

public class DialogoVersprog
extends JDialog
implements IGui {
    private static final String KEY_CANCELAR = "Cancelar";
    private static final String KEY_SIGUIENTE = "Siguiente";
    private static final String KEY_FINALIZAR = "Finalizar";
    public static final String URL_PRODUCCION = "https://www2.agenciatributaria.gob.es/sincertificados";
    public static final String CATALAN = "ca";
    public static final String CASTELLANO = "es";
    private IModeloVersiones modeloV;
    private IVistaVersiones vistaV;
    private final String modelo;
    private final String ejercicio;
    private final String version;
    private JPanel jContentPane = null;
    private JXHeader jxHeader = null;
    private JPanel jPanelCentral = null;
    private JPanel jPanel2 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private static Cursor cursorBeg;
    private static Cursor cursorEnd;
    private Map<String, Action> actions;
    private final Bienvenida bienvenida;
    private final CancelaActualizacion cancelaActualizacion;
    private final Descarga descarga;
    private final FinDescarga finDescarga;
    private final NoVersion noVersion;
    private final NuevaVersion nuevaVersion;
    private final PanelError panelError;
    private JLabel jLabel1;
    private final String ejercicioV;

    public DialogoVersprog(JFrame jFrame, String string, String string2, String string3) {
        this(jFrame, string, string2, string3, URL_PRODUCCION, true, CASTELLANO, new String[0]);
    }

    public DialogoVersprog(JFrame jFrame, String string, String string2, String string3, boolean bl) {
        this(jFrame, string, string2, string3, URL_PRODUCCION, bl, CASTELLANO, new String[0]);
    }

    public DialogoVersprog(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl) {
        this(jFrame, string, string2, string3, string4, bl, CASTELLANO, new String[0]);
    }

    public DialogoVersprog(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl, String string5, String ... stringArray) {
        super((Frame)jFrame, true);
        this.ejercicioV = stringArray.length > 0 ? stringArray[0] : null;
        Messages.setLocale(string5);
        this.bienvenida = new Bienvenida();
        this.cancelaActualizacion = new CancelaActualizacion();
        this.descarga = new Descarga();
        this.finDescarga = new FinDescarga();
        this.noVersion = new NoVersion();
        this.nuevaVersion = new NuevaVersion();
        this.panelError = new PanelError();
        this.initialize();
        this.modelo = string;
        this.version = string3;
        this.ejercicio = string2;
        this.modeloV = new ModeloVersiones(new Conexion(), string4);
        this.vistaV = new VistaVersiones(this, this.modeloV);
        new ControladorVersiones(this.modeloV, this.vistaV, bl);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            FlowLayout flowLayout = new FlowLayout();
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(flowLayout);
            this.jPanel2.setPreferredSize(new Dimension(600, 50));
            flowLayout.setAlignment(2);
            this.jPanel2.add((Component)this.getJButton1(), null);
            this.jPanel2.add((Component)this.getJButton(), null);
        }
        return this.jPanel2;
    }

    private JPanel getJPanelCentral() {
        if (this.jPanelCentral == null) {
            this.jPanelCentral = new JPanel();
            this.jPanelCentral.setLayout(new CardLayout());
            this.jPanelCentral.setPreferredSize(new Dimension(250, 300));
            this.jPanelCentral.add((Component)this.bienvenida, "Bienvenida");
            this.jPanelCentral.add((Component)this.cancelaActualizacion, "CancelaActualizacion");
            this.jPanelCentral.add((Component)this.descarga, "Descarga");
            this.jPanelCentral.add((Component)this.finDescarga, "FinDescarga");
            this.jPanelCentral.add((Component)this.noVersion, "NoVersion");
            this.jPanelCentral.add((Component)this.nuevaVersion, "NuevaVersion");
            this.jPanelCentral.add((Component)this.panelError, "PanelError");
        }
        return this.jPanelCentral;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(Messages.getString("DialogoVersprog.11"));
            this.jButton.setHorizontalAlignment(0);
            this.jButton.setHorizontalTextPosition(11);
            this.jButton.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.jButton.setCursor(new Cursor(12));
            this.jButton.setIcon(new ImageIcon(this.getClass().getResource("/com/aeat/versprog/gui/imagenes/agt_stop.png")));
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(Messages.getString("DialogoVersprog.13"));
            this.jButton1.setCursor(new Cursor(12));
            this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/aeat/versprog/gui/imagenes/1rightarrow.png")));
        }
        return this.jButton1;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.getProperties().put("https.proxySet", "true");
        System.getProperties().put("https.proxyHost", "proxyint.aeat");
        System.getProperties().put("https.proxyPort", "8889");
        System.getProperties().put("http.proxySet", "true");
        System.getProperties().put("http.proxyHost", "proxyint.aeat");
        System.getProperties().put("http.proxyPort", "8889");
        DialogoVersprog dialogoVersprog = new DialogoVersprog(null, "131W", "2011", "1.00");
        dialogoVersprog.setVisible(true);
        System.exit(0);
    }

    private void initialize() {
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setCursor(new Cursor(0));
        this.setSize(565, 313);
        this.setTitle(Messages.getString("DialogoVersprog.30"));
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.add((Component)this.getJXHeader(), "North");
        this.jLabel1.setText("");
        this.jLabel1.setHorizontalTextPosition(4);
        this.jLabel1.setHorizontalAlignment(4);
        this.bienvenida.add((Component)this.jLabel1, "South");
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(" ");
            jLabel.setPreferredSize(new Dimension(10, 300));
            this.jContentPane.add((Component)jLabel, "West");
            this.jContentPane.add((Component)this.getJPanelCentral(), "Center");
            this.jContentPane.add((Component)this.getJPanel2(), "South");
        }
        return this.jContentPane;
    }

    @Override
    public final void showDisplay(int n, Object object) {
        switch (n) {
            case 0: {
                this.mostrarPanelBienvenida();
                break;
            }
            case 3: {
                this.mostrarPanelCancela((List)object);
                break;
            }
            case 4: {
                this.mostrarPanelDescarga((List)object);
                break;
            }
            case 5: {
                this.mostrarPanelFinDescarga();
                break;
            }
            case 2: {
                this.mostrarPanelNoVersion();
                break;
            }
            case 1: {
                List list = (List)object;
                if (this.ejercicioV != null) {
                    list.set(5, this.ejercicioV);
                }
                this.mostrarPanelNuevaVersion(list);
                this.showReloj(false);
                break;
            }
            case 7: {
                this.dispose();
                break;
            }
            case 6: {
                this.mostrarPanelError(object);
                break;
            }
        }
        this.getJPanel2().validate();
    }

    private void mostrarPanel(String string) {
        CardLayout cardLayout = (CardLayout)this.getJPanelCentral().getLayout();
        cardLayout.show(this.getJPanelCentral(), string);
    }

    public final void comienzaReloj() {
        if (cursorBeg == null) {
            cursorBeg = new Cursor(3);
        }
        this.setCursor(cursorBeg);
    }

    public final void finalizaReloj() {
        if (cursorEnd == null) {
            cursorEnd = new Cursor(0);
        }
        this.setCursor(cursorEnd);
    }

    private void mostrarPanelError(Object object) {
        this.showReloj(false);
        this.panelError.setDatos(object);
        this.mostrarPanel("PanelError");
        Action action = this.actions.get(KEY_FINALIZAR);
        this.getJButton1().setAction(action);
        this.getJButton().setVisible(false);
    }

    private void mostrarPanelNuevaVersion(List<?> list) {
        this.nuevaVersion.setDatos(list);
        this.mostrarPanel("NuevaVersion");
        Action action = this.actions.get(KEY_SIGUIENTE);
        this.getJButton1().setAction(action);
        action = this.actions.get(KEY_CANCELAR);
        this.getJButton().setAction(action);
    }

    private void mostrarPanelNoVersion() {
        this.showReloj(false);
        this.mostrarPanel("NoVersion");
        Action action = this.actions.get(KEY_FINALIZAR);
        this.getJButton1().setAction(action);
        this.getJButton().setVisible(false);
    }

    private void mostrarPanelFinDescarga() {
        this.showReloj(false);
        this.mostrarPanel("FinDescarga");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Action action = (Action)DialogoVersprog.this.actions.get(DialogoVersprog.KEY_FINALIZAR);
                DialogoVersprog.this.getJButton1().setAction(action);
                action = (Action)DialogoVersprog.this.actions.get(DialogoVersprog.KEY_CANCELAR);
                DialogoVersprog.this.getJButton().setAction(action);
                action = (Action)DialogoVersprog.this.actions.get(DialogoVersprog.KEY_CANCELAR);
                DialogoVersprog.this.getJButton().setVisible(true);
            }
        });
    }

    private void mostrarPanelDescarga(List<?> list) {
        this.descarga.setDatos(list);
        this.mostrarPanel("Descarga");
        Action action = this.actions.get(KEY_CANCELAR);
        this.getJButton1().setAction(action);
        this.getJButton().setVisible(false);
    }

    private void mostrarPanelCancela(List<?> list) {
        this.showReloj(false);
        this.cancelaActualizacion.setDatos(list);
        this.mostrarPanel("CancelaActualizacion");
        Action action = this.actions.get(KEY_FINALIZAR);
        this.getJButton1().setAction(action);
        this.getJButton().setVisible(false);
    }

    private void mostrarPanelBienvenida() {
        this.mostrarPanel("Bienvenida");
        Action action = this.actions.get(KEY_SIGUIENTE);
        this.getJButton1().setAction(action);
        action = this.actions.get(KEY_CANCELAR);
        this.getJButton().setAction(action);
    }

    @Override
    public final void addActions(Map<String, Action> map) {
        this.actions = map;
        if (!(map.get(KEY_SIGUIENTE) instanceof Action)) {
            throw new IllegalArgumentException("Se requiere un objeto Action");
        }
        Action action = map.get(KEY_SIGUIENTE);
        this.getJButton1().setAction(action);
        if (!(map.get(KEY_CANCELAR) instanceof Action)) {
            throw new IllegalArgumentException("Se requiere un objeto Action");
        }
        action = map.get(KEY_CANCELAR);
        this.getJButton().setAction(action);
        this.getJPanel2().validate();
    }

    @Override
    public final Object getDatosDescarga() {
        if (this.bienvenida.isShowing()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.modelo);
            arrayList.add(this.ejercicio);
            arrayList.add(this.version);
            return arrayList;
        }
        if (this.nuevaVersion.isShowing()) {
            return this.nuevaVersion.getPath();
        }
        return null;
    }

    private JXHeader getJXHeader() {
        if (this.jxHeader == null) {
            this.jxHeader = new JXHeader();
            this.jxHeader.setTitle("Actualizaci\u00f3n de versiones");
            this.jxHeader.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/aeat/versprog/gui/imagenes/irkick.png")));
            this.jxHeader.setIconPosition(JXHeader.IconPosition.LEFT);
            this.jxHeader.setDescription("Actualizar versi\u00f3n por Internet");
        }
        return this.jxHeader;
    }

    @Override
    public final void bytesLeidos(int n) {
        this.descarga.actualizaBytes(n);
    }

    @Override
    public final void showReloj(boolean bl) {
        if (bl) {
            this.comienzaReloj();
        } else {
            this.finalizaReloj();
        }
    }

    @Override
    public final void ponEtiqueta(String string) {
        this.jLabel1.setText(string);
    }

    public final void setNuevaVersion(List<?> list) {
        this.mostrarPanelNuevaVersion(list);
    }

    public final void setMVC(IVistaVersiones iVistaVersiones, IModeloVersiones iModeloVersiones) {
        this.modeloV = iModeloVersiones;
        this.vistaV = iVistaVersiones;
    }
}

