/*
 * Decompiled with CFR 0.152.
 */
package com.aeat.versprog;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class Utilidades {
    private static boolean debug = System.getProperty("versprog.debug") != null;
    private static final String CEROS = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private static final String BLANCOS = "                                                                                                                                                                    ";

    public static String quitaBlanInter(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c != ' ') {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static String quitaCaracter(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 != c) {
                stringBuffer.append(c2);
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static boolean caracEnCad(char[] cArray, char c) {
        boolean bl = false;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean caracEnCad(String string, char c) {
        boolean bl = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 == c) {
                bl = true;
                break;
            }
            c2 = stringCharacterIterator.next();
        }
        return bl;
    }

    public static String cambComaPunto(String string) {
        return string.replace(',', '.');
    }

    static String rellenaC(String string, int n) {
        if (string == null || string.equals("-1")) {
            return CEROS.substring(0, n);
        }
        int n2 = string.length();
        if (n2 == 0) {
            return CEROS.substring(0, n);
        }
        if (n2 == n) {
            return string;
        }
        if (n2 >= n) {
            return string.substring(0, n);
        }
        String string2 = CEROS.substring(0, n - n2);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static String rellenaBl(String string, int n) {
        if (string == null) {
            return BLANCOS.substring(0, n);
        }
        int n2 = string.length();
        if (n2 == 0) {
            return BLANCOS.substring(0, n);
        }
        if (n2 == n) {
            return string;
        }
        if (n2 >= n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(BLANCOS.substring(0, n - n2));
        return stringBuffer.toString();
    }

    static String rellenaN(long l) {
        String string = Long.toString(l);
        return Utilidades.rellenaC(string, 6);
    }

    static String rellenaN(double d) {
        String string = null;
        if (d == 0.0) {
            string = Utilidades.rellenaC("", 13);
        } else {
            if (d < 0.0) {
                return Utilidades.rellenaNegat(d);
            }
            string = Utilidades.formaQuitaPuntos(d);
            int n = string.indexOf(44);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            string = Utilidades.rellenaC(stringBuffer.toString(), 13);
        }
        return string;
    }

    static String rellenaNegat(double d) {
        String string = Utilidades.formaQuitaPuntos(d *= -1.0);
        int n = string.indexOf(44);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.deleteCharAt(n);
        stringBuffer = new StringBuffer(Utilidades.rellenaC(stringBuffer.toString(), 13));
        stringBuffer.setCharAt(0, 'N');
        string = stringBuffer.toString();
        return string;
    }

    static String rellenaPorC(double d) {
        String string = null;
        if (d == 0.0) {
            string = "0000";
        } else {
            string = Utilidades.formaQuitaPuntos(d);
            int n = string.indexOf(44);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            string = Utilidades.rellenaC(stringBuffer.toString(), 4);
        }
        return string;
    }

    static String rellenaNum(double d, int n) {
        String string = null;
        if (d == 0.0) {
            string = Utilidades.rellenaC("", n);
        } else {
            string = Utilidades.formaQuitaPuntos(d);
            int n2 = string.indexOf(44);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n2);
            string = Utilidades.rellenaC(stringBuffer.toString(), n);
        }
        return string;
    }

    static String rellenaNum(int n, int n2) {
        String string = null;
        string = n == 0 ? Utilidades.rellenaC("", n2) : Utilidades.rellenaC(String.valueOf(n), n2);
        return string;
    }

    static String formaQuitaPuntos(double d) {
        return Utilidades.quitaPuntos(Utilidades.formatea(d));
    }

    static String formaQuitaPuntos(Double d) {
        return Utilidades.quitaPuntos(Utilidades.formatea(d));
    }

    static String formaQuitPunCom(Double d) {
        String string = Utilidades.quitaPuntos(Utilidades.formatea(d));
        return string.replace(',', '.');
    }

    static String formaQuitPunCom(double d) {
        String string = Utilidades.quitaPuntos(Utilidades.formatea(d));
        return string.replace(',', '.');
    }

    static String quitaPuntos(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.toString().indexOf(46)) != -1) {
            stringBuilder.deleteCharAt(n);
        }
        return stringBuilder.toString();
    }

    static String formatea(long l) {
        String string = "";
        if (l != 0L) {
            string = NumberFormat.getInstance().format(l);
        }
        return string;
    }

    static String formatea(double d) {
        String string = "";
        if (d != 0.0) {
            string = NumberFormat.getInstance().format(d);
            int n = string.lastIndexOf(44);
            if (n != -1) {
                if (string.length() - n == 2) {
                    string = string + "0";
                }
            } else {
                string = string + ",00";
            }
        }
        return string;
    }

    static long formateaLong(String string) {
        long l = 0L;
        if (string != null && !string.equals("")) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            try {
                l = numberFormat.parse(string).longValue();
            }
            catch (ParseException parseException) {
                Logger.getLogger(Utilidades.class.getName()).severe("Error proceso numeros\n" + parseException);
            }
        }
        return l;
    }

    static double formateaDoble(String string) {
        double d = 0.0;
        if (string != null && !string.equals("")) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            try {
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                Logger.getLogger(Utilidades.class.getName()).severe("Error proceso numeros\n" + parseException);
            }
        }
        return d;
    }

    static String formateaDoble(Double d) {
        return Utilidades.formatea(d);
    }

    public static void ponError(String string, String string2) {
        Logger.getLogger(Utilidades.class.getName()).severe("Error \n" + string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append("\nError: ");
        stringBuffer.append(string2);
        JOptionPane.showMessageDialog(null, stringBuffer, "Error -", 0);
    }

    public static void ponError(String string, Exception exception) {
        if (debug) {
            Logger.getLogger(Utilidades.class.getName()).severe("Error \n" + exception);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        if (exception.getMessage() == null) {
            stringBuffer.append("Error indeterminado");
        } else {
            stringBuffer.append(exception.getMessage());
        }
        JOptionPane.showMessageDialog(null, stringBuffer, "Error -", 0);
    }
}

