/*
 * Decompiled with CFR 0.152.
 */
package com.aeat.versprog;

import com.aeat.versprog.AdaptadorDeEstado;
import com.aeat.versprog.IControladorVersiones;
import com.aeat.versprog.IEstado;
import com.aeat.versprog.IModeloVersiones;
import com.aeat.versprog.IVistaVersiones;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class ControladorVersiones
implements IControladorVersiones {
    private IModeloVersiones modelo;
    private IVistaVersiones vista;
    private Map<String, AdaptadorDeEstado> hMap = new HashMap<String, AdaptadorDeEstado>();
    private IEstado estadoActual;
    private final boolean killApp;

    public ControladorVersiones(IModeloVersiones iModeloVersiones, IVistaVersiones iVistaVersiones, boolean bl) {
        this.modelo = iModeloVersiones;
        this.vista = iVistaVersiones;
        this.killApp = bl;
        this.vista.addControlador(this);
        this.hMap.put("EstadoBienvenida", new EstadoBienvenida());
        this.hMap.put("EstadoBuscar", new EstadoBuscar());
        this.hMap.put("EstadoNoVersion", new EstadoNoVersion());
        this.hMap.put("EstadoCancelado", new EstadoCancelado());
        this.hMap.put("EstadoConfirmarDescarga", new EstadoConfirmarDescarga());
        this.hMap.put("EstadoDescargar", new EstadoDescargar());
        this.hMap.put("EstadoError", new EstadoError());
        this.hMap.put("EstadoFinalDescarga", new EstadoFinalDescarga());
        this.estadoActual = this.hMap.get("EstadoBienvenida");
    }

    public void actualizaDatos() {
    }

    @Override
    public final void siguiente(Object object) {
        this.estadoActual.siguiente(object);
    }

    @Override
    public final void finalizar() {
        this.estadoActual.finalizar();
    }

    @Override
    public final void cancelar() {
        this.estadoActual.cancelar();
    }

    @Override
    public final void errorEnConexion(Exception exception) {
        this.estadoActual = this.hMap.get("EstadoError");
        this.vista.showDisplay(6, exception);
    }

    class EstadoError
    extends AdaptadorDeEstado {
        EstadoError() {
        }

        @Override
        public void finalizar() {
            ControladorVersiones.this.vista.showDisplay(7, null);
        }
    }

    class EstadoFinalDescarga
    extends AdaptadorDeEstado {
        EstadoFinalDescarga() {
        }

        @Override
        public void cancelar() {
            ControladorVersiones.this.vista.showDisplay(7, null);
        }

        @Override
        public void finalizar() {
            try {
                String string = (String)ControladorVersiones.this.modelo.getList().get(0);
                int n = string.lastIndexOf("/");
                String string2 = string.substring(n + 1);
                String string3 = (String)ControladorVersiones.this.modelo.getList().get(1);
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                string3 = string3 + string2;
                Runtime runtime = Runtime.getRuntime();
                runtime.exec(string3.toString());
                if (ControladorVersiones.this.killApp) {
                    System.exit(0);
                } else {
                    ControladorVersiones.this.vista.showDisplay(7, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ControladorVersiones.this.vista.showPopUpError("Error al ejecutar : " + exception.getMessage());
            }
        }
    }

    class EstadoDescargar
    extends AdaptadorDeEstado {
        EstadoDescargar() {
        }

        @Override
        public void siguiente(Object object) {
            ControladorVersiones.this.vista.showDisplay(5, object);
            ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoFinalDescarga");
        }

        @Override
        public void cancelar() {
            ControladorVersiones.this.modelo.cancelarDescarga();
            ControladorVersiones.this.vista.showDisplay(3, ControladorVersiones.this.modelo.getList());
            ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoCancelado");
        }
    }

    class EstadoConfirmarDescarga
    extends AdaptadorDeEstado {
        EstadoConfirmarDescarga() {
        }

        @Override
        public void siguiente(Object object) {
            File file = new File(object.toString());
            if (!file.isDirectory() || !file.canWrite()) {
                JOptionPane.showMessageDialog(null, "Directorio no existe o no tiene permiso de escritura");
                ControladorVersiones.this.vista.showReloj(false);
                return;
            }
            ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoDescargar");
            List<?> list = ControladorVersiones.this.modelo.getList();
            list.set(1, object);
            ControladorVersiones.this.vista.showDisplay(4, list);
            ControladorVersiones.this.modelo.descargaModulo((String)object);
        }

        @Override
        public void cancelar() {
            ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoCancelado");
            ControladorVersiones.this.vista.showDisplay(3, ControladorVersiones.this.modelo.getList());
        }
    }

    class EstadoCancelado
    extends AdaptadorDeEstado {
        EstadoCancelado() {
        }

        @Override
        public void finalizar() {
            ControladorVersiones.this.vista.showDisplay(7, null);
        }
    }

    class EstadoNoVersion
    extends AdaptadorDeEstado {
        EstadoNoVersion() {
        }

        @Override
        public void finalizar() {
            ControladorVersiones.this.vista.showDisplay(7, null);
        }
    }

    class EstadoBuscar
    extends AdaptadorDeEstado {
        EstadoBuscar() {
        }

        @Override
        public void siguiente(Object object) {
            try {
                ControladorVersiones.this.modelo.getDatosDescarga();
                List<?> list = ControladorVersiones.this.modelo.getList();
                if (list.get(2).equals("0")) {
                    ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoNoVersion");
                    ControladorVersiones.this.vista.showDisplay(2, null);
                } else if (list.get(2).equals("1")) {
                    ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoConfirmarDescarga");
                    ControladorVersiones.this.vista.showDisplay(1, list);
                } else {
                    ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoError");
                    ControladorVersiones.this.vista.showDisplay(6, list);
                }
            }
            catch (Exception exception) {
                ControladorVersiones.this.errorEnConexion(exception);
            }
        }
    }

    class EstadoBienvenida
    extends AdaptadorDeEstado {
        EstadoBienvenida() {
        }

        @Override
        public void siguiente(Object object) {
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("Se requiere un objeto List");
            }
            ControladorVersiones.this.modelo.setModeloDatos((List)object);
            ControladorVersiones.this.estadoActual = (IEstado)ControladorVersiones.this.hMap.get("EstadoBuscar");
            ControladorVersiones.this.siguiente(null);
        }

        @Override
        public void cancelar() {
            ControladorVersiones.this.vista.showDisplay(7, null);
        }
    }
}

