/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrp.utilidades;

import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.utilidades.IGestorTablas;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GestorTablas
implements Serializable,
IGestorTablas {
    private static final long serialVersionUID = 1L;
    private Map<String, ITipoDatosCampoValor> tablasRecorriendo;
    private Map<String, String> tablasAcabadas;
    private Map<String, String> tablasEmpezadas;
    private INodoArbol arbolDatos;
    private final String separador = "&&&";

    public GestorTablas(INodoArbol arbolDatos) {
        this.arbolDatos = arbolDatos;
        this.init();
    }

    protected INodoArbol getArbolDatos() {
        return this.arbolDatos;
    }

    @Override
    public void acaboTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            this.tablasAcabadas.put(nombreTabla.toUpperCase() + "&&&" + filtro, "");
            this.tablasRecorriendo.remove(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void comenzoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            this.tablasEmpezadas.put(nombreTabla.toUpperCase() + "&&&" + filtro, "");
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void quitarComenzoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            this.tablasEmpezadas.remove(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void quitarAcaboTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            this.tablasAcabadas.remove(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void recorriendoTabla(String nombreTabla, String filtro, ITipoDatosCampoValor datos) throws ExceptionMotor {
        try {
            this.tablasRecorriendo.put(nombreTabla.toUpperCase() + "&&&" + filtro, datos);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void init() {
        this.tablasRecorriendo = new HashMap<String, ITipoDatosCampoValor>();
        this.tablasAcabadas = new HashMap<String, String>();
        this.tablasEmpezadas = new HashMap<String, String>();
    }

    @Override
    public List<String> dameListaTablasRecorriendose() throws ExceptionMotor {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            Set<String> col = this.tablasRecorriendo.keySet();
            Iterator i = col.iterator();
            while (i.hasNext()) {
                ret.add(((String)i.next()).split("&&&")[0]);
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public List<String> dameListaTablasAcabadas() throws ExceptionMotor {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            Set<String> col = this.tablasAcabadas.keySet();
            Iterator i = col.iterator();
            while (i.hasNext()) {
                ret.add(((String)i.next()).split("&&&")[0]);
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public List<String> dameListaTablasEmpezadas() throws ExceptionMotor {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            Set<String> col = this.tablasEmpezadas.keySet();
            Iterator i = col.iterator();
            while (i.hasNext()) {
                ret.add(((String)i.next()).split("&&&")[0]);
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean isComenzoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            return this.tablasEmpezadas.containsKey(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean isRecorriendoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.containsKey(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean isRecorriendoTablas() throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.size() > 0;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public int recorriendoTablasCount() throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.size();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean isAcabadaTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            return this.tablasAcabadas.containsKey(nombreTabla.toUpperCase() + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public long getPosicionRecorriendoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            return Long.parseLong(this.tablasRecorriendo.get(nombreTabla.toUpperCase() + "&&&" + filtro).getNombreCampo());
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String getLocalizacionRecorriendoTabla(String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.get(nombreTabla.toUpperCase() + "&&&" + filtro).getValor();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean esTablaAcabada(String tablaBuscar, String filtro) throws ExceptionMotor {
        try {
            return this.tablasAcabadas.containsKey(tablaBuscar + "&&&" + filtro);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }
}

