/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrp.excepciones;

import java.io.Serializable;

public class ExceptionMotor
extends Exception
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String informacionExtra = "";
    protected StackTraceElement[] trazaExtra = null;

    public ExceptionMotor() {
    }

    public ExceptionMotor(String message) {
        super(message);
    }

    public ExceptionMotor(String message, StackTraceElement[] traza) {
        super(message);
        this.trazaExtra = traza;
    }

    public ExceptionMotor(Throwable t) {
        super(t);
    }

    public ExceptionMotor(Throwable t, String informacionExtra) {
        this(t);
        this.setInformacionExtra(informacionExtra);
    }

    public ExceptionMotor(String message, Throwable t) {
        super(message, t);
    }

    public ExceptionMotor(String message, Throwable t, String informacionExtra) {
        this(message, t);
        this.setInformacionExtra(informacionExtra);
    }

    public ExceptionMotor(Exception e) {
        super(e);
        this.setStackTrace((StackTraceElement[])e.getStackTrace().clone());
        if (e instanceof ExceptionMotor) {
            this.setInformacionExtra(((ExceptionMotor)e).getInformacionExtra());
        }
    }

    public ExceptionMotor(Exception e, String informacionExtra) {
        this(e);
        this.setInformacionExtra(informacionExtra);
    }

    public void setInformacionExtra(String informacionExtra) {
        if (!this.toString().contains(informacionExtra)) {
            this.informacionExtra = informacionExtra;
        }
    }

    public String getInformacionExtra() {
        return this.informacionExtra;
    }

    public void setTrazaExtra(StackTraceElement[] trazaExtra) {
        this.trazaExtra = trazaExtra;
    }

    public StackTraceElement[] getTrazaExtra() {
        return this.trazaExtra;
    }

    public String excepcionDetallada() {
        String detalle = super.toString();
        StackTraceElement[] elements = this.getTrazaExtra();
        if (elements == null) {
            elements = this.getStackTrace();
        }
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            detalle = detalle + "\n" + elements[i].getFileName() + "[" + elements[i].getLineNumber() + "] ==> " + elements[i].getMethodName() + "()";
        }
        return detalle;
    }

    @Override
    public String toString() {
        boolean salir;
        String str = super.toString();
        do {
            salir = true;
            int i = str.indexOf(ExceptionMotor.class.getName() + ":");
            if (i <= -1 || !str.substring(i + 1).contains(ExceptionMotor.class.getName() + ":")) continue;
            salir = false;
            str = str.substring(0, i) + str.substring(i + (ExceptionMotor.class.getName() + ":").length());
        } while (!salir);
        if (this.getInformacionExtra().length() > 0) {
            str = str + " (" + this.getInformacionExtra() + ")";
        }
        return str;
    }

    @Override
    public void printStackTrace() {
        System.out.println(this.toString());
    }
}

