/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.math.BigDecimal;

public final class ValidacionesGUIExtra
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CTE_CORRECTO = 0;
    public static final int CTE_ERROR_CHRS_NO_VALIDOS = 1;
    public static final int CTE_LONGITUD_INCORRECTA = 2;
    private static ValidacionesGUIExtra instanciaValidacionesGUIExtra = null;

    private ValidacionesGUIExtra() {
    }

    public static ValidacionesGUIExtra getValidaciones() {
        if (instanciaValidacionesGUIExtra == null) {
            instanciaValidacionesGUIExtra = new ValidacionesGUIExtra();
        }
        return instanciaValidacionesGUIExtra;
    }

    public int validarCampoTelefonoEuropeo(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esTelefonoEuropeo(valor)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoAlfabetico(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esAlfabeticoAEAT(valor)) {
                return 1;
            }
            if (Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(valor)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoAlfanum\u00e9rico(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esAlfanumericaAEAT(valor)) {
                return 1;
            }
            if (Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(valor)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoCadNum(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esNumerica(valor)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoCadNum2(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esNumerica(valor) && valor.trim().length() > 0) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoEmail(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            if (valor.trim().length() > 0 && valor.startsWith(" ")) {
                return 1;
            }
            char[] cadena = valor.toUpperCase().toCharArray();
            for (int i = 0; i < valor.length(); ++i) {
                if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._@\u00d1\u00c7\u00b4\\:;&/()".indexOf(cadena[i]) != -1) continue;
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoLogico(String valor) throws ExceptionMotor {
        try {
            if (valor.trim().length() > 0 && !valor.equalsIgnoreCase("TRUE") && !valor.equalsIgnoreCase("FALSE")) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoFecha(String valor) throws ExceptionMotor {
        try {
            int longitud = 10;
            if (valor.trim().length() > 0) {
                if (longitud != valor.length()) {
                    return 2;
                }
                if (valor.charAt(2) != '-' && valor.charAt(2) != '/') {
                    return 1;
                }
                if (valor.charAt(5) != '-' && valor.charAt(5) != '/') {
                    return 1;
                }
                if (valor.charAt(2) != valor.charAt(5)) {
                    return 1;
                }
                if (!Validaciones.getValidaciones().esNumerica(valor.substring(0, 2) + valor.substring(3, 5) + valor.substring(6, 10))) {
                    return 1;
                }
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoEntero(String valor, int longitudMaxima) throws ExceptionMotor {
        try {
            if (valor.length() == 0) {
                return 0;
            }
            try {
                new Integer(valor).intValue();
            }
            catch (Exception ex) {
                return 1;
            }
            if (valor.startsWith("-")) {
                valor = valor.substring(1);
            }
            if (longitudMaxima < valor.length()) {
                return 2;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int validarCampoDoble(String valor, int enteros, int decimales) throws ExceptionMotor {
        try {
            int posComa;
            if (valor.length() == 0) {
                return 0;
            }
            try {
                new BigDecimal(valor);
            }
            catch (Exception ex) {
                return 1;
            }
            if (valor.toUpperCase().contains("E")) {
                valor = Formatear.getFormatear().doubleToString(valor);
            }
            if (valor.startsWith("-")) {
                valor = valor.substring(1);
            }
            if ((posComa = valor.indexOf(44)) == -1) {
                posComa = valor.indexOf(46);
            }
            int enterosValor = 0;
            int decimalesValor = 0;
            if (posComa == -1) {
                enterosValor = valor.length();
            } else {
                enterosValor = posComa;
                decimalesValor = valor.length() - posComa - 1;
            }
            if (enteros < enterosValor || decimales < decimalesValor) {
                return 2;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

