/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import java.io.Serializable;

public final class Validaciones
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Validaciones instanciaValidaciones = null;

    private Validaciones() {
    }

    public static Validaciones getValidaciones() {
        if (instanciaValidaciones == null) {
            instanciaValidaciones = new Validaciones();
        }
        return instanciaValidaciones;
    }

    private boolean ascii65a90(char c) {
        return (byte)c >= 65 && (byte)c <= 90;
    }

    private boolean ascii48a57(char c) {
        return (byte)c >= 48 && (byte)c <= 57;
    }

    public boolean esNumerica(char c) {
        return this.ascii48a57(c);
    }

    public boolean esAlfabetico(char c) {
        return this.ascii65a90(c);
    }

    public boolean esAlfabeticoAEAT(char c) {
        try {
            if (this.esAlfabetico(c)) {
                return true;
            }
            if (c == '\u00d1') {
                return true;
            }
            if (c == '\u00c7') {
                return true;
            }
            if (c == '-') {
                return true;
            }
            if (c == ' ') {
                return true;
            }
            if (c == '\'') {
                return true;
            }
            if (c == '.') {
                return true;
            }
            return c == ',';
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(String cad) {
        String cadena = cad;
        try {
            if (cadena.trim().length() > 0 && cadena.startsWith(" ")) {
                return true;
            }
            return (cadena = cadena.trim()).indexOf("  ") > -1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esNumerica(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < valor.length(); ++i) {
            if (this.esNumerica(valor.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean esAlfabetico(String valor) {
        for (int i = 0; i < valor.length(); ++i) {
            if (this.esAlfabetico(valor.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean esTelefonoEuropeo(String sCadena) {
        try {
            for (int i = 0; i < sCadena.length(); ++i) {
                if (this.esNumerica(sCadena.charAt(i)) || sCadena.charAt(i) == '+' || sCadena.charAt(i) == '-') continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esAlfabeticoAEAT(String sCadena) {
        try {
            for (int i = 0; i < sCadena.length(); ++i) {
                if (this.esAlfabeticoAEAT(sCadena.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esAlfanumericaAEAT(String sCadena) {
        try {
            for (int i = 0; i < sCadena.length(); ++i) {
                if (this.esAlfanumericaAEAT(sCadena.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esAlfanumericaAEAT(char c) {
        try {
            if (this.esAlfabeticoAEAT(c)) {
                return true;
            }
            if (this.esNumerica(c)) {
                return true;
            }
            if (c == ':') {
                return true;
            }
            if (c == ';') {
                return true;
            }
            if (c == '_') {
                return true;
            }
            if (c == '&') {
                return true;
            }
            return c == '/';
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esNumericaAEAT(String sCadena) {
        try {
            if (!this.esnumericaConSignoAEAT(sCadena)) {
                return false;
            }
            Double tmp = new Double(sCadena);
            return tmp >= 0.0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esnumericaConSignoAEAT(String sCadena) {
        try {
            Double.valueOf(sCadena);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean esLetraONumeroAEAT(char c) {
        try {
            if (this.esAlfabetico(c)) {
                return true;
            }
            return this.esNumerica(c);
        }
        catch (Exception e) {
            return false;
        }
    }
}

