/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class NodoArbol
implements Serializable,
INodoArbol {
    private static final long serialVersionUID = 1L;
    private String nombreNodo = "";
    private String valorNodo = "";
    private List<INodoArbol> listaHijos = new ArrayList<INodoArbol>();
    private INodoArbol parentNode = null;

    public NodoArbol(String nombre) {
        this.nombreNodo = nombre;
        this.valorNodo = nombre;
    }

    public NodoArbol(String nombre, String valor) {
        this.nombreNodo = nombre;
        this.valorNodo = valor;
    }

    private NodoArbol(String nombre, String valor, INodoArbol parent) {
        this.nombreNodo = nombre;
        this.valorNodo = valor;
        this.parentNode = parent;
    }

    @Override
    public int numeroHijos() {
        return this.listaHijos.size();
    }

    @Override
    public int size() {
        return this.numeroHijos();
    }

    @Override
    public String toString() {
        return this.valorNodo;
    }

    @Override
    public String getValorNodo() {
        return this.toString();
    }

    @Override
    public String getNombreNodo() {
        return this.nombreNodo;
    }

    @Override
    public boolean setValorNodo(String nuevoValor) {
        try {
            this.valorNodo = nuevoValor;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public INodoArbol buscaHijo(String nombre) throws ExceptionMotor {
        try {
            INodoArbol ret = null;
            for (int i = 0; i < this.listaHijos.size(); ++i) {
                ret = this.listaHijos.get(i);
                if (ret.getNombreNodo().equalsIgnoreCase(nombre)) {
                    return ret;
                }
                if ((ret = ret.buscaHijo(nombre)) == null) continue;
                return ret;
            }
            if (nombre.equalsIgnoreCase(this.nombreNodo)) {
                return this;
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public INodoArbol getHijo(int index) throws ExceptionMotor {
        try {
            return this.listaHijos.get(index);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public INodoArbol get(int index) throws ExceptionMotor {
        return this.getHijo(index);
    }

    @Override
    public INodoArbol getHijo(String nombre) throws ExceptionMotor {
        try {
            INodoArbol ret = null;
            for (int i = 0; i < this.listaHijos.size(); ++i) {
                ret = this.listaHijos.get(i);
                if (!ret.getNombreNodo().equalsIgnoreCase(nombre)) continue;
                return ret;
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public INodoArbol get(String nombre) throws ExceptionMotor {
        return this.getHijo(nombre);
    }

    @Override
    public INodoArbol getParent() throws ExceptionMotor {
        try {
            if (this.parentNode == null) {
                return null;
            }
            return this.parentNode;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setParent(INodoArbol padre) {
        this.parentNode = padre;
    }

    @Override
    public int appendHijo(String nombre) {
        return this.appendHijo(nombre, nombre);
    }

    @Override
    public int appendHijo(String nombre, String valor) {
        try {
            return this.appendHijo(new NodoArbol(nombre, valor, this));
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            return -1;
        }
    }

    @Override
    public int appendHijo(INodoArbol nodo) {
        nodo.setParent(this);
        this.listaHijos.add(nodo);
        return this.listaHijos.size();
    }
}

