/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MensajesMotor {
    private String NOMBRE_FICHERO_PROPIEDADES = "mensajes.properties";
    private final String PAQUETE_BASE = "/es/aeat/pftw/mtrc/mensajes";
    private Map<String, Properties> cacheProperties = new HashMap<String, Properties>();

    public MensajesMotor(String i18n) {
        this.NOMBRE_FICHERO_PROPIEDADES = i18n != null && i18n.length() > 0 ? "mensajes" + i18n + ".properties" : "mensajes.properties";
    }

    public void setIdioma(String cadenaIdioma) throws ExceptionMotor {
        this.NOMBRE_FICHERO_PROPIEDADES = "mensajes" + cadenaIdioma + ".properties";
        this.cargaFicheroPropiedades();
    }

    public String get(String claveMensaje) throws ExceptionMotor {
        try {
            String resultado = null;
            Properties props = this.cargaFicheroPropiedades();
            resultado = props.getProperty(claveMensaje);
            if (resultado == null) {
                throw new ExceptionMotor("No est\u00e1 configurada la clave de mensaje " + claveMensaje + " del fichero de mensajes del componente " + "mensajes");
            }
            return resultado;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private Properties cargaFicheroPropiedades() throws ExceptionMotor {
        try {
            Properties props = null;
            if (this.cacheProperties.containsKey("mensajes")) {
                props = this.cacheProperties.get("mensajes");
            } else {
                InputStream inputStream = MensajesMotor.class.getResourceAsStream("/es/aeat/pftw/mtrc/mensajes/" + this.NOMBRE_FICHERO_PROPIEDADES);
                props = new Properties();
                try {
                    props.load(inputStream);
                    this.cacheProperties.put("mensajes", props);
                }
                catch (Exception e) {
                    throw new ExceptionMotor("No se ha configurado el fichero de mensajes del motor", e);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new ExceptionMotor("No se ha configurado el fichero de mensajes del motor", e);
                    }
                }
            }
            return props;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void dispose() {
        if (this.cacheProperties != null) {
            this.cacheProperties.clear();
            this.cacheProperties = null;
        }
    }

    public int getTamanoCache() {
        return this.cacheProperties.size();
    }
}

