/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.tipos.ITipoDatosReglasTipoYPartidas;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public final class ManejadorGestorTraducciones
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IGestorTraducciones gt = null;
    private static final String LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO = "El gestor de traducciones no existe, imposible hacer nada";

    public ManejadorGestorTraducciones(IGestorFicheros referenciaAlGestorDeFicheros) {
        this.gt = (IGestorTraducciones)referenciaAlGestorDeFicheros.getGestorTraducciones();
    }

    public List<ITipoDatosTabla> getTablas() throws ExceptionMotor {
        try {
            if (this.gt == null) {
                throw new ExceptionMotor(LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO);
            }
            return this.gt.getTablas();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<ITipoDatosTabla> getTablasAuxiliares() throws ExceptionMotor {
        try {
            if (this.gt == null) {
                throw new ExceptionMotor(LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO);
            }
            return this.gt.getTablasAuxiliares();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Map<String, String> getPropiedadesDeTabla(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.gt == null) {
                throw new ExceptionMotor(LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO);
            }
            return this.gt.getTabla(nombreTabla);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<ITipoDatosCampos> getCamposDeTabla(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.gt == null) {
                throw new ExceptionMotor(LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO);
            }
            return this.gt.getTablaEntry(nombreTabla).getCampos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<ITipoDatosCampos> getCamposDeTablaAuxiliar(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.gt == null) {
                throw new ExceptionMotor(LITERAL_ERR_GESTOR_TRADUCCIONES_NO_CREADO);
            }
            return this.gt.getTablaAuxiliarEntry(nombreTabla).getCampos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Map<String, List<String>> getCamposInicializacionTablas() throws ExceptionMotor {
        try {
            return this.gt.getCamposInicializacionTablas();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Map<String, String> getConstantes() throws ExceptionMotor {
        try {
            return this.gt.getConstantes();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Map<String, String> getVariables() throws ExceptionMotor {
        try {
            return this.gt.getVariables();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<ITipoDatosReglasTipoYPartidas> getReglasFichero() throws ExceptionMotor {
        try {
            return this.gt.getReglasFichero();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<ITipoDatosReglasTipoYPartidas> getReglasRegistro() throws ExceptionMotor {
        try {
            return this.gt.getReglasRegistro();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<Object> getSecuencias() throws ExceptionMotor {
        try {
            return this.gt.getSecuencias();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

