/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.BufferedReaderEx;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;

public final class LectorFicherosPlanos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nombreFichero = "";
    private boolean ficheroAbierto = false;
    private boolean eof = false;
    private boolean leercllf = false;
    private FileInputStream fis = null;
    private DataInputStream dis = null;
    private BufferedReaderEx brd = null;
    private int numLinea = 0;

    public LectorFicherosPlanos() {
    }

    public LectorFicherosPlanos(String rutaFicheroTXT) {
        this.nombreFichero = rutaFicheroTXT;
    }

    public boolean abrirFichero() throws ExceptionMotor {
        try {
            if (this.ficheroAbierto) {
                throw new ExceptionMotor("Ya existe un fichero abierto cierrelo primero");
            }
            if (this.nombreFichero.length() == 0) {
                throw new ExceptionMotor("Indique que fichero hay que abrir");
            }
            this.fis = new FileInputStream(new File(this.nombreFichero));
            this.dis = new DataInputStream(this.fis);
            this.brd = new BufferedReaderEx(new InputStreamReader((InputStream)this.dis, Charset.forName("ISO-8859-1")));
            this.ficheroAbierto = true;
            this.eof = false;
            this.numLinea = 0;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean abrirFichero(String rutaFicheroTXT) throws ExceptionMotor {
        try {
            if (this.ficheroAbierto) {
                throw new ExceptionMotor("Ya existe un fichero abierto cierrelo primero");
            }
            this.nombreFichero = rutaFicheroTXT;
            return this.abrirFichero();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean cerrarFichero() throws ExceptionMotor {
        try {
            if (!this.ficheroAbierto) {
                throw new ExceptionMotor("No hay ningun fichero abierto");
            }
            this.brd.close();
            this.dis.close();
            this.fis.close();
            this.brd = null;
            this.dis = null;
            this.fis = null;
            this.ficheroAbierto = false;
            this.numLinea = 0;
            this.eof = false;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw (ExceptionMotor)e;
        }
    }

    public int getLineaFichero() {
        return this.numLinea;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public boolean getleercllf() {
        return this.leercllf;
    }

    public void setleercllf(boolean habilitar) {
        this.leercllf = habilitar;
        if (this.brd != null) {
            this.brd.setIncludeCrLf(this.leercllf);
        }
    }

    public String lineaSiguiente() throws ExceptionMotor, IOException {
        if (!this.ficheroAbierto) {
            throw new ExceptionMotor("No hay ningun fichero abierto");
        }
        if (this.eof) {
            return null;
        }
        String cadena = null;
        String cadenaAux = null;
        while ((cadenaAux = this.brd.readLine()) != null) {
            if (cadena == null) {
                cadena = "";
            }
            cadena = cadena + cadenaAux;
            ++this.numLinea;
        }
        this.eof = true;
        return cadena;
    }

    public void setFileReader(FileInputStream fr) {
        this.fis = fr;
    }
}

