/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.xml.sax.InputSource;

public final class JarResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean debugOn = false;
    private Map<String, Integer> htSizes = new Hashtable<String, Integer>();
    private Map<String, byte[]> htJarContents = new Hashtable<String, byte[]>();
    private String jarFileName;

    public JarResources(String sJarFileName) {
        this.jarFileName = sJarFileName;
        this.init();
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public byte[] getResource(String name) {
        return this.htJarContents.get(this.getResourceNameWithoutCase(name));
    }

    public InputStream getResourceInputStream(String name) {
        return new ByteArrayInputStream(this.getResource(this.getResourceNameWithoutCase(name)));
    }

    public InputSource getResourceInputSource(String name, String chr) {
        return new InputSource(new InputStreamReader(this.getResourceInputStream(this.getResourceNameWithoutCase(name)), Charset.forName("ISO-8859-1")));
    }

    public InputSource getResourceInputSource(String name) {
        return this.getResourceInputSource(this.getResourceNameWithoutCase(name), "ISO-8859-1");
    }

    public String getResourceNameWithoutCase(String nombreRecurso) {
        try {
            String nombreReal = "";
            Set<String> s = this.htJarContents.keySet();
            Iterator<String> it = s.iterator();
            while (it.hasNext()) {
                nombreReal = it.next().toString();
                if (!nombreReal.equalsIgnoreCase(nombreRecurso)) continue;
                return nombreReal;
            }
            return nombreRecurso;
        }
        catch (Exception ex) {
            return nombreRecurso;
        }
    }

    private void init() {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                this.htSizes.put(ze.getName(), (int)ze.getSize());
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                String alias = ze.getName();
                if (alias.lastIndexOf(47) > -1) {
                    alias = alias.substring(alias.lastIndexOf(47) + 1);
                }
                this.htJarContents.put(alias, b);
            }
            try {
                zis.close();
            }
            catch (Exception ex) {}
        }
        catch (NullPointerException e) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("JarResources::init : " + e.toString());
        }
        catch (FileNotFoundException ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
        }
        catch (IOException ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
        }
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }
}

