/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends SecureClassLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String jar;

    public JarClassLoader(ClassLoader parent, String jar) {
        super(parent);
        this.jar = jar;
    }

    @Override
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (name.startsWith(".") || name.indexOf("..") != -1 || name.endsWith(".")) {
                throw new ClassNotFoundException(name, e);
            }
            try {
                byte[] b = this.getClassBytes(name);
                c = this.defineClass(name, b, 0, b.length);
            }
            catch (IOException e2) {
                throw new ClassNotFoundException(name, e2);
            }
        }
        return c;
    }

    private byte[] getClassBytes(String name) throws IOException {
        return this.getRecurso(name.replace('.', '/').concat(".class"));
    }

    private byte[] getRecurso(String name) throws IOException {
        JarFile modeloJar = new JarFile(this.jar);
        JarEntry xmlEntry = modeloJar.getJarEntry(name);
        if (xmlEntry == null) {
            throw new IOException(name);
        }
        InputStream xmlStream = modeloJar.getInputStream(xmlEntry);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int leido = 0;
        while ((leido = xmlStream.read()) != -1) {
            out.write(leido);
        }
        out.flush();
        xmlStream.close();
        modeloJar.close();
        byte[] b = out.toByteArray();
        out.close();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.jar);
                JarEntry recurso = jarFile.getJarEntry(name);
                if (recurso != null) {
                    StringBuffer sb = new StringBuffer("jar:");
                    sb.append(new URL("file", "", this.jar).toExternalForm());
                    sb.append("!/");
                    sb.append(name);
                    url = new URL(sb.toString());
                }
            }
            catch (IOException e) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e1) {}
                }
            }
        }
        return url;
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        byte[] b = null;
        try {
            b = this.getRecurso(name);
            return new ByteArrayInputStream(b);
        }
        catch (IOException e) {
            return null;
        }
    }
}

