/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class JarBytesClassLoader
extends ClassLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static JarBytesClassLoader jarBytesClassLoader = new JarBytesClassLoader();
    private Map<String, byte[]> classesMap = new ConcurrentHashMap<String, byte[]>();

    private JarBytesClassLoader() {
    }

    public static JarBytesClassLoader getInstance() {
        return jarBytesClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarBytes(byte[] jarBytes) {
        ByteArrayInputStream byteArrayInputStream = null;
        ZipInputStream jarInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(jarBytes);
            jarInputStream = new JarInputStream(byteArrayInputStream);
            bufferedInputStream = new BufferedInputStream(jarInputStream);
            JarEntry jarEntry = null;
            while ((jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                String name;
                if (!jarEntry.isDirectory() && (name = jarEntry.getName()).toLowerCase().endsWith(".class")) {
                    String className = name.replaceAll("/", ".").substring(0, name.length() - 6);
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                        int i = -1;
                        while ((i = bufferedInputStream.read()) != -1) {
                            bufferedOutputStream.write(i);
                        }
                        bufferedOutputStream.flush();
                        byte[] bytes = byteArrayOutputStream.toByteArray();
                        this.classesMap.put(className, bytes);
                    }
                    finally {
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException ex) {}
                        }
                        if (bufferedOutputStream != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
                jarInputStream.closeEntry();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException ex) {}
            }
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ex) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void reset() {
        JarBytesClassLoader.jarBytesClassLoader.classesMap.clear();
        jarBytesClassLoader = new JarBytesClassLoader();
    }

    @Override
    protected Class<?> findClass(String name) {
        byte[] bytes = this.loadClassData(name);
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private byte[] loadClassData(String name) {
        return this.classesMap.get(name);
    }
}

