/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class HugeSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ObjectOutputStream writer = null;
    private ObjectInputStream reader = null;
    private int contadorDescendente = 0;
    private int contadorAscendente = 0;
    private int indexFicheroActual = -1;
    private List<String> listaFicheros = new ArrayList<String>();
    private int maxFileRecords = 500;
    private int paginaActual = 0;

    public boolean setmaxFileRecords(int max) {
        if (this.listaFicheros.size() > 0 || max < 1) {
            return false;
        }
        this.maxFileRecords = max;
        return true;
    }

    public boolean guardaObjeto(Object obj) throws ExceptionMotor {
        try {
            if (this.reader != null) {
                this.finalizaClase();
                this.inicializaClase();
            } else if (this.writer == null) {
                this.inicializaClase();
            }
            ++this.contadorDescendente;
            if (this.paginaActual * this.maxFileRecords < this.contadorDescendente) {
                this.newFile();
            }
            this.writer.writeObject(obj);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Object recuperaObjetoInverso() throws ExceptionMotor {
        try {
            if (this.listaFicheros.size() == 0) {
                throw new ExceptionMotor("No existen datos a recuperar");
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.contadorDescendente == 0) {
                return null;
            }
            this.indexFicheroActual = (this.contadorDescendente - 1) / this.maxFileRecords;
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            File f = new File(this.listaFicheros.get(this.indexFicheroActual).toString());
            FileInputStream fTmp = new FileInputStream(f);
            f = null;
            this.reader = new ObjectInputStream(fTmp);
            fTmp = null;
            for (int i = 1; i < this.contadorDescendente - this.indexFicheroActual * this.maxFileRecords; ++i) {
                this.reader.readObject();
            }
            --this.contadorDescendente;
            return this.reader.readObject();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (EOFException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Object recuperaObjeto() throws ExceptionMotor {
        try {
            if (this.listaFicheros.size() == 0) {
                throw new ExceptionMotor("No existen datos a recuperar");
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.contadorAscendente > this.contadorDescendente) {
                return null;
            }
            if (this.indexFicheroActual != this.contadorAscendente / this.maxFileRecords) {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                this.indexFicheroActual = this.contadorAscendente / this.maxFileRecords;
                File f = new File(this.listaFicheros.get(this.indexFicheroActual).toString());
                FileInputStream fTmp = new FileInputStream(f);
                f = null;
                this.reader = new ObjectInputStream(fTmp);
                Object var2_5 = null;
            }
            ++this.contadorAscendente;
            return this.reader.readObject();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (EOFException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean newFile() throws ExceptionMotor {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            File f = null;
            f = FuncionesUtiles.getFuncionesUtiles().creaArchivoTemporal("HSer", ".Tmp");
            this.listaFicheros.add(f.getPath());
            FileOutputStream fTmp = new FileOutputStream(f);
            this.writer = new ObjectOutputStream(fTmp);
            fTmp = null;
            f = null;
            ++this.paginaActual;
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean inicializaClase() throws ExceptionMotor {
        try {
            this.finalizaClase();
            this.contadorDescendente = 0;
            this.contadorAscendente = 0;
            this.indexFicheroActual = -1;
            this.paginaActual = 0;
            return this.newFile();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean finalizaClase() throws ExceptionMotor {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            for (int i = 0; i < this.listaFicheros.size(); ++i) {
                File f = new File(this.listaFicheros.get(i).toString());
                f.delete();
                Object var2_3 = null;
            }
            this.contadorDescendente = 0;
            this.contadorAscendente = 0;
            this.indexFicheroActual = -1;
            this.listaFicheros.clear();
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

