/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.GestorDatosBase;
import es.aeat.pftw.mtrc.utilidades.GestorDatosGenerado;
import es.aeat.pftw.mtrc.utilidades.IGestorDatosOpciones;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GestorDatosXmldeOpciones
extends GestorDatosBase
implements IGestorDatosOpciones {
    private static final long serialVersionUID = 1L;
    protected Map<String, List<String>> coleccionGenerica = new HashMap<String, List<String>>();
    protected Map<String, List<String>> coleccionEspecifica = new HashMap<String, List<String>>();
    protected List<String> arrayListTemporal = null;
    private String rutaJar = null;
    protected List<ITipoDatosCampoValor> listadoTrans = null;

    @Override
    protected boolean cargarDocument(Document doc, boolean generica) throws ExceptionMotor {
        try {
            if (doc == null) {
                boolean bl = false;
                return bl;
            }
            Map<String, List<String>> coleccion = this.getColeccionEspecifica();
            if (generica) {
                coleccion = this.getColeccionGenerica();
            }
            NodeList listaNodos = doc.getChildNodes();
            NodeList listaNodosHijos = null;
            NodeList listaNodosNietos = null;
            ArrayList<String> listaValores = null;
            coleccion.clear();
            String clave = "";
            for (int j = 0; j < listaNodos.getLength(); ++j) {
                if (listaNodos.item(j).getNodeType() != 1) continue;
                listaNodos = listaNodos.item(j).getChildNodes();
                break;
            }
            for (int i = 0; i < listaNodos.getLength(); ++i) {
                if (listaNodos.item(i).getNodeType() != 1 || !listaNodos.item(i).getNodeName().equalsIgnoreCase("opcion")) continue;
                clave = FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(listaNodos.item(i).getAttributes(), "nombre");
                listaValores = new ArrayList<String>();
                listaNodosHijos = listaNodos.item(i).getChildNodes();
                String valor = "";
                for (int j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (!listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("VALOR")) continue;
                    listaNodosNietos = listaNodosHijos.item(j).getChildNodes();
                    for (int k = 0; k < listaNodosNietos.getLength(); ++k) {
                        if (listaNodosNietos.item(k).getNodeType() != 3) continue;
                        valor = listaNodosNietos.item(k).getNodeValue();
                        listaValores.add(valor);
                    }
                }
                coleccion.put(clave, listaValores);
                listaValores = null;
            }
            boolean bl = this.cargaDesdeXML(generica);
            return bl;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            this.dispose();
        }
    }

    protected boolean cargaDesdeXML(boolean esGenerica) throws ExceptionMotor {
        try {
            this.gestorDatosGenerado = new GestorDatosGenerado();
            GestorDatosGenerado gsinDep = (GestorDatosGenerado)this.getGestorDatosOpcionesGeneradoSinDependencias();
            gsinDep.setColeccionEspecifica(this.getColeccionEspecifica());
            gsinDep.setColeccionGenerica(this.getColeccionGenerica());
            Map<String, List<String>> coleccion = gsinDep.getColeccionEspecifica();
            if (esGenerica) {
                coleccion = gsinDep.getColeccionGenerica();
            }
            for (String opcion : coleccion.keySet()) {
                if (!opcion.startsWith("TRANS")) continue;
                List<String> opciones = coleccion.get(opcion);
                for (String op : opciones) {
                    gsinDep.getListadoTrans().add(new TipoDatosCampoValor(op, new String(FuncionesUtiles.getFuncionesUtiles().inputStream2byteArray(FuncionesUtiles.getFuncionesUtiles().getRecurso(op, this.getRutaJar())))));
                }
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, List<String>> getOpciones() {
        HashMap<String, List<String>> union = new HashMap<String, List<String>>();
        union.putAll(this.getColeccionEspecifica());
        union.putAll(this.getColeccionGenerica());
        return union;
    }

    @Override
    public List<String> getOpcion(String opcion) throws ExceptionMotor {
        try {
            if (opcion == null) {
                throw new Exception("Debe especificar opcion!!!");
            }
            List<String> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get(opcion.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get(opcion.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<String>();
                    }
                }
                if (table != null) {
                    return table;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setColeccionGenerica(Map<String, List<String>> coleccionGenerica) {
        this.coleccionGenerica = coleccionGenerica;
    }

    protected Map<String, List<String>> getColeccionGenerica() {
        return this.coleccionGenerica;
    }

    protected void setColeccionEspecifica(Map<String, List<String>> coleccionEspecifica) {
        this.coleccionEspecifica = coleccionEspecifica;
    }

    protected Map<String, List<String>> getColeccionEspecifica() {
        return this.coleccionEspecifica;
    }

    protected void setArrayListTemporal(List<String> arrayListTemporal) {
        this.arrayListTemporal = arrayListTemporal;
    }

    protected List<String> getArrayListTemporal() {
        return this.arrayListTemporal;
    }

    @Override
    public List<ITipoDatosCampoValor> getListadoTrans() {
        if (this.listadoTrans == null) {
            this.listadoTrans = new ArrayList<ITipoDatosCampoValor>();
        }
        return this.listadoTrans;
    }

    protected void setListadoTrans(List<ITipoDatosCampoValor> listadoTrans) {
        this.listadoTrans = listadoTrans;
    }

    public String getRutaJar() {
        return this.rutaJar;
    }

    public void setRutaJar(String rutaJar) {
        this.rutaJar = rutaJar;
    }
}

