/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.GestorDatosAuxiliaresGenerado;
import es.aeat.pftw.mtrc.utilidades.GestorDatosBase;
import es.aeat.pftw.mtrc.utilidades.IGestorDatosAuxiliares;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GestorDatosXml
extends GestorDatosBase
implements IGestorDatosAuxiliares {
    private static final long serialVersionUID = 1L;
    private Map<String, List<ITipoDatosCampoValor>> coleccionGenerica = new HashMap<String, List<ITipoDatosCampoValor>>();
    private Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica = new HashMap<String, List<ITipoDatosCampoValor>>();
    private List<ITipoDatosCampoValor> arrayListTemporal = null;
    protected IGestorDatosAuxiliares gestorDatosAuxiliaresGenerado = null;

    @Override
    public IGestorDatosAuxiliares getGestorDatosAuxiliaresGeneradoSinDependencias() {
        return this.gestorDatosAuxiliaresGenerado;
    }

    @Override
    public String getRegistro(String tabla, String clave) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (table != null) {
                    int indice = TipoDatosCampoValor.indiceListaContieneCampo(table, clave);
                    if (indice != -1) {
                        return table.get(indice).getValor();
                    }
                    return "";
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccion(boolean generica) throws ExceptionMotor {
        try {
            if (this.getGestorDatosAuxiliaresGeneradoSinDependencias() != null) {
                if (generica) {
                    return ((GestorDatosAuxiliaresGenerado)this.getGestorDatosAuxiliaresGeneradoSinDependencias()).getColeccionGenerica();
                }
                return ((GestorDatosAuxiliaresGenerado)this.getGestorDatosAuxiliaresGeneradoSinDependencias()).getColeccionEspecifica();
            }
            if (generica) {
                return this.getColeccionGenerica();
            }
            return this.getColeccionGenerica();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    protected boolean cargarDocument(Document doc, boolean generica) throws ExceptionMotor {
        try {
            if (doc == null) {
                boolean bl = false;
                return bl;
            }
            Map<String, List<ITipoDatosCampoValor>> coleccion = this.getColeccion(generica);
            NodeList listaNodos = doc.getChildNodes();
            NodeList listaNodosHijos = null;
            NodeList listaNodosNietos = null;
            NodeList listaNodosBisNietos = null;
            String valorLeido = "";
            String claveLeida = "";
            coleccion.clear();
            listaNodos = listaNodos.item(0).getChildNodes();
            for (int i = 0; i < listaNodos.getLength(); ++i) {
                if (listaNodos.item(i).getNodeType() != 1) continue;
                String nombreTabla = listaNodos.item(i).getNodeName().toUpperCase();
                if (listaNodos.item(i).hasAttributes()) {
                    try {
                        nombreTabla = listaNodos.item(i).getAttributes().getNamedItem("id").getNodeValue();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.setArrayListTemporal(null);
                this.setArrayListTemporal(new ArrayList<ITipoDatosCampoValor>());
                listaNodosHijos = listaNodos.item(i).getChildNodes();
                for (int j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (!listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("Entrada")) continue;
                    listaNodosNietos = listaNodosHijos.item(j).getChildNodes();
                    for (int k = 0; k < listaNodosNietos.getLength(); ++k) {
                        if (listaNodosNietos.item(k).getNodeName().equalsIgnoreCase("Relacionada")) {
                            listaNodosBisNietos = listaNodosNietos.item(k).getChildNodes();
                            for (int l = 0; l < listaNodosBisNietos.getLength(); ++l) {
                                if (listaNodosBisNietos.item(l).getNodeType() != 3) continue;
                                if (valorLeido.length() > 0) {
                                    valorLeido = valorLeido + ";";
                                }
                                valorLeido = valorLeido + listaNodosBisNietos.item(l).getNodeValue();
                            }
                        }
                        if (valorLeido.length() != 0 || listaNodosNietos.item(k).getNodeType() != 3) continue;
                        valorLeido = listaNodosNietos.item(k).getNodeValue();
                    }
                    claveLeida = FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(listaNodosHijos.item(j).getAttributes(), "Clave");
                    this.getArrayListTemporal().add(new TipoDatosCampoValor(claveLeida, valorLeido));
                    valorLeido = "";
                }
                if (coleccion.get(nombreTabla) != null) {
                    throw new ExceptionMotor("Se esta sobreescribiendo la tabla " + nombreTabla + " !!!!!");
                }
                coleccion.put(nombreTabla, this.getArrayListTemporal());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String tabla, boolean orden) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (table != null) {
                    return table;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String tabla) throws ExceptionMotor {
        return this.getTabla(tabla, false);
    }

    @Override
    public Map<String, String> getTablaHashMap(String tabla) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> tablaLista = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        tablaLista = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        tablaLista = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return new HashMap<String, String>();
                    }
                }
                if (tablaLista != null) {
                    HashMap<String, String> tablaHashMap = new HashMap<String, String>();
                    for (ITipoDatosCampoValor tipoDatosCampoValor : tablaLista) {
                        tablaHashMap.put(tipoDatosCampoValor.getNombreCampo(), tipoDatosCampoValor.getValor());
                    }
                    return tablaHashMap;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String tablaPadre, String tablaHija, String claveAjena, boolean ordenar) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> res = new ArrayList<ITipoDatosCampoValor>();
            String[] claves = null;
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get("RELACION_" + tablaPadre.toUpperCase() + "_" + tablaHija.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get("RELACION_" + tablaPadre.toUpperCase() + "_" + tablaHija.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (table != null) {
                    int indice = TipoDatosCampoValor.indiceListaContieneCampo(table, claveAjena);
                    if (indice != -1) {
                        claves = table.get(indice).getValor().split(";");
                        for (int j = 0; j < claves.length; ++j) {
                            res.add(new TipoDatosCampoValor(claves[j], this.getRegistro(tablaHija, claves[j])));
                        }
                        return res;
                    }
                    return res;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String tablaPadre, String tablaHija, String claveAjena) throws ExceptionMotor {
        return this.getTablaFiltrada(tablaPadre, tablaHija, claveAjena, true);
    }

    protected void setColeccionGenerica(Map<String, List<ITipoDatosCampoValor>> coleccionGenerica) {
        this.coleccionGenerica = coleccionGenerica;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionGenerica() {
        return this.coleccionGenerica;
    }

    protected void setColeccionEspecifica(Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica) {
        this.coleccionEspecifica = coleccionEspecifica;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionEspecifica() {
        return this.coleccionEspecifica;
    }

    protected void setArrayListTemporal(List<ITipoDatosCampoValor> arrayListTemporal) {
        this.arrayListTemporal = arrayListTemporal;
    }

    protected List<ITipoDatosCampoValor> getArrayListTemporal() {
        return this.arrayListTemporal;
    }

    @Override
    public void cargaFicheros(List<ITipoDatosCampoValor> listado) throws ExceptionMotor {
    }
}

